/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.os.Parcel;
import android.os.Parcelable;

public final class ScanSettings
implements Parcelable {
    public static final int CALLBACK_TYPE_ALL_MATCHES = 1;
    public static final int CALLBACK_TYPE_FIRST_MATCH = 2;
    public static final int CALLBACK_TYPE_MATCH_LOST = 4;
    public static final Parcelable.Creator<ScanSettings> CREATOR = new Parcelable.Creator<ScanSettings>(){

        @Override
        public ScanSettings createFromParcel(Parcel parcel) {
            return new ScanSettings(parcel);
        }

        public ScanSettings[] newArray(int n) {
            return new ScanSettings[n];
        }
    };
    public static final int SCAN_MODE_BALANCED = 1;
    public static final int SCAN_MODE_LOW_LATENCY = 2;
    public static final int SCAN_MODE_LOW_POWER = 0;
    public static final int SCAN_RESULT_TYPE_ABBREVIATED = 1;
    public static final int SCAN_RESULT_TYPE_FULL;
    private int mCallbackType;
    private long mReportDelayMillis;
    private int mScanMode;
    private int mScanResultType;

    private ScanSettings(int n, int n2, int n3, long l) {
        this.mScanMode = n;
        this.mCallbackType = n2;
        this.mScanResultType = n3;
        this.mReportDelayMillis = l;
    }

    private ScanSettings(Parcel parcel) {
        this.mScanMode = parcel.readInt();
        this.mCallbackType = parcel.readInt();
        this.mScanResultType = parcel.readInt();
        this.mReportDelayMillis = parcel.readLong();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getCallbackType() {
        return this.mCallbackType;
    }

    public long getReportDelayMillis() {
        return this.mReportDelayMillis;
    }

    public int getScanMode() {
        return this.mScanMode;
    }

    public int getScanResultType() {
        return this.mScanResultType;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mScanMode);
        parcel.writeInt(this.mCallbackType);
        parcel.writeInt(this.mScanResultType);
        parcel.writeLong(this.mReportDelayMillis);
    }

    public static final class Builder {
        private int mCallbackType = 1;
        private long mReportDelayMillis = 0L;
        private int mScanMode = 0;
        private int mScanResultType = 0;

        /*
         * Enabled aggressive block sorting
         */
        private boolean isValidCallbackType(int n) {
            return n == 1 || n == 2 || n == 4 || n == 6;
        }

        public ScanSettings build() {
            return new ScanSettings(this.mScanMode, this.mCallbackType, this.mScanResultType, this.mReportDelayMillis);
        }

        public Builder setCallbackType(int n) {
            if (!this.isValidCallbackType(n)) {
                throw new IllegalArgumentException("invalid callback type - " + n);
            }
            this.mCallbackType = n;
            return this;
        }

        public Builder setReportDelay(long l) {
            if (l < 0L) {
                throw new IllegalArgumentException("reportDelay must be > 0");
            }
            this.mReportDelayMillis = l;
            return this;
        }

        public Builder setScanMode(int n) {
            if (n < 0 || n > 2) {
                throw new IllegalArgumentException("invalid scan mode " + n);
            }
            this.mScanMode = n;
            return this;
        }

        public Builder setScanResultType(int n) {
            if (n < 0 || n > 1) {
                throw new IllegalArgumentException("invalid scanResultType - " + n);
            }
            this.mScanResultType = n;
            return this;
        }
    }
}

