/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothPbap;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;

public class BluetoothPbap {
    private static final boolean DBG = true;
    public static final String PBAP_PREVIOUS_STATE = "android.bluetooth.pbap.intent.PBAP_PREVIOUS_STATE";
    public static final String PBAP_STATE = "android.bluetooth.pbap.intent.PBAP_STATE";
    public static final String PBAP_STATE_CHANGED_ACTION = "android.bluetooth.pbap.intent.action.PBAP_STATE_CHANGED";
    public static final int RESULT_CANCELED = 2;
    public static final int RESULT_FAILURE = 0;
    public static final int RESULT_SUCCESS = 1;
    public static final int STATE_CONNECTED = 2;
    public static final int STATE_CONNECTING = 1;
    public static final int STATE_DISCONNECTED = 0;
    public static final int STATE_ERROR = -1;
    private static final String TAG = "BluetoothPbap";
    private static final boolean VDBG;
    private BluetoothAdapter mAdapter;
    private final IBluetoothStateChangeCallback mBluetoothStateChangeCallback = new IBluetoothStateChangeCallback.Stub(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onBluetoothStateChange(boolean bl) {
            Log.d(BluetoothPbap.TAG, "onBluetoothStateChange: up=" + bl);
            if (!bl) {
                ServiceConnection serviceConnection = BluetoothPbap.this.mConnection;
                synchronized (serviceConnection) {
                    try {
                        BluetoothPbap.access$102(BluetoothPbap.this, null);
                        BluetoothPbap.this.mContext.unbindService(BluetoothPbap.this.mConnection);
                    }
                    catch (Exception exception) {
                        Log.e(BluetoothPbap.TAG, "", exception);
                    }
                    return;
                }
            }
            ServiceConnection serviceConnection = BluetoothPbap.this.mConnection;
            synchronized (serviceConnection) {
                try {
                    if (BluetoothPbap.this.mService == null) {
                        BluetoothPbap.this.doBind();
                    }
                }
                catch (Exception exception) {
                    Log.e(BluetoothPbap.TAG, "", exception);
                }
                return;
            }
        }
    };
    private final ServiceConnection mConnection = new ServiceConnection(){

        @Override
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            BluetoothPbap.log("Proxy object connected");
            BluetoothPbap.access$102(BluetoothPbap.this, IBluetoothPbap.Stub.asInterface(iBinder));
            if (BluetoothPbap.this.mServiceListener != null) {
                BluetoothPbap.this.mServiceListener.onServiceConnected(BluetoothPbap.this);
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
            BluetoothPbap.log("Proxy object disconnected");
            BluetoothPbap.access$102(BluetoothPbap.this, null);
            if (BluetoothPbap.this.mServiceListener != null) {
                BluetoothPbap.this.mServiceListener.onServiceDisconnected();
            }
        }
    };
    private final Context mContext;
    private IBluetoothPbap mService;
    private ServiceListener mServiceListener;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BluetoothPbap(Context context, ServiceListener serviceListener) {
        this.mContext = context;
        this.mServiceListener = serviceListener;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        IBluetoothManager iBluetoothManager = this.mAdapter.getBluetoothManager();
        if (iBluetoothManager != null) {
            try {
                iBluetoothManager.registerStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "", remoteException);
            }
        }
        this.doBind();
    }

    static /* synthetic */ IBluetoothPbap access$102(BluetoothPbap bluetoothPbap, IBluetoothPbap iBluetoothPbap) {
        bluetoothPbap.mService = iBluetoothPbap;
        return iBluetoothPbap;
    }

    public static boolean doesClassMatchSink(BluetoothClass bluetoothClass) {
        switch (bluetoothClass.getDeviceClass()) {
            default: {
                return false;
            }
            case 256: 
            case 260: 
            case 264: 
            case 268: 
        }
        return true;
    }

    private static void log(String string2) {
        Log.d(TAG, string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        synchronized (this) {
            IBluetoothManager iBluetoothManager = this.mAdapter.getBluetoothManager();
            if (iBluetoothManager != null) {
                try {
                    iBluetoothManager.unregisterStateChangeCallback(this.mBluetoothStateChangeCallback);
                }
                catch (Exception exception) {
                    Log.e(TAG, "", exception);
                }
            }
            ServiceConnection serviceConnection = this.mConnection;
            synchronized (serviceConnection) {
                IBluetoothPbap iBluetoothPbap = this.mService;
                if (iBluetoothPbap != null) {
                    try {
                        this.mService = null;
                        this.mContext.unbindService(this.mConnection);
                    }
                    catch (Exception exception) {
                        Log.e(TAG, "", exception);
                    }
                }
            }
            this.mServiceListener = null;
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean disconnect() {
        BluetoothPbap.log("disconnect()");
        if (this.mService != null) {
            try {
                this.mService.disconnect();
                return true;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, remoteException.toString());
                return false;
            }
        }
        Log.w(TAG, "Proxy not attached to service");
        BluetoothPbap.log(Log.getStackTraceString(new Throwable()));
        return false;
    }

    boolean doBind() {
        Intent intent = new Intent(IBluetoothPbap.class.getName());
        ComponentName componentName = intent.resolveSystemService(this.mContext.getPackageManager(), 0);
        intent.setComponent(componentName);
        if (componentName == null || !this.mContext.bindServiceAsUser(intent, this.mConnection, 0, Process.myUserHandle())) {
            Log.e(TAG, "Could not bind to Bluetooth Pbap Service with " + intent);
            return false;
        }
        return true;
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
            return;
        }
        finally {
            super.finalize();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BluetoothDevice getClient() {
        if (this.mService != null) {
            try {
                return this.mService.getClient();
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, remoteException.toString());
                return null;
            }
        }
        Log.w(TAG, "Proxy not attached to service");
        BluetoothPbap.log(Log.getStackTraceString(new Throwable()));
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getState() {
        if (this.mService != null) {
            try {
                return this.mService.getState();
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, remoteException.toString());
                return -1;
            }
        }
        Log.w(TAG, "Proxy not attached to service");
        BluetoothPbap.log(Log.getStackTraceString(new Throwable()));
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isConnected(BluetoothDevice bluetoothDevice) {
        if (this.mService != null) {
            try {
                return this.mService.isConnected(bluetoothDevice);
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, remoteException.toString());
                return false;
            }
        }
        Log.w(TAG, "Proxy not attached to service");
        BluetoothPbap.log(Log.getStackTraceString(new Throwable()));
        return false;
    }

    public static interface ServiceListener {
        public void onServiceConnected(BluetoothPbap var1);

        public void onServiceDisconnected();
    }
}

