/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothSocket;
import android.bluetooth.IBluetooth;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothManagerCallback;
import android.content.Context;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.UUID;

public final class BluetoothDevice
implements Parcelable {
    public static final int ACCESS_ALLOWED = 1;
    public static final int ACCESS_REJECTED = 2;
    public static final int ACCESS_UNKNOWN = 0;
    public static final String ACTION_ACL_CONNECTED = "android.bluetooth.device.action.ACL_CONNECTED";
    public static final String ACTION_ACL_DISCONNECTED = "android.bluetooth.device.action.ACL_DISCONNECTED";
    public static final String ACTION_ACL_DISCONNECT_REQUESTED = "android.bluetooth.device.action.ACL_DISCONNECT_REQUESTED";
    public static final String ACTION_ALIAS_CHANGED = "android.bluetooth.device.action.ALIAS_CHANGED";
    public static final String ACTION_BOND_STATE_CHANGED = "android.bluetooth.device.action.BOND_STATE_CHANGED";
    public static final String ACTION_CLASS_CHANGED = "android.bluetooth.device.action.CLASS_CHANGED";
    public static final String ACTION_CONNECTION_ACCESS_CANCEL = "android.bluetooth.device.action.CONNECTION_ACCESS_CANCEL";
    public static final String ACTION_CONNECTION_ACCESS_REPLY = "android.bluetooth.device.action.CONNECTION_ACCESS_REPLY";
    public static final String ACTION_CONNECTION_ACCESS_REQUEST = "android.bluetooth.device.action.CONNECTION_ACCESS_REQUEST";
    public static final String ACTION_DISAPPEARED = "android.bluetooth.device.action.DISAPPEARED";
    public static final String ACTION_FOUND = "android.bluetooth.device.action.FOUND";
    public static final String ACTION_MAS_INSTANCE = "android.bluetooth.device.action.MAS_INSTANCE";
    public static final String ACTION_NAME_CHANGED = "android.bluetooth.device.action.NAME_CHANGED";
    public static final String ACTION_NAME_FAILED = "android.bluetooth.device.action.NAME_FAILED";
    public static final String ACTION_PAIRING_CANCEL = "android.bluetooth.device.action.PAIRING_CANCEL";
    public static final String ACTION_PAIRING_REQUEST = "android.bluetooth.device.action.PAIRING_REQUEST";
    public static final String ACTION_UUID = "android.bluetooth.device.action.UUID";
    public static final int BOND_BONDED = 12;
    public static final int BOND_BONDING = 11;
    public static final int BOND_NONE = 10;
    public static final int BOND_SUCCESS = 0;
    public static final int CONNECTION_ACCESS_NO = 2;
    public static final int CONNECTION_ACCESS_YES = 1;
    public static final Parcelable.Creator<BluetoothDevice> CREATOR;
    private static final boolean DBG = false;
    public static final int DEVICE_TYPE_CLASSIC = 1;
    public static final int DEVICE_TYPE_DUAL = 3;
    public static final int DEVICE_TYPE_LE = 2;
    public static final int DEVICE_TYPE_UNKNOWN = 0;
    public static final int ERROR = Integer.MIN_VALUE;
    public static final String EXTRA_ACCESS_REQUEST_TYPE = "android.bluetooth.device.extra.ACCESS_REQUEST_TYPE";
    public static final String EXTRA_ALWAYS_ALLOWED = "android.bluetooth.device.extra.ALWAYS_ALLOWED";
    public static final String EXTRA_BOND_STATE = "android.bluetooth.device.extra.BOND_STATE";
    public static final String EXTRA_CLASS = "android.bluetooth.device.extra.CLASS";
    public static final String EXTRA_CLASS_NAME = "android.bluetooth.device.extra.CLASS_NAME";
    public static final String EXTRA_CONNECTION_ACCESS_RESULT = "android.bluetooth.device.extra.CONNECTION_ACCESS_RESULT";
    public static final String EXTRA_DEVICE = "android.bluetooth.device.extra.DEVICE";
    public static final String EXTRA_MAS_INSTANCE = "android.bluetooth.device.extra.MAS_INSTANCE";
    public static final String EXTRA_NAME = "android.bluetooth.device.extra.NAME";
    public static final String EXTRA_PACKAGE_NAME = "android.bluetooth.device.extra.PACKAGE_NAME";
    public static final String EXTRA_PAIRING_KEY = "android.bluetooth.device.extra.PAIRING_KEY";
    public static final String EXTRA_PAIRING_VARIANT = "android.bluetooth.device.extra.PAIRING_VARIANT";
    public static final String EXTRA_PREVIOUS_BOND_STATE = "android.bluetooth.device.extra.PREVIOUS_BOND_STATE";
    public static final String EXTRA_REASON = "android.bluetooth.device.extra.REASON";
    public static final String EXTRA_RSSI = "android.bluetooth.device.extra.RSSI";
    public static final String EXTRA_UUID = "android.bluetooth.device.extra.UUID";
    public static final int PAIRING_VARIANT_CONSENT = 3;
    public static final int PAIRING_VARIANT_DISPLAY_PASSKEY = 4;
    public static final int PAIRING_VARIANT_DISPLAY_PIN = 5;
    public static final int PAIRING_VARIANT_OOB_CONSENT = 6;
    public static final int PAIRING_VARIANT_PASSKEY = 1;
    public static final int PAIRING_VARIANT_PASSKEY_CONFIRMATION = 2;
    public static final int PAIRING_VARIANT_PIN = 0;
    public static final int REQUEST_TYPE_MESSAGE_ACCESS = 3;
    public static final int REQUEST_TYPE_PHONEBOOK_ACCESS = 2;
    public static final int REQUEST_TYPE_PROFILE_CONNECTION = 1;
    private static final String TAG = "BluetoothDevice";
    public static final int TRANSPORT_AUTO = 0;
    public static final int TRANSPORT_BREDR = 1;
    public static final int TRANSPORT_LE = 2;
    public static final int UNBOND_REASON_AUTH_CANCELED = 3;
    public static final int UNBOND_REASON_AUTH_FAILED = 1;
    public static final int UNBOND_REASON_AUTH_REJECTED = 2;
    public static final int UNBOND_REASON_AUTH_TIMEOUT = 6;
    public static final int UNBOND_REASON_DISCOVERY_IN_PROGRESS = 5;
    public static final int UNBOND_REASON_REMOTE_AUTH_CANCELED = 8;
    public static final int UNBOND_REASON_REMOTE_DEVICE_DOWN = 4;
    public static final int UNBOND_REASON_REMOVED = 9;
    public static final int UNBOND_REASON_REPEATED_ATTEMPTS = 7;
    static IBluetoothManagerCallback mStateChangeCallback;
    private static IBluetooth sService;
    private final String mAddress;

    static {
        mStateChangeCallback = new IBluetoothManagerCallback.Stub(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onBluetoothServiceDown() throws RemoteException {
                synchronized (BluetoothDevice.class) {
                    BluetoothDevice.access$002(null);
                    return;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onBluetoothServiceUp(IBluetooth iBluetooth) throws RemoteException {
                synchronized (BluetoothDevice.class) {
                    BluetoothDevice.access$002(iBluetooth);
                    return;
                }
            }
        };
        CREATOR = new Parcelable.Creator<BluetoothDevice>(){

            @Override
            public BluetoothDevice createFromParcel(Parcel parcel) {
                return new BluetoothDevice(parcel.readString());
            }

            public BluetoothDevice[] newArray(int n) {
                return new BluetoothDevice[n];
            }
        };
    }

    BluetoothDevice(String string2) {
        BluetoothDevice.getService();
        if (!BluetoothAdapter.checkBluetoothAddress(string2)) {
            throw new IllegalArgumentException(string2 + " is not a valid Bluetooth address");
        }
        this.mAddress = string2;
    }

    static /* synthetic */ IBluetooth access$002(IBluetooth iBluetooth) {
        sService = iBluetooth;
        return iBluetooth;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] convertPinToBytes(String string2) {
        byte[] byArray;
        if (string2 == null) {
            return null;
        }
        try {
            byte[] byArray2;
            byArray = byArray2 = string2.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log.e(TAG, "UTF-8 not supported?!?");
            return null;
        }
        if (byArray.length <= 0) return null;
        if (byArray.length <= 16) return byArray;
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static IBluetooth getService() {
        synchronized (BluetoothDevice.class) {
            if (sService == null) {
                sService = BluetoothAdapter.getDefaultAdapter().getBluetoothService(mStateChangeCallback);
            }
            return sService;
        }
    }

    public boolean cancelBondProcess() {
        if (sService == null) {
            Log.e(TAG, "BT not enabled. Cannot cancel Remote Device bond");
            return false;
        }
        try {
            boolean bl = sService.cancelBondProcess(this);
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return false;
        }
    }

    public boolean cancelPairingUserInput() {
        if (sService == null) {
            Log.e(TAG, "BT not enabled. Cannot create pairing user input");
            return false;
        }
        try {
            boolean bl = sService.cancelBondProcess(this);
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return false;
        }
    }

    public BluetoothGatt connectGatt(Context context, boolean bl, BluetoothGattCallback bluetoothGattCallback) {
        return this.connectGatt(context, bl, bluetoothGattCallback, 0);
    }

    public BluetoothGatt connectGatt(Context context, boolean bl, BluetoothGattCallback bluetoothGattCallback, int n) {
        IBluetoothGatt iBluetoothGatt;
        block3: {
            IBluetoothManager iBluetoothManager = BluetoothAdapter.getDefaultAdapter().getBluetoothManager();
            try {
                iBluetoothGatt = iBluetoothManager.getBluetoothGatt();
                if (iBluetoothGatt != null) break block3;
                return null;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "", remoteException);
                return null;
            }
        }
        BluetoothGatt bluetoothGatt = new BluetoothGatt(context, iBluetoothGatt, this, n);
        bluetoothGatt.connect(bl, bluetoothGattCallback);
        return bluetoothGatt;
    }

    public boolean createBond() {
        if (sService == null) {
            Log.e(TAG, "BT not enabled. Cannot create bond to Remote Device");
            return false;
        }
        try {
            boolean bl = sService.createBond(this, 0);
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return false;
        }
    }

    public boolean createBond(int n) {
        if (sService == null) {
            Log.e(TAG, "BT not enabled. Cannot create bond to Remote Device");
            return false;
        }
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException(n + " is not a valid Bluetooth transport");
        }
        try {
            boolean bl = sService.createBond(this, n);
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return false;
        }
    }

    public boolean createBondOutOfBand(byte[] byArray, byte[] byArray2) {
        return false;
    }

    public BluetoothSocket createInsecureRfcommSocket(int n) throws IOException {
        return new BluetoothSocket(1, -1, false, false, this, n, null);
    }

    public BluetoothSocket createInsecureRfcommSocketToServiceRecord(UUID uUID) throws IOException {
        return new BluetoothSocket(1, -1, false, false, this, -1, new ParcelUuid(uUID));
    }

    public BluetoothSocket createRfcommSocket(int n) throws IOException {
        return new BluetoothSocket(1, -1, true, true, this, n, null);
    }

    public BluetoothSocket createRfcommSocketToServiceRecord(UUID uUID) throws IOException {
        return new BluetoothSocket(1, -1, true, true, this, -1, new ParcelUuid(uUID));
    }

    public BluetoothSocket createScoSocket() throws IOException {
        return new BluetoothSocket(2, -1, true, true, this, -1, null);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object object) {
        if (object instanceof BluetoothDevice) {
            return this.mAddress.equals(((BluetoothDevice)object).getAddress());
        }
        return false;
    }

    public boolean fetchMasInstances() {
        if (sService == null) {
            Log.e(TAG, "BT not enabled. Cannot query remote device for MAS instances");
            return false;
        }
        try {
            boolean bl = sService.fetchRemoteMasInstances(this);
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return false;
        }
    }

    public boolean fetchUuidsWithSdp() {
        IBluetooth iBluetooth = sService;
        if (iBluetooth == null) {
            Log.e(TAG, "BT not enabled. Cannot fetchUuidsWithSdp");
            return false;
        }
        try {
            boolean bl = iBluetooth.fetchRemoteUuids(this);
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return false;
        }
    }

    public String getAddress() {
        return this.mAddress;
    }

    public String getAlias() {
        if (sService == null) {
            Log.e(TAG, "BT not enabled. Cannot get Remote Device Alias");
            return null;
        }
        try {
            String string2 = sService.getRemoteAlias(this);
            return string2;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return null;
        }
    }

    public String getAliasName() {
        String string2 = this.getAlias();
        if (string2 == null) {
            string2 = this.getName();
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BluetoothClass getBluetoothClass() {
        int n;
        if (sService == null) {
            Log.e(TAG, "BT not enabled. Cannot get Bluetooth Class");
            return null;
        }
        try {
            n = sService.getRemoteClass(this);
            if (n == -16777216) return null;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return null;
        }
        return new BluetoothClass(n);
    }

    public int getBondState() {
        if (sService == null) {
            Log.e(TAG, "BT not enabled. Cannot get bond state");
            return 10;
        }
        try {
            int n = sService.getBondState(this);
            return n;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return 10;
        }
        catch (NullPointerException nullPointerException) {
            Log.e(TAG, "NullPointerException for getBondState() of device (" + this.getAddress() + ")", nullPointerException);
            return 10;
        }
    }

    public int getMessageAccessPermission() {
        if (sService == null) {
            return 0;
        }
        try {
            int n = sService.getMessageAccessPermission(this);
            return n;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return 0;
        }
    }

    public String getName() {
        if (sService == null) {
            Log.e(TAG, "BT not enabled. Cannot get Remote Device name");
            return null;
        }
        try {
            String string2 = sService.getRemoteName(this);
            return string2;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return null;
        }
    }

    public int getPhonebookAccessPermission() {
        if (sService == null) {
            return 0;
        }
        try {
            int n = sService.getPhonebookAccessPermission(this);
            return n;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return 0;
        }
    }

    public int getServiceChannel(ParcelUuid parcelUuid) {
        return Integer.MIN_VALUE;
    }

    public int getType() {
        if (sService == null) {
            Log.e(TAG, "BT not enabled. Cannot get Remote Device type");
            return 0;
        }
        try {
            int n = sService.getRemoteType(this);
            return n;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return 0;
        }
    }

    public ParcelUuid[] getUuids() {
        if (sService == null) {
            Log.e(TAG, "BT not enabled. Cannot get remote device Uuids");
            return null;
        }
        try {
            ParcelUuid[] parcelUuidArray = sService.getRemoteUuids(this);
            return parcelUuidArray;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return null;
        }
    }

    public int hashCode() {
        return this.mAddress.hashCode();
    }

    public boolean isBluetoothDock() {
        return false;
    }

    public boolean isConnected() {
        if (sService == null) {
            return false;
        }
        try {
            boolean bl = sService.isConnected(this);
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return false;
        }
    }

    public boolean removeBond() {
        if (sService == null) {
            Log.e(TAG, "BT not enabled. Cannot remove Remote Device bond");
            return false;
        }
        try {
            boolean bl = sService.removeBond(this);
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return false;
        }
    }

    public boolean setAlias(String string2) {
        if (sService == null) {
            Log.e(TAG, "BT not enabled. Cannot set Remote Device name");
            return false;
        }
        try {
            boolean bl = sService.setRemoteAlias(this, string2);
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return false;
        }
    }

    public boolean setDeviceOutOfBandData(byte[] byArray, byte[] byArray2) {
        return false;
    }

    public boolean setMessageAccessPermission(int n) {
        if (sService == null) {
            return false;
        }
        try {
            boolean bl = sService.setMessageAccessPermission(this, n);
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return false;
        }
    }

    public boolean setPairingConfirmation(boolean bl) {
        if (sService == null) {
            Log.e(TAG, "BT not enabled. Cannot set pairing confirmation");
            return false;
        }
        try {
            boolean bl2 = sService.setPairingConfirmation(this, bl);
            return bl2;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return false;
        }
    }

    public boolean setPasskey(int n) {
        return false;
    }

    public boolean setPhonebookAccessPermission(int n) {
        if (sService == null) {
            return false;
        }
        try {
            boolean bl = sService.setPhonebookAccessPermission(this, n);
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return false;
        }
    }

    public boolean setPin(byte[] byArray) {
        if (sService == null) {
            Log.e(TAG, "BT not enabled. Cannot set Remote Device pin");
            return false;
        }
        try {
            boolean bl = sService.setPin(this, true, byArray.length, byArray);
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "", remoteException);
            return false;
        }
    }

    public boolean setRemoteOutOfBandData() {
        return false;
    }

    public String toString() {
        return this.mAddress;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.mAddress);
    }
}

