/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothAudioConfig;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.IBluetoothA2dpSink;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;

public final class BluetoothA2dpSink
implements BluetoothProfile {
    public static final String ACTION_AUDIO_CONFIG_CHANGED = "android.bluetooth.a2dp-sink.profile.action.AUDIO_CONFIG_CHANGED";
    public static final String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.a2dp-sink.profile.action.CONNECTION_STATE_CHANGED";
    public static final String ACTION_PLAYING_STATE_CHANGED = "android.bluetooth.a2dp-sink.profile.action.PLAYING_STATE_CHANGED";
    private static final boolean DBG = true;
    public static final String EXTRA_AUDIO_CONFIG = "android.bluetooth.a2dp-sink.profile.extra.AUDIO_CONFIG";
    public static final int STATE_NOT_PLAYING = 11;
    public static final int STATE_PLAYING = 10;
    private static final String TAG = "BluetoothA2dpSink";
    private static final boolean VDBG;
    private BluetoothAdapter mAdapter;
    private final IBluetoothStateChangeCallback mBluetoothStateChangeCallback = new IBluetoothStateChangeCallback.Stub(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onBluetoothStateChange(boolean bl) {
            Log.d(BluetoothA2dpSink.TAG, "onBluetoothStateChange: up=" + bl);
            if (!bl) {
                ServiceConnection serviceConnection = BluetoothA2dpSink.this.mConnection;
                synchronized (serviceConnection) {
                    try {
                        BluetoothA2dpSink.access$102(BluetoothA2dpSink.this, null);
                        BluetoothA2dpSink.this.mContext.unbindService(BluetoothA2dpSink.this.mConnection);
                    }
                    catch (Exception exception) {
                        Log.e(BluetoothA2dpSink.TAG, "", exception);
                    }
                    return;
                }
            }
            ServiceConnection serviceConnection = BluetoothA2dpSink.this.mConnection;
            synchronized (serviceConnection) {
                try {
                    if (BluetoothA2dpSink.this.mService == null) {
                        BluetoothA2dpSink.this.doBind();
                    }
                }
                catch (Exception exception) {
                    Log.e(BluetoothA2dpSink.TAG, "", exception);
                }
                return;
            }
        }
    };
    private final ServiceConnection mConnection = new ServiceConnection(){

        @Override
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            Log.d(BluetoothA2dpSink.TAG, "Proxy object connected");
            BluetoothA2dpSink.access$102(BluetoothA2dpSink.this, IBluetoothA2dpSink.Stub.asInterface(iBinder));
            if (BluetoothA2dpSink.this.mServiceListener != null) {
                BluetoothA2dpSink.this.mServiceListener.onServiceConnected(10, BluetoothA2dpSink.this);
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
            Log.d(BluetoothA2dpSink.TAG, "Proxy object disconnected");
            BluetoothA2dpSink.access$102(BluetoothA2dpSink.this, null);
            if (BluetoothA2dpSink.this.mServiceListener != null) {
                BluetoothA2dpSink.this.mServiceListener.onServiceDisconnected(10);
            }
        }
    };
    private Context mContext;
    private IBluetoothA2dpSink mService;
    private BluetoothProfile.ServiceListener mServiceListener;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    BluetoothA2dpSink(Context context, BluetoothProfile.ServiceListener serviceListener) {
        this.mContext = context;
        this.mServiceListener = serviceListener;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        IBluetoothManager iBluetoothManager = this.mAdapter.getBluetoothManager();
        if (iBluetoothManager != null) {
            try {
                iBluetoothManager.registerStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "", remoteException);
            }
        }
        this.doBind();
    }

    static /* synthetic */ IBluetoothA2dpSink access$102(BluetoothA2dpSink bluetoothA2dpSink, IBluetoothA2dpSink iBluetoothA2dpSink) {
        bluetoothA2dpSink.mService = iBluetoothA2dpSink;
        return iBluetoothA2dpSink;
    }

    private boolean isEnabled() {
        return this.mAdapter.getState() == 12;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isValidDevice(BluetoothDevice bluetoothDevice) {
        return bluetoothDevice != null && BluetoothAdapter.checkBluetoothAddress(bluetoothDevice.getAddress());
    }

    private static void log(String string2) {
        Log.d(TAG, string2);
    }

    public static String stateToString(int n) {
        switch (n) {
            default: {
                return "<unknown state " + n + ">";
            }
            case 0: {
                return "disconnected";
            }
            case 1: {
                return "connecting";
            }
            case 2: {
                return "connected";
            }
            case 3: {
                return "disconnecting";
            }
            case 10: {
                return "playing";
            }
            case 11: 
        }
        return "not playing";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void close() {
        this.mServiceListener = null;
        IBluetoothManager iBluetoothManager = this.mAdapter.getBluetoothManager();
        if (iBluetoothManager != null) {
            try {
                iBluetoothManager.unregisterStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (Exception exception) {
                Log.e(TAG, "", exception);
            }
        }
        ServiceConnection serviceConnection = this.mConnection;
        synchronized (serviceConnection) {
            IBluetoothA2dpSink iBluetoothA2dpSink = this.mService;
            if (iBluetoothA2dpSink != null) {
                try {
                    this.mService = null;
                    this.mContext.unbindService(this.mConnection);
                }
                catch (Exception exception) {
                    Log.e(TAG, "", exception);
                }
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean connect(BluetoothDevice bluetoothDevice) {
        BluetoothA2dpSink.log("connect(" + bluetoothDevice + ")");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                boolean bl = this.mService.connect(bluetoothDevice);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        IBluetoothA2dpSink iBluetoothA2dpSink = this.mService;
        boolean bl = false;
        if (iBluetoothA2dpSink != null) return bl;
        Log.w(TAG, "Proxy not attached to service");
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean disconnect(BluetoothDevice bluetoothDevice) {
        BluetoothA2dpSink.log("disconnect(" + bluetoothDevice + ")");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                boolean bl = this.mService.disconnect(bluetoothDevice);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        IBluetoothA2dpSink iBluetoothA2dpSink = this.mService;
        boolean bl = false;
        if (iBluetoothA2dpSink != null) return bl;
        Log.w(TAG, "Proxy not attached to service");
        return false;
    }

    boolean doBind() {
        Intent intent = new Intent(IBluetoothA2dpSink.class.getName());
        ComponentName componentName = intent.resolveSystemService(this.mContext.getPackageManager(), 0);
        intent.setComponent(componentName);
        if (componentName == null || !this.mContext.bindServiceAsUser(intent, this.mConnection, 0, Process.myUserHandle())) {
            Log.e(TAG, "Could not bind to Bluetooth A2DP Service with " + intent);
            return false;
        }
        return true;
    }

    public void finalize() {
        this.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BluetoothAudioConfig getAudioConfig(BluetoothDevice bluetoothDevice) {
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                BluetoothAudioConfig bluetoothAudioConfig = this.mService.getAudioConfig(bluetoothDevice);
                return bluetoothAudioConfig;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
                return null;
            }
        }
        IBluetoothA2dpSink iBluetoothA2dpSink = this.mService;
        BluetoothAudioConfig bluetoothAudioConfig = null;
        if (iBluetoothA2dpSink != null) return bluetoothAudioConfig;
        Log.w(TAG, "Proxy not attached to service");
        return null;
    }

    @Override
    public List<BluetoothDevice> getConnectedDevices() {
        if (this.mService != null && this.isEnabled()) {
            try {
                List<BluetoothDevice> list = this.mService.getConnectedDevices();
                return list;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (this.mService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getConnectionState(BluetoothDevice bluetoothDevice) {
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                int n = this.mService.getConnectionState(bluetoothDevice);
                return n;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
                return 0;
            }
        }
        IBluetoothA2dpSink iBluetoothA2dpSink = this.mService;
        int n = 0;
        if (iBluetoothA2dpSink != null) return n;
        Log.w(TAG, "Proxy not attached to service");
        return 0;
    }

    @Override
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] nArray) {
        if (this.mService != null && this.isEnabled()) {
            try {
                List<BluetoothDevice> list = this.mService.getDevicesMatchingConnectionStates(nArray);
                return list;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (this.mService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }
}

