/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.app.WallpaperManager;
import android.app.backup.BackupDataInputStream;
import android.app.backup.BackupDataOutput;
import android.app.backup.BackupHelper;
import android.app.backup.FileBackupHelperBase;
import android.content.Context;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.util.Slog;
import android.view.Display;
import android.view.WindowManager;
import java.io.File;

public class WallpaperBackupHelper
extends FileBackupHelperBase
implements BackupHelper {
    private static final boolean DEBUG = false;
    private static final double MAX_HEIGHT_RATIO = 1.35;
    private static final double MIN_HEIGHT_RATIO = 0.0;
    private static final boolean REJECT_OUTSIZED_RESTORE = true;
    private static final String STAGE_FILE;
    private static final String TAG = "WallpaperBackupHelper";
    public static final String WALLPAPER_IMAGE;
    public static final String WALLPAPER_IMAGE_KEY = "/data/data/com.android.settings/files/wallpaper";
    public static final String WALLPAPER_INFO;
    public static final String WALLPAPER_INFO_KEY = "/data/system/wallpaper_info.xml";
    Context mContext;
    double mDesiredMinHeight;
    double mDesiredMinWidth;
    String[] mFiles;
    String[] mKeys;

    static {
        WALLPAPER_IMAGE = new File(Environment.getUserSystemDirectory(0), "wallpaper").getAbsolutePath();
        WALLPAPER_INFO = new File(Environment.getUserSystemDirectory(0), "wallpaper_info.xml").getAbsolutePath();
        STAGE_FILE = new File(Environment.getUserSystemDirectory(0), "wallpaper-tmp").getAbsolutePath();
    }

    public WallpaperBackupHelper(Context context, String[] stringArray, String[] stringArray2) {
        super(context);
        this.mContext = context;
        this.mFiles = stringArray;
        this.mKeys = stringArray2;
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        WallpaperManager wallpaperManager = (WallpaperManager)context.getSystemService("wallpaper");
        Display display = windowManager.getDefaultDisplay();
        Point point = new Point();
        display.getSize(point);
        this.mDesiredMinWidth = point.x;
        this.mDesiredMinHeight = wallpaperManager.getDesiredMinimumHeight();
        if (this.mDesiredMinHeight <= 0.0) {
            this.mDesiredMinHeight = point.y;
        }
    }

    @Override
    public void performBackup(ParcelFileDescriptor parcelFileDescriptor, BackupDataOutput backupDataOutput, ParcelFileDescriptor parcelFileDescriptor2) {
        WallpaperBackupHelper.performBackup_checked(parcelFileDescriptor, backupDataOutput, parcelFileDescriptor2, this.mFiles, this.mKeys);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void restoreEntity(BackupDataInputStream backupDataInputStream) {
        String string2 = backupDataInputStream.getKey();
        if (!this.isKeyInList(string2, this.mKeys)) return;
        if (string2.equals(WALLPAPER_IMAGE_KEY)) {
            File file = new File(STAGE_FILE);
            if (!this.writeFile(file, backupDataInputStream)) return;
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile(STAGE_FILE, options);
            double d = this.mDesiredMinHeight / (double)options.outHeight;
            if (!((double)options.outWidth < this.mDesiredMinWidth || d >= 1.35 || d <= 0.0)) {
                Slog.d(TAG, "Applying restored wallpaper image.");
                file.renameTo(new File(WALLPAPER_IMAGE));
                return;
            }
            Slog.i(TAG, "Restored image dimensions (w=" + options.outWidth + ", h=" + options.outHeight + ") too far off target (tw=" + this.mDesiredMinWidth + ", th=" + this.mDesiredMinHeight + "); falling back to default wallpaper.");
            file.delete();
            return;
        }
        if (!string2.equals(WALLPAPER_INFO_KEY)) return;
        this.writeFile(new File(WALLPAPER_INFO), backupDataInputStream);
    }
}

