/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.app.backup.IFullBackupRestoreObserver;
import android.app.backup.IRestoreSession;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;

public interface IBackupManager
extends IInterface {
    public void acknowledgeFullBackupOrRestore(int var1, boolean var2, String var3, String var4, IFullBackupRestoreObserver var5) throws RemoteException;

    public void agentConnected(String var1, IBinder var2) throws RemoteException;

    public void agentDisconnected(String var1) throws RemoteException;

    public boolean appBackupApkCopy(String var1, String var2, ParcelFileDescriptor[] var3) throws RemoteException;

    public boolean appBackupDataCopy(PackageInfo var1, String var2, String var3, boolean var4, ParcelFileDescriptor[] var5) throws RemoteException;

    public boolean appBackupDataRestore(PackageInfo var1, ParcelFileDescriptor[] var2) throws RemoteException;

    public void appBackupTearDown(PackageInfo var1) throws RemoteException;

    public void backupNow() throws RemoteException;

    public IRestoreSession beginRestoreSession(String var1, String var2) throws RemoteException;

    public void clearBackupData(String var1, String var2) throws RemoteException;

    public void dataChanged(String var1) throws RemoteException;

    public void fullBackup(ParcelFileDescriptor var1, boolean var2, boolean var3, boolean var4, boolean var5, boolean var6, boolean var7, boolean var8, String[] var9) throws RemoteException;

    public void fullRestore(ParcelFileDescriptor var1) throws RemoteException;

    public void fullTransportBackup(String[] var1) throws RemoteException;

    public Intent getConfigurationIntent(String var1) throws RemoteException;

    public String getCurrentTransport() throws RemoteException;

    public boolean getDataCopyResult() throws RemoteException;

    public Intent getDataManagementIntent(String var1) throws RemoteException;

    public String getDataManagementLabel(String var1) throws RemoteException;

    public String getDestinationString(String var1) throws RemoteException;

    public boolean hasBackupPassword() throws RemoteException;

    public boolean hasNewRestoreMethod() throws RemoteException;

    public boolean isBackupEnabled() throws RemoteException;

    public String[] listAllTransports() throws RemoteException;

    public void opComplete(int var1) throws RemoteException;

    public void restoreAtInstall(String var1, int var2) throws RemoteException;

    public String selectBackupTransport(String var1) throws RemoteException;

    public void setAutoRestore(boolean var1) throws RemoteException;

    public void setBackupEnabled(boolean var1) throws RemoteException;

    public boolean setBackupPassword(String var1, String var2) throws RemoteException;

    public void setBackupProvisioned(boolean var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBackupManager {
        private static final String DESCRIPTOR = "android.app.backup.IBackupManager";
        static final int TRANSACTION_acknowledgeFullBackupOrRestore = 16;
        static final int TRANSACTION_agentConnected = 3;
        static final int TRANSACTION_agentDisconnected = 4;
        static final int TRANSACTION_appBackupApkCopy = 27;
        static final int TRANSACTION_appBackupDataCopy = 26;
        static final int TRANSACTION_appBackupDataRestore = 31;
        static final int TRANSACTION_appBackupTearDown = 28;
        static final int TRANSACTION_backupNow = 12;
        static final int TRANSACTION_beginRestoreSession = 24;
        static final int TRANSACTION_clearBackupData = 2;
        static final int TRANSACTION_dataChanged = 1;
        static final int TRANSACTION_fullBackup = 13;
        static final int TRANSACTION_fullRestore = 15;
        static final int TRANSACTION_fullTransportBackup = 14;
        static final int TRANSACTION_getConfigurationIntent = 20;
        static final int TRANSACTION_getCurrentTransport = 17;
        static final int TRANSACTION_getDataCopyResult = 29;
        static final int TRANSACTION_getDataManagementIntent = 22;
        static final int TRANSACTION_getDataManagementLabel = 23;
        static final int TRANSACTION_getDestinationString = 21;
        static final int TRANSACTION_hasBackupPassword = 11;
        static final int TRANSACTION_hasNewRestoreMethod = 30;
        static final int TRANSACTION_isBackupEnabled = 9;
        static final int TRANSACTION_listAllTransports = 18;
        static final int TRANSACTION_opComplete = 25;
        static final int TRANSACTION_restoreAtInstall = 5;
        static final int TRANSACTION_selectBackupTransport = 19;
        static final int TRANSACTION_setAutoRestore = 7;
        static final int TRANSACTION_setBackupEnabled = 6;
        static final int TRANSACTION_setBackupPassword = 10;
        static final int TRANSACTION_setBackupProvisioned = 8;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IBackupManager asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IBackupManager) {
                return (IBackupManager)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.dataChanged(parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.clearBackupData(parcel.readString(), parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.agentConnected(parcel.readString(), parcel.readStrongBinder());
                    parcel2.writeNoException();
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.agentDisconnected(parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.restoreAtInstall(parcel.readString(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = parcel.readInt() != 0;
                    this.setBackupEnabled(bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = parcel.readInt() != 0;
                    this.setAutoRestore(bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = parcel.readInt() != 0;
                    this.setBackupProvisioned(bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 9: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isBackupEnabled();
                    parcel2.writeNoException();
                    int n3 = bl ? 1 : 0;
                    parcel2.writeInt(n3);
                    return true;
                }
                case 10: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.setBackupPassword(parcel.readString(), parcel.readString());
                    parcel2.writeNoException();
                    int n4 = bl ? 1 : 0;
                    parcel2.writeInt(n4);
                    return true;
                }
                case 11: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.hasBackupPassword();
                    parcel2.writeNoException();
                    int n5 = bl ? 1 : 0;
                    parcel2.writeInt(n5);
                    return true;
                }
                case 12: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.backupNow();
                    parcel2.writeNoException();
                    return true;
                }
                case 13: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ParcelFileDescriptor parcelFileDescriptor = parcel.readInt() != 0 ? ParcelFileDescriptor.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = parcel.readInt() != 0;
                    boolean bl2 = parcel.readInt() != 0;
                    boolean bl3 = parcel.readInt() != 0;
                    boolean bl4 = parcel.readInt() != 0;
                    boolean bl5 = parcel.readInt() != 0;
                    boolean bl6 = parcel.readInt() != 0;
                    boolean bl7 = parcel.readInt() != 0;
                    this.fullBackup(parcelFileDescriptor, bl, bl2, bl3, bl4, bl5, bl6, bl7, parcel.createStringArray());
                    parcel2.writeNoException();
                    return true;
                }
                case 14: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.fullTransportBackup(parcel.createStringArray());
                    parcel2.writeNoException();
                    return true;
                }
                case 15: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ParcelFileDescriptor parcelFileDescriptor = parcel.readInt() != 0 ? ParcelFileDescriptor.CREATOR.createFromParcel(parcel) : null;
                    this.fullRestore(parcelFileDescriptor);
                    parcel2.writeNoException();
                    return true;
                }
                case 16: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n6 = parcel.readInt();
                    boolean bl = parcel.readInt() != 0;
                    this.acknowledgeFullBackupOrRestore(n6, bl, parcel.readString(), parcel.readString(), IFullBackupRestoreObserver.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    return true;
                }
                case 17: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string2 = this.getCurrentTransport();
                    parcel2.writeNoException();
                    parcel2.writeString(string2);
                    return true;
                }
                case 18: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String[] stringArray = this.listAllTransports();
                    parcel2.writeNoException();
                    parcel2.writeStringArray(stringArray);
                    return true;
                }
                case 19: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string3 = this.selectBackupTransport(parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeString(string3);
                    return true;
                }
                case 20: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Intent intent = this.getConfigurationIntent(parcel.readString());
                    parcel2.writeNoException();
                    if (intent != null) {
                        parcel2.writeInt(1);
                        intent.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 21: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string4 = this.getDestinationString(parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeString(string4);
                    return true;
                }
                case 22: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Intent intent = this.getDataManagementIntent(parcel.readString());
                    parcel2.writeNoException();
                    if (intent != null) {
                        parcel2.writeInt(1);
                        intent.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 23: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string5 = this.getDataManagementLabel(parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeString(string5);
                    return true;
                }
                case 24: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IRestoreSession iRestoreSession = this.beginRestoreSession(parcel.readString(), parcel.readString());
                    parcel2.writeNoException();
                    IBinder iBinder = iRestoreSession != null ? iRestoreSession.asBinder() : null;
                    parcel2.writeStrongBinder(iBinder);
                    return true;
                }
                case 25: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.opComplete(parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 26: {
                    parcel.enforceInterface(DESCRIPTOR);
                    PackageInfo packageInfo = parcel.readInt() != 0 ? PackageInfo.CREATOR.createFromParcel(parcel) : null;
                    String string6 = parcel.readString();
                    String string7 = parcel.readString();
                    boolean bl = parcel.readInt() != 0;
                    Parcelable[] parcelableArray = parcel.createTypedArray(ParcelFileDescriptor.CREATOR);
                    boolean bl8 = this.appBackupDataCopy(packageInfo, string6, string7, bl, (ParcelFileDescriptor[])parcelableArray);
                    parcel2.writeNoException();
                    int n7 = bl8 ? 1 : 0;
                    parcel2.writeInt(n7);
                    parcel2.writeTypedArray(parcelableArray, 1);
                    return true;
                }
                case 27: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string8 = parcel.readString();
                    String string9 = parcel.readString();
                    Parcelable[] parcelableArray = parcel.createTypedArray(ParcelFileDescriptor.CREATOR);
                    boolean bl = this.appBackupApkCopy(string8, string9, (ParcelFileDescriptor[])parcelableArray);
                    parcel2.writeNoException();
                    int n8 = bl ? 1 : 0;
                    parcel2.writeInt(n8);
                    parcel2.writeTypedArray(parcelableArray, 1);
                    return true;
                }
                case 28: {
                    parcel.enforceInterface(DESCRIPTOR);
                    PackageInfo packageInfo = parcel.readInt() != 0 ? PackageInfo.CREATOR.createFromParcel(parcel) : null;
                    this.appBackupTearDown(packageInfo);
                    parcel2.writeNoException();
                    return true;
                }
                case 29: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.getDataCopyResult();
                    parcel2.writeNoException();
                    int n9 = bl ? 1 : 0;
                    parcel2.writeInt(n9);
                    return true;
                }
                case 30: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.hasNewRestoreMethod();
                    parcel2.writeNoException();
                    int n10 = bl ? 1 : 0;
                    parcel2.writeInt(n10);
                    return true;
                }
                case 31: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            PackageInfo packageInfo = parcel.readInt() != 0 ? PackageInfo.CREATOR.createFromParcel(parcel) : null;
            Parcelable[] parcelableArray = parcel.createTypedArray(ParcelFileDescriptor.CREATOR);
            boolean bl = this.appBackupDataRestore(packageInfo, (ParcelFileDescriptor[])parcelableArray);
            parcel2.writeNoException();
            int n11 = bl ? 1 : 0;
            parcel2.writeInt(n11);
            parcel2.writeTypedArray(parcelableArray, 1);
            return true;
        }

        private static class Proxy
        implements IBackupManager {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void acknowledgeFullBackupOrRestore(int n, boolean bl, String string2, String string3, IFullBackupRestoreObserver iFullBackupRestoreObserver) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    int n2 = 0;
                    if (bl) {
                        n2 = 1;
                    }
                    parcel.writeInt(n2);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    IBinder iBinder = iFullBackupRestoreObserver != null ? iFullBackupRestoreObserver.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(16, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void agentConnected(String string2, IBinder iBinder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void agentDisconnected(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public boolean appBackupApkCopy(String string2, String string3, ParcelFileDescriptor[] parcelFileDescriptorArray) throws RemoteException {
                boolean bl;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel2.writeString(string2);
                    parcel2.writeString(string3);
                    parcel2.writeTypedArray(parcelFileDescriptorArray, 0);
                    this.mRemote.transact(27, parcel2, parcel, 0);
                    parcel.readException();
                    int n = parcel.readInt();
                    bl = false;
                    if (n == 0) break block4;
                    bl = true;
                }
                try {
                    parcel.readTypedArray(parcelFileDescriptorArray, ParcelFileDescriptor.CREATOR);
                    return bl;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean appBackupDataCopy(PackageInfo packageInfo, String string2, String string3, boolean bl, ParcelFileDescriptor[] parcelFileDescriptorArray) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl2;
                block6: {
                    block5: {
                        bl2 = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            if (packageInfo != null) {
                                parcel2.writeInt(1);
                                packageInfo.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            parcel2.writeString(string2);
                            parcel2.writeString(string3);
                            boolean bl3 = bl ? bl2 : false;
                            parcel2.writeInt(bl3 ? 1 : 0);
                            parcel2.writeTypedArray(parcelFileDescriptorArray, 0);
                            this.mRemote.transact(26, parcel2, parcel, 0);
                            parcel.readException();
                            if (parcel.readInt() == 0) break block5;
                            break block6;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl2 = false;
                }
                parcel.readTypedArray(parcelFileDescriptorArray, ParcelFileDescriptor.CREATOR);
                parcel.recycle();
                parcel2.recycle();
                return bl2;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean appBackupDataRestore(PackageInfo packageInfo, ParcelFileDescriptor[] parcelFileDescriptorArray) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl;
                block6: {
                    block5: {
                        bl = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            if (packageInfo != null) {
                                parcel2.writeInt(1);
                                packageInfo.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            parcel2.writeTypedArray(parcelFileDescriptorArray, 0);
                            this.mRemote.transact(31, parcel2, parcel, 0);
                            parcel.readException();
                            if (parcel.readInt() == 0) break block5;
                            break block6;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl = false;
                }
                parcel.readTypedArray(parcelFileDescriptorArray, ParcelFileDescriptor.CREATOR);
                parcel.recycle();
                parcel2.recycle();
                return bl;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void appBackupTearDown(PackageInfo packageInfo) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (packageInfo != null) {
                        parcel.writeInt(1);
                        packageInfo.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(28, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            @Override
            public void backupNow() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(12, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public IRestoreSession beginRestoreSession(String string2, String string3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    this.mRemote.transact(24, parcel, parcel2, 0);
                    parcel2.readException();
                    IRestoreSession iRestoreSession = IRestoreSession.Stub.asInterface(parcel2.readStrongBinder());
                    return iRestoreSession;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void clearBackupData(String string2, String string3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void dataChanged(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void fullBackup(ParcelFileDescriptor parcelFileDescriptor, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, String[] stringArray) throws RemoteException {
                int n = 1;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (parcelFileDescriptor != null) {
                        parcel.writeInt(1);
                        parcelFileDescriptor.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
                int n2 = bl ? n : 0;
                parcel.writeInt(n2);
                int n3 = bl2 ? n : 0;
                parcel.writeInt(n3);
                int n4 = bl3 ? n : 0;
                parcel.writeInt(n4);
                int n5 = bl4 ? n : 0;
                parcel.writeInt(n5);
                int n6 = bl5 ? n : 0;
                parcel.writeInt(n6);
                int n7 = bl6 ? n : 0;
                parcel.writeInt(n7);
                if (!bl7) {
                    n = 0;
                }
                parcel.writeInt(n);
                parcel.writeStringArray(stringArray);
                this.mRemote.transact(13, parcel, parcel2, 0);
                parcel2.readException();
                parcel2.recycle();
                parcel.recycle();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void fullRestore(ParcelFileDescriptor parcelFileDescriptor) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (parcelFileDescriptor != null) {
                        parcel.writeInt(1);
                        parcelFileDescriptor.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(15, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void fullTransportBackup(String[] stringArray) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStringArray(stringArray);
                    this.mRemote.transact(14, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Intent getConfigurationIntent(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(20, parcel, parcel2, 0);
                    parcel2.readException();
                    Intent intent = parcel2.readInt() != 0 ? Intent.CREATOR.createFromParcel(parcel2) : null;
                    return intent;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public String getCurrentTransport() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(17, parcel, parcel2, 0);
                    parcel2.readException();
                    String string2 = parcel2.readString();
                    return string2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public boolean getDataCopyResult() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(29, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Intent getDataManagementIntent(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(22, parcel, parcel2, 0);
                    parcel2.readException();
                    Intent intent = parcel2.readInt() != 0 ? Intent.CREATOR.createFromParcel(parcel2) : null;
                    return intent;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public String getDataManagementLabel(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(23, parcel, parcel2, 0);
                    parcel2.readException();
                    String string3 = parcel2.readString();
                    return string3;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public String getDestinationString(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(21, parcel, parcel2, 0);
                    parcel2.readException();
                    String string3 = parcel2.readString();
                    return string3;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public boolean hasBackupPassword() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(11, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean hasNewRestoreMethod() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(30, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isBackupEnabled() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public String[] listAllTransports() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(18, parcel, parcel2, 0);
                    parcel2.readException();
                    String[] stringArray = parcel2.createStringArray();
                    return stringArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void opComplete(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(25, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void restoreAtInstall(String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public String selectBackupTransport(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(19, parcel, parcel2, 0);
                    parcel2.readException();
                    String string3 = parcel2.readString();
                    return string3;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setAutoRestore(boolean bl) throws RemoteException {
                int n;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    n = 0;
                    if (!bl) break block4;
                    n = 1;
                }
                try {
                    parcel2.writeInt(n);
                    this.mRemote.transact(7, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public void setBackupEnabled(boolean bl) throws RemoteException {
                int n;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    n = 0;
                    if (!bl) break block4;
                    n = 1;
                }
                try {
                    parcel2.writeInt(n);
                    this.mRemote.transact(6, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public boolean setBackupPassword(String string2, String string3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    this.mRemote.transact(10, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void setBackupProvisioned(boolean bl) throws RemoteException {
                int n;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    n = 0;
                    if (!bl) break block4;
                    n = 1;
                }
                try {
                    parcel2.writeInt(n);
                    this.mRemote.transact(8, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }
        }
    }
}

