/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.app.backup.BackupDataInputStream;
import android.app.backup.BackupDataOutput;
import android.content.Context;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import java.io.File;
import java.io.FileDescriptor;

class FileBackupHelperBase {
    private static final String TAG = "FileBackupHelperBase";
    Context mContext;
    boolean mExceptionLogged;
    long mPtr = FileBackupHelperBase.ctor();

    FileBackupHelperBase(Context context) {
        this.mContext = context;
    }

    private static native long ctor();

    private static native void dtor(long var0);

    /*
     * Enabled aggressive block sorting
     */
    static void performBackup_checked(ParcelFileDescriptor parcelFileDescriptor, BackupDataOutput backupDataOutput, ParcelFileDescriptor parcelFileDescriptor2, String[] stringArray, String[] stringArray2) {
        int n;
        block7: {
            block6: {
                if (stringArray.length == 0) break block6;
                int n2 = stringArray.length;
                for (int i = 0; i < n2; ++i) {
                    String string2 = stringArray[i];
                    if (string2.charAt(0) == '/') continue;
                    throw new RuntimeException("files must have all absolute paths: " + string2);
                }
                if (stringArray.length != stringArray2.length) {
                    throw new RuntimeException("files.length=" + stringArray.length + " keys.length=" + stringArray2.length);
                }
                FileDescriptor fileDescriptor = parcelFileDescriptor != null ? parcelFileDescriptor.getFileDescriptor() : null;
                FileDescriptor fileDescriptor2 = parcelFileDescriptor2.getFileDescriptor();
                if (fileDescriptor2 == null) {
                    throw new NullPointerException();
                }
                n = FileBackupHelperBase.performBackup_native(fileDescriptor, backupDataOutput.mBackupWriter, fileDescriptor2, stringArray, stringArray2);
                if (n != 0) break block7;
            }
            return;
        }
        throw new RuntimeException("Backup failed 0x" + Integer.toHexString(n));
    }

    private static native int performBackup_native(FileDescriptor var0, long var1, FileDescriptor var3, String[] var4, String[] var5);

    private static native int writeFile_native(long var0, String var2, long var3);

    private static native int writeSnapshot_native(long var0, FileDescriptor var2);

    protected void finalize() throws Throwable {
        try {
            FileBackupHelperBase.dtor(this.mPtr);
            return;
        }
        finally {
            super.finalize();
        }
    }

    boolean isKeyInList(String string2, String[] stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].equals(string2)) continue;
            return true;
        }
        return false;
    }

    boolean writeFile(File file, BackupDataInputStream backupDataInputStream) {
        file.getParentFile().mkdirs();
        int n = FileBackupHelperBase.writeFile_native(this.mPtr, file.getAbsolutePath(), backupDataInputStream.mData.mBackupReader);
        if (n != 0 && !this.mExceptionLogged) {
            Log.e(TAG, "Failed restoring file '" + file + "' for app '" + this.mContext.getPackageName() + "' result=0x" + Integer.toHexString(n));
            this.mExceptionLogged = true;
        }
        return n == 0;
    }

    public void writeNewStateDescription(ParcelFileDescriptor parcelFileDescriptor) {
        FileBackupHelperBase.writeSnapshot_native(this.mPtr, parcelFileDescriptor.getFileDescriptor());
    }
}

