/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import java.io.FileDescriptor;
import java.io.IOException;

public class BackupDataOutput {
    long mBackupWriter;

    public BackupDataOutput(FileDescriptor fileDescriptor) {
        if (fileDescriptor == null) {
            throw new NullPointerException();
        }
        this.mBackupWriter = BackupDataOutput.ctor(fileDescriptor);
        if (this.mBackupWriter == 0L) {
            throw new RuntimeException("Native initialization failed with fd=" + fileDescriptor);
        }
    }

    private static native long ctor(FileDescriptor var0);

    private static native void dtor(long var0);

    private static native void setKeyPrefix_native(long var0, String var2);

    private static native int writeEntityData_native(long var0, byte[] var2, int var3);

    private static native int writeEntityHeader_native(long var0, String var2, int var3);

    protected void finalize() throws Throwable {
        try {
            BackupDataOutput.dtor(this.mBackupWriter);
            return;
        }
        finally {
            super.finalize();
        }
    }

    public void setKeyPrefix(String string2) {
        BackupDataOutput.setKeyPrefix_native(this.mBackupWriter, string2);
    }

    public int writeEntityData(byte[] byArray, int n) throws IOException {
        int n2 = BackupDataOutput.writeEntityData_native(this.mBackupWriter, byArray, n);
        if (n2 >= 0) {
            return n2;
        }
        throw new IOException("result=0x" + Integer.toHexString(n2));
    }

    public int writeEntityHeader(String string2, int n) throws IOException {
        int n2 = BackupDataOutput.writeEntityHeader_native(this.mBackupWriter, string2, n);
        if (n2 >= 0) {
            return n2;
        }
        throw new IOException("result=0x" + Integer.toHexString(n2));
    }
}

