/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import java.io.FileDescriptor;
import java.io.IOException;

public class BackupDataInput {
    long mBackupReader;
    private EntityHeader mHeader = new EntityHeader();
    private boolean mHeaderReady;

    public BackupDataInput(FileDescriptor fileDescriptor) {
        if (fileDescriptor == null) {
            throw new NullPointerException();
        }
        this.mBackupReader = BackupDataInput.ctor(fileDescriptor);
        if (this.mBackupReader == 0L) {
            throw new RuntimeException("Native initialization failed with fd=" + fileDescriptor);
        }
    }

    private static native long ctor(FileDescriptor var0);

    private static native void dtor(long var0);

    private native int readEntityData_native(long var1, byte[] var3, int var4, int var5);

    private native int readNextHeader_native(long var1, EntityHeader var3);

    private native int skipEntityData_native(long var1);

    protected void finalize() throws Throwable {
        try {
            BackupDataInput.dtor(this.mBackupReader);
            return;
        }
        finally {
            super.finalize();
        }
    }

    public int getDataSize() {
        if (this.mHeaderReady) {
            return this.mHeader.dataSize;
        }
        throw new IllegalStateException("Entity header not read");
    }

    public String getKey() {
        if (this.mHeaderReady) {
            return this.mHeader.key;
        }
        throw new IllegalStateException("Entity header not read");
    }

    public int readEntityData(byte[] byArray, int n, int n2) throws IOException {
        if (this.mHeaderReady) {
            int n3 = this.readEntityData_native(this.mBackupReader, byArray, n, n2);
            if (n3 >= 0) {
                return n3;
            }
            throw new IOException("result=0x" + Integer.toHexString(n3));
        }
        throw new IllegalStateException("Entity header not read");
    }

    public boolean readNextHeader() throws IOException {
        int n = this.readNextHeader_native(this.mBackupReader, this.mHeader);
        if (n == 0) {
            this.mHeaderReady = true;
            return true;
        }
        if (n > 0) {
            this.mHeaderReady = false;
            return false;
        }
        this.mHeaderReady = false;
        throw new IOException("failed: 0x" + Integer.toHexString(n));
    }

    public void skipEntityData() throws IOException {
        if (this.mHeaderReady) {
            this.skipEntityData_native(this.mBackupReader);
            return;
        }
        throw new IllegalStateException("Entity header not read");
    }

    private static class EntityHeader {
        int dataSize;
        String key;

        private EntityHeader() {
        }
    }
}

