/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.content.Context;
import android.content.res.Resources;
import android.os.SystemProperties;
import android.text.TextUtils;
import android.util.Log;
import android.util.Xml;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParserException;

public class WallpaperUtilities {
    protected static final String CUSTOMIZE_RES_PACKAGE_NAME = "com.asus.LauncherRes";
    private static final boolean DEBUG = false;
    public static final int INVALID_RESOURCE_ID = 0;
    private static final String PROP_IDCODE = "ro.config.idcode";
    private static final String RES_CUSTOMIZE_ETC_ROOT_PATH = "/system/etc/LauncherRes";
    private static final String RES_CUSTOMIZE_ROOT_PATH = "/system/vendor/etc";
    private static final String RES_VERSA_DEFAULT_FOLDER_NAME = "Generic";
    private static final String TAG = "WallpaperUtilities";
    private static final String WALLPAPER_LIST_FILENAME = "wallpaper_list.xml";
    private static final String WALLPAPER_PATH = "/Launcher/wallpapers";

    protected static String getADFDefaultWallpaperFilePath(Context context) {
        String[] stringArray = WallpaperUtilities.getWallpaperListInOrder(context, WALLPAPER_LIST_FILENAME, WallpaperUtilities.getWallpaperFolderPath());
        String string2 = null;
        if (stringArray != null) {
            int n = stringArray.length;
            string2 = null;
            if (n > 0) {
                string2 = WallpaperUtilities.getWallpaperFilePathFromADF(stringArray[0]);
            }
        }
        return string2;
    }

    private static String getColorIdCode() {
        String string2 = SystemProperties.get(PROP_IDCODE, "").toLowerCase();
        Log.d(TAG, "getColorIdCode: " + string2);
        if (TextUtils.isEmpty(string2) || string2.equals("unknown")) {
            string2 = "1a";
        }
        return WallpaperUtilities.mappingColorIdCodeForZf2(string2);
    }

    protected static int getDefaultWallpaperResId(Resources resources, String string2) {
        if (string2 == null) {
            string2 = "android";
        }
        String string3 = WallpaperUtilities.getColorIdCode();
        int n = resources.getIdentifier("default_wallpaper_" + string3, "drawable", string2);
        if (n == 0) {
            String string4 = WallpaperUtilities.getPartialMatchedColorIdCode(string3);
            n = resources.getIdentifier("default_wallpaper_" + string4, "drawable", string2);
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static String getEtcResDefaultWallpaperFilePath(Context context) {
        String string2 = WallpaperUtilities.getColorIdCode();
        String string3 = WallpaperUtilities.isSupportDds() && WallpaperUtilities.isDdsPad(context) ? "pad_default_wallpaper_" + string2 : "default_wallpaper_" + string2;
        File[] fileArray = WallpaperUtilities.getFileStartsWith(WallpaperUtilities.getLauncherResFolderPath(), string3, true);
        if (fileArray != null && fileArray.length > 0) {
            return fileArray[0].toString();
        }
        String string4 = WallpaperUtilities.getPartialMatchedColorIdCode(string2);
        String string5 = WallpaperUtilities.isSupportDds() && WallpaperUtilities.isDdsPad(context) ? "pad_default_wallpaper_" + string4 : "default_wallpaper_" + string4;
        File[] fileArray2 = WallpaperUtilities.getFileStartsWith(WallpaperUtilities.getLauncherResFolderPath(), string5, true);
        if (fileArray2 != null && fileArray2.length > 0) {
            return fileArray2[0].toString();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static String getEtcResDefaultWallpaperFilePathForLockscreen(Context context) {
        String string2 = WallpaperUtilities.isSupportDds() && WallpaperUtilities.isDdsPad(context) ? "pad_default_wallpaper_1a" : "default_wallpaper_1a";
        File[] fileArray = WallpaperUtilities.getFileStartsWith(WallpaperUtilities.getLauncherResFolderPath(), string2, true);
        if (fileArray != null && fileArray.length > 0) {
            return fileArray[0].toString();
        }
        return null;
    }

    private static File[] getFileStartsWith(final String string2, final String string3, final boolean bl) {
        if (!WallpaperUtilities.isDirectory(string2)) {
            return null;
        }
        return new File(string2).listFiles(new FilenameFilter(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public boolean accept(File file, String string22) {
                String string32;
                if (bl) {
                    string22 = string22.toLowerCase();
                }
                if (string22.startsWith(string32 = bl ? string3.toLowerCase() : string3)) {
                    Log.v(WallpaperUtilities.TAG, "find: " + string22 + ", getFileStartsWith: " + string3 + ", ignoreCase= " + bl + ", find in folder: " + string2);
                    return true;
                }
                return false;
            }
        });
    }

    private static String getLauncherResFolderPath() {
        return RES_CUSTOMIZE_ETC_ROOT_PATH;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static Resources getLauncherResources(Resources resources) {
        try {
            Object obj = Class.forName("android.content.res.AssetManager").getDeclaredConstructor(null).newInstance(null);
            obj.getClass().getDeclaredMethod("addAssetPath", String.class).invoke(obj, "/system/app/AsusLauncherRes.apk");
            Class[] classArray = new Class[]{obj.getClass(), resources.getDisplayMetrics().getClass(), resources.getConfiguration().getClass()};
            Constructor constructor = Resources.class.getDeclaredConstructor(classArray);
            Object[] objectArray = new Object[]{obj, resources.getDisplayMetrics(), resources.getConfiguration()};
            return (Resources)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            return null;
        }
        catch (Resources.NotFoundException notFoundException) {
            return null;
        }
    }

    private static String getPartialMatchedColorIdCode(String string2) {
        if (string2.length() > 1) {
            string2 = 1 + string2.substring(-1 + string2.length());
        }
        return string2;
    }

    public static int getScreenSize(Context context) {
        if (context == null) {
            return -1;
        }
        return 0xF & context.getResources().getConfiguration().screenLayout;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String getVersatilityPath() {
        String string2 = "/system/vendor/etc/" + SystemProperties.get("ro.config.versatility", RES_VERSA_DEFAULT_FOLDER_NAME).trim() + "/" + SystemProperties.get("ro.config.CID", "").trim();
        if (WallpaperUtilities.isDirectory(string2) || WallpaperUtilities.isDirectory(string2 = "/system/vendor/etc/Generic")) {
            return string2;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String getWallpaperFilePathFromADF(String string2) {
        File[] fileArray;
        if (WallpaperUtilities.getVersatilityPath() == null || (fileArray = WallpaperUtilities.getFileStartsWith(WallpaperUtilities.getWallpaperFolderPath(), string2, true)) == null || fileArray.length <= 0) {
            return null;
        }
        if (fileArray.length > 1) {
            // empty if block
        }
        return fileArray[0].toString();
    }

    private static String getWallpaperFolderPath() {
        String string2 = WallpaperUtilities.getVersatilityPath();
        if (TextUtils.isEmpty(string2)) {
            return null;
        }
        return string2 + WALLPAPER_PATH;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String[] getWallpaperListInOrder(Context var0, String var1_1, String var2_2) {
        block35: {
            var3_3 = WallpaperUtilities.isSupportDds() != false && WallpaperUtilities.isDdsPad(var0) != false ? "pad_default_wallpaper_names" : "default_wallpaper_names";
            var4_4 = new ArrayList<String>();
            var5_5 = WallpaperUtilities.getFileStartsWith(var2_2, var1_1, true);
            if (var5_5 == null) {
                return null;
            }
            if (var5_5.length <= 0) break block35;
            var6_6 = null;
            var7_7 = new BufferedInputStream(new FileInputStream(var5_5[0]));
            try {
                block36: {
                    var20_8 = Xml.newPullParser();
                    var20_8.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
                    var20_8.setInput(var7_7, null);
                    var21_9 = var20_8.getEventType();
                    break block36;
                    catch (IOException var8_16) {}
                    ** GOTO lbl-1000
                    catch (XmlPullParserException var14_20) {}
                    ** GOTO lbl-1000
                }
                while (var21_9 != 1) {
                    if ("string-array".equals(var20_8.getName()) && var20_8.getEventType() == 2 && var3_3.equals(var20_8.getAttributeValue(null, "name"))) {
                        while (var20_8.nextTag() == 2) {
                            var20_8.require(2, null, "item");
                            var4_4.add(var20_8.nextText());
                            if (var20_8.getEventType() != 3) {
                                var20_8.nextTag();
                            }
                            var20_8.require(3, null, "item");
                        }
                    }
                    var21_9 = var22_10 = var20_8.next();
                }
                ** GOTO lbl38
            }
            catch (FileNotFoundException var17_11) {
                var6_6 = var7_7;
                ** GOTO lbl73
lbl38:
                // 1 sources

                if (var7_7 != null) {
                    try {
                        var7_7.close();
                    }
                    catch (IOException var25_14) {
                        Log.w("WallpaperUtilities", "close fail ", var25_14);
                    }
                }
                catch (Throwable var9_26) {
                    var6_6 = var7_7;
                }
                catch (XmlPullParserException var14_22) {
                    var6_6 = var7_7;
                }
lbl-1000:
                // 2 sources

                {
                    var14_21.printStackTrace();
                    ** if (var6_6 == null) goto lbl-1000
lbl-1000:
                    // 1 sources

                    {
                        try {
                            var6_6.close();
                        }
                        catch (IOException var15_23) {
                            Log.w("WallpaperUtilities", "close fail ", var15_23);
                        }
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block35;
                    }
                    catch (IOException var8_18) {
                        var6_6 = var7_7;
                    }
lbl-1000:
                    // 2 sources

                    {
                        try {
                            var8_17.printStackTrace();
                            ** if (var6_6 == null) goto lbl-1000
                        }
                        catch (Throwable var9_24) {}
lbl-1000:
                        // 1 sources

                        {
                            try {
                                var6_6.close();
                            }
                            catch (IOException var12_19) {
                                Log.w("WallpaperUtilities", "close fail ", var12_19);
                            }
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block35;
                        }
lbl73:
                        // 2 sources

                        while (true) {
                            var17_12.printStackTrace();
                            break;
                        }
                    }
                }
                finally {
                    if (var6_6 == null) break block35;
                    try {
                        var6_6.close();
                    }
                    catch (IOException var18_15) {
                        Log.w("WallpaperUtilities", "close fail ", var18_15);
                    }
                }
            }
        }
        if (var4_4.isEmpty()) {
            return null;
        }
        return var4_4.toArray(new String[var4_4.size()]);
        catch (FileNotFoundException var17_13) {
            var6_6 = null;
            ** continue;
        }
    }

    public static boolean isDdsPad(Context context) {
        return WallpaperUtilities.isSupportDds() && WallpaperUtilities.isScreenSizePad(WallpaperUtilities.getScreenSize(context));
    }

    private static boolean isDirectory(String string2) {
        if (TextUtils.isEmpty(string2)) {
            return false;
        }
        return new File(string2).isDirectory();
    }

    public static boolean isScreenSizePad(int n) {
        return n > 2;
    }

    public static boolean isSupportDds() {
        return SystemProperties.getInt("persist.sys.padfone", 0) == 1;
    }

    /*
     * Exception decompiling
     */
    public static boolean isZf2List() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String mappingColorIdCodeForZf2(String string2) {
        String string3 = string2;
        if (WallpaperUtilities.isZf2List()) {
            if (string2.length() > 1) {
                string3 = string2.substring(-1 + string2.length());
            }
            if ("b".equals(string3)) {
                string3 = "a";
            }
            string3 = 1 + string3;
            Log.d(TAG, "mappingIdCode from " + string2 + " to " + string3);
        }
        return string3;
    }
}

