/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Printer;
import android.util.Xml;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParserException;

public final class WallpaperInfo
implements Parcelable {
    public static final Parcelable.Creator<WallpaperInfo> CREATOR = new Parcelable.Creator<WallpaperInfo>(){

        @Override
        public WallpaperInfo createFromParcel(Parcel parcel) {
            return new WallpaperInfo(parcel);
        }

        public WallpaperInfo[] newArray(int n) {
            return new WallpaperInfo[n];
        }
    };
    static final String TAG = "WallpaperInfo";
    final int mAuthorResource;
    final int mDescriptionResource;
    final ResolveInfo mService;
    final String mSettingsActivityName;
    final int mThumbnailResource;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WallpaperInfo(Context context, ResolveInfo resolveInfo) throws XmlPullParserException, IOException {
        int n;
        int n2;
        int n3;
        String string2;
        this.mService = resolveInfo;
        ServiceInfo serviceInfo = resolveInfo.serviceInfo;
        PackageManager packageManager = context.getPackageManager();
        XmlResourceParser xmlResourceParser = null;
        try {
            int n4;
            try {
                xmlResourceParser = serviceInfo.loadXmlMetaData(packageManager, "android.service.wallpaper");
                if (xmlResourceParser == null) {
                    throw new XmlPullParserException("No android.service.wallpaper meta-data");
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                throw new XmlPullParserException("Unable to create context for: " + serviceInfo.packageName);
            }
            Resources resources = packageManager.getResourcesForApplication(serviceInfo.applicationInfo);
            AttributeSet attributeSet = Xml.asAttributeSet(xmlResourceParser);
            while ((n4 = xmlResourceParser.next()) != 1 && n4 != 2) {
            }
            if (!"wallpaper".equals(xmlResourceParser.getName())) {
                throw new XmlPullParserException("Meta-data does not start with wallpaper tag");
            }
            TypedArray typedArray = resources.obtainAttributes(attributeSet, R.styleable.Wallpaper);
            string2 = typedArray.getString(1);
            n3 = typedArray.getResourceId(2, -1);
            n2 = typedArray.getResourceId(3, -1);
            n = typedArray.getResourceId(0, -1);
            typedArray.recycle();
        }
        finally {
            if (xmlResourceParser != null) {
                xmlResourceParser.close();
            }
        }
        this.mSettingsActivityName = string2;
        this.mThumbnailResource = n3;
        this.mAuthorResource = n2;
        this.mDescriptionResource = n;
    }

    WallpaperInfo(Parcel parcel) {
        this.mSettingsActivityName = parcel.readString();
        this.mThumbnailResource = parcel.readInt();
        this.mAuthorResource = parcel.readInt();
        this.mDescriptionResource = parcel.readInt();
        this.mService = ResolveInfo.CREATOR.createFromParcel(parcel);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void dump(Printer printer, String string2) {
        printer.println(string2 + "Service:");
        this.mService.dump(printer, string2 + "  ");
        printer.println(string2 + "mSettingsActivityName=" + this.mSettingsActivityName);
    }

    public ComponentName getComponent() {
        return new ComponentName(this.mService.serviceInfo.packageName, this.mService.serviceInfo.name);
    }

    public String getPackageName() {
        return this.mService.serviceInfo.packageName;
    }

    public ServiceInfo getServiceInfo() {
        return this.mService.serviceInfo;
    }

    public String getServiceName() {
        return this.mService.serviceInfo.name;
    }

    public String getSettingsActivity() {
        return this.mSettingsActivityName;
    }

    public CharSequence loadAuthor(PackageManager packageManager) throws Resources.NotFoundException {
        if (this.mAuthorResource <= 0) {
            throw new Resources.NotFoundException();
        }
        String string2 = this.mService.resolvePackageName;
        ApplicationInfo applicationInfo = null;
        if (string2 == null) {
            string2 = this.mService.serviceInfo.packageName;
            applicationInfo = this.mService.serviceInfo.applicationInfo;
        }
        return packageManager.getText(string2, this.mAuthorResource, applicationInfo);
    }

    public CharSequence loadDescription(PackageManager packageManager) throws Resources.NotFoundException {
        String string2 = this.mService.resolvePackageName;
        ApplicationInfo applicationInfo = null;
        if (string2 == null) {
            string2 = this.mService.serviceInfo.packageName;
            applicationInfo = this.mService.serviceInfo.applicationInfo;
        }
        if (this.mService.serviceInfo.descriptionRes != 0) {
            return packageManager.getText(string2, this.mService.serviceInfo.descriptionRes, applicationInfo);
        }
        if (this.mDescriptionResource <= 0) {
            throw new Resources.NotFoundException();
        }
        return packageManager.getText(string2, this.mDescriptionResource, this.mService.serviceInfo.applicationInfo);
    }

    public Drawable loadIcon(PackageManager packageManager) {
        return this.mService.loadIcon(packageManager);
    }

    public CharSequence loadLabel(PackageManager packageManager) {
        return this.mService.loadLabel(packageManager);
    }

    public Drawable loadThumbnail(PackageManager packageManager) {
        if (this.mThumbnailResource < 0) {
            return null;
        }
        return packageManager.getDrawable(this.mService.serviceInfo.packageName, this.mThumbnailResource, this.mService.serviceInfo.applicationInfo);
    }

    public String toString() {
        return "WallpaperInfo{" + this.mService.serviceInfo.name + ", settings: " + this.mSettingsActivityName + "}";
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.mSettingsActivityName);
        parcel.writeInt(this.mThumbnailResource);
        parcel.writeInt(this.mAuthorResource);
        parcel.writeInt(this.mDescriptionResource);
        this.mService.writeToParcel(parcel, n);
    }
}

