/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityThread;
import android.app.Application;
import android.app.IActivityManager;
import android.app.Notification;
import android.content.ComponentCallbacks2;
import android.content.ComponentName;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public abstract class Service
extends ContextWrapper
implements ComponentCallbacks2 {
    public static final int START_CONTINUATION_MASK = 15;
    public static final int START_FLAG_REDELIVERY = 1;
    public static final int START_FLAG_RETRY = 2;
    public static final int START_NOT_STICKY = 2;
    public static final int START_REDELIVER_INTENT = 3;
    public static final int START_STICKY = 1;
    public static final int START_STICKY_COMPATIBILITY = 0;
    public static final int START_TASK_REMOVED_COMPLETE = 1000;
    private static final String TAG = "Service";
    private IActivityManager mActivityManager = null;
    private Application mApplication = null;
    private String mClassName = null;
    private boolean mStartCompatibility = false;
    private ActivityThread mThread = null;
    private IBinder mToken = null;

    public Service() {
        super(null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void attach(Context context, ActivityThread activityThread, String string2, IBinder iBinder, Application application, Object object) {
        this.attachBaseContext(context);
        this.mThread = activityThread;
        this.mClassName = string2;
        this.mToken = iBinder;
        this.mApplication = application;
        this.mActivityManager = (IActivityManager)object;
        boolean bl = this.getApplicationInfo().targetSdkVersion < 5;
        this.mStartCompatibility = bl;
    }

    protected void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.println("nothing to dump");
    }

    public final Application getApplication() {
        return this.mApplication;
    }

    final String getClassName() {
        return this.mClassName;
    }

    public abstract IBinder onBind(Intent var1);

    @Override
    public void onConfigurationChanged(Configuration configuration) {
    }

    public void onCreate() {
    }

    public void onDestroy() {
    }

    @Override
    public void onLowMemory() {
    }

    public void onRebind(Intent intent) {
    }

    @Deprecated
    public void onStart(Intent intent, int n) {
    }

    public int onStartCommand(Intent intent, int n, int n2) {
        this.onStart(intent, n2);
        if (this.mStartCompatibility) {
            return 0;
        }
        return 1;
    }

    public void onTaskRemoved(Intent intent) {
    }

    @Override
    public void onTrimMemory(int n) {
    }

    public boolean onUnbind(Intent intent) {
        return false;
    }

    @Deprecated
    public final void setForeground(boolean bl) {
        Log.w(TAG, "setForeground: ignoring old API call on " + this.getClass().getName());
    }

    public final void startForeground(int n, Notification notification) {
        try {
            this.mActivityManager.setServiceForeground(new ComponentName((Context)this, this.mClassName), this.mToken, n, notification, true);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public final void stopForeground(boolean bl) {
        try {
            this.mActivityManager.setServiceForeground(new ComponentName((Context)this, this.mClassName), this.mToken, 0, null, bl);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public final void stopSelf() {
        this.stopSelf(-1);
    }

    public final void stopSelf(int n) {
        if (this.mActivityManager == null) {
            return;
        }
        try {
            this.mActivityManager.stopServiceToken(new ComponentName((Context)this, this.mClassName), this.mToken, n);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public final boolean stopSelfResult(int n) {
        if (this.mActivityManager == null) {
            return false;
        }
        try {
            boolean bl = this.mActivityManager.stopServiceToken(new ComponentName((Context)this, this.mClassName), this.mToken, n);
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }
}

