/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ListActivity;
import android.content.Intent;
import android.content.pm.ComponentInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.PaintFlagsDrawFilter;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.PaintDrawable;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.ListView;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class LauncherActivity
extends ListActivity {
    IconResizer mIconResizer;
    Intent mIntent;
    PackageManager mPackageManager;

    private void updateAlertTitle() {
        TextView textView = (TextView)this.findViewById(16909012);
        if (textView != null) {
            textView.setText(this.getTitle());
        }
    }

    private void updateButtonText() {
        Button button = (Button)this.findViewById(16908313);
        if (button != null) {
            button.setOnClickListener(new View.OnClickListener(){

                @Override
                public void onClick(View view) {
                    LauncherActivity.this.finish();
                }
            });
        }
    }

    protected Intent getTargetIntent() {
        return new Intent();
    }

    protected Intent intentForPosition(int n) {
        return ((ActivityAdapter)this.mAdapter).intentForPosition(n);
    }

    protected ListItem itemForPosition(int n) {
        return ((ActivityAdapter)this.mAdapter).itemForPosition(n);
    }

    public List<ListItem> makeListItems() {
        List<ResolveInfo> list = this.onQueryPackageManager(this.mIntent);
        this.onSortResultList(list);
        ArrayList<ListItem> arrayList = new ArrayList<ListItem>(list.size());
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ResolveInfo resolveInfo = list.get(i);
            arrayList.add(new ListItem(this.mPackageManager, resolveInfo, null));
        }
        return arrayList;
    }

    @Override
    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.mPackageManager = this.getPackageManager();
        if (!this.mPackageManager.hasSystemFeature("android.hardware.type.watch")) {
            this.requestWindowFeature(5);
            this.setProgressBarIndeterminateVisibility(true);
        }
        this.onSetContentView();
        this.mIconResizer = new IconResizer();
        this.mIntent = new Intent(this.getTargetIntent());
        this.mIntent.setComponent(null);
        this.mAdapter = new ActivityAdapter(this.mIconResizer);
        this.setListAdapter(this.mAdapter);
        this.getListView().setTextFilterEnabled(true);
        this.updateAlertTitle();
        this.updateButtonText();
        if (!this.mPackageManager.hasSystemFeature("android.hardware.type.watch")) {
            this.setProgressBarIndeterminateVisibility(false);
        }
    }

    protected boolean onEvaluateShowIcons() {
        return true;
    }

    @Override
    protected void onListItemClick(ListView listView, View view, int n, long l) {
        this.startActivity(this.intentForPosition(n));
    }

    protected List<ResolveInfo> onQueryPackageManager(Intent intent) {
        return this.mPackageManager.queryIntentActivities(intent, 0);
    }

    protected void onSetContentView() {
        this.setContentView(17367075);
    }

    protected void onSortResultList(List<ResolveInfo> list) {
        Collections.sort(list, new ResolveInfo.DisplayNameComparator(this.mPackageManager));
    }

    @Override
    public void setTitle(int n) {
        super.setTitle(n);
        this.updateAlertTitle();
    }

    @Override
    public void setTitle(CharSequence charSequence) {
        super.setTitle(charSequence);
        this.updateAlertTitle();
    }

    private class ActivityAdapter
    extends BaseAdapter
    implements Filterable {
        private final Object lock = new Object();
        protected List<ListItem> mActivitiesList;
        private Filter mFilter;
        protected final IconResizer mIconResizer;
        protected final LayoutInflater mInflater;
        private ArrayList<ListItem> mOriginalValues;
        private final boolean mShowIcons;

        public ActivityAdapter(IconResizer iconResizer) {
            this.mIconResizer = iconResizer;
            this.mInflater = (LayoutInflater)LauncherActivity.this.getSystemService("layout_inflater");
            this.mShowIcons = LauncherActivity.this.onEvaluateShowIcons();
            this.mActivitiesList = LauncherActivity.this.makeListItems();
        }

        static /* synthetic */ ArrayList access$102(ActivityAdapter activityAdapter, ArrayList arrayList) {
            activityAdapter.mOriginalValues = arrayList;
            return arrayList;
        }

        private void bindView(View view, ListItem listItem) {
            TextView textView = (TextView)view;
            textView.setText(listItem.label);
            if (this.mShowIcons) {
                if (listItem.icon == null) {
                    listItem.icon = this.mIconResizer.createIconThumbnail(listItem.resolveInfo.loadIcon(LauncherActivity.this.getPackageManager()));
                }
                textView.setCompoundDrawablesWithIntrinsicBounds(listItem.icon, null, null, null);
            }
        }

        @Override
        public int getCount() {
            if (this.mActivitiesList != null) {
                return this.mActivitiesList.size();
            }
            return 0;
        }

        @Override
        public Filter getFilter() {
            if (this.mFilter == null) {
                this.mFilter = new ArrayFilter();
            }
            return this.mFilter;
        }

        @Override
        public Object getItem(int n) {
            return n;
        }

        @Override
        public long getItemId(int n) {
            return n;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public View getView(int n, View view, ViewGroup viewGroup) {
            View view2 = view == null ? this.mInflater.inflate(17367076, viewGroup, false) : view;
            this.bindView(view2, this.mActivitiesList.get(n));
            return view2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Intent intentForPosition(int n) {
            if (this.mActivitiesList == null) {
                return null;
            }
            Intent intent = new Intent(LauncherActivity.this.mIntent);
            ListItem listItem = this.mActivitiesList.get(n);
            intent.setClassName(listItem.packageName, listItem.className);
            if (listItem.extras == null) return intent;
            intent.putExtras(listItem.extras);
            return intent;
        }

        public ListItem itemForPosition(int n) {
            if (this.mActivitiesList == null) {
                return null;
            }
            return this.mActivitiesList.get(n);
        }

        private class ArrayFilter
        extends Filter {
            private ArrayFilter() {
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            protected Filter.FilterResults performFiltering(CharSequence charSequence) {
                Filter.FilterResults filterResults = new Filter.FilterResults();
                if (ActivityAdapter.this.mOriginalValues == null) {
                    Object object = ActivityAdapter.this.lock;
                    synchronized (object) {
                        ActivityAdapter.access$102(ActivityAdapter.this, new ArrayList<ListItem>(ActivityAdapter.this.mActivitiesList));
                    }
                }
                if (charSequence == null || charSequence.length() == 0) {
                    Object object = ActivityAdapter.this.lock;
                    synchronized (object) {
                        ArrayList arrayList;
                        filterResults.values = arrayList = new ArrayList(ActivityAdapter.this.mOriginalValues);
                        filterResults.count = arrayList.size();
                        return filterResults;
                    }
                }
                String string2 = charSequence.toString().toLowerCase();
                ArrayList arrayList = ActivityAdapter.this.mOriginalValues;
                int n = arrayList.size();
                ArrayList<ListItem> arrayList2 = new ArrayList<ListItem>(n);
                int n2 = 0;
                block6: while (true) {
                    if (n2 >= n) {
                        filterResults.values = arrayList2;
                        filterResults.count = arrayList2.size();
                        return filterResults;
                    }
                    ListItem listItem = (ListItem)arrayList.get(n2);
                    String[] stringArray = listItem.label.toString().toLowerCase().split(" ");
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (true) {
                        block15: {
                            block14: {
                                if (n4 >= n3) break block14;
                                if (!stringArray[n4].startsWith(string2)) break block15;
                                arrayList2.add(listItem);
                            }
                            ++n2;
                            continue block6;
                        }
                        ++n4;
                    }
                    break;
                }
            }

            @Override
            protected void publishResults(CharSequence charSequence, Filter.FilterResults filterResults) {
                ActivityAdapter.this.mActivitiesList = (List)filterResults.values;
                if (filterResults.count > 0) {
                    ActivityAdapter.this.notifyDataSetChanged();
                    return;
                }
                ActivityAdapter.this.notifyDataSetInvalidated();
            }
        }
    }

    public class IconResizer {
        private Canvas mCanvas;
        private int mIconHeight = -1;
        private int mIconWidth = -1;
        private final Rect mOldBounds = new Rect();

        public IconResizer() {
            int n;
            this.mCanvas = new Canvas();
            this.mCanvas.setDrawFilter(new PaintFlagsDrawFilter(4, 2));
            this.mIconHeight = n = (int)LauncherActivity.this.getResources().getDimension(0x1050000);
            this.mIconWidth = n;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Drawable createIconThumbnail(Drawable drawable2) {
            int n = this.mIconWidth;
            int n2 = this.mIconHeight;
            int n3 = drawable2.getIntrinsicWidth();
            int n4 = drawable2.getIntrinsicHeight();
            if (drawable2 instanceof PaintDrawable) {
                PaintDrawable paintDrawable = (PaintDrawable)drawable2;
                paintDrawable.setIntrinsicWidth(n);
                paintDrawable.setIntrinsicHeight(n2);
            }
            if (n <= 0 || n2 <= 0) return drawable2;
            if (n < n3 || n2 < n4) {
                float f = (float)n3 / (float)n4;
                if (n3 > n4) {
                    n2 = (int)((float)n / f);
                } else if (n4 > n3) {
                    n = (int)(f * (float)n2);
                }
                Bitmap.Config config = drawable2.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
                Bitmap bitmap = Bitmap.createBitmap(this.mIconWidth, this.mIconHeight, config);
                Canvas canvas = this.mCanvas;
                canvas.setBitmap(bitmap);
                this.mOldBounds.set(drawable2.getBounds());
                int n5 = (this.mIconWidth - n) / 2;
                int n6 = (this.mIconHeight - n2) / 2;
                drawable2.setBounds(n5, n6, n5 + n, n6 + n2);
                drawable2.draw(canvas);
                drawable2.setBounds(this.mOldBounds);
                drawable2 = new BitmapDrawable(LauncherActivity.this.getResources(), bitmap);
                canvas.setBitmap(null);
                return drawable2;
            } else {
                if (n3 >= n || n4 >= n2) return drawable2;
                Bitmap.Config config = Bitmap.Config.ARGB_8888;
                Bitmap bitmap = Bitmap.createBitmap(this.mIconWidth, this.mIconHeight, config);
                Canvas canvas = this.mCanvas;
                canvas.setBitmap(bitmap);
                this.mOldBounds.set(drawable2.getBounds());
                int n7 = (n - n3) / 2;
                int n8 = (n2 - n4) / 2;
                drawable2.setBounds(n7, n8, n7 + n3, n8 + n4);
                drawable2.draw(canvas);
                drawable2.setBounds(this.mOldBounds);
                BitmapDrawable bitmapDrawable = new BitmapDrawable(LauncherActivity.this.getResources(), bitmap);
                canvas.setBitmap(null);
                return bitmapDrawable;
            }
        }
    }

    public static class ListItem {
        public String className;
        public Bundle extras;
        public Drawable icon;
        public CharSequence label;
        public String packageName;
        public ResolveInfo resolveInfo;

        public ListItem() {
        }

        ListItem(PackageManager packageManager, ResolveInfo resolveInfo, IconResizer iconResizer) {
            this.resolveInfo = resolveInfo;
            this.label = resolveInfo.loadLabel(packageManager);
            ComponentInfo componentInfo = resolveInfo.activityInfo;
            if (componentInfo == null) {
                componentInfo = resolveInfo.serviceInfo;
            }
            if (this.label == null && componentInfo != null) {
                this.label = resolveInfo.activityInfo.name;
            }
            if (iconResizer != null) {
                this.icon = iconResizer.createIconThumbnail(resolveInfo.loadIcon(packageManager));
            }
            this.packageName = componentInfo.applicationInfo.packageName;
            this.className = componentInfo.name;
        }
    }
}

