/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.accounts.AccountManager;
import android.accounts.IAccountManager;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.app.ActivityThread;
import android.app.AlarmManager;
import android.app.AppOpsManager;
import android.app.ApplicationPackageManager;
import android.app.DownloadManager;
import android.app.IActivityManager;
import android.app.IAlarmManager;
import android.app.IServiceConnection;
import android.app.Instrumentation;
import android.app.JobSchedulerImpl;
import android.app.KeyguardManager;
import android.app.LoadedApk;
import android.app.NotificationManager;
import android.app.ReceiverRestrictedContext;
import android.app.ResourcesManager;
import android.app.SearchManager;
import android.app.SharedPreferencesImpl;
import android.app.StatusBarManager;
import android.app.UiModeManager;
import android.app.WallpaperManager;
import android.app.admin.DevicePolicyManager;
import android.app.job.IJobScheduler;
import android.app.trust.TrustManager;
import android.app.usage.IUsageStatsManager;
import android.app.usage.UsageStatsManager;
import android.appwidget.AppWidgetManager;
import android.bluetooth.BluetoothManager;
import android.content.BroadcastReceiver;
import android.content.ClipboardManager;
import android.content.ComponentName;
import android.content.ContentProvider;
import android.content.ContentResolver;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.IContentProvider;
import android.content.IIntentReceiver;
import android.content.IRestrictionsManager;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.RestrictionsManager;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.ILauncherApps;
import android.content.pm.IPackageManager;
import android.content.pm.LauncherApps;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.ThemeManager;
import android.database.DatabaseErrorHandler;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.hardware.ConsumerIrManager;
import android.hardware.ISerialManager;
import android.hardware.SerialManager;
import android.hardware.SystemSensorManager;
import android.hardware.camera2.CameraManager;
import android.hardware.display.DisplayManager;
import android.hardware.hdmi.HdmiControlManager;
import android.hardware.hdmi.IHdmiControlService;
import android.hardware.input.InputManager;
import android.hardware.usb.IUsbManager;
import android.hardware.usb.UsbManager;
import android.location.CountryDetector;
import android.location.ICountryDetector;
import android.location.ILocationManager;
import android.location.LocationManager;
import android.media.AudioManager;
import android.media.MediaRouter;
import android.media.projection.MediaProjectionManager;
import android.media.session.MediaSessionManager;
import android.media.tv.ITvInputManager;
import android.media.tv.TvInputManager;
import android.net.ConnectivityManager;
import android.net.EthernetManager;
import android.net.IConnectivityManager;
import android.net.IEthernetManager;
import android.net.INetworkPolicyManager;
import android.net.NetworkPolicyManager;
import android.net.NetworkScoreManager;
import android.net.Uri;
import android.net.nsd.INsdManager;
import android.net.nsd.NsdManager;
import android.net.wifi.IRttManager;
import android.net.wifi.IWifiManager;
import android.net.wifi.IWifiScanner;
import android.net.wifi.RttManager;
import android.net.wifi.WifiManager;
import android.net.wifi.WifiScanner;
import android.net.wifi.p2p.IWifiP2pManager;
import android.net.wifi.p2p.WifiP2pManager;
import android.nfc.NfcManager;
import android.os.BatteryManager;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.os.DropBoxManager;
import android.os.Environment;
import android.os.FileUtils;
import android.os.Handler;
import android.os.IBinder;
import android.os.IPowerManager;
import android.os.IUserManager;
import android.os.Looper;
import android.os.PowerManager;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemVibrator;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.storage.IMountService;
import android.os.storage.StorageManager;
import android.print.IPrintManager;
import android.print.PrintManager;
import android.service.fingerprint.FingerprintManager;
import android.service.fingerprint.IFingerprintService;
import android.service.persistentdata.IPersistentDataBlockService;
import android.service.persistentdata.PersistentDataBlockManager;
import android.telecom.TelecomManager;
import android.telephony.TelephonyManager;
import android.util.AndroidRuntimeException;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Slog;
import android.view.ContextThemeWrapper;
import android.view.Display;
import android.view.DisplayAdjustments;
import android.view.WindowManagerImpl;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.CaptioningManager;
import android.view.inputmethod.InputMethodManager;
import android.view.textservice.TextServicesManager;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.app.IAppOpsService;
import com.android.internal.appwidget.IAppWidgetService;
import com.android.internal.os.IDropBoxManagerService;
import com.android.internal.policy.PolicyManager;
import com.android.internal.util.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;

class ContextImpl
extends Context {
    private static final boolean DEBUG = false;
    private static final String[] EMPTY_FILE_LIST = new String[0];
    private static final HashMap<String, ServiceFetcher> SYSTEM_SERVICE_MAP = new HashMap();
    private static final String TAG = "ContextImpl";
    private static ServiceFetcher WALLPAPER_FETCHER;
    private static int sNextPerContextServiceCacheIndex;
    private static ArrayMap<String, ArrayMap<String, SharedPreferencesImpl>> sSharedPrefs;
    private final IBinder mActivityToken;
    private final String mBasePackageName;
    @GuardedBy(value="mSync")
    private File mCacheDir;
    @GuardedBy(value="mSync")
    private File mCodeCacheDir;
    private final ApplicationContentResolver mContentResolver;
    @GuardedBy(value="mSync")
    private File mDatabasesDir;
    private final Display mDisplay;
    private final DisplayAdjustments mDisplayAdjustments = new DisplayAdjustments();
    @GuardedBy(value="mSync")
    private File[] mExternalCacheDirs;
    @GuardedBy(value="mSync")
    private File[] mExternalFilesDirs;
    @GuardedBy(value="mSync")
    private File[] mExternalMediaDirs;
    @GuardedBy(value="mSync")
    private File[] mExternalObbDirs;
    @GuardedBy(value="mSync")
    private File mFilesDir;
    final ActivityThread mMainThread;
    @GuardedBy(value="mSync")
    private File mNoBackupFilesDir;
    private final String mOpPackageName;
    private Context mOuterContext;
    private final Configuration mOverrideConfiguration;
    final LoadedApk mPackageInfo;
    private PackageManager mPackageManager;
    @GuardedBy(value="mSync")
    private File mPreferencesDir;
    private Context mReceiverRestrictedContext = null;
    private final Resources mResources;
    private final ResourcesManager mResourcesManager;
    private final boolean mRestricted;
    final ArrayList<Object> mServiceCache;
    private final Object mSync = new Object();
    private Resources.Theme mTheme = null;
    private int mThemeResource = 0;
    private final UserHandle mUser;

    static {
        sNextPerContextServiceCacheIndex = 0;
        WALLPAPER_FETCHER = new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                return new WallpaperManager(contextImpl.getOuterContext(), contextImpl.mMainThread.getHandler());
            }
        };
        ContextImpl.registerService("accessibility", new ServiceFetcher(){

            @Override
            public Object getService(ContextImpl contextImpl) {
                return AccessibilityManager.getInstance(contextImpl);
            }
        });
        ContextImpl.registerService("captioning", new ServiceFetcher(){

            @Override
            public Object getService(ContextImpl contextImpl) {
                return new CaptioningManager(contextImpl);
            }
        });
        ContextImpl.registerService("account", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                return new AccountManager(contextImpl, IAccountManager.Stub.asInterface(ServiceManager.getService("account")));
            }
        });
        ContextImpl.registerService("activity", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                return new ActivityManager(contextImpl.getOuterContext(), contextImpl.mMainThread.getHandler());
            }
        });
        ContextImpl.registerService("alarm", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                return new AlarmManager(IAlarmManager.Stub.asInterface(ServiceManager.getService("alarm")), contextImpl);
            }
        });
        ContextImpl.registerService("audio", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                return new AudioManager(contextImpl);
            }
        });
        ContextImpl.registerService("media_router", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                return new MediaRouter(contextImpl);
            }
        });
        ContextImpl.registerService("bluetooth", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                return new BluetoothManager(contextImpl);
            }
        });
        ContextImpl.registerService("hdmi_control", new StaticServiceFetcher(){

            @Override
            public Object createStaticService() {
                return new HdmiControlManager(IHdmiControlService.Stub.asInterface(ServiceManager.getService("hdmi_control")));
            }
        });
        ContextImpl.registerService("clipboard", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                return new ClipboardManager(contextImpl.getOuterContext(), contextImpl.mMainThread.getHandler());
            }
        });
        ContextImpl.registerService("connectivity", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                return new ConnectivityManager(IConnectivityManager.Stub.asInterface(ServiceManager.getService("connectivity")));
            }
        });
        ContextImpl.registerService("country_detector", new StaticServiceFetcher(){

            @Override
            public Object createStaticService() {
                return new CountryDetector(ICountryDetector.Stub.asInterface(ServiceManager.getService("country_detector")));
            }
        });
        ContextImpl.registerService("device_policy", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                return DevicePolicyManager.create(contextImpl, contextImpl.mMainThread.getHandler());
            }
        });
        ContextImpl.registerService("download", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                return new DownloadManager(contextImpl.getContentResolver(), contextImpl.getPackageName());
            }
        });
        ContextImpl.registerService("batterymanager", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                return new BatteryManager();
            }
        });
        ContextImpl.registerService("nfc", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                return new NfcManager(contextImpl);
            }
        });
        ContextImpl.registerService("dropbox", new StaticServiceFetcher(){

            @Override
            public Object createStaticService() {
                return ContextImpl.createDropBoxManager();
            }
        });
        ContextImpl.registerService("input", new StaticServiceFetcher(){

            @Override
            public Object createStaticService() {
                return InputManager.getInstance();
            }
        });
        ContextImpl.registerService("display", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                return new DisplayManager(contextImpl.getOuterContext());
            }
        });
        ContextImpl.registerService("input_method", new StaticServiceFetcher(){

            @Override
            public Object createStaticService() {
                return InputMethodManager.getInstance();
            }
        });
        ContextImpl.registerService("textservices", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                return TextServicesManager.getInstance();
            }
        });
        ContextImpl.registerService("keyguard", new ServiceFetcher(){

            @Override
            public Object getService(ContextImpl contextImpl) {
                return new KeyguardManager();
            }
        });
        ContextImpl.registerService("layout_inflater", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                return PolicyManager.makeNewLayoutInflater(contextImpl.getOuterContext());
            }
        });
        ContextImpl.registerService("location", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                return new LocationManager(contextImpl, ILocationManager.Stub.asInterface(ServiceManager.getService("location")));
            }
        });
        ContextImpl.registerService("netpolicy", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                return new NetworkPolicyManager(INetworkPolicyManager.Stub.asInterface(ServiceManager.getService("netpolicy")));
            }
        });
        ContextImpl.registerService("notification", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                Context context = contextImpl.getOuterContext();
                return new NotificationManager(new ContextThemeWrapper(context, Resources.selectSystemTheme(0, context.getApplicationInfo().targetSdkVersion, 16973835, 16973935, 16974126, 16974130)), contextImpl.mMainThread.getHandler());
            }
        });
        ContextImpl.registerService("servicediscovery", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                INsdManager iNsdManager = INsdManager.Stub.asInterface(ServiceManager.getService("servicediscovery"));
                return new NsdManager(contextImpl.getOuterContext(), iNsdManager);
            }
        });
        ContextImpl.registerService("power", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                IPowerManager iPowerManager = IPowerManager.Stub.asInterface(ServiceManager.getService("power"));
                if (iPowerManager == null) {
                    Log.wtf(ContextImpl.TAG, "Failed to get power manager service.");
                }
                return new PowerManager(contextImpl.getOuterContext(), iPowerManager, contextImpl.mMainThread.getHandler());
            }
        });
        ContextImpl.registerService("search", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                return new SearchManager(contextImpl.getOuterContext(), contextImpl.mMainThread.getHandler());
            }
        });
        ContextImpl.registerService("sensor", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                return new SystemSensorManager(contextImpl.getOuterContext(), contextImpl.mMainThread.getHandler().getLooper());
            }
        });
        ContextImpl.registerService("statusbar", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                return new StatusBarManager(contextImpl.getOuterContext());
            }
        });
        ContextImpl.registerService("storage", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                try {
                    StorageManager storageManager = new StorageManager(contextImpl.getContentResolver(), contextImpl.mMainThread.getHandler().getLooper());
                    return storageManager;
                }
                catch (RemoteException remoteException) {
                    Log.e(ContextImpl.TAG, "Failed to create StorageManager", remoteException);
                    return null;
                }
            }
        });
        ContextImpl.registerService("phone", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                return new TelephonyManager(contextImpl.getOuterContext());
            }
        });
        ContextImpl.registerService("telecom", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                return new TelecomManager(contextImpl.getOuterContext());
            }
        });
        ContextImpl.registerService("uimode", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                return new UiModeManager();
            }
        });
        ContextImpl.registerService("usb", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                return new UsbManager(contextImpl, IUsbManager.Stub.asInterface(ServiceManager.getService("usb")));
            }
        });
        ContextImpl.registerService("serial", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                return new SerialManager(contextImpl, ISerialManager.Stub.asInterface(ServiceManager.getService("serial")));
            }
        });
        ContextImpl.registerService("vibrator", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                return new SystemVibrator(contextImpl);
            }
        });
        ContextImpl.registerService("wallpaper", WALLPAPER_FETCHER);
        ContextImpl.registerService("wifi", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                IWifiManager iWifiManager = IWifiManager.Stub.asInterface(ServiceManager.getService("wifi"));
                return new WifiManager(contextImpl.getOuterContext(), iWifiManager);
            }
        });
        ContextImpl.registerService("wifip2p", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                return new WifiP2pManager(IWifiP2pManager.Stub.asInterface(ServiceManager.getService("wifip2p")));
            }
        });
        ContextImpl.registerService("wifiscanner", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                IWifiScanner iWifiScanner = IWifiScanner.Stub.asInterface(ServiceManager.getService("wifiscanner"));
                return new WifiScanner(contextImpl.getOuterContext(), iWifiScanner);
            }
        });
        ContextImpl.registerService("rttmanager", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                IRttManager iRttManager = IRttManager.Stub.asInterface(ServiceManager.getService("rttmanager"));
                return new RttManager(contextImpl.getOuterContext(), iRttManager);
            }
        });
        ContextImpl.registerService("ethernet", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                IEthernetManager iEthernetManager = IEthernetManager.Stub.asInterface(ServiceManager.getService("ethernet"));
                return new EthernetManager(contextImpl.getOuterContext(), iEthernetManager);
            }
        });
        ContextImpl.registerService("window", new ServiceFetcher(){
            Display mDefaultDisplay;

            @Override
            public Object getService(ContextImpl contextImpl) {
                Display display = contextImpl.mDisplay;
                if (display == null) {
                    if (this.mDefaultDisplay == null) {
                        this.mDefaultDisplay = ((DisplayManager)contextImpl.getOuterContext().getSystemService("display")).getDisplay(0);
                    }
                    display = this.mDefaultDisplay;
                }
                return new WindowManagerImpl(display);
            }
        });
        ContextImpl.registerService("user", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                return new UserManager(contextImpl, IUserManager.Stub.asInterface(ServiceManager.getService("user")));
            }
        });
        ContextImpl.registerService("appops", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                return new AppOpsManager(contextImpl, IAppOpsService.Stub.asInterface(ServiceManager.getService("appops")));
            }
        });
        ContextImpl.registerService("camera", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                return new CameraManager(contextImpl);
            }
        });
        ContextImpl.registerService("launcherapps", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                return new LauncherApps(contextImpl, ILauncherApps.Stub.asInterface(ServiceManager.getService("launcherapps")));
            }
        });
        ContextImpl.registerService("restrictions", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                return new RestrictionsManager(contextImpl, IRestrictionsManager.Stub.asInterface(ServiceManager.getService("restrictions")));
            }
        });
        ContextImpl.registerService("print", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                IPrintManager iPrintManager = IPrintManager.Stub.asInterface(ServiceManager.getService("print"));
                return new PrintManager(contextImpl.getOuterContext(), iPrintManager, UserHandle.myUserId(), UserHandle.getAppId(Process.myUid()));
            }
        });
        ContextImpl.registerService("consumer_ir", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                return new ConsumerIrManager(contextImpl);
            }
        });
        ContextImpl.registerService("media_session", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                return new MediaSessionManager(contextImpl);
            }
        });
        ContextImpl.registerService("trust", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                return new TrustManager(ServiceManager.getService("trust"));
            }
        });
        ContextImpl.registerService("fingerprint", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                IFingerprintService iFingerprintService = IFingerprintService.Stub.asInterface(ServiceManager.getService("fingerprint"));
                return new FingerprintManager(contextImpl.getOuterContext(), iFingerprintService);
            }
        });
        ContextImpl.registerService("tv_input", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                return new TvInputManager(ITvInputManager.Stub.asInterface(ServiceManager.getService("tv_input")), UserHandle.myUserId());
            }
        });
        ContextImpl.registerService("network_score", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                return new NetworkScoreManager(contextImpl);
            }
        });
        ContextImpl.registerService("usagestats", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                IUsageStatsManager iUsageStatsManager = IUsageStatsManager.Stub.asInterface(ServiceManager.getService("usagestats"));
                return new UsageStatsManager(contextImpl.getOuterContext(), iUsageStatsManager);
            }
        });
        ContextImpl.registerService("jobscheduler", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                return new JobSchedulerImpl(IJobScheduler.Stub.asInterface(ServiceManager.getService("jobscheduler")));
            }
        });
        ContextImpl.registerService("persistent_data_block", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                IPersistentDataBlockService iPersistentDataBlockService = IPersistentDataBlockService.Stub.asInterface(ServiceManager.getService("persistent_data_block"));
                if (iPersistentDataBlockService != null) {
                    return new PersistentDataBlockManager(iPersistentDataBlockService);
                }
                return null;
            }
        });
        ContextImpl.registerService("media_projection", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                return new MediaProjectionManager(contextImpl);
            }
        });
        ContextImpl.registerService("appwidget", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                return new AppWidgetManager(contextImpl, IAppWidgetService.Stub.asInterface(ServiceManager.getService("appwidget")));
            }
        });
        if (Build.CTA) {
            ContextImpl.registerService("cta", new ServiceFetcher(){

                @Override
                public Object createService(ContextImpl contextImpl) {
                    return ServiceManager.getService("CTA_SERVICE");
                }
            });
        }
        ContextImpl.registerService("themes", new ServiceFetcher(){

            @Override
            public Object createService(ContextImpl contextImpl) {
                return new ThemeManager(contextImpl.getOuterContext());
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    private ContextImpl(ContextImpl contextImpl, ActivityThread activityThread, LoadedApk loadedApk, IBinder iBinder, UserHandle userHandle, boolean bl, Display display, Configuration configuration) {
        this.mServiceCache = new ArrayList();
        this.mOuterContext = this;
        this.mMainThread = activityThread;
        this.mActivityToken = iBinder;
        this.mRestricted = bl;
        if (userHandle == null) {
            userHandle = Process.myUserHandle();
        }
        this.mUser = userHandle;
        this.mPackageInfo = loadedApk;
        this.mResourcesManager = ResourcesManager.getInstance();
        this.mDisplay = display;
        this.mOverrideConfiguration = configuration;
        int n = this.getDisplayId();
        CompatibilityInfo compatibilityInfo = null;
        if (contextImpl != null) {
            compatibilityInfo = contextImpl.getDisplayAdjustments(n).getCompatibilityInfo();
        }
        if (compatibilityInfo == null && n == 0) {
            compatibilityInfo = loadedApk.getCompatibilityInfo();
        }
        this.mDisplayAdjustments.setCompatibilityInfo(compatibilityInfo);
        this.mDisplayAdjustments.setActivityToken(iBinder);
        Resources resources = loadedApk.getResources(activityThread);
        if (resources != null && (iBinder != null || n != 0 || configuration != null || compatibilityInfo != null && compatibilityInfo.applicationScale != resources.getCompatibilityInfo().applicationScale)) {
            resources = this.mResourcesManager.getTopLevelResources(loadedApk.getResDir(), loadedApk.getSplitResDirs(), loadedApk.getOverlayDirs(), loadedApk.getApplicationInfo().sharedLibraryFiles, n, configuration, compatibilityInfo, iBinder, loadedApk.getPackageName());
        }
        this.mResources = resources;
        if (contextImpl != null) {
            this.mBasePackageName = contextImpl.mBasePackageName;
            this.mOpPackageName = contextImpl.mOpPackageName;
        } else {
            this.mBasePackageName = loadedApk.mPackageName;
            ApplicationInfo applicationInfo = loadedApk.getApplicationInfo();
            this.mOpPackageName = applicationInfo.uid == 1000 && applicationInfo.uid != Process.myUid() ? ActivityThread.currentPackageName() : this.mBasePackageName;
        }
        this.mContentResolver = new ApplicationContentResolver(this, activityThread, userHandle);
    }

    private boolean bindServiceCommon(Intent intent, ServiceConnection serviceConnection, int n, UserHandle userHandle) {
        int n2;
        block8: {
            if (serviceConnection == null) {
                throw new IllegalArgumentException("connection is null");
            }
            if (this.mPackageInfo != null) {
                IServiceConnection iServiceConnection;
                block7: {
                    iServiceConnection = this.mPackageInfo.getServiceDispatcher(serviceConnection, this.getOuterContext(), this.mMainThread.getHandler(), n);
                    this.validateServiceIntent(intent);
                    try {
                        if (this.getActivityToken() != null || (n & 1) != 0) break block7;
                    }
                    catch (RemoteException remoteException) {
                        return false;
                    }
                    if (this.mPackageInfo == null || this.mPackageInfo.getApplicationInfo().targetSdkVersion >= 14) break block7;
                    n |= 0x20;
                }
                intent.prepareToLeaveProcess();
                IActivityManager iActivityManager = ActivityManagerNative.getDefault();
                ActivityThread.ApplicationThread applicationThread = this.mMainThread.getApplicationThread();
                IBinder iBinder = this.getActivityToken();
                String string2 = intent.resolveTypeIfNeeded(this.getContentResolver());
                int n3 = userHandle.getIdentifier();
                n2 = iActivityManager.bindService(applicationThread, iBinder, intent, string2, iServiceConnection, n, n3);
                if (n2 >= 0) break block8;
                throw new SecurityException("Not allowed to bind to service " + intent);
            }
            throw new RuntimeException("Not supported in system context");
        }
        return n2 != 0;
    }

    static ContextImpl createActivityContext(ActivityThread activityThread, LoadedApk loadedApk, IBinder iBinder) {
        if (loadedApk == null) {
            throw new IllegalArgumentException("packageInfo");
        }
        if (iBinder == null) {
            throw new IllegalArgumentException("activityInfo");
        }
        return new ContextImpl(null, activityThread, loadedApk, iBinder, null, false, null, null);
    }

    static ContextImpl createAppContext(ActivityThread activityThread, LoadedApk loadedApk) {
        if (loadedApk == null) {
            throw new IllegalArgumentException("packageInfo");
        }
        return new ContextImpl(null, activityThread, loadedApk, null, null, false, null, null);
    }

    static DropBoxManager createDropBoxManager() {
        IDropBoxManagerService iDropBoxManagerService = IDropBoxManagerService.Stub.asInterface(ServiceManager.getService("dropbox"));
        if (iDropBoxManagerService == null) {
            return null;
        }
        return new DropBoxManager(iDropBoxManagerService);
    }

    private static File createFilesDirLocked(File file) {
        block3: {
            block4: {
                block2: {
                    if (file.exists()) break block2;
                    if (file.mkdirs()) break block3;
                    if (!file.exists()) break block4;
                }
                return file;
            }
            Log.w(TAG, "Unable to create files subdir " + file.getPath());
            return null;
        }
        FileUtils.setPermissions(file.getPath(), 505, -1, -1);
        return file;
    }

    static ContextImpl createSystemContext(ActivityThread activityThread) {
        ContextImpl contextImpl = new ContextImpl(null, activityThread, new LoadedApk(activityThread), null, null, false, null, null);
        contextImpl.mResources.updateConfiguration(contextImpl.mResourcesManager.getConfiguration(), contextImpl.mResourcesManager.getDisplayMetricsLocked(0));
        return contextImpl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void enforce(String string2, int n, boolean bl, int n2, String string3) {
        String string4;
        if (n == 0) return;
        StringBuilder stringBuilder = new StringBuilder();
        String string5 = string3 != null ? string3 + ": " : "";
        StringBuilder stringBuilder2 = stringBuilder.append(string5);
        if (bl) {
            string4 = "Neither user " + n2 + " nor current process has ";
            throw new SecurityException(stringBuilder2.append(string4).append(string2).append(".").toString());
        }
        string4 = "uid " + n2 + " does not have ";
        throw new SecurityException(stringBuilder2.append(string4).append(string2).append(".").toString());
    }

    /*
     * Enabled aggressive block sorting
     */
    private void enforceForUri(int n, int n2, boolean bl, int n3, Uri uri, String string2) {
        String string3;
        if (n2 == 0) return;
        StringBuilder stringBuilder = new StringBuilder();
        String string4 = string2 != null ? string2 + ": " : "";
        StringBuilder stringBuilder2 = stringBuilder.append(string4);
        if (bl) {
            string3 = "Neither user " + n3 + " nor current process has ";
            throw new SecurityException(stringBuilder2.append(string3).append(this.uriModeFlagToString(n)).append(" permission on ").append(uri).append(".").toString());
        }
        string3 = "User " + n3 + " does not have ";
        throw new SecurityException(stringBuilder2.append(string3).append(this.uriModeFlagToString(n)).append(" permission on ").append(uri).append(".").toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File[] ensureDirsExistOrFilter(File[] fileArray) {
        File[] fileArray2 = new File[fileArray.length];
        int n = 0;
        while (n < fileArray.length) {
            File file = fileArray[n];
            if (!(file.exists() || file.mkdirs() || file.exists())) {
                IMountService iMountService = IMountService.Stub.asInterface(ServiceManager.getService("mount"));
                int n2 = -1;
                try {
                    int n3;
                    n2 = n3 = iMountService.mkdirs(this.getPackageName(), file.getAbsolutePath());
                }
                catch (RemoteException remoteException) {}
                if (n2 != 0) {
                    Log.w(TAG, "Failed to ensure directory: " + file);
                    file = null;
                }
            }
            fileArray2[n] = file;
            ++n;
        }
        return fileArray2;
    }

    private File getDataDirFile() {
        if (this.mPackageInfo != null) {
            return this.mPackageInfo.getDataDirFile();
        }
        throw new RuntimeException("Not supported in system context");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File getDatabasesDir() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mDatabasesDir == null) {
                this.mDatabasesDir = new File(this.getDataDirFile(), "databases");
            }
            if (!this.mDatabasesDir.getPath().equals("databases")) return this.mDatabasesDir;
            this.mDatabasesDir = new File("/data/system");
            return this.mDatabasesDir;
        }
    }

    private int getDisplayId() {
        if (this.mDisplay != null) {
            return this.mDisplay.getDisplayId();
        }
        return 0;
    }

    static ContextImpl getImpl(Context context) {
        Context context2;
        while (context instanceof ContextWrapper && (context2 = ((ContextWrapper)context).getBaseContext()) != null) {
            context = context2;
        }
        return (ContextImpl)context;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File getPreferencesDir() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mPreferencesDir != null) return this.mPreferencesDir;
            this.mPreferencesDir = new File(this.getDataDirFile(), "shared_prefs");
            return this.mPreferencesDir;
        }
    }

    private WallpaperManager getWallpaperManager() {
        return (WallpaperManager)WALLPAPER_FETCHER.getService(this);
    }

    private File makeFilename(File file, String string2) {
        if (string2.indexOf(File.separatorChar) < 0) {
            return new File(file, string2);
        }
        throw new IllegalArgumentException("File " + string2 + " contains a path separator");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Intent registerReceiverInternal(BroadcastReceiver broadcastReceiver, int n, IntentFilter intentFilter, String string2, Handler handler, Context context) {
        IIntentReceiver iIntentReceiver = null;
        if (broadcastReceiver != null) {
            if (this.mPackageInfo != null && context != null) {
                if (handler == null) {
                    handler = this.mMainThread.getHandler();
                }
                LoadedApk loadedApk = this.mPackageInfo;
                Instrumentation instrumentation = this.mMainThread.getInstrumentation();
                iIntentReceiver = loadedApk.getReceiverDispatcher(broadcastReceiver, context, handler, instrumentation, true);
            } else {
                if (handler == null) {
                    handler = this.mMainThread.getHandler();
                }
                iIntentReceiver = new LoadedApk.ReceiverDispatcher(broadcastReceiver, context, handler, null, true).getIIntentReceiver();
            }
        }
        try {
            return ActivityManagerNative.getDefault().registerReceiver(this.mMainThread.getApplicationThread(), this.mBasePackageName, iIntentReceiver, intentFilter, string2, n);
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    private static void registerService(String string2, ServiceFetcher serviceFetcher) {
        if (!(serviceFetcher instanceof StaticServiceFetcher)) {
            int n = sNextPerContextServiceCacheIndex;
            sNextPerContextServiceCacheIndex = n + 1;
            serviceFetcher.mContextCacheIndex = n;
        }
        SYSTEM_SERVICE_MAP.put(string2, serviceFetcher);
    }

    private int resolveUserId(Uri uri) {
        return ContentProvider.getUserIdFromUri(uri, this.getUserId());
    }

    static void setFilePermissionsFromMode(String string2, int n, int n2) {
        int n3 = n2 | 0x1B0;
        if ((n & 1) != 0) {
            n3 |= 4;
        }
        if ((n & 2) != 0) {
            n3 |= 2;
        }
        FileUtils.setPermissions(string2, n3, -1, -1);
    }

    private ComponentName startServiceCommon(Intent intent, UserHandle userHandle) {
        ComponentName componentName;
        block5: {
            this.validateServiceIntent(intent);
            intent.prepareToLeaveProcess();
            componentName = ActivityManagerNative.getDefault().startService(this.mMainThread.getApplicationThread(), intent, intent.resolveTypeIfNeeded(this.getContentResolver()), userHandle.getIdentifier());
            if (componentName == null) break block5;
            try {
                if (componentName.getPackageName().equals("!")) {
                    throw new SecurityException("Not allowed to start service " + intent + " without permission " + componentName.getClassName());
                }
                if (componentName.getPackageName().equals("!!")) {
                    throw new SecurityException("Unable to start service " + intent + ": " + componentName.getClassName());
                }
            }
            catch (RemoteException remoteException) {
                componentName = null;
            }
        }
        return componentName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean stopServiceCommon(Intent intent, UserHandle userHandle) {
        int n;
        try {
            this.validateServiceIntent(intent);
            intent.prepareToLeaveProcess();
            n = ActivityManagerNative.getDefault().stopService(this.mMainThread.getApplicationThread(), intent, intent.resolveTypeIfNeeded(this.getContentResolver()), userHandle.getIdentifier());
            if (n < 0) {
                throw new SecurityException("Not allowed to stop service " + intent);
            }
        }
        catch (RemoteException remoteException) {}
        return false;
        if (n == 0) return false;
        return true;
    }

    private String uriModeFlagToString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        if ((n & 1) != 0) {
            stringBuilder.append("read and ");
        }
        if ((n & 2) != 0) {
            stringBuilder.append("write and ");
        }
        if ((n & 0x40) != 0) {
            stringBuilder.append("persistable and ");
        }
        if ((n & 0x80) != 0) {
            stringBuilder.append("prefix and ");
        }
        if (stringBuilder.length() > 5) {
            stringBuilder.setLength(-5 + stringBuilder.length());
            return stringBuilder.toString();
        }
        throw new IllegalArgumentException("Unknown permission mode flags: " + n);
    }

    /*
     * Enabled aggressive block sorting
     */
    private File validateFilePath(String string2, boolean bl) {
        File file;
        File file2;
        if (string2.charAt(0) == File.separatorChar) {
            file2 = new File(string2.substring(0, string2.lastIndexOf(File.separatorChar)));
            file = new File(file2, string2.substring(string2.lastIndexOf(File.separatorChar)));
        } else {
            file2 = this.getDatabasesDir();
            file = this.makeFilename(file2, string2);
        }
        if (bl && !file2.isDirectory() && file2.mkdir()) {
            FileUtils.setPermissions(file2.getPath(), 505, -1, -1);
        }
        return file;
    }

    private void validateServiceIntent(Intent intent) {
        if (intent.getComponent() == null && intent.getPackage() == null) {
            if (this.getApplicationInfo().targetSdkVersion >= 21) {
                throw new IllegalArgumentException("Service Intent must be explicit: " + intent);
            }
            Log.w(TAG, "Implicit intents with startService are not safe: " + intent + " " + Debug.getCallers(2, 3));
        }
    }

    private void warnIfCallingFromSystemProcess() {
        if (Process.myUid() == 1000) {
            Slog.w(TAG, "Calling a method in the system process without a qualified user: " + Debug.getCallers(5));
        }
    }

    @Override
    public boolean bindService(Intent intent, ServiceConnection serviceConnection, int n) {
        this.warnIfCallingFromSystemProcess();
        return this.bindServiceCommon(intent, serviceConnection, n, Process.myUserHandle());
    }

    @Override
    public boolean bindServiceAsUser(Intent intent, ServiceConnection serviceConnection, int n, UserHandle userHandle) {
        return this.bindServiceCommon(intent, serviceConnection, n, userHandle);
    }

    @Override
    public int checkCallingOrSelfPermission(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("permission is null");
        }
        return this.checkPermission(string2, Binder.getCallingPid(), Binder.getCallingUid());
    }

    @Override
    public int checkCallingOrSelfUriPermission(Uri uri, int n) {
        return this.checkUriPermission(uri, Binder.getCallingPid(), Binder.getCallingUid(), n);
    }

    @Override
    public int checkCallingPermission(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("permission is null");
        }
        int n = Binder.getCallingPid();
        if (n != Process.myPid()) {
            return this.checkPermission(string2, n, Binder.getCallingUid());
        }
        return -1;
    }

    @Override
    public int checkCallingUriPermission(Uri uri, int n) {
        int n2 = Binder.getCallingPid();
        if (n2 != Process.myPid()) {
            return this.checkUriPermission(uri, n2, Binder.getCallingUid(), n);
        }
        return -1;
    }

    @Override
    public int checkPermission(String string2, int n, int n2) {
        if (string2 == null) {
            throw new IllegalArgumentException("permission is null");
        }
        try {
            int n3 = ActivityManagerNative.getDefault().checkPermission(string2, n, n2);
            return n3;
        }
        catch (RemoteException remoteException) {
            return -1;
        }
    }

    @Override
    public int checkUriPermission(Uri uri, int n, int n2, int n3) {
        try {
            int n4 = ActivityManagerNative.getDefault().checkUriPermission(ContentProvider.getUriWithoutUserId(uri), n, n2, n3, this.resolveUserId(uri));
            return n4;
        }
        catch (RemoteException remoteException) {
            return -1;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int checkUriPermission(Uri uri, String string2, String string3, int n, int n2, int n3) {
        if ((n3 & 1) != 0 && (string2 == null || this.checkPermission(string2, n, n2) == 0) || (n3 & 2) != 0 && (string3 == null || this.checkPermission(string3, n, n2) == 0)) {
            return 0;
        }
        if (uri != null) {
            return this.checkUriPermission(uri, n, n2, n3);
        }
        return -1;
    }

    void clearResourceIfNeeded() {
        if (this.mResources != Resources.getSystem() && this.mPackageInfo.getCompatibilityInfo().isThemeable) {
            this.mTheme = null;
        }
    }

    @Override
    public void clearWallpaper() throws IOException {
        this.getWallpaperManager().clear();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Context createApplicationContext(ApplicationInfo applicationInfo, int n) throws PackageManager.NameNotFoundException {
        LoadedApk loadedApk = this.mMainThread.getPackageInfo(applicationInfo, this.mResources.getCompatibilityInfo(), 0x40000000 | n);
        if (loadedApk != null) {
            boolean bl = (n & 4) == 4;
            ContextImpl contextImpl = new ContextImpl(this, this.mMainThread, loadedApk, this.mActivityToken, new UserHandle(UserHandle.getUserId(applicationInfo.uid)), bl, this.mDisplay, this.mOverrideConfiguration);
            if (contextImpl.mResources != null) {
                return contextImpl;
            }
        }
        throw new PackageManager.NameNotFoundException("Application package " + applicationInfo.packageName + " not found");
    }

    @Override
    public Context createConfigurationContext(Configuration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("overrideConfiguration must not be null");
        }
        return new ContextImpl(this, this.mMainThread, this.mPackageInfo, this.mActivityToken, this.mUser, this.mRestricted, this.mDisplay, configuration);
    }

    @Override
    public Context createDisplayContext(Display display) {
        if (display == null) {
            throw new IllegalArgumentException("display must not be null");
        }
        return new ContextImpl(this, this.mMainThread, this.mPackageInfo, this.mActivityToken, this.mUser, this.mRestricted, display, this.mOverrideConfiguration);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Context createPackageContext(String string2, int n) throws PackageManager.NameNotFoundException {
        UserHandle userHandle;
        if (this.mUser != null) {
            userHandle = this.mUser;
            return this.createPackageContextAsUser(string2, n, userHandle);
        }
        userHandle = Process.myUserHandle();
        return this.createPackageContextAsUser(string2, n, userHandle);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Context createPackageContextAsUser(String string2, int n, UserHandle userHandle) throws PackageManager.NameNotFoundException {
        boolean bl = (n & 4) == 4;
        if (string2.equals("system")) return new ContextImpl(this, this.mMainThread, this.mPackageInfo, this.mActivityToken, userHandle, bl, this.mDisplay, this.mOverrideConfiguration);
        if (string2.equals("android")) {
            return new ContextImpl(this, this.mMainThread, this.mPackageInfo, this.mActivityToken, userHandle, bl, this.mDisplay, this.mOverrideConfiguration);
        }
        LoadedApk loadedApk = this.mMainThread.getPackageInfo(string2, this.mResources.getCompatibilityInfo(), 0x40000000 | n, userHandle.getIdentifier());
        if (loadedApk == null) throw new PackageManager.NameNotFoundException("Application package " + string2 + " not found");
        ContextImpl contextImpl = new ContextImpl(this, this.mMainThread, loadedApk, this.mActivityToken, userHandle, bl, this.mDisplay, this.mOverrideConfiguration);
        if (contextImpl.mResources != null) return contextImpl;
        throw new PackageManager.NameNotFoundException("Application package " + string2 + " not found");
    }

    @Override
    public String[] databaseList() {
        String[] stringArray = this.getDatabasesDir().list();
        if (stringArray != null) {
            return stringArray;
        }
        return EMPTY_FILE_LIST;
    }

    @Override
    public boolean deleteDatabase(String string2) {
        try {
            boolean bl = SQLiteDatabase.deleteDatabase(this.validateFilePath(string2, false));
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean deleteFile(String string2) {
        return this.makeFilename(this.getFilesDir(), string2).delete();
    }

    @Override
    public void enforceCallingOrSelfPermission(String string2, String string3) {
        this.enforce(string2, this.checkCallingOrSelfPermission(string2), true, Binder.getCallingUid(), string3);
    }

    @Override
    public void enforceCallingOrSelfUriPermission(Uri uri, int n, String string2) {
        this.enforceForUri(n, this.checkCallingOrSelfUriPermission(uri, n), true, Binder.getCallingUid(), uri, string2);
    }

    @Override
    public void enforceCallingPermission(String string2, String string3) {
        this.enforce(string2, this.checkCallingPermission(string2), false, Binder.getCallingUid(), string3);
    }

    @Override
    public void enforceCallingUriPermission(Uri uri, int n, String string2) {
        this.enforceForUri(n, this.checkCallingUriPermission(uri, n), false, Binder.getCallingUid(), uri, string2);
    }

    @Override
    public void enforcePermission(String string2, int n, int n2, String string3) {
        this.enforce(string2, this.checkPermission(string2, n, n2), false, n2, string3);
    }

    @Override
    public void enforceUriPermission(Uri uri, int n, int n2, int n3, String string2) {
        this.enforceForUri(n3, this.checkUriPermission(uri, n, n2, n3), false, n2, uri, string2);
    }

    @Override
    public void enforceUriPermission(Uri uri, String string2, String string3, int n, int n2, int n3, String string4) {
        this.enforceForUri(n3, this.checkUriPermission(uri, string2, string3, n, n2, n3), false, n2, uri, string4);
    }

    @Override
    public String[] fileList() {
        String[] stringArray = this.getFilesDir().list();
        if (stringArray != null) {
            return stringArray;
        }
        return EMPTY_FILE_LIST;
    }

    final IBinder getActivityToken() {
        return this.mActivityToken;
    }

    @Override
    public Context getApplicationContext() {
        if (this.mPackageInfo != null) {
            return this.mPackageInfo.getApplication();
        }
        return this.mMainThread.getApplication();
    }

    @Override
    public ApplicationInfo getApplicationInfo() {
        if (this.mPackageInfo != null) {
            return this.mPackageInfo.getApplicationInfo();
        }
        throw new RuntimeException("Not supported in system context");
    }

    @Override
    public AssetManager getAssets() {
        return this.getResources().getAssets();
    }

    @Override
    public String getBasePackageName() {
        if (this.mBasePackageName != null) {
            return this.mBasePackageName;
        }
        return this.getPackageName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public File getCacheDir() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mCacheDir != null) return ContextImpl.createFilesDirLocked(this.mCacheDir);
            this.mCacheDir = new File(this.getDataDirFile(), "cache");
            return ContextImpl.createFilesDirLocked(this.mCacheDir);
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.mPackageInfo != null) {
            return this.mPackageInfo.getClassLoader();
        }
        return ClassLoader.getSystemClassLoader();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public File getCodeCacheDir() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mCodeCacheDir != null) return ContextImpl.createFilesDirLocked(this.mCodeCacheDir);
            this.mCodeCacheDir = new File(this.getDataDirFile(), "code_cache");
            return ContextImpl.createFilesDirLocked(this.mCodeCacheDir);
        }
    }

    @Override
    public ContentResolver getContentResolver() {
        return this.mContentResolver;
    }

    @Override
    public File getDatabasePath(String string2) {
        return this.validateFilePath(string2, false);
    }

    @Override
    public File getDir(String string2, int n) {
        String string3 = "app_" + string2;
        File file = this.makeFilename(this.getDataDirFile(), string3);
        if (!file.exists()) {
            file.mkdir();
            ContextImpl.setFilePermissionsFromMode(file.getPath(), n, 505);
        }
        return file;
    }

    @Override
    public DisplayAdjustments getDisplayAdjustments(int n) {
        return this.mDisplayAdjustments;
    }

    @Override
    public File getExternalCacheDir() {
        return this.getExternalCacheDirs()[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public File[] getExternalCacheDirs() {
        Object object = this.mSync;
        synchronized (object) {
            this.mExternalCacheDirs = Environment.buildExternalStorageAppCacheDirs(this.getPackageName());
            return this.ensureDirsExistOrFilter(this.mExternalCacheDirs);
        }
    }

    @Override
    public File getExternalFilesDir(String string2) {
        return this.getExternalFilesDirs(string2)[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public File[] getExternalFilesDirs(String string2) {
        Object object = this.mSync;
        synchronized (object) {
            this.mExternalFilesDirs = Environment.buildExternalStorageAppFilesDirs(this.getPackageName());
            File[] fileArray = this.mExternalFilesDirs;
            if (string2 == null) return this.ensureDirsExistOrFilter(fileArray);
            fileArray = Environment.buildPaths(fileArray, string2);
            return this.ensureDirsExistOrFilter(fileArray);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public File[] getExternalMediaDirs() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mExternalMediaDirs != null) return this.ensureDirsExistOrFilter(this.mExternalMediaDirs);
            this.mExternalMediaDirs = Environment.buildExternalStorageAppMediaDirs(this.getPackageName());
            return this.ensureDirsExistOrFilter(this.mExternalMediaDirs);
        }
    }

    @Override
    public File getFileStreamPath(String string2) {
        return this.makeFilename(this.getFilesDir(), string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public File getFilesDir() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mFilesDir != null) return ContextImpl.createFilesDirLocked(this.mFilesDir);
            this.mFilesDir = new File(this.getDataDirFile(), "files");
            return ContextImpl.createFilesDirLocked(this.mFilesDir);
        }
    }

    @Override
    public Looper getMainLooper() {
        return this.mMainThread.getLooper();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public File getNoBackupFilesDir() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mNoBackupFilesDir != null) return ContextImpl.createFilesDirLocked(this.mNoBackupFilesDir);
            this.mNoBackupFilesDir = new File(this.getDataDirFile(), "no_backup");
            return ContextImpl.createFilesDirLocked(this.mNoBackupFilesDir);
        }
    }

    @Override
    public File getObbDir() {
        return this.getObbDirs()[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public File[] getObbDirs() {
        Object object = this.mSync;
        synchronized (object) {
            this.mExternalObbDirs = Environment.buildExternalStorageAppObbDirs(this.getPackageName());
            return this.ensureDirsExistOrFilter(this.mExternalObbDirs);
        }
    }

    @Override
    public String getOpPackageName() {
        if (this.mOpPackageName != null) {
            return this.mOpPackageName;
        }
        return this.getBasePackageName();
    }

    final Context getOuterContext() {
        return this.mOuterContext;
    }

    @Override
    public String getPackageCodePath() {
        if (this.mPackageInfo != null) {
            return this.mPackageInfo.getAppDir();
        }
        throw new RuntimeException("Not supported in system context");
    }

    @Override
    public PackageManager getPackageManager() {
        if (this.mPackageManager != null) {
            return this.mPackageManager;
        }
        IPackageManager iPackageManager = ActivityThread.getPackageManager();
        if (iPackageManager != null) {
            ApplicationPackageManager applicationPackageManager = new ApplicationPackageManager(this, iPackageManager);
            this.mPackageManager = applicationPackageManager;
            return applicationPackageManager;
        }
        return null;
    }

    @Override
    public String getPackageName() {
        if (this.mPackageInfo != null) {
            return this.mPackageInfo.getPackageName();
        }
        return "android";
    }

    @Override
    public String getPackageResourcePath() {
        if (this.mPackageInfo != null) {
            return this.mPackageInfo.getResDir();
        }
        throw new RuntimeException("Not supported in system context");
    }

    final Context getReceiverRestrictedContext() {
        if (this.mReceiverRestrictedContext != null) {
            return this.mReceiverRestrictedContext;
        }
        ReceiverRestrictedContext receiverRestrictedContext = new ReceiverRestrictedContext(this.getOuterContext());
        this.mReceiverRestrictedContext = receiverRestrictedContext;
        return receiverRestrictedContext;
    }

    @Override
    public Resources getResources() {
        return this.mResources;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public SharedPreferences getSharedPreferences(String string2, int n) {
        SharedPreferencesImpl sharedPreferencesImpl;
        String string3;
        ArrayMap<String, SharedPreferencesImpl> arrayMap;
        // MONITORENTER : android.app.ContextImpl.class
        if (sSharedPrefs == null) {
            sSharedPrefs = new ArrayMap();
        }
        if ((arrayMap = sSharedPrefs.get(string3 = this.getPackageName())) == null) {
            arrayMap = new ArrayMap();
            sSharedPrefs.put(string3, arrayMap);
        }
        if (this.mPackageInfo.getApplicationInfo().targetSdkVersion < 19 && string2 == null) {
            string2 = "null";
        }
        if ((sharedPreferencesImpl = arrayMap.get(string2)) == null) {
            SharedPreferencesImpl sharedPreferencesImpl2 = new SharedPreferencesImpl(this.getSharedPrefsFile(string2), n);
            arrayMap.put(string2, sharedPreferencesImpl2);
            // MONITOREXIT : android.app.ContextImpl.class
            return sharedPreferencesImpl2;
        }
        // MONITOREXIT : android.app.ContextImpl.class
        if ((n & 4) == 0) {
            if (this.getApplicationInfo().targetSdkVersion >= 11) return sharedPreferencesImpl;
        }
        sharedPreferencesImpl.startReloadIfChangedUnexpectedly();
        return sharedPreferencesImpl;
    }

    @Override
    public File getSharedPrefsFile(String string2) {
        return this.makeFilename(this.getPreferencesDir(), string2 + ".xml");
    }

    @Override
    public Object getSystemService(String string2) {
        ServiceFetcher serviceFetcher = SYSTEM_SERVICE_MAP.get(string2);
        if (serviceFetcher == null) {
            return null;
        }
        return serviceFetcher.getService(this);
    }

    @Override
    public Resources.Theme getTheme() {
        if (this.mTheme == null) {
            this.mThemeResource = Resources.selectDefaultTheme(this.mThemeResource, this.getOuterContext().getApplicationInfo().targetSdkVersion);
            this.mTheme = this.mResources.newTheme();
            this.mTheme.applyStyle(this.mThemeResource, true);
        }
        return this.mTheme;
    }

    @Override
    public int getThemeResId() {
        return this.mThemeResource;
    }

    @Override
    public int getUserId() {
        return this.mUser.getIdentifier();
    }

    @Override
    public Drawable getWallpaper() {
        return this.getWallpaperManager().getDrawable();
    }

    @Override
    public int getWallpaperDesiredMinimumHeight() {
        return this.getWallpaperManager().getDesiredMinimumHeight();
    }

    @Override
    public int getWallpaperDesiredMinimumWidth() {
        return this.getWallpaperManager().getDesiredMinimumWidth();
    }

    @Override
    public void grantUriPermission(String string2, Uri uri, int n) {
        try {
            ActivityManagerNative.getDefault().grantUriPermission(this.mMainThread.getApplicationThread(), string2, ContentProvider.getUriWithoutUserId(uri), n, this.resolveUserId(uri));
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    void installSystemApplicationInfo(ApplicationInfo applicationInfo, ClassLoader classLoader) {
        this.mPackageInfo.installSystemApplicationInfo(applicationInfo, classLoader);
    }

    @Override
    public boolean isRestricted() {
        return this.mRestricted;
    }

    @Override
    public FileInputStream openFileInput(String string2) throws FileNotFoundException {
        return new FileInputStream(this.makeFilename(this.getFilesDir(), string2));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileOutputStream openFileOutput(String string2, int n) throws FileNotFoundException {
        boolean bl = (0x8000 & n) != 0;
        File file = this.makeFilename(this.getFilesDir(), string2);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file, bl);
            ContextImpl.setFilePermissionsFromMode(file.getPath(), n, 0);
            return fileOutputStream;
        }
        catch (FileNotFoundException fileNotFoundException) {
            File file2 = file.getParentFile();
            file2.mkdir();
            FileUtils.setPermissions(file2.getPath(), 505, -1, -1);
            FileOutputStream fileOutputStream = new FileOutputStream(file, bl);
            ContextImpl.setFilePermissionsFromMode(file.getPath(), n, 0);
            return fileOutputStream;
        }
    }

    @Override
    public SQLiteDatabase openOrCreateDatabase(String string2, int n, SQLiteDatabase.CursorFactory cursorFactory) {
        return this.openOrCreateDatabase(string2, n, cursorFactory, null);
    }

    @Override
    public SQLiteDatabase openOrCreateDatabase(String string2, int n, SQLiteDatabase.CursorFactory cursorFactory, DatabaseErrorHandler databaseErrorHandler) {
        File file = this.validateFilePath(string2, true);
        int n2 = 0x10000000;
        if ((n & 8) != 0) {
            n2 |= 0x20000000;
        }
        SQLiteDatabase sQLiteDatabase = SQLiteDatabase.openDatabase(file.getPath(), cursorFactory, n2, databaseErrorHandler);
        ContextImpl.setFilePermissionsFromMode(file.getPath(), n, 0);
        return sQLiteDatabase;
    }

    @Override
    public Drawable peekWallpaper() {
        return this.getWallpaperManager().peekDrawable();
    }

    final void performFinalCleanup(String string2, String string3) {
        this.mPackageInfo.removeContextRegistrations(this.getOuterContext(), string2, string3);
    }

    @Override
    public Intent registerReceiver(BroadcastReceiver broadcastReceiver, IntentFilter intentFilter) {
        return this.registerReceiver(broadcastReceiver, intentFilter, null, null);
    }

    @Override
    public Intent registerReceiver(BroadcastReceiver broadcastReceiver, IntentFilter intentFilter, String string2, Handler handler) {
        return this.registerReceiverInternal(broadcastReceiver, this.getUserId(), intentFilter, string2, handler, this.getOuterContext());
    }

    @Override
    public Intent registerReceiverAsUser(BroadcastReceiver broadcastReceiver, UserHandle userHandle, IntentFilter intentFilter, String string2, Handler handler) {
        return this.registerReceiverInternal(broadcastReceiver, userHandle.getIdentifier(), intentFilter, string2, handler, this.getOuterContext());
    }

    @Override
    public void removeStickyBroadcast(Intent intent) {
        String string2 = intent.resolveTypeIfNeeded(this.getContentResolver());
        if (string2 != null) {
            Intent intent2 = new Intent(intent);
            intent2.setDataAndType(intent2.getData(), string2);
            intent = intent2;
        }
        try {
            intent.prepareToLeaveProcess();
            ActivityManagerNative.getDefault().unbroadcastIntent(this.mMainThread.getApplicationThread(), intent, this.getUserId());
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void removeStickyBroadcastAsUser(Intent intent, UserHandle userHandle) {
        String string2 = intent.resolveTypeIfNeeded(this.getContentResolver());
        if (string2 != null) {
            Intent intent2 = new Intent(intent);
            intent2.setDataAndType(intent2.getData(), string2);
            intent = intent2;
        }
        try {
            intent.prepareToLeaveProcess();
            ActivityManagerNative.getDefault().unbroadcastIntent(this.mMainThread.getApplicationThread(), intent, userHandle.getIdentifier());
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void revokeUriPermission(Uri uri, int n) {
        try {
            ActivityManagerNative.getDefault().revokeUriPermission(this.mMainThread.getApplicationThread(), ContentProvider.getUriWithoutUserId(uri), n, this.resolveUserId(uri));
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    final void scheduleFinalCleanup(String string2, String string3) {
        this.mMainThread.scheduleContextCleanup(this, string2, string3);
    }

    @Override
    public void sendBroadcast(Intent intent) {
        this.warnIfCallingFromSystemProcess();
        String string2 = intent.resolveTypeIfNeeded(this.getContentResolver());
        try {
            intent.prepareToLeaveProcess();
            ActivityManagerNative.getDefault().broadcastIntent(this.mMainThread.getApplicationThread(), intent, string2, null, -1, null, null, null, -1, false, false, this.getUserId());
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void sendBroadcast(Intent intent, String string2) {
        this.warnIfCallingFromSystemProcess();
        String string3 = intent.resolveTypeIfNeeded(this.getContentResolver());
        try {
            intent.prepareToLeaveProcess();
            ActivityManagerNative.getDefault().broadcastIntent(this.mMainThread.getApplicationThread(), intent, string3, null, -1, null, null, string2, -1, false, false, this.getUserId());
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void sendBroadcast(Intent intent, String string2, int n) {
        this.warnIfCallingFromSystemProcess();
        String string3 = intent.resolveTypeIfNeeded(this.getContentResolver());
        try {
            intent.prepareToLeaveProcess();
            ActivityManagerNative.getDefault().broadcastIntent(this.mMainThread.getApplicationThread(), intent, string3, null, -1, null, null, string2, n, false, false, this.getUserId());
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void sendBroadcastAsUser(Intent intent, UserHandle userHandle) {
        String string2 = intent.resolveTypeIfNeeded(this.getContentResolver());
        try {
            intent.prepareToLeaveProcess();
            ActivityManagerNative.getDefault().broadcastIntent(this.mMainThread.getApplicationThread(), intent, string2, null, -1, null, null, null, -1, false, false, userHandle.getIdentifier());
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void sendBroadcastAsUser(Intent intent, UserHandle userHandle, String string2) {
        String string3 = intent.resolveTypeIfNeeded(this.getContentResolver());
        try {
            intent.prepareToLeaveProcess();
            ActivityManagerNative.getDefault().broadcastIntent(this.mMainThread.getApplicationThread(), intent, string3, null, -1, null, null, string2, -1, false, false, userHandle.getIdentifier());
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void sendOrderedBroadcast(Intent intent, String string2) {
        this.warnIfCallingFromSystemProcess();
        String string3 = intent.resolveTypeIfNeeded(this.getContentResolver());
        try {
            intent.prepareToLeaveProcess();
            ActivityManagerNative.getDefault().broadcastIntent(this.mMainThread.getApplicationThread(), intent, string3, null, -1, null, null, string2, -1, true, false, this.getUserId());
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void sendOrderedBroadcast(Intent intent, String string2, int n, BroadcastReceiver broadcastReceiver, Handler handler, int n2, String string3, Bundle bundle) {
        this.warnIfCallingFromSystemProcess();
        IIntentReceiver iIntentReceiver = null;
        if (broadcastReceiver != null) {
            if (this.mPackageInfo != null) {
                if (handler == null) {
                    handler = this.mMainThread.getHandler();
                }
                LoadedApk loadedApk = this.mPackageInfo;
                Context context = this.getOuterContext();
                Instrumentation instrumentation = this.mMainThread.getInstrumentation();
                iIntentReceiver = loadedApk.getReceiverDispatcher(broadcastReceiver, context, handler, instrumentation, false);
            } else {
                if (handler == null) {
                    handler = this.mMainThread.getHandler();
                }
                iIntentReceiver = new LoadedApk.ReceiverDispatcher(broadcastReceiver, this.getOuterContext(), handler, null, false).getIIntentReceiver();
            }
        }
        String string4 = intent.resolveTypeIfNeeded(this.getContentResolver());
        try {
            intent.prepareToLeaveProcess();
            ActivityManagerNative.getDefault().broadcastIntent(this.mMainThread.getApplicationThread(), intent, string4, iIntentReceiver, n2, string3, bundle, string2, n, true, false, this.getUserId());
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void sendOrderedBroadcast(Intent intent, String string2, BroadcastReceiver broadcastReceiver, Handler handler, int n, String string3, Bundle bundle) {
        this.sendOrderedBroadcast(intent, string2, -1, broadcastReceiver, handler, n, string3, bundle);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void sendOrderedBroadcastAsUser(Intent intent, UserHandle userHandle, String string2, int n, BroadcastReceiver broadcastReceiver, Handler handler, int n2, String string3, Bundle bundle) {
        IIntentReceiver iIntentReceiver = null;
        if (broadcastReceiver != null) {
            if (this.mPackageInfo != null) {
                if (handler == null) {
                    handler = this.mMainThread.getHandler();
                }
                LoadedApk loadedApk = this.mPackageInfo;
                Context context = this.getOuterContext();
                Instrumentation instrumentation = this.mMainThread.getInstrumentation();
                iIntentReceiver = loadedApk.getReceiverDispatcher(broadcastReceiver, context, handler, instrumentation, false);
            } else {
                if (handler == null) {
                    handler = this.mMainThread.getHandler();
                }
                iIntentReceiver = new LoadedApk.ReceiverDispatcher(broadcastReceiver, this.getOuterContext(), handler, null, false).getIIntentReceiver();
            }
        }
        String string4 = intent.resolveTypeIfNeeded(this.getContentResolver());
        try {
            intent.prepareToLeaveProcess();
            ActivityManagerNative.getDefault().broadcastIntent(this.mMainThread.getApplicationThread(), intent, string4, iIntentReceiver, n2, string3, bundle, string2, n, true, false, userHandle.getIdentifier());
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void sendOrderedBroadcastAsUser(Intent intent, UserHandle userHandle, String string2, BroadcastReceiver broadcastReceiver, Handler handler, int n, String string3, Bundle bundle) {
        this.sendOrderedBroadcastAsUser(intent, userHandle, string2, -1, broadcastReceiver, handler, n, string3, bundle);
    }

    @Override
    public void sendStickyBroadcast(Intent intent) {
        this.warnIfCallingFromSystemProcess();
        String string2 = intent.resolveTypeIfNeeded(this.getContentResolver());
        try {
            intent.prepareToLeaveProcess();
            ActivityManagerNative.getDefault().broadcastIntent(this.mMainThread.getApplicationThread(), intent, string2, null, -1, null, null, null, -1, false, true, this.getUserId());
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void sendStickyBroadcastAsUser(Intent intent, UserHandle userHandle) {
        String string2 = intent.resolveTypeIfNeeded(this.getContentResolver());
        try {
            intent.prepareToLeaveProcess();
            ActivityManagerNative.getDefault().broadcastIntent(this.mMainThread.getApplicationThread(), intent, string2, null, -1, null, null, null, -1, false, true, userHandle.getIdentifier());
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void sendStickyOrderedBroadcast(Intent intent, BroadcastReceiver broadcastReceiver, Handler handler, int n, String string2, Bundle bundle) {
        this.warnIfCallingFromSystemProcess();
        IIntentReceiver iIntentReceiver = null;
        if (broadcastReceiver != null) {
            if (this.mPackageInfo != null) {
                if (handler == null) {
                    handler = this.mMainThread.getHandler();
                }
                LoadedApk loadedApk = this.mPackageInfo;
                Context context = this.getOuterContext();
                Instrumentation instrumentation = this.mMainThread.getInstrumentation();
                iIntentReceiver = loadedApk.getReceiverDispatcher(broadcastReceiver, context, handler, instrumentation, false);
            } else {
                if (handler == null) {
                    handler = this.mMainThread.getHandler();
                }
                iIntentReceiver = new LoadedApk.ReceiverDispatcher(broadcastReceiver, this.getOuterContext(), handler, null, false).getIIntentReceiver();
            }
        }
        String string3 = intent.resolveTypeIfNeeded(this.getContentResolver());
        try {
            intent.prepareToLeaveProcess();
            ActivityManagerNative.getDefault().broadcastIntent(this.mMainThread.getApplicationThread(), intent, string3, iIntentReceiver, n, string2, bundle, null, -1, true, true, this.getUserId());
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void sendStickyOrderedBroadcastAsUser(Intent intent, UserHandle userHandle, BroadcastReceiver broadcastReceiver, Handler handler, int n, String string2, Bundle bundle) {
        IIntentReceiver iIntentReceiver = null;
        if (broadcastReceiver != null) {
            if (this.mPackageInfo != null) {
                if (handler == null) {
                    handler = this.mMainThread.getHandler();
                }
                LoadedApk loadedApk = this.mPackageInfo;
                Context context = this.getOuterContext();
                Instrumentation instrumentation = this.mMainThread.getInstrumentation();
                iIntentReceiver = loadedApk.getReceiverDispatcher(broadcastReceiver, context, handler, instrumentation, false);
            } else {
                if (handler == null) {
                    handler = this.mMainThread.getHandler();
                }
                iIntentReceiver = new LoadedApk.ReceiverDispatcher(broadcastReceiver, this.getOuterContext(), handler, null, false).getIIntentReceiver();
            }
        }
        String string3 = intent.resolveTypeIfNeeded(this.getContentResolver());
        try {
            intent.prepareToLeaveProcess();
            ActivityManagerNative.getDefault().broadcastIntent(this.mMainThread.getApplicationThread(), intent, string3, iIntentReceiver, n, string2, bundle, null, -1, true, true, userHandle.getIdentifier());
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    final void setOuterContext(Context context) {
        this.mOuterContext = context;
    }

    @Override
    public void setTheme(int n) {
        this.mThemeResource = n;
    }

    @Override
    public void setWallpaper(Bitmap bitmap) throws IOException {
        this.getWallpaperManager().setBitmap(bitmap);
    }

    @Override
    public void setWallpaper(InputStream inputStream) throws IOException {
        this.getWallpaperManager().setStream(inputStream);
    }

    @Override
    public void startActivities(Intent[] intentArray) {
        this.warnIfCallingFromSystemProcess();
        this.startActivities(intentArray, null);
    }

    @Override
    public void startActivities(Intent[] intentArray, Bundle bundle) {
        this.warnIfCallingFromSystemProcess();
        if ((0x10000000 & intentArray[0].getFlags()) == 0) {
            throw new AndroidRuntimeException("Calling startActivities() from outside of an Activity  context requires the FLAG_ACTIVITY_NEW_TASK flag on first Intent. Is this really what you want?");
        }
        this.mMainThread.getInstrumentation().execStartActivities(this.getOuterContext(), this.mMainThread.getApplicationThread(), null, null, intentArray, bundle);
    }

    @Override
    public void startActivitiesAsUser(Intent[] intentArray, Bundle bundle, UserHandle userHandle) {
        if ((0x10000000 & intentArray[0].getFlags()) == 0) {
            throw new AndroidRuntimeException("Calling startActivities() from outside of an Activity  context requires the FLAG_ACTIVITY_NEW_TASK flag on first Intent. Is this really what you want?");
        }
        this.mMainThread.getInstrumentation().execStartActivitiesAsUser(this.getOuterContext(), this.mMainThread.getApplicationThread(), null, null, intentArray, bundle, userHandle.getIdentifier());
    }

    @Override
    public void startActivity(Intent intent) {
        this.warnIfCallingFromSystemProcess();
        this.startActivity(intent, null);
    }

    @Override
    public void startActivity(Intent intent, Bundle bundle) {
        this.warnIfCallingFromSystemProcess();
        if ((0x10000000 & intent.getFlags()) == 0) {
            throw new AndroidRuntimeException("Calling startActivity() from outside of an Activity  context requires the FLAG_ACTIVITY_NEW_TASK flag. Is this really what you want?");
        }
        this.mMainThread.getInstrumentation().execStartActivity(this.getOuterContext(), (IBinder)this.mMainThread.getApplicationThread(), null, (Activity)null, intent, -1, bundle);
    }

    @Override
    public void startActivityAsUser(Intent intent, Bundle bundle, UserHandle userHandle) {
        try {
            ActivityManagerNative.getDefault().startActivityAsUser(this.mMainThread.getApplicationThread(), this.getBasePackageName(), intent, intent.resolveTypeIfNeeded(this.getContentResolver()), null, null, 0, 0x10000000, null, bundle, userHandle.getIdentifier());
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public void startActivityAsUser(Intent intent, UserHandle userHandle) {
        this.startActivityAsUser(intent, null, userHandle);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean startInstrumentation(ComponentName componentName, String string2, Bundle bundle) {
        if (bundle == null) return ActivityManagerNative.getDefault().startInstrumentation(componentName, string2, 0, bundle, null, null, this.getUserId(), null);
        try {
            bundle.setAllowFds(false);
            return ActivityManagerNative.getDefault().startInstrumentation(componentName, string2, 0, bundle, null, null, this.getUserId(), null);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    @Override
    public void startIntentSender(IntentSender intentSender, Intent intent, int n, int n2, int n3) throws IntentSender.SendIntentException {
        this.startIntentSender(intentSender, intent, n, n2, n3, null);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void startIntentSender(IntentSender var1_1, Intent var2_2, int var3_3, int var4_4, int var5_5, Bundle var6_6) throws IntentSender.SendIntentException {
        var7_7 = null;
        if (var2_2 == null) ** GOTO lbl8
        try {
            var2_2.migrateExtraStreamToClipData();
            var2_2.prepareToLeaveProcess();
            var7_7 = var2_2.resolveTypeIfNeeded(this.getContentResolver());
lbl8:
            // 2 sources

            if ((var9_8 = ActivityManagerNative.getDefault().startActivityIntentSender(this.mMainThread.getApplicationThread(), var1_1, var2_2, var7_7, null, null, 0, var3_3, var4_4, var6_6)) != -6) ** GOTO lbl13
        }
        catch (RemoteException var8_9) {
            return;
        }
        throw new IntentSender.SendIntentException();
lbl13:
        // 1 sources

        Instrumentation.checkStartActivityResult(var9_8, null);
    }

    @Override
    public ComponentName startService(Intent intent) {
        this.warnIfCallingFromSystemProcess();
        return this.startServiceCommon(intent, this.mUser);
    }

    @Override
    public ComponentName startServiceAsUser(Intent intent, UserHandle userHandle) {
        return this.startServiceCommon(intent, userHandle);
    }

    @Override
    public boolean stopService(Intent intent) {
        this.warnIfCallingFromSystemProcess();
        return this.stopServiceCommon(intent, this.mUser);
    }

    @Override
    public boolean stopServiceAsUser(Intent intent, UserHandle userHandle) {
        return this.stopServiceCommon(intent, userHandle);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void unbindService(ServiceConnection serviceConnection) {
        if (serviceConnection == null) {
            throw new IllegalArgumentException("connection is null");
        }
        if (this.mPackageInfo == null) throw new RuntimeException("Not supported in system context");
        IServiceConnection iServiceConnection = this.mPackageInfo.forgetServiceDispatcher(this.getOuterContext(), serviceConnection);
        try {
            ActivityManagerNative.getDefault().unbindService(iServiceConnection);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void unregisterReceiver(BroadcastReceiver broadcastReceiver) {
        if (this.mPackageInfo == null) throw new RuntimeException("Not supported in system context");
        IIntentReceiver iIntentReceiver = this.mPackageInfo.forgetReceiverDispatcher(this.getOuterContext(), broadcastReceiver);
        try {
            ActivityManagerNative.getDefault().unregisterReceiver(iIntentReceiver);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    private static final class ApplicationContentResolver
    extends ContentResolver {
        private final ActivityThread mMainThread;
        private final UserHandle mUser;

        public ApplicationContentResolver(Context context, ActivityThread activityThread, UserHandle userHandle) {
            super(context);
            this.mMainThread = Preconditions.checkNotNull(activityThread);
            this.mUser = Preconditions.checkNotNull(userHandle);
        }

        @Override
        protected IContentProvider acquireExistingProvider(Context context, String string2) {
            return this.mMainThread.acquireExistingProvider(context, ContentProvider.getAuthorityWithoutUserId(string2), this.resolveUserIdFromAuthority(string2), true);
        }

        @Override
        protected IContentProvider acquireProvider(Context context, String string2) {
            return this.mMainThread.acquireProvider(context, ContentProvider.getAuthorityWithoutUserId(string2), this.resolveUserIdFromAuthority(string2), true);
        }

        @Override
        protected IContentProvider acquireUnstableProvider(Context context, String string2) {
            return this.mMainThread.acquireProvider(context, ContentProvider.getAuthorityWithoutUserId(string2), this.resolveUserIdFromAuthority(string2), false);
        }

        @Override
        public void appNotRespondingViaProvider(IContentProvider iContentProvider) {
            this.mMainThread.appNotRespondingViaProvider(iContentProvider.asBinder());
        }

        @Override
        public boolean releaseProvider(IContentProvider iContentProvider) {
            return this.mMainThread.releaseProvider(iContentProvider, true);
        }

        @Override
        public boolean releaseUnstableProvider(IContentProvider iContentProvider) {
            return this.mMainThread.releaseProvider(iContentProvider, false);
        }

        protected int resolveUserIdFromAuthority(String string2) {
            return ContentProvider.getUserIdFromAuthority(string2, this.mUser.getIdentifier());
        }

        @Override
        public void unstableProviderDied(IContentProvider iContentProvider) {
            this.mMainThread.handleUnstableProviderDied(iContentProvider.asBinder(), true);
        }
    }

    static class ServiceFetcher {
        int mContextCacheIndex = -1;

        ServiceFetcher() {
        }

        public Object createService(ContextImpl contextImpl) {
            throw new RuntimeException("Not implemented");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object getService(ContextImpl contextImpl) {
            ArrayList<Object> arrayList = contextImpl.mServiceCache;
            synchronized (arrayList) {
                if (arrayList.size() == 0) {
                    for (int i = 0; i < sNextPerContextServiceCacheIndex; ++i) {
                        arrayList.add(null);
                    }
                } else {
                    Object object = arrayList.get(this.mContextCacheIndex);
                    if (object != null) {
                        return object;
                    }
                }
                Object object = this.createService(contextImpl);
                arrayList.set(this.mContextCacheIndex, object);
                return object;
            }
        }
    }

    static abstract class StaticServiceFetcher
    extends ServiceFetcher {
        private Object mCachedInstance;

        StaticServiceFetcher() {
        }

        public abstract Object createStaticService();

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public final Object getService(ContextImpl contextImpl) {
            synchronized (this) {
                Object object;
                Object object2 = this.mCachedInstance;
                if (object2 != null) {
                    return object2;
                }
                this.mCachedInstance = object = this.createStaticService();
                return object;
            }
        }
    }
}

