/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityManager;
import android.app.ActivityManagerProxy;
import android.app.ActivityOptions;
import android.app.ApplicationErrorReport;
import android.app.ApplicationThreadNative;
import android.app.IActivityContainer;
import android.app.IActivityContainerCallback;
import android.app.IActivityController;
import android.app.IActivityManager;
import android.app.IAppTask;
import android.app.IApplicationThread;
import android.app.IInstrumentationWatcher;
import android.app.IProcessObserver;
import android.app.IServiceConnection;
import android.app.IStopUserCallback;
import android.app.IUiAutomationConnection;
import android.app.IUserSwitchObserver;
import android.app.Notification;
import android.app.PendingIntent;
import android.app.ProfilerInfo;
import android.content.ComponentName;
import android.content.IIntentReceiver;
import android.content.IIntentSender;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.UriPermission;
import android.content.pm.ApplicationInfo;
import android.content.pm.ConfigurationInfo;
import android.content.pm.IPackageDataObserver;
import android.content.pm.ParceledListSlice;
import android.content.pm.UserInfo;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.StrictMode;
import android.service.voice.IVoiceInteractionSession;
import android.text.TextUtils;
import android.util.Singleton;
import com.android.internal.app.IVoiceInteractor;
import java.util.List;

public abstract class ActivityManagerNative
extends Binder
implements IActivityManager {
    private static final Singleton<IActivityManager> gDefault;
    static boolean sSystemReady;

    static {
        sSystemReady = false;
        gDefault = new Singleton<IActivityManager>(){

            @Override
            protected IActivityManager create() {
                return ActivityManagerNative.asInterface(ServiceManager.getService("activity"));
            }
        };
    }

    public ActivityManagerNative() {
        this.attachInterface(this, "android.app.IActivityManager");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IActivityManager asInterface(IBinder iBinder) {
        if (iBinder == null) {
            return null;
        }
        IActivityManager iActivityManager = (IActivityManager)iBinder.queryLocalInterface("android.app.IActivityManager");
        if (iActivityManager != null) return iActivityManager;
        return new ActivityManagerProxy(iBinder);
    }

    public static void broadcastStickyIntent(Intent intent, String string2, int n) {
        try {
            ActivityManagerNative.getDefault().broadcastIntent(null, intent, null, null, -1, null, null, null, -1, false, true, n);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public static IActivityManager getDefault() {
        return gDefault.get();
    }

    public static boolean isSystemReady() {
        if (!sSystemReady) {
            sSystemReady = ActivityManagerNative.getDefault().testIsSystemReady();
        }
        return sSystemReady;
    }

    public static void noteWakeupAlarm(PendingIntent pendingIntent, int n, String string2) {
        try {
            ActivityManagerNative.getDefault().noteWakeupAlarm(pendingIntent.getTarget(), n, string2);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    @Override
    public IBinder asBinder() {
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
        switch (n) {
            default: {
                return super.onTransact(n, parcel, parcel2, n2);
            }
            case 3: {
                parcel.enforceInterface("android.app.IActivityManager");
                IApplicationThread iApplicationThread = ApplicationThreadNative.asInterface(parcel.readStrongBinder());
                String string2 = parcel.readString();
                Intent intent = Intent.CREATOR.createFromParcel(parcel);
                String string3 = parcel.readString();
                IBinder iBinder = parcel.readStrongBinder();
                String string4 = parcel.readString();
                int n3 = parcel.readInt();
                int n4 = parcel.readInt();
                ProfilerInfo profilerInfo = parcel.readInt() != 0 ? ProfilerInfo.CREATOR.createFromParcel(parcel) : null;
                Bundle bundle = parcel.readInt() != 0 ? Bundle.CREATOR.createFromParcel(parcel) : null;
                int n5 = this.startActivity(iApplicationThread, string2, intent, string3, iBinder, string4, n3, n4, profilerInfo, bundle);
                parcel2.writeNoException();
                parcel2.writeInt(n5);
                return true;
            }
            case 153: {
                parcel.enforceInterface("android.app.IActivityManager");
                IApplicationThread iApplicationThread = ApplicationThreadNative.asInterface(parcel.readStrongBinder());
                String string5 = parcel.readString();
                Intent intent = Intent.CREATOR.createFromParcel(parcel);
                String string6 = parcel.readString();
                IBinder iBinder = parcel.readStrongBinder();
                String string7 = parcel.readString();
                int n6 = parcel.readInt();
                int n7 = parcel.readInt();
                ProfilerInfo profilerInfo = parcel.readInt() != 0 ? ProfilerInfo.CREATOR.createFromParcel(parcel) : null;
                Bundle bundle = parcel.readInt() != 0 ? Bundle.CREATOR.createFromParcel(parcel) : null;
                int n8 = this.startActivityAsUser(iApplicationThread, string5, intent, string6, iBinder, string7, n6, n7, profilerInfo, bundle, parcel.readInt());
                parcel2.writeNoException();
                parcel2.writeInt(n8);
                return true;
            }
            case 233: {
                parcel.enforceInterface("android.app.IActivityManager");
                IApplicationThread iApplicationThread = ApplicationThreadNative.asInterface(parcel.readStrongBinder());
                String string8 = parcel.readString();
                Intent intent = Intent.CREATOR.createFromParcel(parcel);
                String string9 = parcel.readString();
                IBinder iBinder = parcel.readStrongBinder();
                String string10 = parcel.readString();
                int n9 = parcel.readInt();
                int n10 = parcel.readInt();
                ProfilerInfo profilerInfo = parcel.readInt() != 0 ? ProfilerInfo.CREATOR.createFromParcel(parcel) : null;
                Bundle bundle = parcel.readInt() != 0 ? Bundle.CREATOR.createFromParcel(parcel) : null;
                int n11 = this.startActivityAsCaller(iApplicationThread, string8, intent, string9, iBinder, string10, n9, n10, profilerInfo, bundle, parcel.readInt());
                parcel2.writeNoException();
                parcel2.writeInt(n11);
                return true;
            }
            case 105: {
                parcel.enforceInterface("android.app.IActivityManager");
                IApplicationThread iApplicationThread = ApplicationThreadNative.asInterface(parcel.readStrongBinder());
                String string11 = parcel.readString();
                Intent intent = Intent.CREATOR.createFromParcel(parcel);
                String string12 = parcel.readString();
                IBinder iBinder = parcel.readStrongBinder();
                String string13 = parcel.readString();
                int n12 = parcel.readInt();
                int n13 = parcel.readInt();
                ProfilerInfo profilerInfo = parcel.readInt() != 0 ? ProfilerInfo.CREATOR.createFromParcel(parcel) : null;
                Bundle bundle = parcel.readInt() != 0 ? Bundle.CREATOR.createFromParcel(parcel) : null;
                IActivityManager.WaitResult waitResult = this.startActivityAndWait(iApplicationThread, string11, intent, string12, iBinder, string13, n12, n13, profilerInfo, bundle, parcel.readInt());
                parcel2.writeNoException();
                waitResult.writeToParcel(parcel2, 0);
                return true;
            }
            case 107: {
                parcel.enforceInterface("android.app.IActivityManager");
                IApplicationThread iApplicationThread = ApplicationThreadNative.asInterface(parcel.readStrongBinder());
                String string14 = parcel.readString();
                Intent intent = Intent.CREATOR.createFromParcel(parcel);
                String string15 = parcel.readString();
                IBinder iBinder = parcel.readStrongBinder();
                String string16 = parcel.readString();
                int n14 = parcel.readInt();
                int n15 = parcel.readInt();
                Configuration configuration = Configuration.CREATOR.createFromParcel(parcel);
                Bundle bundle = parcel.readInt() != 0 ? Bundle.CREATOR.createFromParcel(parcel) : null;
                int n16 = parcel.readInt();
                int n17 = this.startActivityWithConfig(iApplicationThread, string14, intent, string15, iBinder, string16, n14, n15, configuration, bundle, n16);
                parcel2.writeNoException();
                parcel2.writeInt(n17);
                return true;
            }
            case 100: {
                parcel.enforceInterface("android.app.IActivityManager");
                IApplicationThread iApplicationThread = ApplicationThreadNative.asInterface(parcel.readStrongBinder());
                IntentSender intentSender = IntentSender.CREATOR.createFromParcel(parcel);
                int n18 = parcel.readInt();
                Intent intent = null;
                if (n18 != 0) {
                    intent = Intent.CREATOR.createFromParcel(parcel);
                }
                String string17 = parcel.readString();
                IBinder iBinder = parcel.readStrongBinder();
                String string18 = parcel.readString();
                int n19 = parcel.readInt();
                int n20 = parcel.readInt();
                int n21 = parcel.readInt();
                Bundle bundle = parcel.readInt() != 0 ? Bundle.CREATOR.createFromParcel(parcel) : null;
                int n22 = this.startActivityIntentSender(iApplicationThread, intentSender, intent, string17, iBinder, string18, n19, n20, n21, bundle);
                parcel2.writeNoException();
                parcel2.writeInt(n22);
                return true;
            }
            case 219: {
                parcel.enforceInterface("android.app.IActivityManager");
                String string19 = parcel.readString();
                int n23 = parcel.readInt();
                int n24 = parcel.readInt();
                Intent intent = Intent.CREATOR.createFromParcel(parcel);
                String string20 = parcel.readString();
                IVoiceInteractionSession iVoiceInteractionSession = IVoiceInteractionSession.Stub.asInterface(parcel.readStrongBinder());
                IVoiceInteractor iVoiceInteractor = IVoiceInteractor.Stub.asInterface(parcel.readStrongBinder());
                int n25 = parcel.readInt();
                ProfilerInfo profilerInfo = parcel.readInt() != 0 ? ProfilerInfo.CREATOR.createFromParcel(parcel) : null;
                Bundle bundle = parcel.readInt() != 0 ? Bundle.CREATOR.createFromParcel(parcel) : null;
                int n26 = parcel.readInt();
                int n27 = this.startVoiceActivity(string19, n23, n24, intent, string20, iVoiceInteractionSession, iVoiceInteractor, n25, profilerInfo, bundle, n26);
                parcel2.writeNoException();
                parcel2.writeInt(n27);
                return true;
            }
            case 67: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = parcel.readStrongBinder();
                Intent intent = Intent.CREATOR.createFromParcel(parcel);
                Bundle bundle = parcel.readInt() != 0 ? Bundle.CREATOR.createFromParcel(parcel) : null;
                boolean bl = this.startNextMatchingActivity(iBinder, intent, bundle);
                parcel2.writeNoException();
                int n28 = bl ? 1 : 0;
                parcel2.writeInt(n28);
                return true;
            }
            case 230: {
                parcel.enforceInterface("android.app.IActivityManager");
                int n29 = parcel.readInt();
                Bundle bundle = parcel.readInt() == 0 ? null : Bundle.CREATOR.createFromParcel(parcel);
                int n30 = this.startActivityFromRecents(n29, bundle);
                parcel2.writeNoException();
                parcel2.writeInt(n30);
                return true;
            }
            case 11: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = parcel.readStrongBinder();
                int n31 = parcel.readInt();
                int n32 = parcel.readInt();
                Intent intent = null;
                if (n32 != 0) {
                    intent = Intent.CREATOR.createFromParcel(parcel);
                }
                boolean bl = parcel.readInt() != 0;
                boolean bl2 = this.finishActivity(iBinder, n31, intent, bl);
                parcel2.writeNoException();
                int n33 = bl2 ? 1 : 0;
                parcel2.writeInt(n33);
                return true;
            }
            case 32: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.finishSubActivity(parcel.readStrongBinder(), parcel.readString(), parcel.readInt());
                parcel2.writeNoException();
                return true;
            }
            case 149: {
                parcel.enforceInterface("android.app.IActivityManager");
                boolean bl = this.finishActivityAffinity(parcel.readStrongBinder());
                parcel2.writeNoException();
                int n34 = bl ? 1 : 0;
                parcel2.writeInt(n34);
                return true;
            }
            case 224: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.finishVoiceTask(IVoiceInteractionSession.Stub.asInterface(parcel.readStrongBinder()));
                parcel2.writeNoException();
                return true;
            }
            case 236: {
                parcel.enforceInterface("android.app.IActivityManager");
                boolean bl = this.releaseActivityInstance(parcel.readStrongBinder());
                parcel2.writeNoException();
                int n35 = bl ? 1 : 0;
                parcel2.writeInt(n35);
                return true;
            }
            case 237: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.releaseSomeActivities(ApplicationThreadNative.asInterface(parcel.readStrongBinder()));
                parcel2.writeNoException();
                return true;
            }
            case 106: {
                parcel.enforceInterface("android.app.IActivityManager");
                boolean bl = this.willActivityBeVisible(parcel.readStrongBinder());
                parcel2.writeNoException();
                int n36 = bl ? 1 : 0;
                parcel2.writeInt(n36);
                return true;
            }
            case 12: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = parcel.readStrongBinder();
                IApplicationThread iApplicationThread = iBinder != null ? ApplicationThreadNative.asInterface(iBinder) : null;
                String string21 = parcel.readString();
                IBinder iBinder2 = parcel.readStrongBinder();
                IIntentReceiver iIntentReceiver = iBinder2 != null ? IIntentReceiver.Stub.asInterface(iBinder2) : null;
                IntentFilter intentFilter = IntentFilter.CREATOR.createFromParcel(parcel);
                String string22 = parcel.readString();
                int n37 = parcel.readInt();
                Intent intent = this.registerReceiver(iApplicationThread, string21, iIntentReceiver, intentFilter, string22, n37);
                parcel2.writeNoException();
                if (intent != null) {
                    parcel2.writeInt(1);
                    intent.writeToParcel(parcel2, 0);
                    return true;
                }
                parcel2.writeInt(0);
                return true;
            }
            case 13: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = parcel.readStrongBinder();
                if (iBinder == null) {
                    return true;
                }
                this.unregisterReceiver(IIntentReceiver.Stub.asInterface(iBinder));
                parcel2.writeNoException();
                return true;
            }
            case 14: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = parcel.readStrongBinder();
                IApplicationThread iApplicationThread = iBinder != null ? ApplicationThreadNative.asInterface(iBinder) : null;
                Intent intent = Intent.CREATOR.createFromParcel(parcel);
                String string23 = parcel.readString();
                IBinder iBinder3 = parcel.readStrongBinder();
                IIntentReceiver iIntentReceiver = iBinder3 != null ? IIntentReceiver.Stub.asInterface(iBinder3) : null;
                int n38 = parcel.readInt();
                String string24 = parcel.readString();
                Bundle bundle = parcel.readBundle();
                String string25 = parcel.readString();
                int n39 = parcel.readInt();
                boolean bl = parcel.readInt() != 0;
                boolean bl3 = parcel.readInt() != 0;
                int n40 = parcel.readInt();
                int n41 = this.broadcastIntent(iApplicationThread, intent, string23, iIntentReceiver, n38, string24, bundle, string25, n39, bl, bl3, n40);
                parcel2.writeNoException();
                parcel2.writeInt(n41);
                return true;
            }
            case 15: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = parcel.readStrongBinder();
                IApplicationThread iApplicationThread = iBinder != null ? ApplicationThreadNative.asInterface(iBinder) : null;
                this.unbroadcastIntent(iApplicationThread, Intent.CREATOR.createFromParcel(parcel), parcel.readInt());
                parcel2.writeNoException();
                return true;
            }
            case 16: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = parcel.readStrongBinder();
                int n42 = parcel.readInt();
                String string26 = parcel.readString();
                Bundle bundle = parcel.readBundle();
                boolean bl = parcel.readInt() != 0;
                if (iBinder != null) {
                    this.finishReceiver(iBinder, n42, string26, bundle, bl);
                }
                parcel2.writeNoException();
                return true;
            }
            case 17: {
                parcel.enforceInterface("android.app.IActivityManager");
                IApplicationThread iApplicationThread = ApplicationThreadNative.asInterface(parcel.readStrongBinder());
                if (iApplicationThread != null) {
                    this.attachApplication(iApplicationThread);
                }
                parcel2.writeNoException();
                return true;
            }
            case 18: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = parcel.readStrongBinder();
                int n43 = parcel.readInt();
                Configuration configuration = null;
                if (n43 != 0) {
                    configuration = Configuration.CREATOR.createFromParcel(parcel);
                }
                boolean bl = parcel.readInt() != 0;
                if (iBinder != null) {
                    this.activityIdle(iBinder, configuration, bl);
                }
                parcel2.writeNoException();
                return true;
            }
            case 39: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.activityResumed(parcel.readStrongBinder());
                parcel2.writeNoException();
                return true;
            }
            case 19: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.activityPaused(parcel.readStrongBinder());
                parcel2.writeNoException();
                return true;
            }
            case 20: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.activityStopped(parcel.readStrongBinder(), parcel.readBundle(), parcel.readPersistableBundle(), TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel));
                parcel2.writeNoException();
                return true;
            }
            case 123: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.activitySlept(parcel.readStrongBinder());
                parcel2.writeNoException();
                return true;
            }
            case 62: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.activityDestroyed(parcel.readStrongBinder());
                parcel2.writeNoException();
                return true;
            }
            case 21: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = parcel.readStrongBinder();
                String string27 = iBinder != null ? this.getCallingPackage(iBinder) : null;
                parcel2.writeNoException();
                parcel2.writeString(string27);
                return true;
            }
            case 22: {
                parcel.enforceInterface("android.app.IActivityManager");
                ComponentName componentName = this.getCallingActivity(parcel.readStrongBinder());
                parcel2.writeNoException();
                ComponentName.writeToParcel(componentName, parcel2);
                return true;
            }
            case 221: {
                parcel.enforceInterface("android.app.IActivityManager");
                List<IAppTask> list = this.getAppTasks(parcel.readString());
                parcel2.writeNoException();
                int n44 = list != null ? list.size() : -1;
                parcel2.writeInt(n44);
                int n45 = 0;
                while (n45 < n44) {
                    parcel2.writeStrongBinder(list.get(n45).asBinder());
                    ++n45;
                }
                return true;
            }
            case 234: {
                parcel.enforceInterface("android.app.IActivityManager");
                int n46 = this.addAppTask(parcel.readStrongBinder(), Intent.CREATOR.createFromParcel(parcel), ActivityManager.TaskDescription.CREATOR.createFromParcel(parcel), Bitmap.CREATOR.createFromParcel(parcel));
                parcel2.writeNoException();
                parcel2.writeInt(n46);
                return true;
            }
            case 235: {
                parcel.enforceInterface("android.app.IActivityManager");
                Point point = this.getAppTaskThumbnailSize();
                parcel2.writeNoException();
                point.writeToParcel(parcel2, 0);
                return true;
            }
            case 23: {
                parcel.enforceInterface("android.app.IActivityManager");
                List<ActivityManager.RunningTaskInfo> list = this.getTasks(parcel.readInt(), parcel.readInt());
                parcel2.writeNoException();
                int n47 = list != null ? list.size() : -1;
                parcel2.writeInt(n47);
                int n48 = 0;
                while (n48 < n47) {
                    list.get(n48).writeToParcel(parcel2, 0);
                    ++n48;
                }
                return true;
            }
            case 60: {
                parcel.enforceInterface("android.app.IActivityManager");
                List<ActivityManager.RecentTaskInfo> list = this.getRecentTasks(parcel.readInt(), parcel.readInt(), parcel.readInt());
                parcel2.writeNoException();
                parcel2.writeTypedList(list);
                return true;
            }
            case 82: {
                parcel.enforceInterface("android.app.IActivityManager");
                ActivityManager.TaskThumbnail taskThumbnail = this.getTaskThumbnail(parcel.readInt());
                parcel2.writeNoException();
                if (taskThumbnail != null) {
                    parcel2.writeInt(1);
                    taskThumbnail.writeToParcel(parcel2, 1);
                    return true;
                }
                parcel2.writeInt(0);
                return true;
            }
            case 81: {
                parcel.enforceInterface("android.app.IActivityManager");
                List<ActivityManager.RunningServiceInfo> list = this.getServices(parcel.readInt(), parcel.readInt());
                parcel2.writeNoException();
                int n49 = list != null ? list.size() : -1;
                parcel2.writeInt(n49);
                int n50 = 0;
                while (n50 < n49) {
                    list.get(n50).writeToParcel(parcel2, 0);
                    ++n50;
                }
                return true;
            }
            case 77: {
                parcel.enforceInterface("android.app.IActivityManager");
                List<ActivityManager.ProcessErrorStateInfo> list = this.getProcessesInErrorState();
                parcel2.writeNoException();
                parcel2.writeTypedList(list);
                return true;
            }
            case 83: {
                parcel.enforceInterface("android.app.IActivityManager");
                List<ActivityManager.RunningAppProcessInfo> list = this.getRunningAppProcesses();
                parcel2.writeNoException();
                parcel2.writeTypedList(list);
                return true;
            }
            case 108: {
                parcel.enforceInterface("android.app.IActivityManager");
                List<ApplicationInfo> list = this.getRunningExternalApplications();
                parcel2.writeNoException();
                parcel2.writeTypedList(list);
                return true;
            }
            case 24: {
                parcel.enforceInterface("android.app.IActivityManager");
                int n51 = parcel.readInt();
                int n52 = parcel.readInt();
                Bundle bundle = parcel.readInt() != 0 ? Bundle.CREATOR.createFromParcel(parcel) : null;
                this.moveTaskToFront(n51, n52, bundle);
                parcel2.writeNoException();
                return true;
            }
            case 25: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.moveTaskToBack(parcel.readInt());
                parcel2.writeNoException();
                return true;
            }
            case 75: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = parcel.readStrongBinder();
                boolean bl = parcel.readInt() != 0;
                boolean bl4 = this.moveActivityTaskToBack(iBinder, bl);
                parcel2.writeNoException();
                int n53 = bl4 ? 1 : 0;
                parcel2.writeInt(n53);
                return true;
            }
            case 26: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.moveTaskBackwards(parcel.readInt());
                parcel2.writeNoException();
                return true;
            }
            case 169: {
                parcel.enforceInterface("android.app.IActivityManager");
                int n54 = parcel.readInt();
                int n55 = parcel.readInt();
                boolean bl = parcel.readInt() != 0;
                this.moveTaskToStack(n54, n55, bl);
                parcel2.writeNoException();
                return true;
            }
            case 170: {
                parcel.enforceInterface("android.app.IActivityManager");
                int n56 = parcel.readInt();
                parcel.readFloat();
                this.resizeStack(n56, Rect.CREATOR.createFromParcel(parcel));
                parcel2.writeNoException();
                return true;
            }
            case 171: {
                parcel.enforceInterface("android.app.IActivityManager");
                List<ActivityManager.StackInfo> list = this.getAllStackInfos();
                parcel2.writeNoException();
                parcel2.writeTypedList(list);
                return true;
            }
            case 173: {
                parcel.enforceInterface("android.app.IActivityManager");
                ActivityManager.StackInfo stackInfo = this.getStackInfo(parcel.readInt());
                parcel2.writeNoException();
                if (stackInfo != null) {
                    parcel2.writeInt(1);
                    stackInfo.writeToParcel(parcel2, 0);
                    return true;
                }
                parcel2.writeInt(0);
                return true;
            }
            case 213: {
                parcel.enforceInterface("android.app.IActivityManager");
                boolean bl = this.isInHomeStack(parcel.readInt());
                parcel2.writeNoException();
                int n57 = bl ? 1 : 0;
                parcel2.writeInt(n57);
                return true;
            }
            case 172: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.setFocusedStack(parcel.readInt());
                parcel2.writeNoException();
                return true;
            }
            case 27: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = parcel.readStrongBinder();
                boolean bl = parcel.readInt() != 0;
                int n58 = iBinder != null ? this.getTaskForActivity(iBinder, bl) : -1;
                parcel2.writeNoException();
                parcel2.writeInt(n58);
                return true;
            }
            case 29: {
                parcel.enforceInterface("android.app.IActivityManager");
                IApplicationThread iApplicationThread = ApplicationThreadNative.asInterface(parcel.readStrongBinder());
                String string28 = parcel.readString();
                int n59 = parcel.readInt();
                boolean bl = parcel.readInt() != 0;
                IActivityManager.ContentProviderHolder contentProviderHolder = this.getContentProvider(iApplicationThread, string28, n59, bl);
                parcel2.writeNoException();
                if (contentProviderHolder != null) {
                    parcel2.writeInt(1);
                    contentProviderHolder.writeToParcel(parcel2, 0);
                    return true;
                }
                parcel2.writeInt(0);
                return true;
            }
            case 141: {
                parcel.enforceInterface("android.app.IActivityManager");
                IActivityManager.ContentProviderHolder contentProviderHolder = this.getContentProviderExternal(parcel.readString(), parcel.readInt(), parcel.readStrongBinder());
                parcel2.writeNoException();
                if (contentProviderHolder != null) {
                    parcel2.writeInt(1);
                    contentProviderHolder.writeToParcel(parcel2, 0);
                    return true;
                }
                parcel2.writeInt(0);
                return true;
            }
            case 30: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.publishContentProviders(ApplicationThreadNative.asInterface(parcel.readStrongBinder()), parcel.createTypedArrayList(IActivityManager.ContentProviderHolder.CREATOR));
                parcel2.writeNoException();
                return true;
            }
            case 31: {
                parcel.enforceInterface("android.app.IActivityManager");
                boolean bl = this.refContentProvider(parcel.readStrongBinder(), parcel.readInt(), parcel.readInt());
                parcel2.writeNoException();
                int n60 = bl ? 1 : 0;
                parcel2.writeInt(n60);
                return true;
            }
            case 151: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.unstableProviderDied(parcel.readStrongBinder());
                parcel2.writeNoException();
                return true;
            }
            case 183: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.appNotRespondingViaProvider(parcel.readStrongBinder());
                parcel2.writeNoException();
                return true;
            }
            case 69: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = parcel.readStrongBinder();
                boolean bl = parcel.readInt() != 0;
                this.removeContentProvider(iBinder, bl);
                parcel2.writeNoException();
                return true;
            }
            case 142: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.removeContentProviderExternal(parcel.readString(), parcel.readStrongBinder());
                parcel2.writeNoException();
                return true;
            }
            case 33: {
                parcel.enforceInterface("android.app.IActivityManager");
                PendingIntent pendingIntent = this.getRunningServiceControlPanel(ComponentName.CREATOR.createFromParcel(parcel));
                parcel2.writeNoException();
                PendingIntent.writePendingIntentOrNullToParcel(pendingIntent, parcel2);
                return true;
            }
            case 34: {
                parcel.enforceInterface("android.app.IActivityManager");
                ComponentName componentName = this.startService(ApplicationThreadNative.asInterface(parcel.readStrongBinder()), Intent.CREATOR.createFromParcel(parcel), parcel.readString(), parcel.readInt());
                parcel2.writeNoException();
                ComponentName.writeToParcel(componentName, parcel2);
                return true;
            }
            case 35: {
                parcel.enforceInterface("android.app.IActivityManager");
                int n61 = this.stopService(ApplicationThreadNative.asInterface(parcel.readStrongBinder()), Intent.CREATOR.createFromParcel(parcel), parcel.readString(), parcel.readInt());
                parcel2.writeNoException();
                parcel2.writeInt(n61);
                return true;
            }
            case 48: {
                parcel.enforceInterface("android.app.IActivityManager");
                boolean bl = this.stopServiceToken(ComponentName.readFromParcel(parcel), parcel.readStrongBinder(), parcel.readInt());
                parcel2.writeNoException();
                int n62 = bl ? 1 : 0;
                parcel2.writeInt(n62);
                return true;
            }
            case 74: {
                parcel.enforceInterface("android.app.IActivityManager");
                ComponentName componentName = ComponentName.readFromParcel(parcel);
                IBinder iBinder = parcel.readStrongBinder();
                int n63 = parcel.readInt();
                int n64 = parcel.readInt();
                Notification notification = null;
                if (n64 != 0) {
                    notification = Notification.CREATOR.createFromParcel(parcel);
                }
                boolean bl = parcel.readInt() != 0;
                this.setServiceForeground(componentName, iBinder, n63, notification, bl);
                parcel2.writeNoException();
                return true;
            }
            case 36: {
                parcel.enforceInterface("android.app.IActivityManager");
                IApplicationThread iApplicationThread = ApplicationThreadNative.asInterface(parcel.readStrongBinder());
                IBinder iBinder = parcel.readStrongBinder();
                Intent intent = Intent.CREATOR.createFromParcel(parcel);
                String string29 = parcel.readString();
                IBinder iBinder4 = parcel.readStrongBinder();
                int n65 = parcel.readInt();
                int n66 = parcel.readInt();
                int n67 = this.bindService(iApplicationThread, iBinder, intent, string29, IServiceConnection.Stub.asInterface(iBinder4), n65, n66);
                parcel2.writeNoException();
                parcel2.writeInt(n67);
                return true;
            }
            case 37: {
                parcel.enforceInterface("android.app.IActivityManager");
                boolean bl = this.unbindService(IServiceConnection.Stub.asInterface(parcel.readStrongBinder()));
                parcel2.writeNoException();
                int n68 = bl ? 1 : 0;
                parcel2.writeInt(n68);
                return true;
            }
            case 38: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.publishService(parcel.readStrongBinder(), Intent.CREATOR.createFromParcel(parcel), parcel.readStrongBinder());
                parcel2.writeNoException();
                return true;
            }
            case 72: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = parcel.readStrongBinder();
                Intent intent = Intent.CREATOR.createFromParcel(parcel);
                boolean bl = parcel.readInt() != 0;
                this.unbindFinished(iBinder, intent, bl);
                parcel2.writeNoException();
                return true;
            }
            case 61: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.serviceDoneExecuting(parcel.readStrongBinder(), parcel.readInt(), parcel.readInt(), parcel.readInt());
                parcel2.writeNoException();
                return true;
            }
            case 44: {
                parcel.enforceInterface("android.app.IActivityManager");
                boolean bl = this.startInstrumentation(ComponentName.readFromParcel(parcel), parcel.readString(), parcel.readInt(), parcel.readBundle(), IInstrumentationWatcher.Stub.asInterface(parcel.readStrongBinder()), IUiAutomationConnection.Stub.asInterface(parcel.readStrongBinder()), parcel.readInt(), parcel.readString());
                parcel2.writeNoException();
                int n69 = bl ? 1 : 0;
                parcel2.writeInt(n69);
                return true;
            }
            case 45: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.finishInstrumentation(ApplicationThreadNative.asInterface(parcel.readStrongBinder()), parcel.readInt(), parcel.readBundle());
                parcel2.writeNoException();
                return true;
            }
            case 46: {
                parcel.enforceInterface("android.app.IActivityManager");
                Configuration configuration = this.getConfiguration();
                parcel2.writeNoException();
                configuration.writeToParcel(parcel2, 0);
                return true;
            }
            case 47: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.updateConfiguration(Configuration.CREATOR.createFromParcel(parcel));
                parcel2.writeNoException();
                return true;
            }
            case 70: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.setRequestedOrientation(parcel.readStrongBinder(), parcel.readInt());
                parcel2.writeNoException();
                return true;
            }
            case 71: {
                parcel.enforceInterface("android.app.IActivityManager");
                int n70 = this.getRequestedOrientation(parcel.readStrongBinder());
                parcel2.writeNoException();
                parcel2.writeInt(n70);
                return true;
            }
            case 49: {
                parcel.enforceInterface("android.app.IActivityManager");
                ComponentName componentName = this.getActivityClassForToken(parcel.readStrongBinder());
                parcel2.writeNoException();
                ComponentName.writeToParcel(componentName, parcel2);
                return true;
            }
            case 50: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = parcel.readStrongBinder();
                parcel2.writeNoException();
                parcel2.writeString(this.getPackageForToken(iBinder));
                return true;
            }
            case 63: {
                String[] stringArray;
                Intent[] intentArray;
                parcel.enforceInterface("android.app.IActivityManager");
                int n71 = parcel.readInt();
                String string30 = parcel.readString();
                IBinder iBinder = parcel.readStrongBinder();
                String string31 = parcel.readString();
                int n72 = parcel.readInt();
                if (parcel.readInt() != 0) {
                    intentArray = parcel.createTypedArray(Intent.CREATOR);
                    stringArray = parcel.createStringArray();
                } else {
                    intentArray = null;
                    stringArray = null;
                }
                int n73 = parcel.readInt();
                Bundle bundle = parcel.readInt() != 0 ? Bundle.CREATOR.createFromParcel(parcel) : null;
                int n74 = parcel.readInt();
                IIntentSender iIntentSender = this.getIntentSender(n71, string30, iBinder, string31, n72, intentArray, stringArray, n73, bundle, n74);
                parcel2.writeNoException();
                IBinder iBinder5 = iIntentSender != null ? iIntentSender.asBinder() : null;
                parcel2.writeStrongBinder(iBinder5);
                return true;
            }
            case 64: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.cancelIntentSender(IIntentSender.Stub.asInterface(parcel.readStrongBinder()));
                parcel2.writeNoException();
                return true;
            }
            case 65: {
                parcel.enforceInterface("android.app.IActivityManager");
                String string32 = this.getPackageForIntentSender(IIntentSender.Stub.asInterface(parcel.readStrongBinder()));
                parcel2.writeNoException();
                parcel2.writeString(string32);
                return true;
            }
            case 93: {
                parcel.enforceInterface("android.app.IActivityManager");
                int n75 = this.getUidForIntentSender(IIntentSender.Stub.asInterface(parcel.readStrongBinder()));
                parcel2.writeNoException();
                parcel2.writeInt(n75);
                return true;
            }
            case 94: {
                parcel.enforceInterface("android.app.IActivityManager");
                int n76 = parcel.readInt();
                int n77 = parcel.readInt();
                int n78 = parcel.readInt();
                boolean bl = parcel.readInt() != 0;
                boolean bl5 = parcel.readInt() != 0;
                int n79 = this.handleIncomingUser(n76, n77, n78, bl, bl5, parcel.readString(), parcel.readString());
                parcel2.writeNoException();
                parcel2.writeInt(n79);
                return true;
            }
            case 51: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.setProcessLimit(parcel.readInt());
                parcel2.writeNoException();
                return true;
            }
            case 52: {
                parcel.enforceInterface("android.app.IActivityManager");
                int n80 = this.getProcessLimit();
                parcel2.writeNoException();
                parcel2.writeInt(n80);
                return true;
            }
            case 73: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = parcel.readStrongBinder();
                int n81 = parcel.readInt();
                boolean bl = parcel.readInt() != 0;
                this.setProcessForeground(iBinder, n81, bl);
                parcel2.writeNoException();
                return true;
            }
            case 53: {
                parcel.enforceInterface("android.app.IActivityManager");
                int n82 = this.checkPermission(parcel.readString(), parcel.readInt(), parcel.readInt());
                parcel2.writeNoException();
                parcel2.writeInt(n82);
                return true;
            }
            case 54: {
                parcel.enforceInterface("android.app.IActivityManager");
                int n83 = this.checkUriPermission(Uri.CREATOR.createFromParcel(parcel), parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.readInt());
                parcel2.writeNoException();
                parcel2.writeInt(n83);
                return true;
            }
            case 78: {
                parcel.enforceInterface("android.app.IActivityManager");
                boolean bl = this.clearApplicationUserData(parcel.readString(), IPackageDataObserver.Stub.asInterface(parcel.readStrongBinder()), parcel.readInt());
                parcel2.writeNoException();
                int n84 = bl ? 1 : 0;
                parcel2.writeInt(n84);
                return true;
            }
            case 55: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.grantUriPermission(ApplicationThreadNative.asInterface(parcel.readStrongBinder()), parcel.readString(), Uri.CREATOR.createFromParcel(parcel), parcel.readInt(), parcel.readInt());
                parcel2.writeNoException();
                return true;
            }
            case 56: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.revokeUriPermission(ApplicationThreadNative.asInterface(parcel.readStrongBinder()), Uri.CREATOR.createFromParcel(parcel), parcel.readInt(), parcel.readInt());
                parcel2.writeNoException();
                return true;
            }
            case 180: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.takePersistableUriPermission(Uri.CREATOR.createFromParcel(parcel), parcel.readInt(), parcel.readInt());
                parcel2.writeNoException();
                return true;
            }
            case 181: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.releasePersistableUriPermission(Uri.CREATOR.createFromParcel(parcel), parcel.readInt(), parcel.readInt());
                parcel2.writeNoException();
                return true;
            }
            case 182: {
                parcel.enforceInterface("android.app.IActivityManager");
                String string33 = parcel.readString();
                boolean bl = parcel.readInt() != 0;
                ParceledListSlice<UriPermission> parceledListSlice = this.getPersistedUriPermissions(string33, bl);
                parcel2.writeNoException();
                parceledListSlice.writeToParcel(parcel2, 1);
                return true;
            }
            case 58: {
                parcel.enforceInterface("android.app.IActivityManager");
                IApplicationThread iApplicationThread = ApplicationThreadNative.asInterface(parcel.readStrongBinder());
                boolean bl = parcel.readInt() != 0;
                this.showWaitingForDebugger(iApplicationThread, bl);
                parcel2.writeNoException();
                return true;
            }
            case 76: {
                parcel.enforceInterface("android.app.IActivityManager");
                ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
                this.getMemoryInfo(memoryInfo);
                parcel2.writeNoException();
                memoryInfo.writeToParcel(parcel2, 0);
                return true;
            }
            case 4: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.unhandledBack();
                parcel2.writeNoException();
                return true;
            }
            case 5: {
                parcel.enforceInterface("android.app.IActivityManager");
                ParcelFileDescriptor parcelFileDescriptor = this.openContentUri(Uri.parse(parcel.readString()));
                parcel2.writeNoException();
                if (parcelFileDescriptor != null) {
                    parcel2.writeInt(1);
                    parcelFileDescriptor.writeToParcel(parcel2, 1);
                    return true;
                }
                parcel2.writeInt(0);
                return true;
            }
            case 148: {
                parcel.enforceInterface("android.app.IActivityManager");
                boolean bl = parcel.readInt() != 0;
                this.setLockScreenShown(bl);
                parcel2.writeNoException();
                return true;
            }
            case 42: {
                parcel.enforceInterface("android.app.IActivityManager");
                String string34 = parcel.readString();
                boolean bl = parcel.readInt() != 0;
                boolean bl6 = parcel.readInt() != 0;
                this.setDebugApp(string34, bl, bl6);
                parcel2.writeNoException();
                return true;
            }
            case 43: {
                parcel.enforceInterface("android.app.IActivityManager");
                boolean bl = parcel.readInt() != 0;
                this.setAlwaysFinish(bl);
                parcel2.writeNoException();
                return true;
            }
            case 57: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.setActivityController(IActivityController.Stub.asInterface(parcel.readStrongBinder()));
                parcel2.writeNoException();
                return true;
            }
            case 66: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.enterSafeMode();
                parcel2.writeNoException();
                return true;
            }
            case 68: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.noteWakeupAlarm(IIntentSender.Stub.asInterface(parcel.readStrongBinder()), parcel.readInt(), parcel.readString());
                parcel2.writeNoException();
                return true;
            }
            case 80: {
                parcel.enforceInterface("android.app.IActivityManager");
                int[] nArray = parcel.createIntArray();
                String string35 = parcel.readString();
                boolean bl = parcel.readInt() != 0;
                boolean bl7 = this.killPids(nArray, string35, bl);
                parcel2.writeNoException();
                int n85 = bl7 ? 1 : 0;
                parcel2.writeInt(n85);
                return true;
            }
            case 144: {
                parcel.enforceInterface("android.app.IActivityManager");
                boolean bl = this.killProcessesBelowForeground(parcel.readString());
                parcel2.writeNoException();
                int n86 = bl ? 1 : 0;
                parcel2.writeInt(n86);
                return true;
            }
            case 2: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = parcel.readStrongBinder();
                ApplicationErrorReport.CrashInfo crashInfo = new ApplicationErrorReport.CrashInfo(parcel);
                this.handleApplicationCrash(iBinder, crashInfo);
                parcel2.writeNoException();
                return true;
            }
            case 102: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = parcel.readStrongBinder();
                String string36 = parcel.readString();
                boolean bl = parcel.readInt() != 0;
                ApplicationErrorReport.CrashInfo crashInfo = new ApplicationErrorReport.CrashInfo(parcel);
                boolean bl8 = this.handleApplicationWtf(iBinder, string36, bl, crashInfo);
                parcel2.writeNoException();
                int n87 = bl8 ? 1 : 0;
                parcel2.writeInt(n87);
                return true;
            }
            case 110: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = parcel.readStrongBinder();
                int n88 = parcel.readInt();
                StrictMode.ViolationInfo violationInfo = new StrictMode.ViolationInfo(parcel);
                this.handleApplicationStrictModeViolation(iBinder, n88, violationInfo);
                parcel2.writeNoException();
                return true;
            }
            case 59: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.signalPersistentProcesses(parcel.readInt());
                parcel2.writeNoException();
                return true;
            }
            case 103: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.killBackgroundProcesses(parcel.readString(), parcel.readInt());
                parcel2.writeNoException();
                return true;
            }
            case 140: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.killAllBackgroundProcesses();
                parcel2.writeNoException();
                return true;
            }
            case 79: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.forceStopPackage(parcel.readString(), parcel.readInt());
                parcel2.writeNoException();
                return true;
            }
            case 4203: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.forceStopNativeProcess(parcel.readString());
                parcel2.writeNoException();
                return true;
            }
            case 143: {
                parcel.enforceInterface("android.app.IActivityManager");
                ActivityManager.RunningAppProcessInfo runningAppProcessInfo = new ActivityManager.RunningAppProcessInfo();
                this.getMyMemoryState(runningAppProcessInfo);
                parcel2.writeNoException();
                runningAppProcessInfo.writeToParcel(parcel2, 0);
                return true;
            }
            case 84: {
                parcel.enforceInterface("android.app.IActivityManager");
                ConfigurationInfo configurationInfo = this.getDeviceConfigurationInfo();
                parcel2.writeNoException();
                configurationInfo.writeToParcel(parcel2, 0);
                return true;
            }
            case 86: {
                parcel.enforceInterface("android.app.IActivityManager");
                String string37 = parcel.readString();
                int n89 = parcel.readInt();
                boolean bl = parcel.readInt() != 0;
                int n90 = parcel.readInt();
                ProfilerInfo profilerInfo = parcel.readInt() != 0 ? ProfilerInfo.CREATOR.createFromParcel(parcel) : null;
                boolean bl9 = this.profileControl(string37, n89, bl, profilerInfo, n90);
                parcel2.writeNoException();
                int n91 = bl9 ? 1 : 0;
                parcel2.writeInt(n91);
                return true;
            }
            case 87: {
                parcel.enforceInterface("android.app.IActivityManager");
                boolean bl = this.shutdown(parcel.readInt());
                parcel2.writeNoException();
                int n92 = bl ? 1 : 0;
                parcel2.writeInt(n92);
                return true;
            }
            case 88: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.stopAppSwitches();
                parcel2.writeNoException();
                return true;
            }
            case 89: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.resumeAppSwitches();
                parcel2.writeNoException();
                return true;
            }
            case 85: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = this.peekService(Intent.CREATOR.createFromParcel(parcel), parcel.readString());
                parcel2.writeNoException();
                parcel2.writeStrongBinder(iBinder);
                return true;
            }
            case 90: {
                parcel.enforceInterface("android.app.IActivityManager");
                boolean bl = this.bindBackupAgent(ApplicationInfo.CREATOR.createFromParcel(parcel), parcel.readInt());
                parcel2.writeNoException();
                int n93 = bl ? 1 : 0;
                parcel2.writeInt(n93);
                return true;
            }
            case 91: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.backupAgentCreated(parcel.readString(), parcel.readStrongBinder());
                parcel2.writeNoException();
                return true;
            }
            case 92: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.unbindBackupAgent(ApplicationInfo.CREATOR.createFromParcel(parcel));
                parcel2.writeNoException();
                return true;
            }
            case 95: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.addPackageDependency(parcel.readString());
                parcel2.writeNoException();
                return true;
            }
            case 96: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.killApplicationWithAppId(parcel.readString(), parcel.readInt(), parcel.readString());
                parcel2.writeNoException();
                return true;
            }
            case 97: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.closeSystemDialogs(parcel.readString());
                parcel2.writeNoException();
                return true;
            }
            case 98: {
                parcel.enforceInterface("android.app.IActivityManager");
                Parcelable[] parcelableArray = this.getProcessMemoryInfo(parcel.createIntArray());
                parcel2.writeNoException();
                parcel2.writeTypedArray(parcelableArray, 1);
                return true;
            }
            case 99: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.killApplicationProcess(parcel.readString(), parcel.readInt());
                parcel2.writeNoException();
                return true;
            }
            case 101: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.overridePendingTransition(parcel.readStrongBinder(), parcel.readString(), parcel.readInt(), parcel.readInt());
                parcel2.writeNoException();
                return true;
            }
            case 104: {
                parcel.enforceInterface("android.app.IActivityManager");
                boolean bl = this.isUserAMonkey();
                parcel2.writeNoException();
                int n94 = bl ? 1 : 0;
                parcel2.writeInt(n94);
                return true;
            }
            case 166: {
                parcel.enforceInterface("android.app.IActivityManager");
                boolean bl = parcel.readInt() == 1;
                this.setUserIsMonkey(bl);
                parcel2.writeNoException();
                return true;
            }
            case 109: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.finishHeavyWeightApp();
                parcel2.writeNoException();
                return true;
            }
            case 111: {
                parcel.enforceInterface("android.app.IActivityManager");
                boolean bl = this.isImmersive(parcel.readStrongBinder());
                parcel2.writeNoException();
                int n95 = bl ? 1 : 0;
                parcel2.writeInt(n95);
                return true;
            }
            case 225: {
                parcel.enforceInterface("android.app.IActivityManager");
                boolean bl = this.isTopOfTask(parcel.readStrongBinder());
                parcel2.writeNoException();
                int n96 = bl ? 1 : 0;
                parcel2.writeInt(n96);
                return true;
            }
            case 174: {
                parcel.enforceInterface("android.app.IActivityManager");
                boolean bl = this.convertFromTranslucent(parcel.readStrongBinder());
                parcel2.writeNoException();
                int n97 = bl ? 1 : 0;
                parcel2.writeInt(n97);
                return true;
            }
            case 175: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = parcel.readStrongBinder();
                Bundle bundle = parcel.readInt() == 0 ? null : parcel.readBundle();
                ActivityOptions activityOptions = bundle == null ? null : new ActivityOptions(bundle);
                boolean bl = this.convertToTranslucent(iBinder, activityOptions);
                parcel2.writeNoException();
                int n98 = bl ? 1 : 0;
                parcel2.writeInt(n98);
                return true;
            }
            case 220: {
                parcel.enforceInterface("android.app.IActivityManager");
                ActivityOptions activityOptions = this.getActivityOptions(parcel.readStrongBinder());
                parcel2.writeNoException();
                Bundle bundle = activityOptions == null ? null : activityOptions.toBundle();
                parcel2.writeBundle(bundle);
                return true;
            }
            case 112: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = parcel.readStrongBinder();
                boolean bl = parcel.readInt() == 1;
                this.setImmersive(iBinder, bl);
                parcel2.writeNoException();
                return true;
            }
            case 113: {
                parcel.enforceInterface("android.app.IActivityManager");
                boolean bl = this.isTopActivityImmersive();
                parcel2.writeNoException();
                int n99 = bl ? 1 : 0;
                parcel2.writeInt(n99);
                return true;
            }
            case 114: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.crashApplication(parcel.readInt(), parcel.readInt(), parcel.readString(), parcel.readString());
                parcel2.writeNoException();
                return true;
            }
            case 115: {
                parcel.enforceInterface("android.app.IActivityManager");
                String string38 = this.getProviderMimeType(Uri.CREATOR.createFromParcel(parcel), parcel.readInt());
                parcel2.writeNoException();
                parcel2.writeString(string38);
                return true;
            }
            case 116: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = this.newUriPermissionOwner(parcel.readString());
                parcel2.writeNoException();
                parcel2.writeStrongBinder(iBinder);
                return true;
            }
            case 117: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.grantUriPermissionFromOwner(parcel.readStrongBinder(), parcel.readInt(), parcel.readString(), Uri.CREATOR.createFromParcel(parcel), parcel.readInt(), parcel.readInt(), parcel.readInt());
                parcel2.writeNoException();
                return true;
            }
            case 118: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = parcel.readStrongBinder();
                int n100 = parcel.readInt();
                Uri uri = null;
                if (n100 != 0) {
                    uri = Uri.CREATOR.createFromParcel(parcel);
                }
                int n101 = parcel.readInt();
                int n102 = parcel.readInt();
                this.revokeUriPermissionFromOwner(iBinder, uri, n101, n102);
                parcel2.writeNoException();
                return true;
            }
            case 119: {
                parcel.enforceInterface("android.app.IActivityManager");
                int n103 = this.checkGrantUriPermission(parcel.readInt(), parcel.readString(), Uri.CREATOR.createFromParcel(parcel), parcel.readInt(), parcel.readInt());
                parcel2.writeNoException();
                parcel2.writeInt(n103);
                return true;
            }
            case 120: {
                parcel.enforceInterface("android.app.IActivityManager");
                String string39 = parcel.readString();
                int n104 = parcel.readInt();
                boolean bl = parcel.readInt() != 0;
                String string40 = parcel.readString();
                ParcelFileDescriptor parcelFileDescriptor = parcel.readInt() != 0 ? ParcelFileDescriptor.CREATOR.createFromParcel(parcel) : null;
                boolean bl10 = this.dumpHeap(string39, n104, bl, string40, parcelFileDescriptor);
                parcel2.writeNoException();
                int n105 = bl10 ? 1 : 0;
                parcel2.writeInt(n105);
                return true;
            }
            case 121: {
                parcel.enforceInterface("android.app.IActivityManager");
                IApplicationThread iApplicationThread = ApplicationThreadNative.asInterface(parcel.readStrongBinder());
                String string41 = parcel.readString();
                Intent[] intentArray = parcel.createTypedArray(Intent.CREATOR);
                String[] stringArray = parcel.createStringArray();
                IBinder iBinder = parcel.readStrongBinder();
                Bundle bundle = parcel.readInt() != 0 ? Bundle.CREATOR.createFromParcel(parcel) : null;
                int n106 = parcel.readInt();
                int n107 = this.startActivities(iApplicationThread, string41, intentArray, stringArray, iBinder, bundle, n106);
                parcel2.writeNoException();
                parcel2.writeInt(n107);
                return true;
            }
            case 124: {
                parcel.enforceInterface("android.app.IActivityManager");
                int n108 = this.getFrontActivityScreenCompatMode();
                parcel2.writeNoException();
                parcel2.writeInt(n108);
                return true;
            }
            case 125: {
                parcel.enforceInterface("android.app.IActivityManager");
                int n109 = parcel.readInt();
                this.setFrontActivityScreenCompatMode(n109);
                parcel2.writeNoException();
                parcel2.writeInt(n109);
                return true;
            }
            case 126: {
                parcel.enforceInterface("android.app.IActivityManager");
                int n110 = this.getPackageScreenCompatMode(parcel.readString());
                parcel2.writeNoException();
                parcel2.writeInt(n110);
                return true;
            }
            case 127: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.setPackageScreenCompatMode(parcel.readString(), parcel.readInt());
                parcel2.writeNoException();
                return true;
            }
            case 130: {
                parcel.enforceInterface("android.app.IActivityManager");
                boolean bl = this.switchUser(parcel.readInt());
                parcel2.writeNoException();
                int n111 = bl ? 1 : 0;
                parcel2.writeInt(n111);
                return true;
            }
            case 212: {
                parcel.enforceInterface("android.app.IActivityManager");
                boolean bl = this.startUserInBackground(parcel.readInt());
                parcel2.writeNoException();
                int n112 = bl ? 1 : 0;
                parcel2.writeInt(n112);
                return true;
            }
            case 154: {
                parcel.enforceInterface("android.app.IActivityManager");
                int n113 = this.stopUser(parcel.readInt(), IStopUserCallback.Stub.asInterface(parcel.readStrongBinder()));
                parcel2.writeNoException();
                parcel2.writeInt(n113);
                return true;
            }
            case 145: {
                parcel.enforceInterface("android.app.IActivityManager");
                UserInfo userInfo = this.getCurrentUser();
                parcel2.writeNoException();
                userInfo.writeToParcel(parcel2, 0);
                return true;
            }
            case 122: {
                parcel.enforceInterface("android.app.IActivityManager");
                int n114 = parcel.readInt();
                boolean bl = parcel.readInt() != 0;
                boolean bl11 = this.isUserRunning(n114, bl);
                parcel2.writeNoException();
                int n115 = bl11 ? 1 : 0;
                parcel2.writeInt(n115);
                return true;
            }
            case 157: {
                parcel.enforceInterface("android.app.IActivityManager");
                int[] nArray = this.getRunningUserIds();
                parcel2.writeNoException();
                parcel2.writeIntArray(nArray);
                return true;
            }
            case 132: {
                parcel.enforceInterface("android.app.IActivityManager");
                boolean bl = this.removeTask(parcel.readInt(), parcel.readInt());
                parcel2.writeNoException();
                int n116 = bl ? 1 : 0;
                parcel2.writeInt(n116);
                return true;
            }
            case 133: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.registerProcessObserver(IProcessObserver.Stub.asInterface(parcel.readStrongBinder()));
                return true;
            }
            case 134: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.unregisterProcessObserver(IProcessObserver.Stub.asInterface(parcel.readStrongBinder()));
                return true;
            }
            case 128: {
                parcel.enforceInterface("android.app.IActivityManager");
                boolean bl = this.getPackageAskScreenCompat(parcel.readString());
                parcel2.writeNoException();
                int n117 = bl ? 1 : 0;
                parcel2.writeInt(n117);
                return true;
            }
            case 129: {
                parcel.enforceInterface("android.app.IActivityManager");
                String string42 = parcel.readString();
                boolean bl = parcel.readInt() != 0;
                this.setPackageAskScreenCompat(string42, bl);
                parcel2.writeNoException();
                return true;
            }
            case 135: {
                parcel.enforceInterface("android.app.IActivityManager");
                boolean bl = this.isIntentSenderTargetedToPackage(IIntentSender.Stub.asInterface(parcel.readStrongBinder()));
                parcel2.writeNoException();
                int n118 = bl ? 1 : 0;
                parcel2.writeInt(n118);
                return true;
            }
            case 152: {
                parcel.enforceInterface("android.app.IActivityManager");
                boolean bl = this.isIntentSenderAnActivity(IIntentSender.Stub.asInterface(parcel.readStrongBinder()));
                parcel2.writeNoException();
                int n119 = bl ? 1 : 0;
                parcel2.writeInt(n119);
                return true;
            }
            case 161: {
                parcel.enforceInterface("android.app.IActivityManager");
                Intent intent = this.getIntentForIntentSender(IIntentSender.Stub.asInterface(parcel.readStrongBinder()));
                parcel2.writeNoException();
                if (intent != null) {
                    parcel2.writeInt(1);
                    intent.writeToParcel(parcel2, 1);
                    return true;
                }
                parcel2.writeInt(0);
                return true;
            }
            case 211: {
                parcel.enforceInterface("android.app.IActivityManager");
                String string43 = this.getTagForIntentSender(IIntentSender.Stub.asInterface(parcel.readStrongBinder()), parcel.readString());
                parcel2.writeNoException();
                parcel2.writeString(string43);
                return true;
            }
            case 136: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.updatePersistentConfiguration(Configuration.CREATOR.createFromParcel(parcel));
                parcel2.writeNoException();
                return true;
            }
            case 137: {
                parcel.enforceInterface("android.app.IActivityManager");
                long[] lArray = this.getProcessPss(parcel.createIntArray());
                parcel2.writeNoException();
                parcel2.writeLongArray(lArray);
                return true;
            }
            case 138: {
                parcel.enforceInterface("android.app.IActivityManager");
                CharSequence charSequence = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
                boolean bl = parcel.readInt() != 0;
                this.showBootMessage(charSequence, bl);
                parcel2.writeNoException();
                return true;
            }
            case 232: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.keyguardWaitingForActivityDrawn();
                parcel2.writeNoException();
                return true;
            }
            case 146: {
                parcel.enforceInterface("android.app.IActivityManager");
                boolean bl = this.shouldUpRecreateTask(parcel.readStrongBinder(), parcel.readString());
                parcel2.writeNoException();
                int n120 = bl ? 1 : 0;
                parcel2.writeInt(n120);
                return true;
            }
            case 147: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = parcel.readStrongBinder();
                Intent intent = Intent.CREATOR.createFromParcel(parcel);
                int n121 = parcel.readInt();
                int n122 = parcel.readInt();
                Intent intent2 = null;
                if (n122 != 0) {
                    intent2 = Intent.CREATOR.createFromParcel(parcel);
                }
                boolean bl = this.navigateUpTo(iBinder, intent, n121, intent2);
                parcel2.writeNoException();
                int n123 = bl ? 1 : 0;
                parcel2.writeInt(n123);
                return true;
            }
            case 150: {
                parcel.enforceInterface("android.app.IActivityManager");
                int n124 = this.getLaunchedFromUid(parcel.readStrongBinder());
                parcel2.writeNoException();
                parcel2.writeInt(n124);
                return true;
            }
            case 164: {
                parcel.enforceInterface("android.app.IActivityManager");
                String string44 = this.getLaunchedFromPackage(parcel.readStrongBinder());
                parcel2.writeNoException();
                parcel2.writeString(string44);
                return true;
            }
            case 155: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.registerUserSwitchObserver(IUserSwitchObserver.Stub.asInterface(parcel.readStrongBinder()));
                parcel2.writeNoException();
                return true;
            }
            case 156: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.unregisterUserSwitchObserver(IUserSwitchObserver.Stub.asInterface(parcel.readStrongBinder()));
                parcel2.writeNoException();
                return true;
            }
            case 158: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.requestBugReport();
                parcel2.writeNoException();
                return true;
            }
            case 159: {
                parcel.enforceInterface("android.app.IActivityManager");
                int n125 = parcel.readInt();
                boolean bl = parcel.readInt() != 0;
                String string45 = parcel.readString();
                long l = this.inputDispatchingTimedOut(n125, bl, string45);
                parcel2.writeNoException();
                parcel2.writeLong(l);
                return true;
            }
            case 162: {
                parcel.enforceInterface("android.app.IActivityManager");
                Bundle bundle = this.getAssistContextExtras(parcel.readInt());
                parcel2.writeNoException();
                parcel2.writeBundle(bundle);
                return true;
            }
            case 163: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.reportAssistContextExtras(parcel.readStrongBinder(), parcel.readBundle());
                parcel2.writeNoException();
                return true;
            }
            case 240: {
                parcel.enforceInterface("android.app.IActivityManager");
                boolean bl = this.launchAssistIntent(Intent.CREATOR.createFromParcel(parcel), parcel.readInt(), parcel.readString(), parcel.readInt());
                parcel2.writeNoException();
                int n126 = bl ? 1 : 0;
                parcel2.writeInt(n126);
                return true;
            }
            case 165: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.killUid(parcel.readInt(), parcel.readString());
                parcel2.writeNoException();
                return true;
            }
            case 167: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = parcel.readStrongBinder();
                boolean bl = parcel.readInt() != 0;
                this.hang(iBinder, bl);
                parcel2.writeNoException();
                return true;
            }
            case 177: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.reportActivityFullyDrawn(parcel.readStrongBinder());
                parcel2.writeNoException();
                return true;
            }
            case 176: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.notifyActivityDrawn(parcel.readStrongBinder());
                parcel2.writeNoException();
                return true;
            }
            case 178: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.restart();
                parcel2.writeNoException();
                return true;
            }
            case 179: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.performIdleMaintenance();
                parcel2.writeNoException();
                return true;
            }
            case 168: {
                parcel.enforceInterface("android.app.IActivityManager");
                IActivityContainer iActivityContainer = this.createActivityContainer(parcel.readStrongBinder(), IActivityContainerCallback.Stub.asInterface(parcel.readStrongBinder()));
                parcel2.writeNoException();
                if (iActivityContainer != null) {
                    parcel2.writeInt(1);
                    parcel2.writeStrongBinder(iActivityContainer.asBinder());
                    return true;
                }
                parcel2.writeInt(0);
                return true;
            }
            case 186: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.deleteActivityContainer(IActivityContainer.Stub.asInterface(parcel.readStrongBinder()));
                parcel2.writeNoException();
                return true;
            }
            case 185: {
                parcel.enforceInterface("android.app.IActivityManager");
                int n127 = this.getActivityDisplayId(parcel.readStrongBinder());
                parcel2.writeNoException();
                parcel2.writeInt(n127);
                return true;
            }
            case 184: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = this.getHomeActivityToken();
                parcel2.writeNoException();
                parcel2.writeStrongBinder(iBinder);
                return true;
            }
            case 214: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.startLockTaskMode(parcel.readInt());
                parcel2.writeNoException();
                return true;
            }
            case 215: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.startLockTaskMode(parcel.readStrongBinder());
                parcel2.writeNoException();
                return true;
            }
            case 222: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.startLockTaskModeOnCurrent();
                parcel2.writeNoException();
                return true;
            }
            case 216: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.stopLockTaskMode();
                parcel2.writeNoException();
                return true;
            }
            case 223: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.stopLockTaskModeOnCurrent();
                parcel2.writeNoException();
                return true;
            }
            case 217: {
                parcel.enforceInterface("android.app.IActivityManager");
                boolean bl = this.isInLockTaskMode();
                parcel2.writeNoException();
                int n128 = bl ? 1 : 0;
                parcel2.writeInt(n128);
                return true;
            }
            case 218: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.setTaskDescription(parcel.readStrongBinder(), ActivityManager.TaskDescription.CREATOR.createFromParcel(parcel));
                parcel2.writeNoException();
                return true;
            }
            case 239: {
                parcel.enforceInterface("android.app.IActivityManager");
                Bitmap bitmap = this.getTaskDescriptionIcon(parcel.readString());
                parcel2.writeNoException();
                if (bitmap == null) {
                    parcel2.writeInt(0);
                    return true;
                }
                parcel2.writeInt(1);
                bitmap.writeToParcel(parcel2, 0);
                return true;
            }
            case 226: {
                parcel.enforceInterface("android.app.IActivityManager");
                IBinder iBinder = parcel.readStrongBinder();
                boolean bl = parcel.readInt() > 0;
                boolean bl12 = this.requestVisibleBehind(iBinder, bl);
                parcel2.writeNoException();
                int n129 = bl12 ? 1 : 0;
                parcel2.writeInt(n129);
                return true;
            }
            case 227: {
                parcel.enforceInterface("android.app.IActivityManager");
                boolean bl = this.isBackgroundVisibleBehind(parcel.readStrongBinder());
                parcel2.writeNoException();
                int n130 = bl ? 1 : 0;
                parcel2.writeInt(n130);
                return true;
            }
            case 228: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.backgroundResourcesReleased(parcel.readStrongBinder());
                parcel2.writeNoException();
                return true;
            }
            case 229: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.notifyLaunchTaskBehindComplete(parcel.readStrongBinder());
                parcel2.writeNoException();
                return true;
            }
            case 231: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.notifyEnterAnimationComplete(parcel.readStrongBinder());
                parcel2.writeNoException();
                return true;
            }
            case 238: {
                parcel.enforceInterface("android.app.IActivityManager");
                this.bootAnimationComplete();
                parcel2.writeNoException();
                return true;
            }
            case 4202: 
        }
        parcel.enforceInterface("android.app.IActivityManager");
        String string46 = this.getFocusAppPackageName();
        parcel2.writeNoException();
        parcel2.writeString(string46);
        return true;
    }
}

