/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.BidirectionalTypeConverter;
import android.animation.FloatArrayEvaluator;
import android.animation.FloatEvaluator;
import android.animation.IntArrayEvaluator;
import android.animation.IntEvaluator;
import android.animation.Keyframe;
import android.animation.KeyframeSet;
import android.animation.Keyframes;
import android.animation.PathKeyframes;
import android.animation.TypeConverter;
import android.animation.TypeEvaluator;
import android.graphics.Path;
import android.graphics.PointF;
import android.util.FloatProperty;
import android.util.IntProperty;
import android.util.Log;
import android.util.Property;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class PropertyValuesHolder
implements Cloneable {
    private static Class[] DOUBLE_VARIANTS;
    private static Class[] FLOAT_VARIANTS;
    private static Class[] INTEGER_VARIANTS;
    private static final TypeEvaluator sFloatEvaluator;
    private static final HashMap<Class, HashMap<String, Method>> sGetterPropertyMap;
    private static final TypeEvaluator sIntEvaluator;
    private static final HashMap<Class, HashMap<String, Method>> sSetterPropertyMap;
    private Object mAnimatedValue;
    private TypeConverter mConverter;
    private TypeEvaluator mEvaluator;
    private Method mGetter = null;
    Keyframes mKeyframes = null;
    protected Property mProperty;
    final ReentrantReadWriteLock mPropertyMapLock = new ReentrantReadWriteLock();
    String mPropertyName;
    Method mSetter = null;
    final Object[] mTmpValueArray = new Object[1];
    Class mValueType;

    static {
        sIntEvaluator = new IntEvaluator();
        sFloatEvaluator = new FloatEvaluator();
        Class[] classArray = new Class[]{Float.TYPE, Float.class, Double.TYPE, Integer.TYPE, Double.class, Integer.class};
        FLOAT_VARIANTS = classArray;
        Class[] classArray2 = new Class[]{Integer.TYPE, Integer.class, Float.TYPE, Double.TYPE, Float.class, Double.class};
        INTEGER_VARIANTS = classArray2;
        Class[] classArray3 = new Class[]{Double.TYPE, Double.class, Float.TYPE, Integer.TYPE, Float.class, Integer.class};
        DOUBLE_VARIANTS = classArray3;
        sSetterPropertyMap = new HashMap();
        sGetterPropertyMap = new HashMap();
    }

    private PropertyValuesHolder(Property property) {
        this.mProperty = property;
        if (property != null) {
            this.mPropertyName = property.getName();
        }
    }

    private PropertyValuesHolder(String string2) {
        this.mPropertyName = string2;
    }

    static /* synthetic */ long access$1300(Class clazz, String string2, int n) {
        return PropertyValuesHolder.nGetMultipleIntMethod(clazz, string2, n);
    }

    static /* synthetic */ long access$900(Class clazz, String string2, int n) {
        return PropertyValuesHolder.nGetMultipleFloatMethod(clazz, string2, n);
    }

    private Object convertBack(Object object) {
        if (this.mConverter != null) {
            if (!(this.mConverter instanceof BidirectionalTypeConverter)) {
                throw new IllegalArgumentException("Converter " + this.mConverter.getClass().getName() + " must be a BidirectionalTypeConverter");
            }
            object = ((BidirectionalTypeConverter)this.mConverter).convertBack(object);
        }
        return object;
    }

    static String getMethodName(String string2, String string3) {
        if (string3 == null || string3.length() == 0) {
            return string2;
        }
        char c = Character.toUpperCase(string3.charAt(0));
        String string4 = string3.substring(1);
        return string2 + c + string4;
    }

    /*
     * Unable to fully structure code
     */
    private Method getPropertyFunction(Class var1_1, String var2_2, Class var3_3) {
        block12: {
            block11: {
                block10: {
                    var4_4 = null;
                    var5_5 = PropertyValuesHolder.getMethodName(var2_2, this.mPropertyName);
                    if (var3_3 == null) {
                        var4_4 = var15_6 = var1_1.getMethod(var5_5, null);
lbl6:
                        // 3 sources

                        while (true) {
                            if (var4_4 == null) {
                                Log.w("PropertyValuesHolder", "Method " + PropertyValuesHolder.getMethodName(var2_2, this.mPropertyName) + "() with type " + var3_3 + " not found on target class " + var1_1);
                            }
                            return var4_4;
                        }
                    }
                    var6_7 = new Class[1];
                    if (!var3_3.equals(Float.class)) break block10;
                    var7_8 = PropertyValuesHolder.FLOAT_VARIANTS;
lbl14:
                    // 4 sources

                    while (true) {
                        var8_9 = var7_8;
                        var9_10 = var8_9.length;
                        var10_11 = 0;
lbl18:
                        // 2 sources

                        while (true) {
                            if (var10_11 >= var9_10) ** GOTO lbl6
                            var6_7[0] = var11_12 = var8_9[var10_11];
                            var4_4 = var1_1.getMethod(var5_5, var6_7);
                            if (this.mConverter == null) {
                                this.mValueType = var11_12;
                            }
                            return var4_4;
                            break;
                        }
                        break;
                    }
                }
                if (!var3_3.equals(Integer.class)) break block11;
                var7_8 = PropertyValuesHolder.INTEGER_VARIANTS;
                ** GOTO lbl14
            }
            if (!var3_3.equals(Double.class)) break block12;
            var7_8 = PropertyValuesHolder.DOUBLE_VARIANTS;
            ** GOTO lbl14
        }
        var7_8 = new Class[]{var3_3};
        ** while (true)
        catch (NoSuchMethodException var12_13) {
            ++var10_11;
            ** continue;
        }
        catch (NoSuchMethodException var14_14) {
            var4_4 = null;
            ** continue;
        }
    }

    private static native void nCallFloatMethod(Object var0, long var1, float var3);

    private static native void nCallFourFloatMethod(Object var0, long var1, float var3, float var4, float var5, float var6);

    private static native void nCallFourIntMethod(Object var0, long var1, int var3, int var4, int var5, int var6);

    private static native void nCallIntMethod(Object var0, long var1, int var3);

    private static native void nCallMultipleFloatMethod(Object var0, long var1, float[] var3);

    private static native void nCallMultipleIntMethod(Object var0, long var1, int[] var3);

    private static native void nCallTwoFloatMethod(Object var0, long var1, float var3, float var4);

    private static native void nCallTwoIntMethod(Object var0, long var1, int var3, int var4);

    private static native long nGetFloatMethod(Class var0, String var1);

    private static native long nGetIntMethod(Class var0, String var1);

    private static native long nGetMultipleFloatMethod(Class var0, String var1, int var2);

    private static native long nGetMultipleIntMethod(Class var0, String var1, int var2);

    public static PropertyValuesHolder ofFloat(Property<?, Float> property, float ... fArray) {
        return new FloatPropertyValuesHolder(property, fArray);
    }

    public static PropertyValuesHolder ofFloat(String string2, float ... fArray) {
        return new FloatPropertyValuesHolder(string2, fArray);
    }

    public static PropertyValuesHolder ofInt(Property<?, Integer> property, int ... nArray) {
        return new IntPropertyValuesHolder(property, nArray);
    }

    public static PropertyValuesHolder ofInt(String string2, int ... nArray) {
        return new IntPropertyValuesHolder(string2, nArray);
    }

    public static PropertyValuesHolder ofKeyframe(Property property, Keyframe ... keyframeArray) {
        return PropertyValuesHolder.ofKeyframes(property, (Keyframes)KeyframeSet.ofKeyframe(keyframeArray));
    }

    public static PropertyValuesHolder ofKeyframe(String string2, Keyframe ... keyframeArray) {
        return PropertyValuesHolder.ofKeyframes(string2, (Keyframes)KeyframeSet.ofKeyframe(keyframeArray));
    }

    static PropertyValuesHolder ofKeyframes(Property property, Keyframes keyframes) {
        if (keyframes instanceof Keyframes.IntKeyframes) {
            return new IntPropertyValuesHolder(property, (Keyframes.IntKeyframes)keyframes);
        }
        if (keyframes instanceof Keyframes.FloatKeyframes) {
            return new FloatPropertyValuesHolder(property, (Keyframes.FloatKeyframes)keyframes);
        }
        PropertyValuesHolder propertyValuesHolder = new PropertyValuesHolder(property);
        propertyValuesHolder.mKeyframes = keyframes;
        propertyValuesHolder.mValueType = keyframes.getType();
        return propertyValuesHolder;
    }

    static PropertyValuesHolder ofKeyframes(String string2, Keyframes keyframes) {
        if (keyframes instanceof Keyframes.IntKeyframes) {
            return new IntPropertyValuesHolder(string2, (Keyframes.IntKeyframes)keyframes);
        }
        if (keyframes instanceof Keyframes.FloatKeyframes) {
            return new FloatPropertyValuesHolder(string2, (Keyframes.FloatKeyframes)keyframes);
        }
        PropertyValuesHolder propertyValuesHolder = new PropertyValuesHolder(string2);
        propertyValuesHolder.mKeyframes = keyframes;
        propertyValuesHolder.mValueType = keyframes.getType();
        return propertyValuesHolder;
    }

    public static <T> PropertyValuesHolder ofMultiFloat(String string2, TypeConverter<T, float[]> typeConverter, TypeEvaluator<T> typeEvaluator, Keyframe ... keyframeArray) {
        return new MultiFloatValuesHolder(string2, typeConverter, typeEvaluator, KeyframeSet.ofKeyframe(keyframeArray));
    }

    public static <V> PropertyValuesHolder ofMultiFloat(String string2, TypeConverter<V, float[]> typeConverter, TypeEvaluator<V> typeEvaluator, V ... VArray) {
        return new MultiFloatValuesHolder(string2, typeConverter, typeEvaluator, VArray);
    }

    public static PropertyValuesHolder ofMultiFloat(String string2, Path path) {
        PathKeyframes pathKeyframes = KeyframeSet.ofPath(path);
        return new MultiFloatValuesHolder(string2, (TypeConverter)new PointFToFloatArray(), null, pathKeyframes);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static PropertyValuesHolder ofMultiFloat(String string2, float[][] fArray) {
        if (fArray.length < 2) {
            throw new IllegalArgumentException("At least 2 values must be supplied");
        }
        int n = 0;
        int n2 = 0;
        while (n2 < fArray.length) {
            if (fArray[n2] == null) {
                throw new IllegalArgumentException("values must not be null");
            }
            int n3 = fArray[n2].length;
            if (n2 == 0) {
                n = n3;
            } else if (n3 != n) {
                throw new IllegalArgumentException("Values must all have the same length");
            }
            ++n2;
        }
        return new MultiFloatValuesHolder(string2, null, (TypeEvaluator)new FloatArrayEvaluator(new float[n]), (Object[])fArray);
    }

    public static <T> PropertyValuesHolder ofMultiInt(String string2, TypeConverter<T, int[]> typeConverter, TypeEvaluator<T> typeEvaluator, Keyframe ... keyframeArray) {
        return new MultiIntValuesHolder(string2, typeConverter, typeEvaluator, KeyframeSet.ofKeyframe(keyframeArray));
    }

    public static <V> PropertyValuesHolder ofMultiInt(String string2, TypeConverter<V, int[]> typeConverter, TypeEvaluator<V> typeEvaluator, V ... VArray) {
        return new MultiIntValuesHolder(string2, typeConverter, typeEvaluator, VArray);
    }

    public static PropertyValuesHolder ofMultiInt(String string2, Path path) {
        PathKeyframes pathKeyframes = KeyframeSet.ofPath(path);
        return new MultiIntValuesHolder(string2, (TypeConverter)new PointFToIntArray(), null, pathKeyframes);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static PropertyValuesHolder ofMultiInt(String string2, int[][] nArray) {
        if (nArray.length < 2) {
            throw new IllegalArgumentException("At least 2 values must be supplied");
        }
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == null) {
                throw new IllegalArgumentException("values must not be null");
            }
            int n3 = nArray[n2].length;
            if (n2 == 0) {
                n = n3;
            } else if (n3 != n) {
                throw new IllegalArgumentException("Values must all have the same length");
            }
            ++n2;
        }
        return new MultiIntValuesHolder(string2, null, (TypeEvaluator)new IntArrayEvaluator(new int[n]), (Object[])nArray);
    }

    public static <T, V> PropertyValuesHolder ofObject(Property<?, V> property, TypeConverter<T, V> typeConverter, TypeEvaluator<T> typeEvaluator, T ... TArray) {
        PropertyValuesHolder propertyValuesHolder = new PropertyValuesHolder(property);
        propertyValuesHolder.setConverter(typeConverter);
        propertyValuesHolder.setObjectValues(TArray);
        propertyValuesHolder.setEvaluator(typeEvaluator);
        return propertyValuesHolder;
    }

    public static <V> PropertyValuesHolder ofObject(Property<?, V> property, TypeConverter<PointF, V> typeConverter, Path path) {
        PropertyValuesHolder propertyValuesHolder = new PropertyValuesHolder(property);
        propertyValuesHolder.mKeyframes = KeyframeSet.ofPath(path);
        propertyValuesHolder.mValueType = PointF.class;
        propertyValuesHolder.setConverter(typeConverter);
        return propertyValuesHolder;
    }

    public static <V> PropertyValuesHolder ofObject(Property property, TypeEvaluator<V> typeEvaluator, V ... VArray) {
        PropertyValuesHolder propertyValuesHolder = new PropertyValuesHolder(property);
        propertyValuesHolder.setObjectValues(VArray);
        propertyValuesHolder.setEvaluator(typeEvaluator);
        return propertyValuesHolder;
    }

    public static PropertyValuesHolder ofObject(String string2, TypeConverter<PointF, ?> typeConverter, Path path) {
        PropertyValuesHolder propertyValuesHolder = new PropertyValuesHolder(string2);
        propertyValuesHolder.mKeyframes = KeyframeSet.ofPath(path);
        propertyValuesHolder.mValueType = PointF.class;
        propertyValuesHolder.setConverter(typeConverter);
        return propertyValuesHolder;
    }

    public static PropertyValuesHolder ofObject(String string2, TypeEvaluator typeEvaluator, Object ... objectArray) {
        PropertyValuesHolder propertyValuesHolder = new PropertyValuesHolder(string2);
        propertyValuesHolder.setObjectValues(objectArray);
        propertyValuesHolder.setEvaluator(typeEvaluator);
        return propertyValuesHolder;
    }

    private void setupGetter(Class clazz) {
        this.mGetter = this.setupSetterOrGetter(clazz, sGetterPropertyMap, "get", null);
    }

    private Method setupSetterOrGetter(Class clazz, HashMap<Class, HashMap<String, Method>> hashMap, String string2, Class clazz2) {
        Method method;
        HashMap<String, Method> hashMap2;
        block8: {
            this.mPropertyMapLock.writeLock().lock();
            hashMap2 = hashMap.get(clazz);
            method = null;
            if (hashMap2 == null) break block8;
            method = hashMap2.get(this.mPropertyName);
        }
        if (method == null) {
            method = this.getPropertyFunction(clazz, string2, clazz2);
            if (hashMap2 == null) {
                hashMap2 = new HashMap();
                hashMap.put(clazz, hashMap2);
            }
            hashMap2.put(this.mPropertyName, method);
        }
        return method;
        finally {
            this.mPropertyMapLock.writeLock().unlock();
        }
    }

    private void setupValue(Object object, Keyframe keyframe) {
        if (this.mProperty != null) {
            keyframe.setValue(this.convertBack(this.mProperty.get(object)));
        }
        try {
            if (this.mGetter == null) {
                this.setupGetter(object.getClass());
                if (this.mGetter == null) {
                    return;
                }
            }
            keyframe.setValue(this.convertBack(this.mGetter.invoke(object, new Object[0])));
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            Log.e("PropertyValuesHolder", invocationTargetException.toString());
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.e("PropertyValuesHolder", illegalAccessException.toString());
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void calculateValue(float f) {
        Object object = this.mKeyframes.getValue(f);
        if (this.mConverter != null) {
            object = this.mConverter.convert(object);
        }
        this.mAnimatedValue = object;
    }

    public PropertyValuesHolder clone() {
        try {
            PropertyValuesHolder propertyValuesHolder = (PropertyValuesHolder)super.clone();
            propertyValuesHolder.mPropertyName = this.mPropertyName;
            propertyValuesHolder.mProperty = this.mProperty;
            propertyValuesHolder.mKeyframes = this.mKeyframes.clone();
            propertyValuesHolder.mEvaluator = this.mEvaluator;
            return propertyValuesHolder;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    Object getAnimatedValue() {
        return this.mAnimatedValue;
    }

    public String getPropertyName() {
        return this.mPropertyName;
    }

    /*
     * Enabled aggressive block sorting
     */
    void init() {
        if (this.mEvaluator == null) {
            TypeEvaluator typeEvaluator = this.mValueType == Integer.class ? sIntEvaluator : (this.mValueType == Float.class ? sFloatEvaluator : null);
            this.mEvaluator = typeEvaluator;
        }
        if (this.mEvaluator != null) {
            this.mKeyframes.setEvaluator(this.mEvaluator);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setAnimatedValue(Object object) {
        if (this.mProperty != null) {
            this.mProperty.set(object, this.getAnimatedValue());
        }
        if (this.mSetter == null) return;
        try {
            this.mTmpValueArray[0] = this.getAnimatedValue();
            this.mSetter.invoke(object, this.mTmpValueArray);
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            Log.e("PropertyValuesHolder", invocationTargetException.toString());
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.e("PropertyValuesHolder", illegalAccessException.toString());
            return;
        }
    }

    public void setConverter(TypeConverter typeConverter) {
        this.mConverter = typeConverter;
    }

    public void setEvaluator(TypeEvaluator typeEvaluator) {
        this.mEvaluator = typeEvaluator;
        this.mKeyframes.setEvaluator(typeEvaluator);
    }

    public void setFloatValues(float ... fArray) {
        this.mValueType = Float.TYPE;
        this.mKeyframes = KeyframeSet.ofFloat(fArray);
    }

    public void setIntValues(int ... nArray) {
        this.mValueType = Integer.TYPE;
        this.mKeyframes = KeyframeSet.ofInt(nArray);
    }

    public void setKeyframes(Keyframe ... keyframeArray) {
        int n = keyframeArray.length;
        Keyframe[] keyframeArray2 = new Keyframe[Math.max(n, 2)];
        this.mValueType = keyframeArray[0].getType();
        for (int i = 0; i < n; ++i) {
            keyframeArray2[i] = keyframeArray[i];
        }
        this.mKeyframes = new KeyframeSet(keyframeArray2);
    }

    public void setObjectValues(Object ... objectArray) {
        this.mValueType = objectArray[0].getClass();
        this.mKeyframes = KeyframeSet.ofObject(objectArray);
        if (this.mEvaluator != null) {
            this.mKeyframes.setEvaluator(this.mEvaluator);
        }
    }

    public void setProperty(Property property) {
        this.mProperty = property;
    }

    public void setPropertyName(String string2) {
        this.mPropertyName = string2;
    }

    void setupEndValue(Object object) {
        ArrayList<Keyframe> arrayList = this.mKeyframes.getKeyframes();
        if (!arrayList.isEmpty()) {
            this.setupValue(object, arrayList.get(-1 + arrayList.size()));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void setupSetter(Class clazz) {
        Class clazz2 = this.mConverter == null ? this.mValueType : this.mConverter.getTargetType();
        this.mSetter = this.setupSetterOrGetter(clazz, sSetterPropertyMap, "set", clazz2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setupSetterAndGetter(Object object) {
        ArrayList<Keyframe> arrayList;
        Class<?> clazz;
        block16: {
            int n;
            ArrayList<Keyframe> arrayList2;
            block15: {
                this.mKeyframes.invalidateCache();
                if (this.mProperty != null) {
                    try {
                        int n2;
                        arrayList2 = this.mKeyframes.getKeyframes();
                        if (arrayList2 == null) {
                            return;
                        }
                        n = n2 = arrayList2.size();
                        break block15;
                    }
                    catch (ClassCastException classCastException) {
                        Log.w("PropertyValuesHolder", "No such property (" + this.mProperty.getName() + ") on target object " + object + ". Trying reflection instead");
                        this.mProperty = null;
                    }
                }
                clazz = object.getClass();
                if (this.mSetter == null) {
                    this.setupSetter(clazz);
                }
                if ((arrayList = this.mKeyframes.getKeyframes()) == null) {
                    return;
                }
                break block16;
            }
            int n3 = 0;
            Object object2 = null;
            while (n3 < n) {
                Keyframe keyframe = arrayList2.get(n3);
                if (!keyframe.hasValue() || keyframe.valueWasSetOnStart()) {
                    if (object2 == null) {
                        object2 = this.convertBack(this.mProperty.get(object));
                    }
                    keyframe.setValue(object2);
                    keyframe.setValueWasSetOnStart(true);
                }
                ++n3;
            }
            return;
        }
        int n = arrayList.size();
        int n4 = 0;
        while (n4 < n) {
            Keyframe keyframe = arrayList.get(n4);
            if (!keyframe.hasValue() || keyframe.valueWasSetOnStart()) {
                if (this.mGetter == null) {
                    this.setupGetter(clazz);
                    if (this.mGetter == null) return;
                }
                try {
                    keyframe.setValue(this.convertBack(this.mGetter.invoke(object, new Object[0])));
                    keyframe.setValueWasSetOnStart(true);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Log.e("PropertyValuesHolder", invocationTargetException.toString());
                }
                catch (IllegalAccessException illegalAccessException) {
                    Log.e("PropertyValuesHolder", illegalAccessException.toString());
                }
            }
            ++n4;
        }
    }

    void setupStartValue(Object object) {
        ArrayList<Keyframe> arrayList = this.mKeyframes.getKeyframes();
        if (!arrayList.isEmpty()) {
            this.setupValue(object, arrayList.get(0));
        }
    }

    public String toString() {
        return this.mPropertyName + ": " + this.mKeyframes.toString();
    }

    static class FloatPropertyValuesHolder
    extends PropertyValuesHolder {
        private static final HashMap<Class, HashMap<String, Long>> sJNISetterPropertyMap = new HashMap();
        float mFloatAnimatedValue;
        Keyframes.FloatKeyframes mFloatKeyframes;
        private FloatProperty mFloatProperty;
        long mJniSetter;

        public FloatPropertyValuesHolder(Property property, Keyframes.FloatKeyframes floatKeyframes) {
            super(property);
            this.mValueType = Float.TYPE;
            this.mKeyframes = floatKeyframes;
            this.mFloatKeyframes = floatKeyframes;
            if (property instanceof FloatProperty) {
                this.mFloatProperty = (FloatProperty)this.mProperty;
            }
        }

        public FloatPropertyValuesHolder(Property property, float ... fArray) {
            super(property);
            this.setFloatValues(fArray);
            if (property instanceof FloatProperty) {
                this.mFloatProperty = (FloatProperty)this.mProperty;
            }
        }

        public FloatPropertyValuesHolder(String string2, Keyframes.FloatKeyframes floatKeyframes) {
            super(string2);
            this.mValueType = Float.TYPE;
            this.mKeyframes = floatKeyframes;
            this.mFloatKeyframes = floatKeyframes;
        }

        public FloatPropertyValuesHolder(String string2, float ... fArray) {
            super(string2);
            this.setFloatValues(fArray);
        }

        @Override
        void calculateValue(float f) {
            this.mFloatAnimatedValue = this.mFloatKeyframes.getFloatValue(f);
        }

        @Override
        public FloatPropertyValuesHolder clone() {
            FloatPropertyValuesHolder floatPropertyValuesHolder = (FloatPropertyValuesHolder)super.clone();
            floatPropertyValuesHolder.mFloatKeyframes = (Keyframes.FloatKeyframes)floatPropertyValuesHolder.mKeyframes;
            return floatPropertyValuesHolder;
        }

        @Override
        Object getAnimatedValue() {
            return Float.valueOf(this.mFloatAnimatedValue);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        void setAnimatedValue(Object object) {
            if (this.mFloatProperty != null) {
                this.mFloatProperty.setValue(object, this.mFloatAnimatedValue);
                return;
            } else {
                if (this.mProperty != null) {
                    this.mProperty.set(object, Float.valueOf(this.mFloatAnimatedValue));
                    return;
                }
                if (this.mJniSetter != 0L) {
                    PropertyValuesHolder.nCallFloatMethod(object, this.mJniSetter, this.mFloatAnimatedValue);
                    return;
                }
                if (this.mSetter == null) return;
                try {
                    this.mTmpValueArray[0] = Float.valueOf(this.mFloatAnimatedValue);
                    this.mSetter.invoke(object, this.mTmpValueArray);
                    return;
                }
                catch (InvocationTargetException invocationTargetException) {
                    Log.e("PropertyValuesHolder", invocationTargetException.toString());
                    return;
                }
                catch (IllegalAccessException illegalAccessException) {
                    Log.e("PropertyValuesHolder", illegalAccessException.toString());
                    return;
                }
            }
        }

        @Override
        public void setFloatValues(float ... fArray) {
            super.setFloatValues(fArray);
            this.mFloatKeyframes = (Keyframes.FloatKeyframes)this.mKeyframes;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        void setupSetter(Class clazz) {
            block13: {
                block12: {
                    block11: {
                        if (this.mProperty != null) break block12;
                        try {
                            Long l;
                            this.mPropertyMapLock.writeLock().lock();
                            HashMap<String, Long> hashMap = sJNISetterPropertyMap.get(clazz);
                            if (hashMap != null && (l = hashMap.get(this.mPropertyName)) != null) {
                                this.mJniSetter = l;
                            }
                            if (this.mJniSetter != 0L) break block11;
                            this.mJniSetter = PropertyValuesHolder.nGetFloatMethod(clazz, FloatPropertyValuesHolder.getMethodName("set", this.mPropertyName));
                            if (this.mJniSetter != 0L) {
                                void var4_4;
                                if (hashMap == null) {
                                    HashMap hashMap2 = new HashMap();
                                    sJNISetterPropertyMap.put(clazz, hashMap2);
                                }
                                var4_4.put(this.mPropertyName, this.mJniSetter);
                            }
                            break block11;
                        }
                        catch (NoSuchMethodError noSuchMethodError) {}
                        break block11;
                        finally {
                            this.mPropertyMapLock.writeLock().unlock();
                        }
                    }
                    if (this.mJniSetter == 0L) break block13;
                }
                return;
            }
            super.setupSetter(clazz);
        }
    }

    static class IntPropertyValuesHolder
    extends PropertyValuesHolder {
        private static final HashMap<Class, HashMap<String, Long>> sJNISetterPropertyMap = new HashMap();
        int mIntAnimatedValue;
        Keyframes.IntKeyframes mIntKeyframes;
        private IntProperty mIntProperty;
        long mJniSetter;

        public IntPropertyValuesHolder(Property property, Keyframes.IntKeyframes intKeyframes) {
            super(property);
            this.mValueType = Integer.TYPE;
            this.mKeyframes = intKeyframes;
            this.mIntKeyframes = intKeyframes;
            if (property instanceof IntProperty) {
                this.mIntProperty = (IntProperty)this.mProperty;
            }
        }

        public IntPropertyValuesHolder(Property property, int ... nArray) {
            super(property);
            this.setIntValues(nArray);
            if (property instanceof IntProperty) {
                this.mIntProperty = (IntProperty)this.mProperty;
            }
        }

        public IntPropertyValuesHolder(String string2, Keyframes.IntKeyframes intKeyframes) {
            super(string2);
            this.mValueType = Integer.TYPE;
            this.mKeyframes = intKeyframes;
            this.mIntKeyframes = intKeyframes;
        }

        public IntPropertyValuesHolder(String string2, int ... nArray) {
            super(string2);
            this.setIntValues(nArray);
        }

        @Override
        void calculateValue(float f) {
            this.mIntAnimatedValue = this.mIntKeyframes.getIntValue(f);
        }

        @Override
        public IntPropertyValuesHolder clone() {
            IntPropertyValuesHolder intPropertyValuesHolder = (IntPropertyValuesHolder)super.clone();
            intPropertyValuesHolder.mIntKeyframes = (Keyframes.IntKeyframes)intPropertyValuesHolder.mKeyframes;
            return intPropertyValuesHolder;
        }

        @Override
        Object getAnimatedValue() {
            return this.mIntAnimatedValue;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        void setAnimatedValue(Object object) {
            if (this.mIntProperty != null) {
                this.mIntProperty.setValue(object, this.mIntAnimatedValue);
                return;
            } else {
                if (this.mProperty != null) {
                    this.mProperty.set(object, this.mIntAnimatedValue);
                    return;
                }
                if (this.mJniSetter != 0L) {
                    PropertyValuesHolder.nCallIntMethod(object, this.mJniSetter, this.mIntAnimatedValue);
                    return;
                }
                if (this.mSetter == null) return;
                try {
                    this.mTmpValueArray[0] = this.mIntAnimatedValue;
                    this.mSetter.invoke(object, this.mTmpValueArray);
                    return;
                }
                catch (InvocationTargetException invocationTargetException) {
                    Log.e("PropertyValuesHolder", invocationTargetException.toString());
                    return;
                }
                catch (IllegalAccessException illegalAccessException) {
                    Log.e("PropertyValuesHolder", illegalAccessException.toString());
                    return;
                }
            }
        }

        @Override
        public void setIntValues(int ... nArray) {
            super.setIntValues(nArray);
            this.mIntKeyframes = (Keyframes.IntKeyframes)this.mKeyframes;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        void setupSetter(Class clazz) {
            block13: {
                block12: {
                    block11: {
                        if (this.mProperty != null) break block12;
                        try {
                            Long l;
                            this.mPropertyMapLock.writeLock().lock();
                            HashMap<String, Long> hashMap = sJNISetterPropertyMap.get(clazz);
                            if (hashMap != null && (l = hashMap.get(this.mPropertyName)) != null) {
                                this.mJniSetter = l;
                            }
                            if (this.mJniSetter != 0L) break block11;
                            this.mJniSetter = PropertyValuesHolder.nGetIntMethod(clazz, IntPropertyValuesHolder.getMethodName("set", this.mPropertyName));
                            if (this.mJniSetter != 0L) {
                                void var4_4;
                                if (hashMap == null) {
                                    HashMap hashMap2 = new HashMap();
                                    sJNISetterPropertyMap.put(clazz, hashMap2);
                                }
                                var4_4.put(this.mPropertyName, this.mJniSetter);
                            }
                            break block11;
                        }
                        catch (NoSuchMethodError noSuchMethodError) {}
                        break block11;
                        finally {
                            this.mPropertyMapLock.writeLock().unlock();
                        }
                    }
                    if (this.mJniSetter == 0L) break block13;
                }
                return;
            }
            super.setupSetter(clazz);
        }
    }

    static class MultiFloatValuesHolder
    extends PropertyValuesHolder {
        private static final HashMap<Class, HashMap<String, Long>> sJNISetterPropertyMap = new HashMap();
        private long mJniSetter;

        public MultiFloatValuesHolder(String string2, TypeConverter typeConverter, TypeEvaluator typeEvaluator, Keyframes keyframes) {
            super(string2);
            this.setConverter(typeConverter);
            this.mKeyframes = keyframes;
            this.setEvaluator(typeEvaluator);
        }

        public MultiFloatValuesHolder(String string2, TypeConverter typeConverter, TypeEvaluator typeEvaluator, Object ... objectArray) {
            super(string2);
            this.setConverter(typeConverter);
            this.setObjectValues(objectArray);
            this.setEvaluator(typeEvaluator);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        void setAnimatedValue(Object object) {
            float[] fArray = (float[])this.getAnimatedValue();
            int n = fArray.length;
            if (this.mJniSetter == 0L) return;
            switch (n) {
                default: {
                    PropertyValuesHolder.nCallMultipleFloatMethod(object, this.mJniSetter, fArray);
                    return;
                }
                case 1: {
                    PropertyValuesHolder.nCallFloatMethod(object, this.mJniSetter, fArray[0]);
                    return;
                }
                case 2: {
                    PropertyValuesHolder.nCallTwoFloatMethod(object, this.mJniSetter, fArray[0], fArray[1]);
                    return;
                }
                case 4: 
            }
            PropertyValuesHolder.nCallFourFloatMethod(object, this.mJniSetter, fArray[0], fArray[1], fArray[2], fArray[3]);
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        void setupSetter(Class var1_1) {
            if (this.mJniSetter != 0L) {
                return;
            }
            try {
                this.mPropertyMapLock.writeLock().lock();
                var3_2 /* !! */  = MultiFloatValuesHolder.sJNISetterPropertyMap.get(var1_1);
                if (var3_2 /* !! */  != null && (var4_3 = var3_2 /* !! */ .get(this.mPropertyName)) != null) {
                    this.mJniSetter = var4_3;
                }
                if (this.mJniSetter != 0L) ** GOTO lbl29
                var5_4 = MultiFloatValuesHolder.getMethodName("set", this.mPropertyName);
                this.calculateValue(0.0f);
                var6_5 = ((float[])this.getAnimatedValue()).length;
                try {
                    this.mJniSetter = PropertyValuesHolder.access$900(var1_1, var5_4, var6_5);
lbl14:
                    // 2 sources

                    while (true) {
                        if (this.mJniSetter == 0L) break block12;
                        if (var3_2 /* !! */  != null) break block13;
                        var3_2 /* !! */  = new HashMap<K, V>();
                        MultiFloatValuesHolder.sJNISetterPropertyMap.put(var1_1, var3_2 /* !! */ );
                        break;
                    }
                }
                catch (NoSuchMethodError var7_6) {
                    this.mJniSetter = PropertyValuesHolder.access$900(var1_1, this.mPropertyName, var6_5);
                    ** continue;
                }
                {
                    block12: {
                        block13: {
                        }
                        var3_2 /* !! */ .put(this.mPropertyName, this.mJniSetter);
                    }
                    return;
                }
            }
            finally {
                this.mPropertyMapLock.writeLock().unlock();
            }
        }

        @Override
        void setupSetterAndGetter(Object object) {
            this.setupSetter(object.getClass());
        }
    }

    static class MultiIntValuesHolder
    extends PropertyValuesHolder {
        private static final HashMap<Class, HashMap<String, Long>> sJNISetterPropertyMap = new HashMap();
        private long mJniSetter;

        public MultiIntValuesHolder(String string2, TypeConverter typeConverter, TypeEvaluator typeEvaluator, Keyframes keyframes) {
            super(string2);
            this.setConverter(typeConverter);
            this.mKeyframes = keyframes;
            this.setEvaluator(typeEvaluator);
        }

        public MultiIntValuesHolder(String string2, TypeConverter typeConverter, TypeEvaluator typeEvaluator, Object ... objectArray) {
            super(string2);
            this.setConverter(typeConverter);
            this.setObjectValues(objectArray);
            this.setEvaluator(typeEvaluator);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        void setAnimatedValue(Object object) {
            int[] nArray = (int[])this.getAnimatedValue();
            int n = nArray.length;
            if (this.mJniSetter == 0L) return;
            switch (n) {
                default: {
                    PropertyValuesHolder.nCallMultipleIntMethod(object, this.mJniSetter, nArray);
                    return;
                }
                case 1: {
                    PropertyValuesHolder.nCallIntMethod(object, this.mJniSetter, nArray[0]);
                    return;
                }
                case 2: {
                    PropertyValuesHolder.nCallTwoIntMethod(object, this.mJniSetter, nArray[0], nArray[1]);
                    return;
                }
                case 4: 
            }
            PropertyValuesHolder.nCallFourIntMethod(object, this.mJniSetter, nArray[0], nArray[1], nArray[2], nArray[3]);
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        void setupSetter(Class var1_1) {
            if (this.mJniSetter != 0L) {
                return;
            }
            try {
                this.mPropertyMapLock.writeLock().lock();
                var3_2 /* !! */  = MultiIntValuesHolder.sJNISetterPropertyMap.get(var1_1);
                if (var3_2 /* !! */  != null && (var4_3 = var3_2 /* !! */ .get(this.mPropertyName)) != null) {
                    this.mJniSetter = var4_3;
                }
                if (this.mJniSetter != 0L) ** GOTO lbl29
                var5_4 = MultiIntValuesHolder.getMethodName("set", this.mPropertyName);
                this.calculateValue(0.0f);
                var6_5 = ((int[])this.getAnimatedValue()).length;
                try {
                    this.mJniSetter = PropertyValuesHolder.access$1300(var1_1, var5_4, var6_5);
lbl14:
                    // 2 sources

                    while (true) {
                        if (this.mJniSetter == 0L) break block12;
                        if (var3_2 /* !! */  != null) break block13;
                        var3_2 /* !! */  = new HashMap<K, V>();
                        MultiIntValuesHolder.sJNISetterPropertyMap.put(var1_1, var3_2 /* !! */ );
                        break;
                    }
                }
                catch (NoSuchMethodError var7_6) {
                    this.mJniSetter = PropertyValuesHolder.access$1300(var1_1, this.mPropertyName, var6_5);
                    ** continue;
                }
                {
                    block12: {
                        block13: {
                        }
                        var3_2 /* !! */ .put(this.mPropertyName, this.mJniSetter);
                    }
                    return;
                }
            }
            finally {
                this.mPropertyMapLock.writeLock().unlock();
            }
        }

        @Override
        void setupSetterAndGetter(Object object) {
            this.setupSetter(object.getClass());
        }
    }

    private static class PointFToFloatArray
    extends TypeConverter<PointF, float[]> {
        private float[] mCoordinates = new float[2];

        public PointFToFloatArray() {
            super(PointF.class, float[].class);
        }

        @Override
        public float[] convert(PointF pointF) {
            this.mCoordinates[0] = pointF.x;
            this.mCoordinates[1] = pointF.y;
            return this.mCoordinates;
        }
    }

    private static class PointFToIntArray
    extends TypeConverter<PointF, int[]> {
        private int[] mCoordinates = new int[2];

        public PointFToIntArray() {
            super(PointF.class, int[].class);
        }

        @Override
        public int[] convert(PointF pointF) {
            this.mCoordinates[0] = Math.round(pointF.x);
            this.mCoordinates[1] = Math.round(pointF.y);
            return this.mCoordinates;
        }
    }
}

