/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.KeyframeSet;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

public class LayoutTransition {
    private static TimeInterpolator ACCEL_DECEL_INTERPOLATOR;
    public static final int APPEARING = 2;
    public static final int CHANGE_APPEARING = 0;
    public static final int CHANGE_DISAPPEARING = 1;
    public static final int CHANGING = 4;
    private static TimeInterpolator DECEL_INTERPOLATOR;
    private static long DEFAULT_DURATION = 0L;
    public static final int DISAPPEARING = 3;
    private static final int FLAG_APPEARING = 1;
    private static final int FLAG_CHANGE_APPEARING = 4;
    private static final int FLAG_CHANGE_DISAPPEARING = 8;
    private static final int FLAG_CHANGING = 16;
    private static final int FLAG_DISAPPEARING = 2;
    private static ObjectAnimator defaultChange;
    private static ObjectAnimator defaultChangeIn;
    private static ObjectAnimator defaultChangeOut;
    private static ObjectAnimator defaultFadeIn;
    private static ObjectAnimator defaultFadeOut;
    private static TimeInterpolator sAppearingInterpolator;
    private static TimeInterpolator sChangingAppearingInterpolator;
    private static TimeInterpolator sChangingDisappearingInterpolator;
    private static TimeInterpolator sChangingInterpolator;
    private static TimeInterpolator sDisappearingInterpolator;
    private final LinkedHashMap<View, Animator> currentAppearingAnimations;
    private final LinkedHashMap<View, Animator> currentChangingAnimations;
    private final LinkedHashMap<View, Animator> currentDisappearingAnimations;
    private final HashMap<View, View.OnLayoutChangeListener> layoutChangeListenerMap;
    private boolean mAnimateParentHierarchy = true;
    private Animator mAppearingAnim = null;
    private long mAppearingDelay;
    private long mAppearingDuration;
    private TimeInterpolator mAppearingInterpolator;
    private Animator mChangingAnim = null;
    private Animator mChangingAppearingAnim = null;
    private long mChangingAppearingDelay = 0L;
    private long mChangingAppearingDuration = DEFAULT_DURATION;
    private TimeInterpolator mChangingAppearingInterpolator;
    private long mChangingAppearingStagger = 0L;
    private long mChangingDelay = 0L;
    private Animator mChangingDisappearingAnim = null;
    private long mChangingDisappearingDelay;
    private long mChangingDisappearingDuration = DEFAULT_DURATION;
    private TimeInterpolator mChangingDisappearingInterpolator;
    private long mChangingDisappearingStagger = 0L;
    private long mChangingDuration = DEFAULT_DURATION;
    private TimeInterpolator mChangingInterpolator;
    private long mChangingStagger = 0L;
    private Animator mDisappearingAnim = null;
    private long mDisappearingDelay = 0L;
    private long mDisappearingDuration;
    private TimeInterpolator mDisappearingInterpolator;
    private ArrayList<TransitionListener> mListeners;
    private int mTransitionTypes = 15;
    private final HashMap<View, Animator> pendingAnimations;
    private long staggerDelay;

    static {
        DEFAULT_DURATION = 300L;
        ACCEL_DECEL_INTERPOLATOR = new AccelerateDecelerateInterpolator();
        DECEL_INTERPOLATOR = new DecelerateInterpolator();
        sAppearingInterpolator = ACCEL_DECEL_INTERPOLATOR;
        sDisappearingInterpolator = ACCEL_DECEL_INTERPOLATOR;
        sChangingAppearingInterpolator = DECEL_INTERPOLATOR;
        sChangingDisappearingInterpolator = DECEL_INTERPOLATOR;
        sChangingInterpolator = DECEL_INTERPOLATOR;
    }

    public LayoutTransition() {
        this.mAppearingDuration = DEFAULT_DURATION;
        this.mDisappearingDuration = DEFAULT_DURATION;
        this.mAppearingDelay = DEFAULT_DURATION;
        this.mChangingDisappearingDelay = DEFAULT_DURATION;
        this.mAppearingInterpolator = sAppearingInterpolator;
        this.mDisappearingInterpolator = sDisappearingInterpolator;
        this.mChangingAppearingInterpolator = sChangingAppearingInterpolator;
        this.mChangingDisappearingInterpolator = sChangingDisappearingInterpolator;
        this.mChangingInterpolator = sChangingInterpolator;
        this.pendingAnimations = new HashMap();
        this.currentChangingAnimations = new LinkedHashMap();
        this.currentAppearingAnimations = new LinkedHashMap();
        this.currentDisappearingAnimations = new LinkedHashMap();
        this.layoutChangeListenerMap = new HashMap();
        if (defaultChangeIn == null) {
            PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofInt("left", 0, 1);
            PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofInt("top", 0, 1);
            PropertyValuesHolder propertyValuesHolder3 = PropertyValuesHolder.ofInt("right", 0, 1);
            PropertyValuesHolder propertyValuesHolder4 = PropertyValuesHolder.ofInt("bottom", 0, 1);
            PropertyValuesHolder propertyValuesHolder5 = PropertyValuesHolder.ofInt("scrollX", 0, 1);
            PropertyValuesHolder propertyValuesHolder6 = PropertyValuesHolder.ofInt("scrollY", 0, 1);
            defaultChangeIn = ObjectAnimator.ofPropertyValuesHolder((Object)null, propertyValuesHolder, propertyValuesHolder2, propertyValuesHolder3, propertyValuesHolder4, propertyValuesHolder5, propertyValuesHolder6);
            defaultChangeIn.setDuration(DEFAULT_DURATION);
            defaultChangeIn.setStartDelay(this.mChangingAppearingDelay);
            defaultChangeIn.setInterpolator(this.mChangingAppearingInterpolator);
            defaultChangeOut = defaultChangeIn.clone();
            defaultChangeOut.setStartDelay(this.mChangingDisappearingDelay);
            defaultChangeOut.setInterpolator(this.mChangingDisappearingInterpolator);
            defaultChange = defaultChangeIn.clone();
            defaultChange.setStartDelay(this.mChangingDelay);
            defaultChange.setInterpolator(this.mChangingInterpolator);
            defaultFadeIn = ObjectAnimator.ofFloat(null, "alpha", 0.0f, 1.0f);
            defaultFadeIn.setDuration(DEFAULT_DURATION);
            defaultFadeIn.setStartDelay(this.mAppearingDelay);
            defaultFadeIn.setInterpolator(this.mAppearingInterpolator);
            defaultFadeOut = ObjectAnimator.ofFloat(null, "alpha", 1.0f, 0.0f);
            defaultFadeOut.setDuration(DEFAULT_DURATION);
            defaultFadeOut.setStartDelay(this.mDisappearingDelay);
            defaultFadeOut.setInterpolator(this.mDisappearingInterpolator);
        }
        this.mChangingAppearingAnim = defaultChangeIn;
        this.mChangingDisappearingAnim = defaultChangeOut;
        this.mChangingAnim = defaultChange;
        this.mAppearingAnim = defaultFadeIn;
        this.mDisappearingAnim = defaultFadeOut;
    }

    static /* synthetic */ long access$314(LayoutTransition layoutTransition, long l) {
        long l2;
        layoutTransition.staggerDelay = l2 = l + layoutTransition.staggerDelay;
        return l2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addChild(ViewGroup viewGroup, View view, boolean bl) {
        block9: {
            block8: {
                if (viewGroup.getWindowVisibility() != 0) break block8;
                if ((1 & this.mTransitionTypes) == 1) {
                    this.cancel(3);
                }
                if (bl && (4 & this.mTransitionTypes) == 4) {
                    this.cancel(0);
                    this.cancel(4);
                }
                if (this.hasListeners() && (1 & this.mTransitionTypes) == 1) {
                    Iterator iterator = ((ArrayList)this.mListeners.clone()).iterator();
                    while (iterator.hasNext()) {
                        ((TransitionListener)iterator.next()).startTransition(this, viewGroup, view, 2);
                    }
                }
                if (bl && (4 & this.mTransitionTypes) == 4) {
                    this.runChangeTransition(viewGroup, view, 2);
                }
                if ((1 & this.mTransitionTypes) == 1) break block9;
            }
            return;
        }
        this.runAppearingTransition(viewGroup, view);
    }

    private boolean hasListeners() {
        return this.mListeners != null && this.mListeners.size() > 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void removeChild(ViewGroup viewGroup, View view, boolean bl) {
        block9: {
            block8: {
                if (viewGroup.getWindowVisibility() != 0) break block8;
                if ((2 & this.mTransitionTypes) == 2) {
                    this.cancel(2);
                }
                if (bl && (8 & this.mTransitionTypes) == 8) {
                    this.cancel(1);
                    this.cancel(4);
                }
                if (this.hasListeners() && (2 & this.mTransitionTypes) == 2) {
                    Iterator iterator = ((ArrayList)this.mListeners.clone()).iterator();
                    while (iterator.hasNext()) {
                        ((TransitionListener)iterator.next()).startTransition(this, viewGroup, view, 3);
                    }
                }
                if (bl && (8 & this.mTransitionTypes) == 8) {
                    this.runChangeTransition(viewGroup, view, 3);
                }
                if ((2 & this.mTransitionTypes) == 2) break block9;
            }
            return;
        }
        this.runDisappearingTransition(viewGroup, view);
    }

    private void runAppearingTransition(final ViewGroup viewGroup, final View view) {
        Animator animator2 = this.currentDisappearingAnimations.get(view);
        if (animator2 != null) {
            animator2.cancel();
        }
        if (this.mAppearingAnim == null) {
            if (this.hasListeners()) {
                Iterator iterator = ((ArrayList)this.mListeners.clone()).iterator();
                while (iterator.hasNext()) {
                    ((TransitionListener)iterator.next()).endTransition(this, viewGroup, view, 2);
                }
            }
        } else {
            Animator animator3 = this.mAppearingAnim.clone();
            animator3.setTarget(view);
            animator3.setStartDelay(this.mAppearingDelay);
            animator3.setDuration(this.mAppearingDuration);
            if (this.mAppearingInterpolator != sAppearingInterpolator) {
                animator3.setInterpolator(this.mAppearingInterpolator);
            }
            if (animator3 instanceof ObjectAnimator) {
                ((ObjectAnimator)animator3).setCurrentPlayTime(0L);
            }
            animator3.addListener(new AnimatorListenerAdapter(){

                @Override
                public void onAnimationEnd(Animator animator2) {
                    LayoutTransition.this.currentAppearingAnimations.remove(view);
                    if (LayoutTransition.this.hasListeners()) {
                        Iterator iterator = ((ArrayList)LayoutTransition.this.mListeners.clone()).iterator();
                        while (iterator.hasNext()) {
                            ((TransitionListener)iterator.next()).endTransition(LayoutTransition.this, viewGroup, view, 2);
                        }
                    }
                }
            });
            this.currentAppearingAnimations.put(view, animator3);
            animator3.start();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void runChangeTransition(final ViewGroup viewGroup, View view, int n) {
        ViewTreeObserver viewTreeObserver;
        long l;
        ObjectAnimator objectAnimator;
        Animator animator2;
        block13: {
            block12: {
                animator2 = null;
                objectAnimator = null;
                switch (n) {
                    default: {
                        l = 0L;
                        break;
                    }
                    case 2: {
                        animator2 = this.mChangingAppearingAnim;
                        l = this.mChangingAppearingDuration;
                        objectAnimator = defaultChangeIn;
                        break;
                    }
                    case 3: {
                        animator2 = this.mChangingDisappearingAnim;
                        l = this.mChangingDisappearingDuration;
                        objectAnimator = defaultChangeOut;
                        break;
                    }
                    case 4: {
                        animator2 = this.mChangingAnim;
                        l = this.mChangingDuration;
                        objectAnimator = defaultChange;
                    }
                }
                if (animator2 == null) break block12;
                this.staggerDelay = 0L;
                viewTreeObserver = viewGroup.getViewTreeObserver();
                if (viewTreeObserver.isAlive()) break block13;
            }
            return;
        }
        int n2 = viewGroup.getChildCount();
        for (int i = 0; i < n2; ++i) {
            View view2 = viewGroup.getChildAt(i);
            if (view2 == view) continue;
            this.setupChangeAnimation(viewGroup, n, animator2, l, view2);
        }
        if (this.mAnimateParentHierarchy) {
            ViewGroup viewGroup2 = viewGroup;
            while (viewGroup2 != null) {
                ViewParent viewParent = viewGroup2.getParent();
                if (viewParent instanceof ViewGroup) {
                    this.setupChangeAnimation((ViewGroup)viewParent, n, objectAnimator, l, viewGroup2);
                    viewGroup2 = (ViewGroup)viewParent;
                    continue;
                }
                viewGroup2 = null;
            }
        }
        viewTreeObserver.addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            @Override
            public boolean onPreDraw() {
                viewGroup.getViewTreeObserver().removeOnPreDrawListener(this);
                if (LayoutTransition.this.layoutChangeListenerMap.size() > 0) {
                    for (View view : LayoutTransition.this.layoutChangeListenerMap.keySet()) {
                        view.removeOnLayoutChangeListener((View.OnLayoutChangeListener)LayoutTransition.this.layoutChangeListenerMap.get(view));
                    }
                }
                LayoutTransition.this.layoutChangeListenerMap.clear();
                return true;
            }
        });
    }

    private void runDisappearingTransition(ViewGroup viewGroup, final View view) {
        Animator animator2 = this.currentAppearingAnimations.get(view);
        if (animator2 != null) {
            animator2.cancel();
        }
        if (this.mDisappearingAnim == null) {
            if (this.hasListeners()) {
                Iterator iterator = ((ArrayList)this.mListeners.clone()).iterator();
                while (iterator.hasNext()) {
                    ((TransitionListener)iterator.next()).endTransition(this, viewGroup, view, 3);
                }
            }
        } else {
            Animator animator3 = this.mDisappearingAnim.clone();
            animator3.setStartDelay(this.mDisappearingDelay);
            animator3.setDuration(this.mDisappearingDuration);
            if (this.mDisappearingInterpolator != sDisappearingInterpolator) {
                animator3.setInterpolator(this.mDisappearingInterpolator);
            }
            animator3.setTarget(view);
            animator3.addListener(new AnimatorListenerAdapter(view.getAlpha(), viewGroup){
                final /* synthetic */ ViewGroup val$parent;
                final /* synthetic */ float val$preAnimAlpha;
                {
                    this.val$preAnimAlpha = f;
                    this.val$parent = viewGroup;
                }

                @Override
                public void onAnimationEnd(Animator animator2) {
                    LayoutTransition.this.currentDisappearingAnimations.remove(view);
                    view.setAlpha(this.val$preAnimAlpha);
                    if (LayoutTransition.this.hasListeners()) {
                        Iterator iterator = ((ArrayList)LayoutTransition.this.mListeners.clone()).iterator();
                        while (iterator.hasNext()) {
                            ((TransitionListener)iterator.next()).endTransition(LayoutTransition.this, this.val$parent, view, 3);
                        }
                    }
                }
            });
            if (animator3 instanceof ObjectAnimator) {
                ((ObjectAnimator)animator3).setCurrentPlayTime(0L);
            }
            this.currentDisappearingAnimations.put(view, animator3);
            animator3.start();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setupChangeAnimation(final ViewGroup viewGroup, final int n, Animator animator2, final long l, final View view) {
        if (this.layoutChangeListenerMap.get(view) != null || view.getWidth() == 0 && view.getHeight() == 0) {
            return;
        }
        final Animator animator3 = animator2.clone();
        animator3.setTarget(view);
        animator3.setupStartValues();
        Animator animator4 = this.pendingAnimations.get(view);
        if (animator4 != null) {
            animator4.cancel();
            this.pendingAnimations.remove(view);
        }
        this.pendingAnimations.put(view, animator3);
        Animator animator5 = ValueAnimator.ofFloat(0.0f, 1.0f).setDuration(100L + l);
        animator5.addListener(new AnimatorListenerAdapter(){

            @Override
            public void onAnimationEnd(Animator animator2) {
                LayoutTransition.this.pendingAnimations.remove(view);
            }
        });
        ((ValueAnimator)animator5).start();
        final View.OnLayoutChangeListener onLayoutChangeListener = new View.OnLayoutChangeListener(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onLayoutChange(View view2, int n9, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
                animator3.setupEndValues();
                if (animator3 instanceof ValueAnimator) {
                    boolean bl = false;
                    PropertyValuesHolder[] propertyValuesHolderArray = ((ValueAnimator)animator3).getValues();
                    for (int i = 0; i < propertyValuesHolderArray.length; ++i) {
                        PropertyValuesHolder propertyValuesHolder = propertyValuesHolderArray[i];
                        if (propertyValuesHolder.mKeyframes instanceof KeyframeSet) {
                            KeyframeSet keyframeSet = (KeyframeSet)propertyValuesHolder.mKeyframes;
                            if (keyframeSet.mFirstKeyframe != null && keyframeSet.mLastKeyframe != null && keyframeSet.mFirstKeyframe.getValue().equals(keyframeSet.mLastKeyframe.getValue())) continue;
                            bl = true;
                            continue;
                        }
                        if (propertyValuesHolder.mKeyframes.getValue(0.0f).equals(propertyValuesHolder.mKeyframes.getValue(1.0f))) continue;
                        bl = true;
                    }
                    if (!bl) {
                        return;
                    }
                }
                long l2 = 0L;
                switch (n) {
                    case 2: {
                        l2 = LayoutTransition.this.mChangingAppearingDelay + LayoutTransition.this.staggerDelay;
                        LayoutTransition.access$314(LayoutTransition.this, LayoutTransition.this.mChangingAppearingStagger);
                        if (LayoutTransition.this.mChangingAppearingInterpolator == sChangingAppearingInterpolator) break;
                        animator3.setInterpolator(LayoutTransition.this.mChangingAppearingInterpolator);
                        break;
                    }
                    case 3: {
                        l2 = LayoutTransition.this.mChangingDisappearingDelay + LayoutTransition.this.staggerDelay;
                        LayoutTransition.access$314(LayoutTransition.this, LayoutTransition.this.mChangingDisappearingStagger);
                        if (LayoutTransition.this.mChangingDisappearingInterpolator == sChangingDisappearingInterpolator) break;
                        animator3.setInterpolator(LayoutTransition.this.mChangingDisappearingInterpolator);
                        break;
                    }
                    case 4: {
                        l2 = LayoutTransition.this.mChangingDelay + LayoutTransition.this.staggerDelay;
                        LayoutTransition.access$314(LayoutTransition.this, LayoutTransition.this.mChangingStagger);
                        if (LayoutTransition.this.mChangingInterpolator == sChangingInterpolator) break;
                        animator3.setInterpolator(LayoutTransition.this.mChangingInterpolator);
                        break;
                    }
                }
                animator3.setStartDelay(l2);
                animator3.setDuration(l);
                Animator animator2 = (Animator)LayoutTransition.this.currentChangingAnimations.get(view);
                if (animator2 != null) {
                    animator2.cancel();
                }
                if ((Animator)LayoutTransition.this.pendingAnimations.get(view) != null) {
                    LayoutTransition.this.pendingAnimations.remove(view);
                }
                LayoutTransition.this.currentChangingAnimations.put(view, animator3);
                viewGroup.requestTransitionStart(LayoutTransition.this);
                view.removeOnLayoutChangeListener(this);
                LayoutTransition.this.layoutChangeListenerMap.remove(view);
            }
        };
        animator3.addListener(new AnimatorListenerAdapter(){

            @Override
            public void onAnimationCancel(Animator animator2) {
                view.removeOnLayoutChangeListener(onLayoutChangeListener);
                LayoutTransition.this.layoutChangeListenerMap.remove(view);
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onAnimationEnd(Animator animator2) {
                LayoutTransition.this.currentChangingAnimations.remove(view);
                if (LayoutTransition.this.hasListeners()) {
                    for (TransitionListener transitionListener : (ArrayList)LayoutTransition.this.mListeners.clone()) {
                        LayoutTransition layoutTransition = LayoutTransition.this;
                        ViewGroup viewGroup2 = viewGroup;
                        View view2 = view;
                        int n2 = n == 2 ? 0 : (n == 3 ? 1 : 4);
                        transitionListener.endTransition(layoutTransition, viewGroup2, view2, n2);
                    }
                }
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onAnimationStart(Animator animator2) {
                if (LayoutTransition.this.hasListeners()) {
                    for (TransitionListener transitionListener : (ArrayList)LayoutTransition.this.mListeners.clone()) {
                        LayoutTransition layoutTransition = LayoutTransition.this;
                        ViewGroup viewGroup2 = viewGroup;
                        View view2 = view;
                        int n2 = n == 2 ? 0 : (n == 3 ? 1 : 4);
                        transitionListener.startTransition(layoutTransition, viewGroup2, view2, n2);
                    }
                }
            }
        });
        view.addOnLayoutChangeListener(onLayoutChangeListener);
        this.layoutChangeListenerMap.put(view, onLayoutChangeListener);
    }

    public void addChild(ViewGroup viewGroup, View view) {
        this.addChild(viewGroup, view, true);
    }

    public void addTransitionListener(TransitionListener transitionListener) {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList();
        }
        this.mListeners.add(transitionListener);
    }

    public void cancel() {
        if (this.currentChangingAnimations.size() > 0) {
            Iterator iterator = ((LinkedHashMap)this.currentChangingAnimations.clone()).values().iterator();
            while (iterator.hasNext()) {
                ((Animator)iterator.next()).cancel();
            }
            this.currentChangingAnimations.clear();
        }
        if (this.currentAppearingAnimations.size() > 0) {
            Iterator iterator = ((LinkedHashMap)this.currentAppearingAnimations.clone()).values().iterator();
            while (iterator.hasNext()) {
                ((Animator)iterator.next()).end();
            }
            this.currentAppearingAnimations.clear();
        }
        if (this.currentDisappearingAnimations.size() > 0) {
            Iterator iterator = ((LinkedHashMap)this.currentDisappearingAnimations.clone()).values().iterator();
            while (iterator.hasNext()) {
                ((Animator)iterator.next()).end();
            }
            this.currentDisappearingAnimations.clear();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void cancel(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 4: {
                if (this.currentChangingAnimations.size() <= 0) return;
                Iterator iterator = ((LinkedHashMap)this.currentChangingAnimations.clone()).values().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        this.currentChangingAnimations.clear();
                        return;
                    }
                    ((Animator)iterator.next()).cancel();
                }
            }
            case 2: {
                if (this.currentAppearingAnimations.size() <= 0) return;
                Iterator iterator = ((LinkedHashMap)this.currentAppearingAnimations.clone()).values().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        this.currentAppearingAnimations.clear();
                        return;
                    }
                    ((Animator)iterator.next()).end();
                }
            }
            default: {
                return;
            }
            case 3: 
        }
        if (this.currentDisappearingAnimations.size() <= 0) return;
        Iterator iterator = ((LinkedHashMap)this.currentDisappearingAnimations.clone()).values().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.currentDisappearingAnimations.clear();
                return;
            }
            ((Animator)iterator.next()).end();
        }
    }

    public void disableTransitionType(int n) {
        switch (n) {
            default: {
                return;
            }
            case 2: {
                this.mTransitionTypes = 0xFFFFFFFE & this.mTransitionTypes;
                return;
            }
            case 3: {
                this.mTransitionTypes = 0xFFFFFFFD & this.mTransitionTypes;
                return;
            }
            case 0: {
                this.mTransitionTypes = 0xFFFFFFFB & this.mTransitionTypes;
                return;
            }
            case 1: {
                this.mTransitionTypes = 0xFFFFFFF7 & this.mTransitionTypes;
                return;
            }
            case 4: 
        }
        this.mTransitionTypes = 0xFFFFFFEF & this.mTransitionTypes;
    }

    public void enableTransitionType(int n) {
        switch (n) {
            default: {
                return;
            }
            case 2: {
                this.mTransitionTypes = 1 | this.mTransitionTypes;
                return;
            }
            case 3: {
                this.mTransitionTypes = 2 | this.mTransitionTypes;
                return;
            }
            case 0: {
                this.mTransitionTypes = 4 | this.mTransitionTypes;
                return;
            }
            case 1: {
                this.mTransitionTypes = 8 | this.mTransitionTypes;
                return;
            }
            case 4: 
        }
        this.mTransitionTypes = 0x10 | this.mTransitionTypes;
    }

    public void endChangingAnimations() {
        for (Animator animator2 : ((LinkedHashMap)this.currentChangingAnimations.clone()).values()) {
            animator2.start();
            animator2.end();
        }
        this.currentChangingAnimations.clear();
    }

    public Animator getAnimator(int n) {
        switch (n) {
            default: {
                return null;
            }
            case 0: {
                return this.mChangingAppearingAnim;
            }
            case 1: {
                return this.mChangingDisappearingAnim;
            }
            case 4: {
                return this.mChangingAnim;
            }
            case 2: {
                return this.mAppearingAnim;
            }
            case 3: 
        }
        return this.mDisappearingAnim;
    }

    public long getDuration(int n) {
        switch (n) {
            default: {
                return 0L;
            }
            case 0: {
                return this.mChangingAppearingDuration;
            }
            case 1: {
                return this.mChangingDisappearingDuration;
            }
            case 4: {
                return this.mChangingDuration;
            }
            case 2: {
                return this.mAppearingDuration;
            }
            case 3: 
        }
        return this.mDisappearingDuration;
    }

    public TimeInterpolator getInterpolator(int n) {
        switch (n) {
            default: {
                return null;
            }
            case 0: {
                return this.mChangingAppearingInterpolator;
            }
            case 1: {
                return this.mChangingDisappearingInterpolator;
            }
            case 4: {
                return this.mChangingInterpolator;
            }
            case 2: {
                return this.mAppearingInterpolator;
            }
            case 3: 
        }
        return this.mDisappearingInterpolator;
    }

    public long getStagger(int n) {
        switch (n) {
            default: {
                return 0L;
            }
            case 0: {
                return this.mChangingAppearingStagger;
            }
            case 1: {
                return this.mChangingDisappearingStagger;
            }
            case 4: 
        }
        return this.mChangingStagger;
    }

    public long getStartDelay(int n) {
        switch (n) {
            default: {
                return 0L;
            }
            case 0: {
                return this.mChangingAppearingDelay;
            }
            case 1: {
                return this.mChangingDisappearingDelay;
            }
            case 4: {
                return this.mChangingDelay;
            }
            case 2: {
                return this.mAppearingDelay;
            }
            case 3: 
        }
        return this.mDisappearingDelay;
    }

    public List<TransitionListener> getTransitionListeners() {
        return this.mListeners;
    }

    @Deprecated
    public void hideChild(ViewGroup viewGroup, View view) {
        this.removeChild(viewGroup, view, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void hideChild(ViewGroup viewGroup, View view, int n) {
        boolean bl = n == 8;
        this.removeChild(viewGroup, view, bl);
    }

    public boolean isChangingLayout() {
        return this.currentChangingAnimations.size() > 0;
    }

    public boolean isRunning() {
        return this.currentChangingAnimations.size() > 0 || this.currentAppearingAnimations.size() > 0 || this.currentDisappearingAnimations.size() > 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isTransitionTypeEnabled(int n) {
        int n2 = 1;
        switch (n) {
            default: {
                return 0 != 0;
            }
            case 2: {
                if ((1 & this.mTransitionTypes) == n2) return n2 != 0;
                return false;
            }
            case 3: {
                if ((2 & this.mTransitionTypes) == 2) return n2 != 0;
                return false;
            }
            case 0: {
                if ((4 & this.mTransitionTypes) == 4) return n2 != 0;
                return false;
            }
            case 1: {
                if ((8 & this.mTransitionTypes) == 8) return n2 != 0;
                return false;
            }
            case 4: 
        }
        if ((0x10 & this.mTransitionTypes) == 16) return n2 != 0;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void layoutChange(ViewGroup viewGroup) {
        if (viewGroup.getWindowVisibility() != 0 || (0x10 & this.mTransitionTypes) != 16 || this.isRunning()) {
            return;
        }
        this.runChangeTransition(viewGroup, null, 4);
    }

    public void removeChild(ViewGroup viewGroup, View view) {
        this.removeChild(viewGroup, view, true);
    }

    public void removeTransitionListener(TransitionListener transitionListener) {
        if (this.mListeners == null) {
            return;
        }
        this.mListeners.remove(transitionListener);
    }

    public void setAnimateParentHierarchy(boolean bl) {
        this.mAnimateParentHierarchy = bl;
    }

    public void setAnimator(int n, Animator animator2) {
        switch (n) {
            default: {
                return;
            }
            case 0: {
                this.mChangingAppearingAnim = animator2;
                return;
            }
            case 1: {
                this.mChangingDisappearingAnim = animator2;
                return;
            }
            case 4: {
                this.mChangingAnim = animator2;
                return;
            }
            case 2: {
                this.mAppearingAnim = animator2;
                return;
            }
            case 3: 
        }
        this.mDisappearingAnim = animator2;
    }

    public void setDuration(int n, long l) {
        switch (n) {
            default: {
                return;
            }
            case 0: {
                this.mChangingAppearingDuration = l;
                return;
            }
            case 1: {
                this.mChangingDisappearingDuration = l;
                return;
            }
            case 4: {
                this.mChangingDuration = l;
                return;
            }
            case 2: {
                this.mAppearingDuration = l;
                return;
            }
            case 3: 
        }
        this.mDisappearingDuration = l;
    }

    public void setDuration(long l) {
        this.mChangingAppearingDuration = l;
        this.mChangingDisappearingDuration = l;
        this.mChangingDuration = l;
        this.mAppearingDuration = l;
        this.mDisappearingDuration = l;
    }

    public void setInterpolator(int n, TimeInterpolator timeInterpolator) {
        switch (n) {
            default: {
                return;
            }
            case 0: {
                this.mChangingAppearingInterpolator = timeInterpolator;
                return;
            }
            case 1: {
                this.mChangingDisappearingInterpolator = timeInterpolator;
                return;
            }
            case 4: {
                this.mChangingInterpolator = timeInterpolator;
                return;
            }
            case 2: {
                this.mAppearingInterpolator = timeInterpolator;
                return;
            }
            case 3: 
        }
        this.mDisappearingInterpolator = timeInterpolator;
    }

    public void setStagger(int n, long l) {
        switch (n) {
            default: {
                return;
            }
            case 0: {
                this.mChangingAppearingStagger = l;
                return;
            }
            case 1: {
                this.mChangingDisappearingStagger = l;
                return;
            }
            case 4: 
        }
        this.mChangingStagger = l;
    }

    public void setStartDelay(int n, long l) {
        switch (n) {
            default: {
                return;
            }
            case 0: {
                this.mChangingAppearingDelay = l;
                return;
            }
            case 1: {
                this.mChangingDisappearingDelay = l;
                return;
            }
            case 4: {
                this.mChangingDelay = l;
                return;
            }
            case 2: {
                this.mAppearingDelay = l;
                return;
            }
            case 3: 
        }
        this.mDisappearingDelay = l;
    }

    @Deprecated
    public void showChild(ViewGroup viewGroup, View view) {
        this.addChild(viewGroup, view, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void showChild(ViewGroup viewGroup, View view, int n) {
        boolean bl = n == 8;
        this.addChild(viewGroup, view, bl);
    }

    public void startChangingAnimations() {
        for (Animator animator2 : ((LinkedHashMap)this.currentChangingAnimations.clone()).values()) {
            if (animator2 instanceof ObjectAnimator) {
                ((ObjectAnimator)animator2).setCurrentPlayTime(0L);
            }
            animator2.start();
        }
    }

    public static interface TransitionListener {
        public void endTransition(LayoutTransition var1, ViewGroup var2, View var3, int var4);

        public void startTransition(LayoutTransition var1, ViewGroup var2, View var3, int var4);
    }
}

