/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.TimeInterpolator;
import java.util.ArrayList;

public abstract class Animator
implements Cloneable {
    ArrayList<AnimatorListener> mListeners = null;
    ArrayList<AnimatorPauseListener> mPauseListeners = null;
    boolean mPaused = false;

    public void addListener(AnimatorListener animatorListener) {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList();
        }
        this.mListeners.add(animatorListener);
    }

    public void addPauseListener(AnimatorPauseListener animatorPauseListener) {
        if (this.mPauseListeners == null) {
            this.mPauseListeners = new ArrayList();
        }
        this.mPauseListeners.add(animatorPauseListener);
    }

    public boolean canReverse() {
        return false;
    }

    public void cancel() {
    }

    public Animator clone() {
        Animator animator2;
        block8: {
            block7: {
                animator2 = (Animator)super.clone();
                if (this.mListeners == null) break block7;
                ArrayList<AnimatorListener> arrayList = this.mListeners;
                animator2.mListeners = new ArrayList();
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    animator2.mListeners.add(arrayList.get(i));
                    continue;
                }
            }
            if (this.mPauseListeners == null) break block8;
            ArrayList<AnimatorPauseListener> arrayList = this.mPauseListeners;
            animator2.mPauseListeners = new ArrayList();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                try {
                    animator2.mPauseListeners.add(arrayList.get(i));
                    continue;
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new AssertionError();
                }
            }
        }
        return animator2;
    }

    public void end() {
    }

    public abstract long getDuration();

    public TimeInterpolator getInterpolator() {
        return null;
    }

    public ArrayList<AnimatorListener> getListeners() {
        return this.mListeners;
    }

    public abstract long getStartDelay();

    public boolean isPaused() {
        return this.mPaused;
    }

    public abstract boolean isRunning();

    public boolean isStarted() {
        return this.isRunning();
    }

    public void pause() {
        if (this.isStarted() && !this.mPaused) {
            this.mPaused = true;
            if (this.mPauseListeners != null) {
                ArrayList arrayList = (ArrayList)this.mPauseListeners.clone();
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    ((AnimatorPauseListener)arrayList.get(i)).onAnimationPause(this);
                }
            }
        }
    }

    public void removeAllListeners() {
        if (this.mListeners != null) {
            this.mListeners.clear();
            this.mListeners = null;
        }
        if (this.mPauseListeners != null) {
            this.mPauseListeners.clear();
            this.mPauseListeners = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void removeListener(AnimatorListener animatorListener) {
        block3: {
            block2: {
                if (this.mListeners == null) break block2;
                this.mListeners.remove(animatorListener);
                if (this.mListeners.size() == 0) break block3;
            }
            return;
        }
        this.mListeners = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void removePauseListener(AnimatorPauseListener animatorPauseListener) {
        block3: {
            block2: {
                if (this.mPauseListeners == null) break block2;
                this.mPauseListeners.remove(animatorPauseListener);
                if (this.mPauseListeners.size() == 0) break block3;
            }
            return;
        }
        this.mPauseListeners = null;
    }

    public void resume() {
        if (this.mPaused) {
            this.mPaused = false;
            if (this.mPauseListeners != null) {
                ArrayList arrayList = (ArrayList)this.mPauseListeners.clone();
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    ((AnimatorPauseListener)arrayList.get(i)).onAnimationResume(this);
                }
            }
        }
    }

    public void reverse() {
        throw new IllegalStateException("Reverse is not supported");
    }

    public void setAllowRunningAsynchronously(boolean bl) {
    }

    public abstract Animator setDuration(long var1);

    public abstract void setInterpolator(TimeInterpolator var1);

    public abstract void setStartDelay(long var1);

    public void setTarget(Object object) {
    }

    public void setupEndValues() {
    }

    public void setupStartValues() {
    }

    public void start() {
    }

    public static interface AnimatorListener {
        public void onAnimationCancel(Animator var1);

        public void onAnimationEnd(Animator var1);

        public void onAnimationRepeat(Animator var1);

        public void onAnimationStart(Animator var1);
    }

    public static interface AnimatorPauseListener {
        public void onAnimationPause(Animator var1);

        public void onAnimationResume(Animator var1);
    }
}

