/*
 * Decompiled with CFR 0.152.
 */
package android.accounts;

import android.accounts.Account;
import android.accounts.AccountAuthenticatorResponse;
import android.accounts.AccountManager;
import android.accounts.IAccountAuthenticator;
import android.accounts.IAccountAuthenticatorResponse;
import android.accounts.NetworkErrorException;
import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import java.util.Arrays;

public abstract class AbstractAccountAuthenticator {
    private static final String TAG = "AccountAuthenticator";
    private final Context mContext;
    private Transport mTransport = new Transport();

    public AbstractAccountAuthenticator(Context context) {
        this.mContext = context;
    }

    private void checkBinderPermission() {
        int n = Binder.getCallingUid();
        if (this.mContext.checkCallingOrSelfPermission("android.permission.ACCOUNT_MANAGER") != 0) {
            throw new SecurityException("caller uid " + n + " lacks " + "android.permission.ACCOUNT_MANAGER");
        }
    }

    private void handleException(IAccountAuthenticatorResponse iAccountAuthenticatorResponse, String string2, String string3, Exception exception) throws RemoteException {
        if (exception instanceof NetworkErrorException) {
            if (Log.isLoggable(TAG, 2)) {
                Log.v(TAG, string2 + "(" + string3 + ")", exception);
            }
            iAccountAuthenticatorResponse.onError(3, exception.getMessage());
            return;
        }
        if (exception instanceof UnsupportedOperationException) {
            if (Log.isLoggable(TAG, 2)) {
                Log.v(TAG, string2 + "(" + string3 + ")", exception);
            }
            iAccountAuthenticatorResponse.onError(6, string2 + " not supported");
            return;
        }
        if (exception instanceof IllegalArgumentException) {
            if (Log.isLoggable(TAG, 2)) {
                Log.v(TAG, string2 + "(" + string3 + ")", exception);
            }
            iAccountAuthenticatorResponse.onError(7, string2 + " not supported");
            return;
        }
        Log.w(TAG, string2 + "(" + string3 + ")", exception);
        iAccountAuthenticatorResponse.onError(1, string2 + " failed");
    }

    public abstract Bundle addAccount(AccountAuthenticatorResponse var1, String var2, String var3, String[] var4, Bundle var5) throws NetworkErrorException;

    public Bundle addAccountFromCredentials(final AccountAuthenticatorResponse accountAuthenticatorResponse, Account account, Bundle bundle) throws NetworkErrorException {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Bundle bundle = new Bundle();
                bundle.putBoolean("booleanResult", false);
                accountAuthenticatorResponse.onResult(bundle);
            }
        }).start();
        return null;
    }

    public abstract Bundle confirmCredentials(AccountAuthenticatorResponse var1, Account var2, Bundle var3) throws NetworkErrorException;

    public abstract Bundle editProperties(AccountAuthenticatorResponse var1, String var2);

    public Bundle getAccountCredentialsForCloning(final AccountAuthenticatorResponse accountAuthenticatorResponse, Account account) throws NetworkErrorException {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Bundle bundle = new Bundle();
                bundle.putBoolean("booleanResult", false);
                accountAuthenticatorResponse.onResult(bundle);
            }
        }).start();
        return null;
    }

    public Bundle getAccountRemovalAllowed(AccountAuthenticatorResponse accountAuthenticatorResponse, Account account) throws NetworkErrorException {
        Bundle bundle = new Bundle();
        bundle.putBoolean("booleanResult", true);
        return bundle;
    }

    public abstract Bundle getAuthToken(AccountAuthenticatorResponse var1, Account var2, String var3, Bundle var4) throws NetworkErrorException;

    public abstract String getAuthTokenLabel(String var1);

    public final IBinder getIBinder() {
        return this.mTransport.asBinder();
    }

    public abstract Bundle hasFeatures(AccountAuthenticatorResponse var1, Account var2, String[] var3) throws NetworkErrorException;

    public abstract Bundle updateCredentials(AccountAuthenticatorResponse var1, Account var2, String var3, Bundle var4) throws NetworkErrorException;

    private class Transport
    extends IAccountAuthenticator.Stub {
        private Transport() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void addAccount(IAccountAuthenticatorResponse iAccountAuthenticatorResponse, String string2, String string3, String[] stringArray, Bundle bundle) throws RemoteException {
            if (Log.isLoggable(AbstractAccountAuthenticator.TAG, 2)) {
                StringBuilder stringBuilder = new StringBuilder().append("addAccount: accountType ").append(string2).append(", authTokenType ").append(string3).append(", features ");
                String string4 = stringArray == null ? "[]" : Arrays.toString(stringArray);
                Log.v(AbstractAccountAuthenticator.TAG, stringBuilder.append(string4).toString());
            }
            AbstractAccountAuthenticator.this.checkBinderPermission();
            try {
                Bundle bundle2 = AbstractAccountAuthenticator.this.addAccount(new AccountAuthenticatorResponse(iAccountAuthenticatorResponse), string2, string3, stringArray, bundle);
                if (Log.isLoggable(AbstractAccountAuthenticator.TAG, 2)) {
                    bundle2.keySet();
                    Log.v(AbstractAccountAuthenticator.TAG, "addAccount: result " + AccountManager.sanitizeResult(bundle2));
                }
                if (bundle2 != null) {
                    iAccountAuthenticatorResponse.onResult(bundle2);
                }
                return;
            }
            catch (Exception exception) {
                AbstractAccountAuthenticator.this.handleException(iAccountAuthenticatorResponse, "addAccount", string2, exception);
                return;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void addAccountFromCredentials(IAccountAuthenticatorResponse iAccountAuthenticatorResponse, Account account, Bundle bundle) throws RemoteException {
            Bundle bundle2;
            AbstractAccountAuthenticator.this.checkBinderPermission();
            try {
                bundle2 = AbstractAccountAuthenticator.this.addAccountFromCredentials(new AccountAuthenticatorResponse(iAccountAuthenticatorResponse), account, bundle);
                if (bundle2 == null) return;
            }
            catch (Exception exception) {
                AbstractAccountAuthenticator.this.handleException(iAccountAuthenticatorResponse, "addAccountFromCredentials", account.toString(), exception);
                return;
            }
            iAccountAuthenticatorResponse.onResult(bundle2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void confirmCredentials(IAccountAuthenticatorResponse iAccountAuthenticatorResponse, Account account, Bundle bundle) throws RemoteException {
            Bundle bundle2;
            if (Log.isLoggable(AbstractAccountAuthenticator.TAG, 2)) {
                Log.v(AbstractAccountAuthenticator.TAG, "confirmCredentials: " + account);
            }
            AbstractAccountAuthenticator.this.checkBinderPermission();
            try {
                bundle2 = AbstractAccountAuthenticator.this.confirmCredentials(new AccountAuthenticatorResponse(iAccountAuthenticatorResponse), account, bundle);
                if (Log.isLoggable(AbstractAccountAuthenticator.TAG, 2)) {
                    bundle2.keySet();
                    Log.v(AbstractAccountAuthenticator.TAG, "confirmCredentials: result " + AccountManager.sanitizeResult(bundle2));
                }
                if (bundle2 == null) return;
            }
            catch (Exception exception) {
                AbstractAccountAuthenticator.this.handleException(iAccountAuthenticatorResponse, "confirmCredentials", account.toString(), exception);
                return;
            }
            iAccountAuthenticatorResponse.onResult(bundle2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void editProperties(IAccountAuthenticatorResponse iAccountAuthenticatorResponse, String string2) throws RemoteException {
            Bundle bundle;
            AbstractAccountAuthenticator.this.checkBinderPermission();
            try {
                bundle = AbstractAccountAuthenticator.this.editProperties(new AccountAuthenticatorResponse(iAccountAuthenticatorResponse), string2);
                if (bundle == null) return;
            }
            catch (Exception exception) {
                AbstractAccountAuthenticator.this.handleException(iAccountAuthenticatorResponse, "editProperties", string2, exception);
                return;
            }
            iAccountAuthenticatorResponse.onResult(bundle);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void getAccountCredentialsForCloning(IAccountAuthenticatorResponse iAccountAuthenticatorResponse, Account account) throws RemoteException {
            Bundle bundle;
            AbstractAccountAuthenticator.this.checkBinderPermission();
            try {
                bundle = AbstractAccountAuthenticator.this.getAccountCredentialsForCloning(new AccountAuthenticatorResponse(iAccountAuthenticatorResponse), account);
                if (bundle == null) return;
            }
            catch (Exception exception) {
                AbstractAccountAuthenticator.this.handleException(iAccountAuthenticatorResponse, "getAccountCredentialsForCloning", account.toString(), exception);
                return;
            }
            iAccountAuthenticatorResponse.onResult(bundle);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void getAccountRemovalAllowed(IAccountAuthenticatorResponse iAccountAuthenticatorResponse, Account account) throws RemoteException {
            Bundle bundle;
            AbstractAccountAuthenticator.this.checkBinderPermission();
            try {
                bundle = AbstractAccountAuthenticator.this.getAccountRemovalAllowed(new AccountAuthenticatorResponse(iAccountAuthenticatorResponse), account);
                if (bundle == null) return;
            }
            catch (Exception exception) {
                AbstractAccountAuthenticator.this.handleException(iAccountAuthenticatorResponse, "getAccountRemovalAllowed", account.toString(), exception);
                return;
            }
            iAccountAuthenticatorResponse.onResult(bundle);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void getAuthToken(IAccountAuthenticatorResponse iAccountAuthenticatorResponse, Account account, String string2, Bundle bundle) throws RemoteException {
            Bundle bundle2;
            if (Log.isLoggable(AbstractAccountAuthenticator.TAG, 2)) {
                Log.v(AbstractAccountAuthenticator.TAG, "getAuthToken: " + account + ", authTokenType " + string2);
            }
            AbstractAccountAuthenticator.this.checkBinderPermission();
            try {
                bundle2 = AbstractAccountAuthenticator.this.getAuthToken(new AccountAuthenticatorResponse(iAccountAuthenticatorResponse), account, string2, bundle);
                if (Log.isLoggable(AbstractAccountAuthenticator.TAG, 2)) {
                    bundle2.keySet();
                    Log.v(AbstractAccountAuthenticator.TAG, "getAuthToken: result " + AccountManager.sanitizeResult(bundle2));
                }
                if (bundle2 == null) return;
            }
            catch (Exception exception) {
                AbstractAccountAuthenticator.this.handleException(iAccountAuthenticatorResponse, "getAuthToken", account.toString() + "," + string2, exception);
                return;
            }
            iAccountAuthenticatorResponse.onResult(bundle2);
        }

        @Override
        public void getAuthTokenLabel(IAccountAuthenticatorResponse iAccountAuthenticatorResponse, String string2) throws RemoteException {
            if (Log.isLoggable(AbstractAccountAuthenticator.TAG, 2)) {
                Log.v(AbstractAccountAuthenticator.TAG, "getAuthTokenLabel: authTokenType " + string2);
            }
            AbstractAccountAuthenticator.this.checkBinderPermission();
            try {
                Bundle bundle = new Bundle();
                bundle.putString("authTokenLabelKey", AbstractAccountAuthenticator.this.getAuthTokenLabel(string2));
                if (Log.isLoggable(AbstractAccountAuthenticator.TAG, 2)) {
                    bundle.keySet();
                    Log.v(AbstractAccountAuthenticator.TAG, "getAuthTokenLabel: result " + AccountManager.sanitizeResult(bundle));
                }
                iAccountAuthenticatorResponse.onResult(bundle);
                return;
            }
            catch (Exception exception) {
                AbstractAccountAuthenticator.this.handleException(iAccountAuthenticatorResponse, "getAuthTokenLabel", string2, exception);
                return;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void hasFeatures(IAccountAuthenticatorResponse iAccountAuthenticatorResponse, Account account, String[] stringArray) throws RemoteException {
            Bundle bundle;
            AbstractAccountAuthenticator.this.checkBinderPermission();
            try {
                bundle = AbstractAccountAuthenticator.this.hasFeatures(new AccountAuthenticatorResponse(iAccountAuthenticatorResponse), account, stringArray);
                if (bundle == null) return;
            }
            catch (Exception exception) {
                AbstractAccountAuthenticator.this.handleException(iAccountAuthenticatorResponse, "hasFeatures", account.toString(), exception);
                return;
            }
            iAccountAuthenticatorResponse.onResult(bundle);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void updateCredentials(IAccountAuthenticatorResponse iAccountAuthenticatorResponse, Account account, String string2, Bundle bundle) throws RemoteException {
            Bundle bundle2;
            if (Log.isLoggable(AbstractAccountAuthenticator.TAG, 2)) {
                Log.v(AbstractAccountAuthenticator.TAG, "updateCredentials: " + account + ", authTokenType " + string2);
            }
            AbstractAccountAuthenticator.this.checkBinderPermission();
            try {
                bundle2 = AbstractAccountAuthenticator.this.updateCredentials(new AccountAuthenticatorResponse(iAccountAuthenticatorResponse), account, string2, bundle);
                if (Log.isLoggable(AbstractAccountAuthenticator.TAG, 2)) {
                    bundle2.keySet();
                    Log.v(AbstractAccountAuthenticator.TAG, "updateCredentials: result " + AccountManager.sanitizeResult(bundle2));
                }
                if (bundle2 == null) return;
            }
            catch (Exception exception) {
                AbstractAccountAuthenticator.this.handleException(iAccountAuthenticatorResponse, "updateCredentials", account.toString() + "," + string2, exception);
                return;
            }
            iAccountAuthenticatorResponse.onResult(bundle2);
        }
    }
}

