/*
 * Decompiled with CFR 0.152.
 */
package soot.shimple.toolkits.scalar;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.Local;
import soot.PatchingChain;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.shimple.ShimpleBody;
import soot.toolkits.scalar.LocalDefs;

public class ShimpleLocalDefs
implements LocalDefs {
    protected Map<Value, List<Unit>> localToDefs;

    public ShimpleLocalDefs(ShimpleBody sb) {
        if (!sb.isSSA()) {
            throw new RuntimeException("ShimpleBody is not in proper SSA form as required by ShimpleLocalDefs.  You may need to rebuild it or use SimpleLocalDefs instead.");
        }
        PatchingChain<Unit> unitsChain = sb.getUnits();
        Iterator unitsIt = unitsChain.iterator();
        this.localToDefs = new HashMap<Value, List<Unit>>(unitsChain.size() * 2 + 1, 0.7f);
        while (unitsIt.hasNext()) {
            Unit unit = (Unit)unitsIt.next();
            Iterator<ValueBox> defBoxesIt = unit.getDefBoxes().iterator();
            while (defBoxesIt.hasNext()) {
                Value value = defBoxesIt.next().getValue();
                if (!(value instanceof Local)) continue;
                this.localToDefs.put(value, Collections.singletonList(unit));
            }
        }
    }

    public List<Unit> getDefsOf(Local l) {
        List<Unit> defs = this.localToDefs.get(l);
        if (defs == null) {
            throw new RuntimeException("Local not found in Body.");
        }
        return defs;
    }

    @Override
    public List<Unit> getDefsOfAt(Local l, Unit s) {
        Iterator<ValueBox> boxIt = s.getUseBoxes().iterator();
        boolean defined = false;
        while (boxIt.hasNext()) {
            Value value = boxIt.next().getValue();
            if (!value.equals(l)) continue;
            defined = true;
            break;
        }
        if (!defined) {
            throw new RuntimeException("Illegal LocalDefs query; local " + l + " is not being used at " + s);
        }
        return this.getDefsOf(l);
    }
}

