/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Local;
import soot.PatchingChain;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.AssignStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NewExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.Stmt;
import soot.options.Options;
import soot.toolkits.graph.BriefUnitGraph;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.scalar.ForwardFlowAnalysis;
import soot.util.HashMultiMap;
import soot.util.MultiMap;

public class JimpleConstructorFolder
extends BodyTransformer {
    static boolean isNew(Stmt s) {
        if (!(s instanceof AssignStmt)) {
            return false;
        }
        return JimpleConstructorFolder.rhs(s) instanceof NewExpr;
    }

    static boolean isConstructor(Stmt s) {
        if (!(s instanceof InvokeStmt)) {
            return false;
        }
        InvokeStmt is = (InvokeStmt)s;
        InvokeExpr expr = is.getInvokeExpr();
        if (!(expr instanceof SpecialInvokeExpr)) {
            return false;
        }
        SpecialInvokeExpr sie = (SpecialInvokeExpr)expr;
        return sie.getMethodRef().name().equals("<init>");
    }

    static Local base(Stmt s) {
        InvokeStmt is = (InvokeStmt)s;
        InstanceInvokeExpr expr = (InstanceInvokeExpr)is.getInvokeExpr();
        return (Local)expr.getBase();
    }

    static void setBase(Stmt s, Local l) {
        InvokeStmt is = (InvokeStmt)s;
        InstanceInvokeExpr expr = (InstanceInvokeExpr)is.getInvokeExpr();
        expr.getBaseBox().setValue(l);
    }

    static boolean isCopy(Stmt s) {
        if (!(s instanceof AssignStmt)) {
            return false;
        }
        if (!(JimpleConstructorFolder.rhs(s) instanceof Local)) {
            return false;
        }
        return JimpleConstructorFolder.lhs(s) instanceof Local;
    }

    static Value rhs(Stmt s) {
        AssignStmt as = (AssignStmt)s;
        return as.getRightOp();
    }

    static Value lhs(Stmt s) {
        AssignStmt as = (AssignStmt)s;
        return as.getLeftOp();
    }

    static Local rhsLocal(Stmt s) {
        return (Local)JimpleConstructorFolder.rhs(s);
    }

    static Local lhsLocal(Stmt s) {
        return (Local)JimpleConstructorFolder.lhs(s);
    }

    @Override
    public void internalTransform(Body b, String phaseName, Map<String, String> options) {
        Fact before;
        Stmt s;
        JimpleBody body = (JimpleBody)b;
        if (Options.v().verbose()) {
            G.v().out.println("[" + body.getMethod().getName() + "] Folding Jimple constructors...");
        }
        Analysis analysis = new Analysis(new BriefUnitGraph(body));
        PatchingChain<Unit> units = body.getUnits();
        ArrayList<Unit> stmtList = new ArrayList<Unit>();
        stmtList.addAll(units);
        for (Unit u : stmtList) {
            s = (Stmt)u;
            if (JimpleConstructorFolder.isCopy(s) || JimpleConstructorFolder.isConstructor(s)) continue;
            before = (Fact)analysis.getFlowBefore(s);
            for (ValueBox usebox : s.getUseBoxes()) {
                Local local;
                Value value = usebox.getValue();
                if (!(value instanceof Local) || before.get(local = (Local)value) == null) continue;
                throw new RuntimeException("Use of an unitialized value before constructor call; are you sure this bytecode is verifiable?\n" + s);
            }
        }
        for (Unit u : stmtList) {
            s = (Stmt)u;
            if (!JimpleConstructorFolder.isNew(s)) continue;
            units.remove(s);
        }
        for (Unit u : stmtList) {
            Stmt newStmt;
            s = (Stmt)u;
            before = (Fact)analysis.getFlowBefore(s);
            Fact after = (Fact)analysis.getFlowAfter(s);
            if (JimpleConstructorFolder.isCopy(s)) {
                newStmt = before.get(JimpleConstructorFolder.rhsLocal(s));
                if (newStmt == null) continue;
                units.remove(s);
                continue;
            }
            if (after.alloc() == null) continue;
            newStmt = before.get(JimpleConstructorFolder.base(s));
            JimpleConstructorFolder.setBase(s, JimpleConstructorFolder.lhsLocal(newStmt));
            units.insertBefore(newStmt, (Unit)s);
            for (Local l : before.get(newStmt)) {
                if (l.equals(JimpleConstructorFolder.base(s))) continue;
                units.insertAfter(Jimple.v().newAssignStmt(l, JimpleConstructorFolder.base(s)), (Unit)s);
            }
        }
    }

    private class Analysis
    extends ForwardFlowAnalysis<Unit, Fact> {
        public Analysis(DirectedGraph<Unit> graph) {
            super(graph);
            this.doAnalysis();
        }

        @Override
        protected Fact newInitialFlow() {
            return new Fact();
        }

        @Override
        public void flowThrough(Fact in, Unit u, Fact out) {
            Stmt newStmt;
            Stmt s = (Stmt)u;
            this.copy(in, out);
            out.setAlloc(null);
            if (JimpleConstructorFolder.isNew(s)) {
                out.add(JimpleConstructorFolder.lhsLocal(s), s);
            } else if (JimpleConstructorFolder.isCopy(s)) {
                Stmt newStmt2 = out.get(JimpleConstructorFolder.rhsLocal(s));
                if (newStmt2 != null) {
                    out.add(JimpleConstructorFolder.lhsLocal(s), newStmt2);
                }
            } else if (JimpleConstructorFolder.isConstructor(s) && (newStmt = out.get(JimpleConstructorFolder.base(s))) != null) {
                out.removeAll(newStmt);
                out.setAlloc(newStmt);
            }
        }

        @Override
        public void copy(Fact source, Fact dest) {
            dest.copyFrom(source);
        }

        @Override
        public void merge(Fact in1, Fact in2, Fact out) {
            out.mergeFrom(in1, in2);
        }
    }

    private class Fact {
        private Map<Local, Stmt> varToStmt = new HashMap<Local, Stmt>();
        private MultiMap<Stmt, Local> stmtToVar = new HashMultiMap<Stmt, Local>();
        private Stmt alloc = null;

        private Fact() {
        }

        public void add(Local l, Stmt s) {
            this.varToStmt.put(l, s);
            this.stmtToVar.put(s, l);
        }

        public Stmt get(Local l) {
            return this.varToStmt.get(l);
        }

        public Set<Local> get(Stmt s) {
            return this.stmtToVar.get(s);
        }

        public void removeAll(Stmt s) {
            for (Local var : this.stmtToVar.get(s)) {
                this.varToStmt.remove(var);
            }
            this.stmtToVar.remove(s);
        }

        public void copyFrom(Fact in) {
            this.varToStmt = new HashMap<Local, Stmt>(in.varToStmt);
            this.stmtToVar = new HashMultiMap<Stmt, Local>(in.stmtToVar);
            this.alloc = in.alloc;
        }

        public void mergeFrom(Fact in1, Fact in2) {
            Stmt newStmt;
            Local l;
            this.varToStmt = new HashMap<Local, Stmt>();
            for (Map.Entry<Local, Stmt> e : in1.varToStmt.entrySet()) {
                Stmt newStmt2;
                l = e.getKey();
                newStmt = e.getValue();
                if (in2.varToStmt.containsKey(l) && !newStmt.equals(newStmt2 = in2.varToStmt.get(l))) {
                    throw new RuntimeException("Merge of different uninitialized values; are you sure this bytecode is verifiable?");
                }
                this.add(l, newStmt);
            }
            for (Map.Entry<Local, Stmt> e : in2.varToStmt.entrySet()) {
                l = e.getKey();
                newStmt = e.getValue();
                this.add(l, newStmt);
            }
            this.alloc = in1.alloc != null && in1.alloc.equals(in2.alloc) ? in1.alloc : null;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Fact)) {
                return false;
            }
            Fact o = (Fact)other;
            if (!this.stmtToVar.equals(o.stmtToVar)) {
                return false;
            }
            if (this.alloc == null && o.alloc != null) {
                return false;
            }
            if (this.alloc != null && o.alloc == null) {
                return false;
            }
            return this.alloc == null || this.alloc.equals(o.alloc);
        }

        public Stmt alloc() {
            return this.alloc;
        }

        public void setAlloc(Stmt newAlloc) {
            this.alloc = newAlloc;
        }
    }
}

