/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.iface.AnnotationElement;
import org.jf.dexlib2.iface.DexFile;
import org.jf.dexlib2.iface.Method;
import org.jf.dexlib2.iface.value.ArrayEncodedValue;
import org.jf.dexlib2.iface.value.EncodedValue;
import org.jf.dexlib2.iface.value.TypeEncodedValue;
import soot.Body;
import soot.G;
import soot.MethodSource;
import soot.Modifier;
import soot.SootClass;
import soot.SootMethod;
import soot.SootResolver;
import soot.Type;
import soot.Unit;
import soot.dexpler.Debug;
import soot.dexpler.DexBody;
import soot.dexpler.DexType;
import soot.dexpler.InvalidDalvikBytecodeException;
import soot.dexpler.Util;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.toolkits.typing.TypeAssigner;
import soot.options.Options;

public class DexMethod {
    private DexMethod() {
    }

    /*
     * WARNING - void declaration
     */
    public static SootMethod makeSootMethod(DexFile dexFile, Method method, SootClass declaringClass) {
        void var9_14;
        int n;
        HashSet<Type> types = new HashSet<Type>();
        int accessFlags = method.getAccessFlags();
        ArrayList<Type> parameterTypes = new ArrayList<Type>();
        String name = method.getName();
        Debug.printDbg("processing method '", method.getDefiningClass(), ": ", method.getReturnType(), " ", method.getName(), " p: ", method.getParameters(), "'");
        ArrayList<SootClass> thrownExceptions = new ArrayList<SootClass>();
        for (Annotation annotation2 : method.getAnnotations()) {
            Type type = DexType.toSoot(annotation2.getType());
            String atypes = type.toString();
            if (!atypes.equals("dalvik.annotation.Throws")) continue;
            for (AnnotationElement annotationElement : annotation2.getElements()) {
                EncodedValue ev = annotationElement.getValue();
                if (!(ev instanceof ArrayEncodedValue)) continue;
                for (EncodedValue encodedValue : ((ArrayEncodedValue)ev).getValue()) {
                    if (!(encodedValue instanceof TypeEncodedValue)) continue;
                    TypeEncodedValue valueType = (TypeEncodedValue)encodedValue;
                    String exceptionName = valueType.getValue();
                    String dottedName = Util.dottedClassName(exceptionName);
                    thrownExceptions.add(SootResolver.v().makeClassRef(dottedName));
                }
            }
        }
        if (method.getParameters() != null) {
            List<? extends CharSequence> parameters = method.getParameterTypes();
            for (CharSequence charSequence : parameters) {
                Type type = DexType.toSoot(charSequence.toString());
                parameterTypes.add(type);
                types.add(type);
            }
        }
        Type returnType = DexType.toSoot(method.getReturnType());
        types.add(returnType);
        SootMethod sootMethod = declaringClass.getMethodUnsafe(name, parameterTypes, returnType);
        if (sootMethod == null) {
            SootMethod sootMethod2 = new SootMethod(name, parameterTypes, returnType, accessFlags, thrownExceptions);
        }
        if (Modifier.isAbstract(n = method.getAccessFlags()) || Modifier.isNative(n)) {
            return var9_14;
        }
        if (Options.v().oaat() && declaringClass.resolvingLevel() <= 2) {
            return var9_14;
        }
        final DexBody dexBody = new DexBody(dexFile, method, declaringClass.getType());
        for (Type type : dexBody.usedTypes()) {
            types.add(type);
        }
        var9_14.setSource(new MethodSource(){

            @Override
            public Body getBody(SootMethod m, String phaseName) {
                JimpleBody b = Jimple.v().newBody(m);
                try {
                    dexBody.jimplify(b, m);
                }
                catch (InvalidDalvikBytecodeException e) {
                    String msg = "Warning: Invalid bytecode in method " + m + ": " + e;
                    G.v().out.println(msg);
                    Util.emptyBody(b);
                    Util.addExceptionAfterUnit(b, "java.lang.RuntimeException", (Unit)b.getUnits().getLast(), "Soot has detected that this method contains invalid Dalvik bytecode which would have throw an exception at runtime. [" + msg + "]");
                    TypeAssigner.v().transform(b);
                }
                m.setActiveBody(b);
                return m.getActiveBody();
            }
        });
        return var9_14;
    }
}

