/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import soot.JastAddJ.ASTNode;
import soot.JastAddJ.ASTNode$State;
import soot.JastAddJ.Binary;
import soot.JastAddJ.Body;
import soot.JastAddJ.BooleanType;
import soot.JastAddJ.Expr;
import soot.JastAddJ.GEExpr;
import soot.JastAddJ.GTExpr;
import soot.JastAddJ.TypeDecl;
import soot.Local;
import soot.Value;
import soot.jimple.Stmt;

public abstract class RelationalExpr
extends Binary
implements Cloneable {
    protected boolean type_computed = false;
    protected TypeDecl type_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.type_computed = false;
        this.type_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public RelationalExpr clone() throws CloneNotSupportedException {
        RelationalExpr node = (RelationalExpr)super.clone();
        node.type_computed = false;
        node.type_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    @Override
    public void typeCheck() {
        if (!this.getLeftOperand().type().isNumericType()) {
            this.error(this.getLeftOperand().type().typeName() + " is not numeric");
        }
        if (!this.getRightOperand().type().isNumericType()) {
            this.error(this.getRightOperand().type().typeName() + " is not numeric");
        }
    }

    @Override
    public Value eval(Body b) {
        return this.emitBooleanCondition(b);
    }

    @Override
    public void emitEvalBranch(Body b) {
        b.setLine(this);
        if (this.isTrue()) {
            b.add(b.newGotoStmt(this.true_label(), this));
        } else if (this.isFalse()) {
            b.add(b.newGotoStmt(this.false_label(), this));
        } else {
            TypeDecl type = this.getLeftOperand().type();
            if (type.isNumericType()) {
                type = this.binaryNumericPromotedType();
                Value left = this.getLeftOperand().type().emitCastTo(b, this.getLeftOperand(), type);
                Value right = this.getRightOperand().type().emitCastTo(b, this.getRightOperand(), type);
                if (type.isDouble() || type.isFloat() || type.isLong()) {
                    Local l = type.isDouble() || type.isFloat() ? (this instanceof GEExpr || this instanceof GTExpr ? this.asLocal(b, b.newCmplExpr(this.asImmediate(b, left), this.asImmediate(b, right), this)) : this.asLocal(b, b.newCmpgExpr(this.asImmediate(b, left), this.asImmediate(b, right), this))) : this.asLocal(b, b.newCmpExpr(this.asImmediate(b, left), this.asImmediate(b, right), this));
                    b.add(b.newIfStmt(this.comparisonInv(b, l, BooleanType.emitConstant(false)), this.false_label(), this));
                    b.add(b.newGotoStmt(this.true_label(), this));
                } else {
                    b.add(b.newIfStmt(this.comparison(b, left, right), this.true_label(), this));
                    b.add(b.newGotoStmt(this.false_label(), this));
                }
            } else {
                Value left = this.getLeftOperand().eval(b);
                Value right = this.getRightOperand().eval(b);
                b.add(b.newIfStmt(this.comparison(b, left, right), this.true_label(), this));
                b.add(b.newGotoStmt(this.false_label(), this));
            }
        }
    }

    public Value comparison(Body b, Value left, Value right) {
        throw new Error("comparison not supported for " + this.getClass().getName());
    }

    public Value comparisonInv(Body b, Value left, Value right) {
        throw new Error("comparisonInv not supported for " + this.getClass().getName());
    }

    public RelationalExpr() {
    }

    @Override
    public void init$Children() {
        this.children = new ASTNode[2];
    }

    public RelationalExpr(Expr p0, Expr p1) {
        this.setChild(p0, 0);
        this.setChild(p1, 1);
    }

    @Override
    protected int numChildren() {
        return 2;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    @Override
    public void setLeftOperand(Expr node) {
        this.setChild(node, 0);
    }

    @Override
    public Expr getLeftOperand() {
        return (Expr)this.getChild(0);
    }

    @Override
    public Expr getLeftOperandNoTransform() {
        return (Expr)this.getChildNoTransform(0);
    }

    @Override
    public void setRightOperand(Expr node) {
        this.setChild(node, 1);
    }

    @Override
    public Expr getRightOperand() {
        return (Expr)this.getChild(1);
    }

    @Override
    public Expr getRightOperandNoTransform() {
        return (Expr)this.getChildNoTransform(1);
    }

    @Override
    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        return this.typeBoolean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean definesLabel() {
        ASTNode$State state = this.state();
        boolean bl = false;
        return bl;
    }

    @Override
    public Stmt Define_soot_jimple_Stmt_condition_false_label(ASTNode caller, ASTNode child) {
        if (caller == this.getRightOperandNoTransform()) {
            return this.false_label();
        }
        if (caller == this.getLeftOperandNoTransform()) {
            return this.false_label();
        }
        return this.getParent().Define_soot_jimple_Stmt_condition_false_label(this, caller);
    }

    @Override
    public Stmt Define_soot_jimple_Stmt_condition_true_label(ASTNode caller, ASTNode child) {
        if (caller == this.getRightOperandNoTransform()) {
            return this.true_label();
        }
        if (caller == this.getLeftOperandNoTransform()) {
            return this.true_label();
        }
        return this.getParent().Define_soot_jimple_Stmt_condition_true_label(this, caller);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

