/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.util;

import com.google.common.base.Predicate;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.AccessFlags;
import org.jf.dexlib2.iface.Method;
import org.jf.dexlib2.iface.reference.MethodReference;

public final class MethodUtil {
    private static int directMask = AccessFlags.STATIC.getValue() | AccessFlags.PRIVATE.getValue() | AccessFlags.CONSTRUCTOR.getValue();
    public static Predicate<Method> METHOD_IS_DIRECT = new Predicate<Method>(){

        @Override
        public boolean apply(@Nullable Method input) {
            return input != null && MethodUtil.isDirect(input);
        }
    };
    public static Predicate<Method> METHOD_IS_VIRTUAL = new Predicate<Method>(){

        @Override
        public boolean apply(@Nullable Method input) {
            return input != null && !MethodUtil.isDirect(input);
        }
    };

    public static boolean isDirect(@Nonnull Method method) {
        return (method.getAccessFlags() & directMask) != 0;
    }

    public static boolean isStatic(@Nonnull Method method) {
        return AccessFlags.STATIC.isSet(method.getAccessFlags());
    }

    public static boolean isConstructor(@Nonnull MethodReference methodReference) {
        return methodReference.getName().equals("<init>");
    }

    public static int getParameterRegisterCount(@Nonnull Method method) {
        return MethodUtil.getParameterRegisterCount(method, MethodUtil.isStatic(method));
    }

    public static int getParameterRegisterCount(@Nonnull MethodReference methodRef, boolean isStatic) {
        return MethodUtil.getParameterRegisterCount(methodRef.getParameterTypes(), isStatic);
    }

    public static int getParameterRegisterCount(@Nonnull Collection<? extends CharSequence> parameterTypes, boolean isStatic) {
        int regCount = 0;
        for (CharSequence charSequence : parameterTypes) {
            char firstChar = charSequence.charAt(0);
            if (firstChar == 'J' || firstChar == 'D') {
                regCount += 2;
                continue;
            }
            ++regCount;
        }
        if (!isStatic) {
            ++regCount;
        }
        return regCount;
    }

    private static char getShortyType(CharSequence type) {
        if (type.length() > 1) {
            return 'L';
        }
        return type.charAt(0);
    }

    public static String getShorty(Collection<? extends CharSequence> params, String returnType) {
        StringBuilder sb = new StringBuilder(params.size() + 1);
        sb.append(MethodUtil.getShortyType(returnType));
        for (CharSequence charSequence : params) {
            sb.append(MethodUtil.getShortyType(charSequence));
        }
        return sb.toString();
    }

    private MethodUtil() {
    }
}

