/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.utilities;

import gnu.trove.map.hash.TCustomHashMap;
import gnu.trove.procedure.TObjectProcedure;
import gnu.trove.set.hash.TCustomHashSet;
import gnu.trove.strategy.HashingStrategy;
import java.util.Collection;
import java.util.LinkedList;

public class TCustomHashMultimap<K, V>
extends TCustomHashMap<K, TCustomHashSet<V>> {
    private final HashingStrategy<? super V> valueStrategy;

    public TCustomHashMultimap(HashingStrategy<? super K> keyStrategy, HashingStrategy<? super V> valueStrategy) {
        super(keyStrategy);
        this.valueStrategy = valueStrategy;
    }

    public int totalSize() {
        TTotalSizeProc p = new TTotalSizeProc();
        super.forEachValue((TObjectProcedure)p);
        return p.totalSize;
    }

    public boolean containsValue(final Object o) {
        return !super.forEachValue(new TObjectProcedure<TCustomHashSet<V>>(){

            public boolean execute(TCustomHashSet<V> set) {
                return !set.contains(o);
            }
        });
    }

    public boolean containsValueSet(Object o) {
        return super.contains(o);
    }

    public boolean putSingleEntry(K key, V value) {
        TCustomHashSet set = (TCustomHashSet)super.get(key);
        if (set == null) {
            boolean changed;
            set = new TCustomHashSet(this.valueStrategy);
            boolean bl = changed = super.put(key, (Object)set) == null;
            return changed && set.add(value);
        }
        return set.add(value);
    }

    public Collection<V> singleValues() {
        final LinkedList vals = new LinkedList();
        super.forEachValue(new TObjectProcedure<TCustomHashSet<V>>(){

            public boolean execute(TCustomHashSet<V> set) {
                vals.addAll(set);
                return true;
            }
        });
        return vals;
    }

    public boolean remove(Object key, Object value) {
        TCustomHashSet set = (TCustomHashSet)super.get(key);
        if (set == null) {
            return false;
        }
        boolean removed = set.remove(value);
        if (removed && set.isEmpty()) {
            super.remove(key);
        }
        return removed;
    }

    public boolean forEachSingleValue(final TObjectProcedure<V> procedure) {
        return super.forEachValue(new TObjectProcedure<TCustomHashSet<V>>(){

            public boolean execute(TCustomHashSet<V> set) {
                return set.forEach(procedure);
            }
        });
    }

    private class TTotalSizeProc
    implements TObjectProcedure<TCustomHashSet<V>> {
        public int totalSize = 0;

        public boolean execute(TCustomHashSet<V> set) {
            this.totalSize += set.size();
            return true;
        }
    }
}

