/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.test.extension.lvl2a;

import de.upb.pga3.panda2.core.services.CoreServices;
import de.upb.pga3.panda2.extension.Enhancer;
import de.upb.pga3.panda2.extension.lvl2a.graphgenerator.CallBackAnalyser;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import soot.SootMethod;

public class JUnitCallBackAnalyserTest {
    Set<String> androidCallBacks;
    Set<String> entryPointClasses;

    @Test
    public void testCallBackAnalyser_1() throws Exception {
        CallBackAnalyser result = new CallBackAnalyser();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetActivityLayoutIDMap_1() throws Exception {
        CallBackAnalyser fixture = new CallBackAnalyser();
        fixture.setInputs(this.androidCallBacks, this.entryPointClasses);
        Map<String, List<Integer>> result = fixture.getActivityLayoutIDMap();
        Assert.assertNotNull(result);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testGetCallBackMethods_1() throws Exception {
        CallBackAnalyser fixture = new CallBackAnalyser();
        fixture.setInputs(this.androidCallBacks, this.entryPointClasses);
        Map<String, List<SootMethod>> result = fixture.getCallBackMethods();
        Assert.assertNotNull(result);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testGetInstance_1() throws Exception {
        CallBackAnalyser result = CallBackAnalyser.getInstance();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testSetInputs_1() throws Exception {
        CallBackAnalyser fixture = new CallBackAnalyser();
        fixture.setInputs(this.androidCallBacks, this.entryPointClasses);
        Assert.assertNotNull(this.androidCallBacks);
        Assert.assertNotNull(this.entryPointClasses);
    }

    @Before
    public void setUp() throws Exception {
        String apkLoc = "test_resources/Lvl2AMoreTestCases/WordSwirlV2.apk";
        Path apkPath = Paths.get("test_resources/Lvl2AMoreTestCases/WordSwirlV2.apk", new String[0]);
        Enhancer enhancer = new Enhancer();
        enhancer.enhance(apkPath);
        this.androidCallBacks = CoreServices.getDataStorageInstance().getCallBackClasses();
        List<String> lstActivities = CoreServices.getXMLParserInstance().getLstActivities();
        List<String> lstProviders = CoreServices.getXMLParserInstance().getLstProviders();
        List<String> lstReceivers = CoreServices.getXMLParserInstance().getLstReceivers();
        List<String> lstServices = CoreServices.getXMLParserInstance().getLstServices();
        HashSet<String> entryPoints = new HashSet<String>();
        if (lstActivities != null) {
            for (String actName : lstActivities) {
                entryPoints.add(actName);
            }
        }
        if (lstProviders != null) {
            for (String proName : lstProviders) {
                entryPoints.add(proName);
            }
        }
        if (lstReceivers != null) {
            for (String recName : lstReceivers) {
                entryPoints.add(recName);
            }
        }
        if (lstServices != null) {
            for (String serName : lstServices) {
                entryPoints.add(serName);
            }
        }
        this.entryPointClasses = entryPoints;
    }

    @After
    public void tearDown() throws Exception {
    }

    public static void main(String[] args) {
        new JUnitCore().run(new Class[]{JUnitCallBackAnalyserTest.class});
    }
}

