/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.test.extension.lvl2a;

import de.upb.pga3.panda2.core.datastructures.AnalysisGraph;
import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.core.datastructures.Permission;
import de.upb.pga3.panda2.extension.lvl2a.AnalysisGraphLvl2a;
import de.upb.pga3.panda2.extension.lvl2a.analyzer.BackwardSlicer;
import de.upb.pga3.panda2.extension.lvl2a.analyzer.SourceAndSinkComputer;
import de.upb.pga3.panda2.test.extension.lvl2a.TestCodeFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import soot.Unit;

public class BackwardSlicerTest {
    @Test
    public void testConstructor() {
        BackwardSlicer mBackwardSlicer = new BackwardSlicer();
        Assert.assertNotNull((Object)mBackwardSlicer);
    }

    @Test
    public void testSlicingAlgo() {
        BackwardSlicer mBackwardSlicer = new BackwardSlicer();
        SourceAndSinkComputer fixture = new SourceAndSinkComputer();
        AnalysisGraph graph = TestCodeFactory.createAnalysisGraph("test_resources/ExpoAppLvl2a.apk");
        Object[] lstNode = graph.getNodes().toArray();
        ArrayList<Unit> lstNodeUnit = new ArrayList<Unit>();
        if (lstNode != null && lstNode.length > 0) {
            Object[] objectArray = lstNode;
            int n = lstNode.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof Unit) {
                    lstNodeUnit.add((Unit)obj);
                }
                ++n2;
            }
        }
        Map<Permission, List<Unit>> sinks = fixture.computeSinks(lstNodeUnit, (EnhancedInput)graph.getInput());
        Map<Permission, List<Unit>> sources = fixture.computeSources(lstNodeUnit, (EnhancedInput)graph.getInput());
        for (Map.Entry entry : sinks.entrySet()) {
            Permission perm = (Permission)entry.getKey();
            List lstSinks = (List)entry.getValue();
            for (Unit sink : lstSinks) {
                Map<Permission, List<Unit>> mapPermSources = mBackwardSlicer.slice((AnalysisGraphLvl2a)graph, sink, sources);
                Assert.assertNotNull(mapPermSources);
            }
        }
    }

    @Test
    public void testSlicingAlgo2() {
        BackwardSlicer mBackwardSlicer = new BackwardSlicer();
        SourceAndSinkComputer fixture = new SourceAndSinkComputer();
        AnalysisGraph graph = TestCodeFactory.createAnalysisGraph("test_resources/TestIfElseCase.apk");
        Object[] lstNode = graph.getNodes().toArray();
        ArrayList<Unit> lstNodeUnit = new ArrayList<Unit>();
        if (lstNode != null && lstNode.length > 0) {
            Object[] objectArray = lstNode;
            int n = lstNode.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof Unit) {
                    lstNodeUnit.add((Unit)obj);
                }
                ++n2;
            }
        }
        Map<Permission, List<Unit>> sinks = fixture.computeSinks(lstNodeUnit, (EnhancedInput)graph.getInput());
        Map<Permission, List<Unit>> sources = fixture.computeSources(lstNodeUnit, (EnhancedInput)graph.getInput());
        for (Map.Entry entry : sinks.entrySet()) {
            Permission perm = (Permission)entry.getKey();
            List lstSinks = (List)entry.getValue();
            for (Unit sink : lstSinks) {
                Map<Permission, List<Unit>> mapPermSources = mBackwardSlicer.slice((AnalysisGraphLvl2a)graph, sink, sources);
                Assert.assertNotNull(mapPermSources);
            }
        }
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    public static void main(String[] args) {
        new JUnitCore().run(new Class[]{BackwardSlicerTest.class});
    }
}

