/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.test.core.services;

import de.upb.pga3.panda2.core.SootAdapter;
import de.upb.pga3.panda2.core.services.A3XMLParser;
import de.upb.pga3.panda2.core.services.ARSCParser;
import de.upb.pga3.panda2.core.services.LayoutBinaryParser;
import de.upb.pga3.panda2.core.services.XMLAttribute;
import de.upb.pga3.panda2.core.services.XMLDocument;
import de.upb.pga3.panda2.core.services.XMLHandler;
import de.upb.pga3.panda2.core.services.XMLLayoutParser;
import de.upb.pga3.panda2.core.services.XMLNamespace;
import de.upb.pga3.panda2.core.services.XMLNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import soot.Transform;

public class XMLDocumentTest {
    String apkfile;
    XMLLayoutParser layoutParser;

    @Test
    public void testXMLDocument_1() throws Exception {
        SootAdapter.getInstance().reinitSoot();
        A3XMLParser.getInstance().fetchData(this.apkfile);
        SootAdapter.getInstance().init(Paths.get(this.apkfile, new String[0]));
        XMLLayoutParser laypars = A3XMLParser.getInstance().getLayoutParser();
        Transform trans = new Transform("wjtp.laypars", laypars);
        SootAdapter.getInstance().addTransformer(trans, SootAdapter.SootPhase.WJTP);
        Assert.assertNotNull(laypars.getLayoutCallbackMethods());
        XMLDocument result = new XMLDocument();
        Assert.assertNotNull((Object)result);
        ARSCParser arscpars = A3XMLParser.getInstance().getArscParser();
        Assert.assertNotNull(arscpars.getPackages());
        Assert.assertNotNull(arscpars.getGlobalStringPool());
        Assert.assertNull((Object)arscpars.findResource(205587256));
        for (ARSCParser.ResPackage respk : arscpars.getPackages()) {
            Assert.assertNotNull((Object)respk.getPackageId());
            Assert.assertNotNull((Object)respk.getPackageName());
            Assert.assertNotNull(respk.getDeclaredTypes());
            for (ARSCParser.ResType rest : respk.getDeclaredTypes()) {
                Assert.assertNotNull(rest.getAllResources());
                for (ARSCParser.AbstractResource abrs : rest.getAllResources()) {
                    Assert.assertNotNull((Object)abrs.getResourceName());
                    Assert.assertNotNull((Object)abrs.getResourceID());
                }
                Assert.assertNull((Object)rest.getResourceByName("activity_main.xml"));
                Assert.assertNotNull((Object)rest.getTypeName());
                Assert.assertNull((Object)rest.getFirstResource("activity_main.xml"));
                Assert.assertNull((Object)rest.getFirstResource(25888972));
            }
        }
        File apkFile = new File(this.apkfile);
        if (!apkFile.exists()) {
            throw new RuntimeException("File " + this.apkfile + " doesn't exist.");
        }
        try {
            ZipFile zFile = new ZipFile(apkFile);
            Enumeration<? extends ZipEntry> entries = zFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String entryName = entry.getName();
                this.parseLayoutFile(entryName, zFile.getInputStream(entry));
            }
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void parseLayoutFile(String fileName, InputStream iStream) {
        if (!fileName.startsWith("res/layout")) {
            return;
        }
        if (!fileName.endsWith(".xml")) {
            return;
        }
        if (!fileName.startsWith("res/layout")) {
            return;
        }
        try {
            XMLHandler handler = new XMLHandler(iStream, new LayoutBinaryParser());
            XMLNode root = handler.getDocument().getRootNode();
            Assert.assertNotNull((Object)root);
            XMLDocument doc = handler.getDocument();
            Assert.assertNotNull(doc.getNamespaces());
            for (XMLNamespace ns : doc.getNamespaces()) {
                Assert.assertNotNull((Object)ns.getLine());
            }
            Assert.assertNotNull(root.getChildrenWithTag("activity"));
            root.setNameSpace("dummy namespace");
            Assert.assertNotNull((Object)root.getNameSpace());
            root.setAdded(true);
            Assert.assertNull(root.getAttribute("domain"));
            Assert.assertNotNull((Object)root.getParent());
            Assert.assertSame((Object)false, (Object)root.hasAttribute("name"));
            Assert.assertNotNull(root.getAttributes());
            Map<String, XMLAttribute<?>> attributes = root.getAttributes();
            for (String attrName : attributes.keySet()) {
                XMLAttribute<?> attr = attributes.get(attrName);
                Assert.assertNotNull(attr.getValue());
                Assert.assertNotNull((Object)attr.getResourceId());
                Assert.assertNotNull((Object)attr.getAttributeType());
                Assert.assertNotNull((Object)attr.getType());
            }
            XMLAttribute<Integer> attr1 = new XMLAttribute<Integer>("Dummy1", 0, "dummynamespace");
            XMLAttribute<Integer> attr2 = new XMLAttribute<Integer>("Dummy2", 205587, 0, "dummynamespace");
            XMLAttribute<Integer> attr3 = new XMLAttribute<Integer>("Dummy3", 205587, 0, "dummynamespace", true);
            Assert.assertTrue((!attr1.equals(attr2) ? 1 : 0) != 0);
            attr3.setValue(25);
            attr2.setAdded(true);
            attr1.setNameSpace("dummyns");
            root.addAttribute(attr1);
            root.addAttribute(attr2);
            root.addAttribute(attr3);
            XMLNode child1 = new XMLNode("ChildNode", "dummyns", root, true);
            root.addSiblingAfter(child1);
            root.addSiblingBefore(child1);
            root.addChild(child1);
            child1.setParent(root);
            Assert.assertNotNull(root.getChildren());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Before
    public void setUp() throws Exception {
        this.apkfile = "test_resources/Lvl2AMoreTestCases/WordSwirlV2.apk";
    }

    @After
    public void tearDown() throws Exception {
    }

    public static void main(String[] args) {
        new JUnitCore().run(new Class[]{XMLDocumentTest.class});
    }
}

