/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.extension.lvl2b.analyzer;

import de.upb.pga3.panda2.core.datastructures.AnalysisGraph;
import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.core.datastructures.Message;
import de.upb.pga3.panda2.core.datastructures.MessageType;
import de.upb.pga3.panda2.core.datastructures.Permission;
import de.upb.pga3.panda2.core.datastructures.ResultInput;
import de.upb.pga3.panda2.core.services.CoreServices;
import de.upb.pga3.panda2.extension.lvl1.AnalysisResultLvl1;
import de.upb.pga3.panda2.extension.lvl2b.AnalysisResultLvl2b;
import de.upb.pga3.panda2.extension.lvl2b.ResultLeafLvl2b;
import de.upb.pga3.panda2.extension.lvl2b.ResultTreeLvl2b;
import de.upb.pga3.panda2.extension.lvl2b.analyzer.FixpointComputer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import soot.SootClass;

public class ManifestPermissionComparerLvl2b {
    private EnhancedInput currentEnhancedInput;
    private AnalysisGraph graph;
    private ResultInput ri;
    private Collection<Permission> allPermissions;
    private ResultLeafLvl2b resultApp;
    private ResultTreeLvl2b resultComponents = new ResultTreeLvl2b();
    private AnalysisResultLvl2b anaResult;
    private boolean allmode;
    private Map<Object, List<Permission>> mapIndirectPermissions;
    private Map<Object, List<Permission>> mapBothPermissions;
    boolean flagMissingMessage = false;
    boolean flagMaybeMissingMessage = false;
    boolean flagUnusedMessage = false;
    boolean flagMaybeRequiredMessage = false;

    public ManifestPermissionComparerLvl2b(boolean allmode) {
        this.allmode = allmode;
    }

    public AnalysisResultLvl2b compare(AnalysisGraph inGraph) {
        this.mapIndirectPermissions = new HashMap<Object, List<Permission>>();
        this.mapBothPermissions = new HashMap<Object, List<Permission>>();
        this.graph = inGraph;
        this.ri = (ResultInput)this.graph.getInput();
        this.currentEnhancedInput = (EnhancedInput)((AnalysisResultLvl1)this.ri.getResults().get(this.ri.getResults().size() - 1)).getAnalysisGraph().getInput();
        this.resultApp = new ResultLeafLvl2b(this.currentEnhancedInput.getAppName());
        this.allPermissions = CoreServices.getDataStorageInstance().getAllPermissions().values();
        FixpointComputer fpc = new FixpointComputer(this.graph, this, this.allmode);
        fpc.computeFixpoint();
        this.anaResult = new AnalysisResultLvl2b();
        this.anaResult.initialize(CoreServices.getXMLParserInstance());
        this.generateAnalysisResult();
        int i = 0;
        while (i < this.ri.getResults().size()) {
            EnhancedInput ei = (EnhancedInput)((AnalysisResultLvl1)this.ri.getResults().get(i)).getAnalysisGraph().getInput();
            if (!ei.getMaybeMoreList().isEmpty()) {
                this.anaResult.addMessage(new Message(MessageType.WARNING, "Target not found", "One or more targets of implicit intents could not be resolved."));
                break;
            }
            ++i;
        }
        return this.anaResult;
    }

    public void addIndirectPermission(Object object, Permission permission, EnhancedInput ei) {
        if (!ei.getPermissions(object).contains(permission)) {
            ei.addPermissionTo(object, permission);
            List<Permission> tempList = this.mapIndirectPermissions.get(object);
            if (tempList == null) {
                tempList = new ArrayList<Permission>();
            }
            tempList.add(permission);
            this.mapIndirectPermissions.remove(object);
            this.mapIndirectPermissions.put(object, tempList);
        } else {
            List<Permission> tempList = this.mapBothPermissions.get(object);
            if (tempList == null) {
                tempList = new ArrayList<Permission>();
            }
            tempList.add(permission);
            this.mapBothPermissions.remove(object);
            this.mapBothPermissions.put(object, tempList);
        }
    }

    private void generateAnalysisResult() {
        SootClass[] sootClassArray = this.currentEnhancedInput.getAppClasses();
        int n = sootClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            SootClass classOrComponentElement = sootClassArray[n2];
            if (!classOrComponentElement.isInterface()) {
                this.checkElement(classOrComponentElement);
            }
            ++n2;
        }
        this.checkElement(this.currentEnhancedInput);
        this.anaResult.setApp(this.resultApp);
        this.anaResult.setComponents(this.resultComponents);
    }

    private void checkElement(Object element) {
        boolean inMaybeMore = false;
        for (Permission permission : this.allPermissions) {
            boolean hasPermission = this.currentEnhancedInput.getPermissions().contains(permission);
            boolean assignedToDescendantDirect = false;
            boolean assignedToDescendantIndirect = false;
            if (this.currentEnhancedInput.getChildren(element) != null) {
                for (Object childElement : this.currentEnhancedInput.getChildren(element)) {
                    if (this.assignedToChild(childElement, permission, false)) {
                        assignedToDescendantDirect = true;
                    }
                    if (this.assignedToChild(childElement, permission, true)) {
                        assignedToDescendantIndirect = true;
                    }
                    if (assignedToDescendantDirect && assignedToDescendantIndirect) break;
                }
            }
            if (!(hasPermission && (assignedToDescendantDirect || assignedToDescendantIndirect) || !hasPermission && (assignedToDescendantDirect || assignedToDescendantIndirect) || !this.currentEnhancedInput.getMaybeMoreList().contains(element))) {
                inMaybeMore = true;
            }
            this.setInResult(element, permission, hasPermission, assignedToDescendantDirect, assignedToDescendantIndirect, inMaybeMore);
        }
    }

    private boolean assignedToChild(Object childElement, Permission permission, boolean checkForIndirect) {
        for (Permission childPermission : this.currentEnhancedInput.getPermissions(childElement)) {
            if (childPermission != permission) continue;
            if (checkForIndirect) {
                if (this.mapIndirectPermissions.get(childElement) != null && this.mapIndirectPermissions.get(childElement).contains(permission)) {
                    return true;
                }
                if (this.mapBothPermissions.get(childElement) == null || !this.mapBothPermissions.get(childElement).contains(permission)) continue;
                return true;
            }
            if (this.mapIndirectPermissions.get(childElement) != null && (this.mapIndirectPermissions.get(childElement) == null || this.mapIndirectPermissions.get(childElement).contains(permission))) continue;
            return true;
        }
        if (this.currentEnhancedInput.getChildren(childElement) != null) {
            for (Object childsChildElement : this.currentEnhancedInput.getChildren(childElement)) {
                if (!this.assignedToChild(childsChildElement, permission, checkForIndirect)) continue;
                return true;
            }
        }
        return false;
    }

    private void setInResult(Object element, Permission permission, boolean hasPermission, boolean assignedToChildDirect, boolean assignedToChildIndirect, boolean inMaybeMore) {
        int direct = assignedToChildDirect && assignedToChildIndirect ? 2 : (assignedToChildIndirect ? 1 : 0);
        if (hasPermission) {
            if (assignedToChildDirect || assignedToChildIndirect) {
                this.setInResult(element, permission, 0, direct);
                return;
            }
            if (inMaybeMore) {
                this.setInResult(element, permission, 1, direct);
                if (!this.flagMaybeRequiredMessage) {
                    this.anaResult.addMessage(new Message(MessageType.WARNING, "MAYBE REQUIRED Permission", "The analyzed App contains one or more maybe required permissions. There might be a cooperation between this App and another that leads to a intended permission usage."));
                    this.flagMaybeRequiredMessage = true;
                }
                return;
            }
            this.setInResult(element, permission, 2, direct);
            if (!this.flagUnusedMessage) {
                this.anaResult.addMessage(new Message(MessageType.WARNING, "UNUSED Permission", "The analyzed App contains one or more unused permissions. Permissions are declared in the Android manifest but never used."));
                this.flagUnusedMessage = true;
            }
            return;
        }
        if (assignedToChildDirect || assignedToChildIndirect) {
            this.setInResult(element, permission, 3, direct);
            if (!this.flagMissingMessage) {
                this.anaResult.addMessage(new Message(MessageType.ERROR, "MISSING Permission", "The analyzed App contains one or more missing permissions. This should be considered as security critical and might lead to a data leak."));
                this.flagMissingMessage = true;
            }
            return;
        }
        if (inMaybeMore) {
            this.setInResult(element, permission, 4, direct);
            if (!this.flagMaybeMissingMessage) {
                this.anaResult.addMessage(new Message(MessageType.WARNING, "MAYBE MISSING Permission", "The analyzed App contains one or more maybe missing permissions. There might be a cooperation between this App and another that leads to a unintended permission usage."));
                this.flagMaybeMissingMessage = true;
            }
            return;
        }
    }

    private void setInResult(Object element, Permission permission, int group, int direct) {
        if (element instanceof EnhancedInput) {
            this.resultApp.addPermission(permission, group, direct);
        } else if (element instanceof SootClass && this.currentEnhancedInput.isAndroidComponent((SootClass)element)) {
            ResultLeafLvl2b tempLeaf = this.resultComponents.getLeaf(element.toString());
            if (tempLeaf == null) {
                tempLeaf = new ResultLeafLvl2b(element.toString());
                this.resultComponents.addLeaf(tempLeaf);
            }
            tempLeaf.addPermission(permission, group, direct);
        }
    }
}

