/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.extension.lvl2a.graphgenerator;

import de.upb.pga3.panda2.core.SootAdapter;
import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.core.datastructures.Message;
import de.upb.pga3.panda2.core.datastructures.MessageType;
import de.upb.pga3.panda2.core.datastructures.Transition;
import de.upb.pga3.panda2.core.services.IntentInformation;
import de.upb.pga3.panda2.extension.lvl2a.AnalysisGraphLvl2a;
import de.upb.pga3.panda2.extension.lvl2a.ParamType;
import de.upb.pga3.panda2.extension.lvl2a.ParameterNode;
import de.upb.pga3.panda2.extension.lvl2a.TransitionLvl2a;
import de.upb.pga3.panda2.extension.lvl2a.TransitionType;
import de.upb.pga3.panda2.extension.lvl2a.graphgenerator.DominatorComputer;
import de.upb.pga3.panda2.extension.lvl2a.graphgenerator.DummyMain;
import de.upb.pga3.panda2.extension.lvl2a.graphgenerator.NodeLinkTransformerPart2;
import de.upb.pga3.panda2.utilities.Constants;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import soot.Body;
import soot.Local;
import soot.PatchingChain;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Transform;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.AssignStmt;
import soot.jimple.InvokeExpr;
import soot.jimple.ReturnStmt;
import soot.jimple.Stmt;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Targets;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.UnitGraph;
import soot.util.Chain;

public class NodeLinkerLvl2a {
    private static final Logger LOGGER = LogManager.getLogger(NodeLinkerLvl2a.class);
    private AnalysisGraphLvl2a mAnalysisGraph;
    private Map<SootMethod, Map<Unit, List<Unit>>> useStmtDefStmtMap = new HashMap<SootMethod, Map<Unit, List<Unit>>>();
    private Map<SootMethod, List<Unit>> methodInvkStmtMap = new HashMap<SootMethod, List<Unit>>();
    private Map<SootMethod, List<Value>> methodParamMap = new HashMap<SootMethod, List<Value>>();
    private Map<SootMethod, Map<Value, Unit>> methodParamIdentityUnitMap = new HashMap<SootMethod, Map<Value, Unit>>();
    private Map<SootMethod, Unit> methodRetnStmtMap = new HashMap<SootMethod, Unit>();
    private List<Transition> intentDataTransitions = new ArrayList<Transition>();
    private Map<SootMethod, UnitGraph> mMapUnitGraph;

    public AnalysisGraphLvl2a link(AnalysisGraphLvl2a inGraph) {
        this.mAnalysisGraph = inGraph;
        this.getGraphsFromSoot();
        this.createControlFlowGraph();
        this.modelControlDependency();
        this.addDataEdges();
        this.addParamEdges();
        this.addParamDataFlow();
        this.addSummaryEdges();
        this.addMethodCallEdges();
        this.computeAndAddDataEdgesForIntents();
        return this.mAnalysisGraph;
    }

    private void getGraphsFromSoot() {
        DummyMain dummyMain = new DummyMain();
        SootAdapter.getInstance().setEntryPoint(dummyMain.initialize());
        NodeLinkTransformerPart2 bodyTransformer = new NodeLinkTransformerPart2();
        SootAdapter.getInstance().addTransformer(new Transform("jtp.lvl2ABodyTransform", bodyTransformer), SootAdapter.SootPhase.JTP);
        SootAdapter.getInstance().run(SootAdapter.SootPhase.JTP);
        this.mMapUnitGraph = bodyTransformer.getMap();
        this.useStmtDefStmtMap = bodyTransformer.getUseStmtDefStmtMap();
        this.methodInvkStmtMap = bodyTransformer.getMethodInvkExprMap();
        this.methodParamMap = bodyTransformer.getMethodParamMap();
        this.methodParamIdentityUnitMap = bodyTransformer.getMethodParamIdentityUnitMap();
        this.methodRetnStmtMap = bodyTransformer.getMethodRetnStmtMap();
    }

    private void createControlFlowGraph() {
        CallGraph callgraph = Scene.v().getCallGraph();
        Chain<SootClass> classList = Scene.v().getApplicationClasses();
        List<SootMethod> lstEntries = Scene.v().getEntryPoints();
        if (lstEntries != null && !lstEntries.isEmpty()) {
            SootMethod dummyMain = lstEntries.get(0);
            Targets targets = new Targets(callgraph.edgesOutOf(dummyMain));
            while (targets.hasNext()) {
                SootMethod targetMethod = (SootMethod)targets.next();
                TransitionLvl2a trans = this.createTransition(dummyMain, targetMethod, TransitionType.CONTROLFLOW);
                this.mAnalysisGraph.addTransition(trans);
            }
            for (SootClass sootClass : classList) {
                List<SootMethod> methodList = sootClass.getMethods();
                for (SootMethod sm : methodList) {
                    targets = new Targets(callgraph.edgesOutOf(sm));
                    while (targets.hasNext()) {
                        SootMethod targetMethod = (SootMethod)targets.next();
                        TransitionLvl2a trans = this.createTransition(sm, targetMethod, TransitionType.CONTROLFLOW);
                        this.mAnalysisGraph.addTransition(trans);
                    }
                    if (sm.isAbstract() || sm.getDeclaringClass().isInterface()) continue;
                    boolean isFirstStatement = true;
                    try {
                        UnitGraph graph;
                        Body body = sm.retrieveActiveBody();
                        PatchingChain<Unit> chainUnits = body.getUnits();
                        if (this.mMapUnitGraph != null) {
                            graph = this.mMapUnitGraph.get(sm);
                            if (graph == null) {
                                graph = new ExceptionalUnitGraph(body);
                            }
                        } else {
                            graph = new ExceptionalUnitGraph(body);
                        }
                        for (Unit unit : chainUnits) {
                            if (isFirstStatement) {
                                isFirstStatement = false;
                                TransitionLvl2a transUnit = this.createTransition(sm, unit, TransitionType.CONTROLFLOW);
                                this.mAnalysisGraph.addTransition(transUnit);
                            }
                            List<Unit> lstUnits = graph.getSuccsOf(unit);
                            for (Unit preds : lstUnits) {
                                TransitionLvl2a transUnit = this.createTransition(unit, preds, TransitionType.CONTROLFLOW);
                                this.mAnalysisGraph.addTransition(transUnit);
                            }
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.warn("The method " + sm.getSubSignature() + " has no body. Exception: " + ex.getMessage());
                    }
                }
            }
        }
    }

    private void addDataEdges() {
        for (Map.Entry<SootMethod, Map<Unit, List<Unit>>> methodToUseDefMap : this.useStmtDefStmtMap.entrySet()) {
            for (Map.Entry<Unit, List<Unit>> useToDefsMap : methodToUseDefMap.getValue().entrySet()) {
                if (useToDefsMap.getValue().isEmpty()) continue;
                for (Unit defUnit : useToDefsMap.getValue()) {
                    TransitionLvl2a dataTrans = this.createTransition(defUnit, useToDefsMap.getKey(), TransitionType.DATAFLOW);
                    this.mAnalysisGraph.addTransition(dataTrans);
                }
            }
        }
    }

    private void addParamEdges() {
        SootClass[] sootClassArray = ((EnhancedInput)this.mAnalysisGraph.getInput()).getAppClasses();
        int n = sootClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            SootClass c = sootClassArray[n2];
            for (SootMethod method : c.getMethods()) {
                if (this.methodParamMap.containsKey(method)) {
                    for (Value param : this.methodParamMap.get(method)) {
                        int index = this.methodParamMap.get(method).indexOf(param);
                        ParameterNode destNode = new ParameterNode(param, ParamType.FORMAL_IN, method, index);
                        this.mAnalysisGraph.addParameterNode(destNode);
                        TransitionLvl2a cntlDepTrans1 = this.createTransition(method, destNode, TransitionType.CONTROLDEPENDENCY);
                        this.mAnalysisGraph.addTransition(cntlDepTrans1);
                    }
                }
                if (!this.methodRetnStmtMap.containsKey(method)) continue;
                Unit retUnit = this.methodRetnStmtMap.get(method);
                ReturnStmt rSt = (ReturnStmt)retUnit;
                Value srcVal = rSt.getOp();
                ParameterNode srcNode = new ParameterNode(srcVal, ParamType.FORMAL_OUT, method, 0);
                this.mAnalysisGraph.addParameterNode(srcNode);
                TransitionLvl2a cntlDepTrans2 = this.createTransition(method, srcNode, TransitionType.CONTROLDEPENDENCY);
                this.mAnalysisGraph.addTransition(cntlDepTrans2);
            }
            ++n2;
        }
        Set<SootMethod> methods = this.methodInvkStmtMap.keySet();
        for (SootMethod sm : methods) {
            List<Unit> invkUnits = this.methodInvkStmtMap.get(sm);
            for (Unit invkUnit : invkUnits) {
                Set<ParameterNode> params;
                Stmt st = (Stmt)invkUnit;
                InvokeExpr iExpr = st.getInvokeExpr();
                SootMethod invkdMethod = iExpr.getMethod();
                if (this.methodParamMap.keySet().contains(invkdMethod)) {
                    List<Value> args = iExpr.getArgs();
                    List<Value> parameters = this.methodParamMap.get(invkdMethod);
                    int i = 0;
                    while (i < args.size()) {
                        Value src = args.get(i);
                        Value dest = parameters.get(i);
                        ParameterNode actualInNode = new ParameterNode(src, ParamType.ACTUAL_IN, invkUnit, i);
                        this.mAnalysisGraph.addParameterNode(actualInNode);
                        TransitionLvl2a cntlDepTrans = this.createTransition(invkUnit, actualInNode, TransitionType.CONTROLDEPENDENCY);
                        this.mAnalysisGraph.addTransition(cntlDepTrans);
                        if (this.mAnalysisGraph.hasParameterNodes(invkdMethod)) {
                            params = this.mAnalysisGraph.getParameterNodes(invkdMethod);
                            for (ParameterNode param : params) {
                                if (param.getIndex() != i || param.getType() != ParamType.FORMAL_IN) continue;
                                TransitionLvl2a paramIn = this.createTransition(actualInNode, param, TransitionType.PARAMIN);
                                this.mAnalysisGraph.addTransition(paramIn);
                            }
                        }
                        ++i;
                    }
                }
                if (!(st instanceof AssignStmt) || !this.methodRetnStmtMap.containsKey(invkdMethod)) continue;
                AssignStmt aSt = (AssignStmt)st;
                Value destVal = aSt.getLeftOp();
                Unit retUnit = this.methodRetnStmtMap.get(invkdMethod);
                ReturnStmt rSt = (ReturnStmt)retUnit;
                Value srcVal = rSt.getOp();
                ParameterNode actualOutNode = new ParameterNode(destVal, ParamType.ACTUAL_OUT, invkUnit, 0);
                this.mAnalysisGraph.addParameterNode(actualOutNode);
                TransitionLvl2a cntlDepTrans3 = this.createTransition(invkUnit, actualOutNode, TransitionType.CONTROLDEPENDENCY);
                this.mAnalysisGraph.addTransition(cntlDepTrans3);
                if (!this.mAnalysisGraph.hasParameterNodes(invkdMethod)) continue;
                params = this.mAnalysisGraph.getParameterNodes(invkdMethod);
                for (ParameterNode param : params) {
                    if (!param.getParameterValue().equals(srcVal) || param.getType() != ParamType.FORMAL_OUT) continue;
                    TransitionLvl2a paramOut = this.createTransition(param, actualOutNode, TransitionType.PARAMOUT);
                    this.mAnalysisGraph.addTransition(paramOut);
                }
            }
        }
    }

    private void addParamDataFlow() {
        for (Unit invkUnit : this.mAnalysisGraph.getParameterizedInvokeStmnts()) {
            for (ParameterNode param : this.mAnalysisGraph.getParameterNodes(invkUnit)) {
                if (param.getType() == ParamType.ACTUAL_IN) {
                    EnhancedInput enhancedInput = (EnhancedInput)this.mAnalysisGraph.getInput();
                    Body body = enhancedInput.getBodyForUnit(invkUnit);
                    List<Unit> defUnits = this.useStmtDefStmtMap.get(body.getMethod()).get(invkUnit);
                    for (Unit defUnit : defUnits) {
                        List<ValueBox> vBoxes = defUnit.getDefBoxes();
                        for (ValueBox vb : vBoxes) {
                            if (!vb.getValue().equals(param.getParameterValue())) continue;
                            TransitionLvl2a dataTransActIn = this.createTransition(defUnit, param, TransitionType.DATAFLOW);
                            this.mAnalysisGraph.addTransition(dataTransActIn);
                        }
                    }
                    continue;
                }
                if (param.getType() == ParamType.ACTUAL_OUT) {
                    Unit invokeUnit = param.getCorrespondingUnit();
                    ArrayList<Transition> transitionsToDelete = new ArrayList<Transition>();
                    for (Transition t : this.mAnalysisGraph.getOutgoingTransitions(invokeUnit)) {
                        TransitionLvl2a transition = (TransitionLvl2a)t;
                        if (transition.getTransitionType() != TransitionType.DATAFLOW) continue;
                        TransitionLvl2a dataFlow = this.createTransition(param, transition.getTarget(), TransitionType.DATAFLOW);
                        this.mAnalysisGraph.addTransition(dataFlow);
                        transitionsToDelete.add(t);
                    }
                    for (Transition t : transitionsToDelete) {
                        this.mAnalysisGraph.removeTransition(t);
                    }
                    continue;
                }
                throw new IllegalStateException("Unexpected param type: " + (Object)((Object)param.getType()));
            }
        }
        for (SootMethod method : this.mAnalysisGraph.getParameterizedMethods()) {
            for (ParameterNode param : this.mAnalysisGraph.getParameterNodes(method)) {
                if (param.getType() == ParamType.FORMAL_IN) {
                    Unit idtyUnit = this.methodParamIdentityUnitMap.get(method).get(param.getParameterValue());
                    TransitionLvl2a dataTransFormIn = this.createTransition(param, idtyUnit, TransitionType.DATAFLOW);
                    this.mAnalysisGraph.addTransition(dataTransFormIn);
                    continue;
                }
                if (param.getType() == ParamType.FORMAL_OUT) {
                    TransitionLvl2a dataTransFormOut = this.createTransition(this.methodRetnStmtMap.get(method), param, TransitionType.DATAFLOW);
                    this.mAnalysisGraph.addTransition(dataTransFormOut);
                    continue;
                }
                throw new IllegalStateException("Unexpected param type: " + (Object)((Object)param.getType()));
            }
        }
    }

    private void modelControlDependency() {
        AnalysisGraphLvl2a reverseCFG = new AnalysisGraphLvl2a(this.mAnalysisGraph.getInput());
        Set<Object> nodes = this.mAnalysisGraph.getNodes();
        for (Object node : nodes) {
            Set<Transition> oldtransitions = this.mAnalysisGraph.getOutgoingTransitions(node);
            for (Transition t : oldtransitions) {
                Iterator oldTransition;
                if (!(t instanceof TransitionLvl2a) || ((TransitionLvl2a)((Object)(oldTransition = (TransitionLvl2a)t))).getTransitionType() != TransitionType.CONTROLFLOW || ((Transition)((Object)oldTransition)).getSource() instanceof SootMethod && ((Transition)((Object)oldTransition)).getTarget() instanceof SootMethod) continue;
                TransitionLvl2a reverseTransition = new TransitionLvl2a(((Transition)((Object)oldTransition)).getTarget(), ((Transition)((Object)oldTransition)).getSource(), TransitionType.CONTROLFLOW);
                reverseCFG.addTransition(reverseTransition);
            }
        }
        String start = "Start";
        String end = "Stop";
        ArrayList<Object> heads = new ArrayList<Object>();
        ArrayList<Object> tails = new ArrayList<Object>();
        for (Object object : nodes) {
            if (reverseCFG.getIncomingTransitions(object).isEmpty()) {
                heads.add(object);
            }
            if (!reverseCFG.getOutgoingTransitions(object).isEmpty()) continue;
            tails.add(object);
        }
        for (Object e : heads) {
            TransitionLvl2a trans = new TransitionLvl2a(start, e, TransitionType.CONTROLFLOW);
            reverseCFG.addTransition(trans);
        }
        for (Object e : tails) {
            TransitionLvl2a t = new TransitionLvl2a(e, end, TransitionType.CONTROLFLOW);
            reverseCFG.addTransition(t);
        }
        TObjectIntHashMap tObjectIntHashMap = new TObjectIntHashMap();
        TIntObjectHashMap mMapIntToNode = new TIntObjectHashMap();
        int i = 1;
        for (Object node : reverseCFG.getNodes()) {
            tObjectIntHashMap.put(node, i);
            mMapIntToNode.put(i, node);
            ++i;
        }
        TIntSet[] succ = new TIntSet[i];
        int j = 0;
        while (j < i) {
            succ[j] = new TIntHashSet();
            ++j;
        }
        for (Object node : reverseCFG.getNodes()) {
            Set<Transition> Transitions = reverseCFG.getOutgoingTransitions(node);
            for (Transition transition : Transitions) {
                TransitionLvl2a trans;
                if (!(transition instanceof TransitionLvl2a) || (trans = (TransitionLvl2a)transition).getTransitionType() != TransitionType.CONTROLFLOW) continue;
                succ[tObjectIntHashMap.get(trans.getSource())].add(tObjectIntHashMap.get(trans.getTarget()));
            }
        }
        DominatorComputer dc = new DominatorComputer();
        int[] dom = dc.computeDominatorTree(succ, tObjectIntHashMap.get((Object)start), i);
        ArrayList<TransitionLvl2a> notDominated = new ArrayList<TransitionLvl2a>();
        for (Object o : nodes) {
            for (Transition t : this.mAnalysisGraph.getOutgoingTransitions(o)) {
                int b;
                int a;
                TransitionLvl2a transition;
                if (!(t instanceof TransitionLvl2a) || (transition = (TransitionLvl2a)t).getTransitionType() != TransitionType.CONTROLFLOW || transition.getSource() instanceof SootMethod && transition.getTarget() instanceof SootMethod || this.bDominatesA(a = tObjectIntHashMap.get(transition.getSource()), b = tObjectIntHashMap.get(transition.getTarget()), dom)) continue;
                notDominated.add(transition);
            }
        }
        ArrayList<Object> allNodes = new ArrayList<Object>(nodes);
        block11: for (TransitionLvl2a transitionLvl2a : notDominated) {
            Object x = transitionLvl2a.getSource();
            Object y = transitionLvl2a.getTarget();
            int parentOfX = dom[tObjectIntHashMap.get(x)];
            int node = tObjectIntHashMap.get(y);
            while (node != 0) {
                if ((node = dom[node]) == parentOfX || node == tObjectIntHashMap.get(x) || node == 0) continue block11;
                TransitionLvl2a controlDependency = this.createTransition(x, mMapIntToNode.get(node), TransitionType.CONTROLDEPENDENCY);
                this.mAnalysisGraph.addTransition(controlDependency);
                allNodes.remove(mMapIntToNode.get(node));
            }
        }
        for (Object e : allNodes) {
            if (!(e instanceof Unit)) continue;
            EnhancedInput ei = (EnhancedInput)this.mAnalysisGraph.getInput();
            Body body = ei.getBodyForUnit((Unit)e);
            SootMethod method = body.getMethod();
            TransitionLvl2a transition = this.createTransition(method, e, TransitionType.CONTROLDEPENDENCY);
            this.mAnalysisGraph.addTransition(transition);
        }
    }

    private boolean bDominatesA(int a, int b, int[] dom) {
        if (dom[a] == 0) {
            return false;
        }
        if (dom[a] == b) {
            return true;
        }
        return this.bDominatesA(dom[a], b, dom);
    }

    private TransitionLvl2a createTransition(Object inEleFrom, Object inEleTo, TransitionType inType) {
        TransitionLvl2a trans = new TransitionLvl2a(inEleFrom, inEleTo, inType);
        return trans;
    }

    public void addTransitionsForExplicitIntent(IntentInformation inIntentInfo) {
        if (inIntentInfo.getTargetClasses() == null || inIntentInfo.getTargetClasses().isEmpty()) {
            this.mAnalysisGraph.addMessage(new Message(MessageType.INFO, "No Target", "No target class could not be found for explicit intent definition"));
            return;
        }
        EnhancedInput eInput = (EnhancedInput)this.mAnalysisGraph.getInput();
        List<Unit> launchingStmts = inIntentInfo.getLstLaunchingUnits();
        if (launchingStmts != null && !launchingStmts.isEmpty()) {
            for (Unit launchingStmt : launchingStmts) {
                String strLaunchingStmt = launchingStmt.toString();
                SootMethod callerMethod = eInput.getBodyForUnit(launchingStmt).getMethod();
                SootClass callerClass = callerMethod.getDeclaringClass();
                for (SootClass target : inIntentInfo.getTargetClasses()) {
                    TransitionLvl2a transition = new TransitionLvl2a(launchingStmt, target, TransitionType.CALL);
                    this.mAnalysisGraph.addTransition(transition);
                }
                if (!strLaunchingStmt.contains("void startActivityForResult(android.content.Intent,int)") && !strLaunchingStmt.contains("void startActivityForResult(android.content.Intent,int,android.os.Bundle)")) continue;
                for (SootClass target : inIntentInfo.getTargetClasses()) {
                    this.processMethodStartActivityForResult(target, callerClass, launchingStmt);
                }
            }
        }
    }

    public void addTransitionsForImplicitIntent(IntentInformation inIntentInfo) {
        if (inIntentInfo.getTargetClasses() == null || inIntentInfo.getTargetClasses().isEmpty()) {
            this.mAnalysisGraph.addMessage(new Message(MessageType.INFO, "No Target", "No target class could not be found for explicit intent definition"));
            return;
        }
        EnhancedInput eInput = (EnhancedInput)this.mAnalysisGraph.getInput();
        List<Unit> launchingStmts = inIntentInfo.getLstLaunchingUnits();
        if (launchingStmts != null && !launchingStmts.isEmpty()) {
            for (Unit launchingStmt : launchingStmts) {
                String strLaunchingStmt = launchingStmt.toString();
                SootMethod callerMethod = eInput.getBodyForUnit(launchingStmt).getMethod();
                SootClass callerClass = callerMethod.getDeclaringClass();
                if (inIntentInfo.getTargetClasses() != null && !inIntentInfo.getTargetClasses().isEmpty()) {
                    for (SootClass target : inIntentInfo.getTargetClasses()) {
                        TransitionLvl2a transition = new TransitionLvl2a(launchingStmt, target, TransitionType.CALL);
                        this.mAnalysisGraph.addTransition(transition);
                    }
                }
                if (!strLaunchingStmt.contains("void startActivityForResult(android.content.Intent,int)") && !strLaunchingStmt.contains("void startActivityForResult(android.content.Intent,int,android.os.Bundle)")) continue;
                if (inIntentInfo.getTargetClasses() != null && !inIntentInfo.getTargetClasses().isEmpty()) {
                    for (SootClass target : inIntentInfo.getTargetClasses()) {
                        this.processMethodStartActivityForResult(target, callerClass, launchingStmt);
                    }
                    continue;
                }
                this.processMethodStartActivityForResult(null, callerClass, launchingStmt);
            }
        }
    }

    private void processMethodStartActivityForResult(SootClass inTargetClass, SootClass inCallerClass, Unit inLaunchingIntent) {
        SootMethod smOnActivityResult = null;
        List<SootMethod> lstSMs = inCallerClass.getMethods();
        if (lstSMs != null && !lstSMs.isEmpty()) {
            for (SootMethod sm : lstSMs) {
                String subSignature = sm.getSubSignature();
                if (!subSignature.contains("void onActivityResult(int,int,android.content.Intent)")) continue;
                smOnActivityResult = sm;
                break;
            }
        }
        if (smOnActivityResult != null) {
            if (inTargetClass != null) {
                lstSMs = inTargetClass.getMethods();
                for (SootMethod sm : lstSMs) {
                    Body body = sm.retrieveActiveBody();
                    PatchingChain<Unit> chainUnts = body.getUnits();
                    if (!(chainUnts != null & !chainUnts.isEmpty())) continue;
                    for (Unit un : chainUnts) {
                        String strUn = un.toString();
                        if (strUn.contains("if ") || strUn.contains("goto ") || !strUn.contains("void setResult(int,android.content.Intent)") && !strUn.contains("void setResult(int)")) continue;
                        TransitionLvl2a transition = new TransitionLvl2a(un, smOnActivityResult, TransitionType.CALL);
                        this.mAnalysisGraph.addTransition(transition);
                    }
                }
            } else {
                TransitionLvl2a transition = new TransitionLvl2a(inLaunchingIntent, smOnActivityResult, TransitionType.CALL);
                this.mAnalysisGraph.addTransition(transition);
            }
        }
    }

    private void addSummaryEdges() {
        HashMap<ParameterNode, ParameterNode> summaryEdges = new HashMap<ParameterNode, ParameterNode>();
        HashMap<Object, List<Object>> pathEdge = new HashMap<Object, List<Object>>();
        HashMap<Object, List<Object>> workList = new HashMap<Object, List<Object>>();
        HashMap<Object, Map<Object, List<Object>>> fragmentPath = new HashMap<Object, Map<Object, List<Object>>>();
        for (SootMethod sootMethod : this.mAnalysisGraph.getParameterizedMethods()) {
            for (ParameterNode parameter : this.mAnalysisGraph.getParameterNodes(sootMethod)) {
                if (parameter.getType() != ParamType.FORMAL_OUT) continue;
                pathEdge.put(parameter, new ArrayList());
                ((List)pathEdge.get(parameter)).add(parameter);
                workList.put(parameter, new ArrayList());
                ((List)workList.get(parameter)).add(parameter);
            }
        }
        while (!workList.isEmpty()) {
            Object k = workList.keySet().iterator().next();
            Object to = ((List)workList.get(k)).get(0);
            ((List)workList.get(k)).remove(0);
            if (((List)workList.get(k)).isEmpty()) {
                workList.remove(k);
            }
            if (k instanceof ParameterNode && ((ParameterNode)k).getType() == ParamType.ACTUAL_OUT) {
                ParameterNode v = (ParameterNode)k;
                for (Object key : summaryEdges.keySet()) {
                    if (!((ParameterNode)summaryEdges.get(key)).equals(v)) continue;
                    this.propagate(pathEdge, workList, fragmentPath, key, to);
                }
                for (Transition incmTrans : this.mAnalysisGraph.getIncomingTransitions(v)) {
                    TransitionLvl2a incmTrans2a;
                    if (!(incmTrans instanceof TransitionLvl2a) || (incmTrans2a = (TransitionLvl2a)incmTrans).getTransitionType() != TransitionType.CONTROLDEPENDENCY) continue;
                    this.propagate(pathEdge, workList, fragmentPath, incmTrans.getSource(), to);
                }
                continue;
            }
            if (k instanceof ParameterNode && ((ParameterNode)k).getType() == ParamType.FORMAL_IN) {
                SootMethod methodOfTo = null;
                if (to instanceof Unit) {
                    Unit unit = (Unit)to;
                    methodOfTo = ((EnhancedInput)this.mAnalysisGraph.getInput()).getBodyForUnit(unit).getMethod();
                } else if (to instanceof SootMethod) {
                    methodOfTo = (SootMethod)to;
                } else if (to instanceof ParameterNode) {
                    ParameterNode param = (ParameterNode)to;
                    if (param.belongsToMethod()) {
                        methodOfTo = param.getCorrespondingMethod();
                    } else {
                        Unit invokeExpr = param.getCorrespondingUnit();
                        Stmt s = (Stmt)invokeExpr;
                        if (s.containsInvokeExpr()) {
                            methodOfTo = s.getInvokeExpr().getMethod();
                        }
                    }
                }
                Set<Unit> paramStmnts = this.mAnalysisGraph.getParameterizedInvokeStmnts();
                for (Unit caller : paramStmnts) {
                    Stmt stmt = (Stmt)caller;
                    if (!stmt.containsInvokeExpr() || !stmt.getInvokeExpr().getMethod().equals(methodOfTo)) continue;
                    ParameterNode actualIn = this.getCorrespondingActualIn(caller, (ParameterNode)k);
                    ParameterNode actualOut = this.getCorrespondingActualOut(caller, methodOfTo);
                    if (actualOut != null && actualIn != null) {
                        summaryEdges.put(actualIn, actualOut);
                    }
                    if (fragmentPath.get(to) == null || ((Map)fragmentPath.get(to)).get(to) == null) continue;
                    for (Object a : (List)((Map)fragmentPath.get(to)).get(to)) {
                        this.propagate(pathEdge, workList, fragmentPath, k, a);
                    }
                }
                continue;
            }
            for (Transition incmTrans : this.mAnalysisGraph.getIncomingTransitions(k)) {
                if (!(incmTrans instanceof TransitionLvl2a)) continue;
                TransitionLvl2a incmTrans2a = (TransitionLvl2a)incmTrans;
                if (incmTrans2a.getTransitionType() == TransitionType.DATAFLOW) {
                    this.propagate(pathEdge, workList, fragmentPath, incmTrans.getSource(), to);
                    continue;
                }
                if (incmTrans2a.getTransitionType() != TransitionType.CONTROLDEPENDENCY || incmTrans.getSource() instanceof ParameterNode && incmTrans.getTarget() instanceof ParameterNode) continue;
                this.propagate(pathEdge, workList, fragmentPath, incmTrans.getSource(), to);
            }
        }
        for (Map.Entry entry : summaryEdges.entrySet()) {
            TransitionLvl2a summaryTrans = this.createTransition(entry.getKey(), entry.getValue(), TransitionType.SUMMARY);
            this.mAnalysisGraph.addTransition(summaryTrans);
        }
    }

    private ParameterNode getCorrespondingActualIn(Unit caller, ParameterNode formalIn) {
        Stmt stmt = (Stmt)caller;
        Set<ParameterNode> paramNodes = this.mAnalysisGraph.getParameterNodes(stmt);
        for (ParameterNode pn : paramNodes) {
            if (pn.getIndex() != formalIn.getIndex() || pn.getType() != ParamType.ACTUAL_IN) continue;
            return pn;
        }
        return null;
    }

    private ParameterNode getCorrespondingActualOut(Unit caller, SootMethod method) {
        for (ParameterNode pn : this.mAnalysisGraph.getParameterNodes(caller)) {
            Unit invokeExpr;
            Stmt s;
            if (pn.getType() != ParamType.ACTUAL_OUT || !(pn.belongsToMethod() ? pn.getCorrespondingMethod().equals(method) : (s = (Stmt)(invokeExpr = pn.getCorrespondingUnit())).containsInvokeExpr() && s.getInvokeExpr().getMethod().equals(method))) continue;
            return pn;
        }
        return null;
    }

    private void propagate(Map<Object, List<Object>> pathEdge, Map<Object, List<Object>> workList, Map<Object, Map<Object, List<Object>>> fragmentPath, Object from, Object to) {
        if (pathEdge.get(from) == null) {
            pathEdge.put(from, new ArrayList());
        }
        if (!pathEdge.get(from).contains(to)) {
            pathEdge.get(from).add(to);
            if (workList.get(from) == null) {
                workList.put(from, new ArrayList());
            }
            workList.get(from).add(to);
            if (from instanceof ParameterNode && ((ParameterNode)from).getType() == ParamType.ACTUAL_OUT) {
                if (fragmentPath.get(to) == null) {
                    fragmentPath.put(to, new HashMap());
                }
                if (fragmentPath.get(to).get(from) == null) {
                    fragmentPath.get(to).put(from, new ArrayList());
                }
                fragmentPath.get(to).get(from).add(to);
            }
        }
    }

    private boolean checkCallBackMethod(SootMethod inSootMethod) {
        if (inSootMethod != null) {
            String subSig = inSootMethod.getSubSignature();
            if (Constants.getActivityLifecycleMethods().contains(subSig)) {
                return true;
            }
            if (Constants.getServiceLifecycleMethods().contains(subSig)) {
                return true;
            }
            if (Constants.getBroadcastLifecycleMethods().contains(subSig)) {
                return true;
            }
            if (Constants.getContentproviderLifecycleMethods().contains(subSig)) {
                return true;
            }
        }
        return false;
    }

    private void addMethodCallEdges() {
        SootClass[] classes = ((EnhancedInput)this.mAnalysisGraph.getInput()).getAppClasses();
        Collection<SootClass> colAndroidComponents = ((EnhancedInput)this.mAnalysisGraph.getInput()).getAndroidComponents();
        SootClass[] sootClassArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            TransitionLvl2a callTrans;
            SootClass sc = sootClassArray[n2];
            List<SootMethod> methods = sc.getMethods();
            if (colAndroidComponents != null && colAndroidComponents.contains(sc)) {
                for (SootMethod sm : methods) {
                    if (!this.checkCallBackMethod(sm)) continue;
                    callTrans = new TransitionLvl2a(sc, sm, TransitionType.CALL);
                    this.mAnalysisGraph.addTransition(callTrans);
                }
            }
            for (SootMethod sm : methods) {
                if (sm.hasActiveBody()) {
                    PatchingChain<Unit> units = sm.getActiveBody().getUnits();
                    for (Unit u : units) {
                        Stmt stmt = (Stmt)u;
                        if (!stmt.containsInvokeExpr()) continue;
                        SootMethod callee = stmt.getInvokeExpr().getMethod();
                        callTrans = new TransitionLvl2a(stmt, callee, TransitionType.CALL);
                        this.mAnalysisGraph.addTransition(callTrans);
                    }
                    continue;
                }
                LOGGER.trace("Found Method " + sm.getName() + " without active body");
            }
            ++n2;
        }
    }

    private void computeAndAddDataEdgesForIntents() {
        EnhancedInput ei = (EnhancedInput)this.mAnalysisGraph.getInput();
        Map<String, Collection<IntentInformation>> intents = ei.getIntents();
        for (String intent : intents.keySet()) {
            Collection<IntentInformation> intentInfoCollection = intents.get(intent);
            for (IntentInformation intentInfo : intentInfoCollection) {
                if (intentInfo.getTypeIntent() != 0) continue;
                List<Unit> inStmntList = intentInfo.getLstLaunchingUnits();
                for (Unit inStmnt : inStmntList) {
                    Local intentLoc = this.getIntentLocalVariable(inStmnt);
                    HashSet<Unit> visitedNodes = new HashSet<Unit>();
                    this.computeDataEdgesForIntent(inStmnt, inStmnt, intentLoc, visitedNodes);
                }
            }
        }
        for (Transition newDataTransition : this.intentDataTransitions) {
            this.mAnalysisGraph.addTransition(newDataTransition);
        }
    }

    private Local getIntentLocalVariable(Unit inUnit) {
        Local loc = null;
        List<ValueBox> vBoxes = inUnit.getUseBoxes();
        for (ValueBox vb : vBoxes) {
            Local l;
            Value v = vb.getValue();
            if (v == null || !(v instanceof Local) || !(l = (Local)v).getType().toString().equals("android.content.Intent")) continue;
            loc = l;
        }
        return loc;
    }

    private void computeDataEdgesForIntent(Unit currUnit, Unit predUnit, Local intentLoc, HashSet<Unit> visitedNodes) {
        if (!visitedNodes.contains(predUnit)) {
            visitedNodes.add(predUnit);
            Set<Transition> transitions = this.mAnalysisGraph.getIncomingTransitions(predUnit);
            for (Transition transition : transitions) {
                TransitionLvl2a trans2a;
                if (!(transition instanceof TransitionLvl2a) || !(trans2a = (TransitionLvl2a)transition).getTransitionType().equals((Object)TransitionType.CONTROLFLOW) || !(trans2a.getSource() instanceof Unit)) continue;
                Unit preUnit = (Unit)trans2a.getSource();
                if (this.checkUnitForIntentLocal(preUnit, intentLoc)) {
                    TransitionLvl2a newDataTransition = new TransitionLvl2a(preUnit, currUnit, TransitionType.DATAFLOW);
                    this.intentDataTransitions.add(newDataTransition);
                    currUnit = preUnit;
                    this.computeDataEdgesForIntent(currUnit, preUnit, intentLoc, visitedNodes);
                    continue;
                }
                this.computeDataEdgesForIntent(currUnit, preUnit, intentLoc, visitedNodes);
            }
        }
    }

    private boolean checkUnitForIntentLocal(Unit preUnit, Local intentLoc) {
        List<ValueBox> vBoxes = preUnit.getUseBoxes();
        ArrayList<Local> unitLocals = new ArrayList<Local>();
        for (ValueBox vBox : vBoxes) {
            if (!(vBox.getValue() instanceof Local)) continue;
            unitLocals.add((Local)vBox.getValue());
        }
        return unitLocals.contains(intentLoc);
    }
}

