/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.extension.lvl2a.analyzer;

import de.upb.pga3.panda2.core.datastructures.AnalysisGraph;
import de.upb.pga3.panda2.core.datastructures.AnalysisResult;
import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.core.datastructures.Permission;
import de.upb.pga3.panda2.core.services.CoreServices;
import de.upb.pga3.panda2.extension.Analyzer;
import de.upb.pga3.panda2.extension.lvl2a.AnalysisGraphLvl2a;
import de.upb.pga3.panda2.extension.lvl2a.AnalysisResultLvl2a;
import de.upb.pga3.panda2.extension.lvl2a.ComparisonAnalysisResultLvl2a;
import de.upb.pga3.panda2.extension.lvl2a.analyzer.BackwardSlicer;
import de.upb.pga3.panda2.extension.lvl2a.analyzer.PathFinder;
import de.upb.pga3.panda2.extension.lvl2a.analyzer.ResultComparerLvl2a;
import de.upb.pga3.panda2.extension.lvl2a.analyzer.SourceAndSinkComputer;
import de.upb.pga3.panda2.extension.lvl2a.flowpath.FlowPath;
import de.upb.pga3.panda2.extension.lvl2a.flowpath.ResourceElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import soot.Unit;
import soot.toolkits.scalar.Pair;

public class AnalyzerLvl2a
implements Analyzer {
    private final SourceAndSinkComputer mSusiComputer = new SourceAndSinkComputer();
    private final BackwardSlicer mBackwardSlicer = new BackwardSlicer();
    private final PathFinder mPathFinder = new PathFinder();
    private final ResultComparerLvl2a mResComparer = new ResultComparerLvl2a();
    private static final Logger LOGGER = LogManager.getLogger(AnalyzerLvl2a.class);

    private Pair<Map<Permission, List<Unit>>, Map<Permission, List<Unit>>> computeSourcesAndSinks(AnalysisGraphLvl2a inGraph) {
        LOGGER.info("AnalyzerLvl2a starts computing sources and sinks");
        Object[] lstNode = inGraph.getNodes().toArray();
        ArrayList<Unit> lstNodeUnit = new ArrayList<Unit>();
        if (lstNode != null && lstNode.length > 0) {
            Object[] objectArray = lstNode;
            int n = lstNode.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof Unit) {
                    lstNodeUnit.add((Unit)obj);
                }
                ++n2;
            }
        }
        Map<Permission, List<Unit>> sources = this.mSusiComputer.computeSources(lstNodeUnit, (EnhancedInput)inGraph.getInput());
        Map<Permission, List<Unit>> sinks = this.mSusiComputer.computeSinks(lstNodeUnit, (EnhancedInput)inGraph.getInput());
        LOGGER.info("AnalyzerLvl2a finished computing sources and sinks");
        return new Pair<Map<Permission, List<Unit>>, Map<Permission, List<Unit>>>(sources, sinks);
    }

    private void extractExecutionPaths(Map<Permission, List<Unit>> inSlicedSources, Permission inPermission, Unit inSink, AnalysisResultLvl2a inRes) {
        Set<Permission> setKeys = inSlicedSources.keySet();
        for (Permission perm : setKeys) {
            List<Unit> sources = inSlicedSources.get(perm);
            for (Unit source : sources) {
                Collection<FlowPath> lstPaths = this.mPathFinder.findPaths(new Pair<Permission, Object>(perm, source), new Pair<Permission, Object>(inPermission, inSink));
                if (lstPaths == null || lstPaths.isEmpty()) continue;
                for (FlowPath path : lstPaths) {
                    inRes.addPath(path);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public AnalysisResult analyze(AnalysisGraph analgraph, AnalysisResult prevRes) {
        LOGGER.info("Analyzer started (Source&Sink - Intra App - Level 2a).");
        AnalysisResultLvl2a res = null;
        if (!(analgraph instanceof AnalysisGraphLvl2a)) throw new IllegalArgumentException("Graph is not of type Level2a!");
        AnalysisGraphLvl2a ag2a = (AnalysisGraphLvl2a)analgraph;
        if (prevRes == null) {
            res = this.performSummaryAnalysis(ag2a);
        } else {
            if (!(prevRes instanceof AnalysisResultLvl2a)) throw new IllegalArgumentException("Previous result is not of type Level2a!");
            res = this.performComparisonAnalysis(ag2a, (AnalysisResultLvl2a)prevRes);
        }
        res.createFilters();
        LOGGER.info("Analyzer finished (Source&Sink - Intra App - Level 2a)");
        return res;
    }

    private AnalysisResultLvl2a performSummaryAnalysis(AnalysisGraphLvl2a angraph) {
        EnhancedInput input = (EnhancedInput)angraph.getInput();
        String appName = input.getAppName();
        AnalysisResultLvl2a res = new AnalysisResultLvl2a();
        res.setAppName(appName);
        res.initialize(CoreServices.getXMLParserInstance());
        Pair<Map<Permission, List<Unit>>, Map<Permission, List<Unit>>> pairSouSi = this.computeSourcesAndSinks(angraph);
        Map<Permission, List<Unit>> sources = pairSouSi.getO1();
        Map<Permission, List<Unit>> sinks = pairSouSi.getO2();
        this.mPathFinder.setGraph(angraph);
        res.addSinks(sinks.keySet().stream().map(p -> ResourceElement.get(p)).collect(Collectors.toSet()));
        res.addSources(sources.keySet().stream().map(p -> ResourceElement.get(p)).collect(Collectors.toSet()));
        LOGGER.info("BackwardSlicer and PathFinder start computing");
        LOGGER.debug("Found {} sink permissions", sinks.size());
        for (Map.Entry<Permission, List<Unit>> entry : sinks.entrySet()) {
            Permission perm = entry.getKey();
            List<Unit> lstSinks = entry.getValue();
            LOGGER.debug("Found {} statements for sink {}", lstSinks.size(), perm.getName());
            for (Unit sink : lstSinks) {
                Map<Permission, List<Unit>> mapPermSources = this.mBackwardSlicer.slice(angraph, sink, sources);
                if (mapPermSources == null || mapPermSources.isEmpty()) continue;
                this.extractExecutionPaths(mapPermSources, perm, sink, res);
            }
        }
        LOGGER.info("BackwardSlicer and PathFinder finished computing");
        return res;
    }

    private ComparisonAnalysisResultLvl2a performComparisonAnalysis(AnalysisGraphLvl2a angraph, AnalysisResultLvl2a prevRes) {
        AnalysisResultLvl2a currRes = this.performSummaryAnalysis(angraph);
        return this.mResComparer.comparePrevAndCur(prevRes, currRes);
    }
}

