/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.extension.lvl2a;

import com.mxgraph.canvas.mxICanvas;
import com.mxgraph.canvas.mxSvgCanvas;
import com.mxgraph.layout.mxGraphLayout;
import com.mxgraph.layout.mxOrganicLayout;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxXmlUtils;
import com.mxgraph.view.mxGraph;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class GroupedLayout
extends mxGraphLayout {
    private static final double BORDER = 20.0;
    private final mxOrganicLayout layout;
    private static int counter = 0;

    public GroupedLayout(mxGraphLayout layout) {
        super(layout.getGraph());
        this.layout = (mxOrganicLayout)layout;
    }

    public void execute(Object parentVertex) {
        LinkedList<Object> stack = new LinkedList<Object>();
        HashSet processed = new HashSet();
        stack.addFirst(parentVertex);
        while (!stack.isEmpty()) {
            Object vertex = stack.peekFirst();
            Object[] children = this.graph.getChildVertices(vertex);
            if (children.length > 0 && !processed.contains(vertex)) {
                Object[] objectArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    stack.addFirst(child);
                    ++n2;
                }
                processed.add(vertex);
                continue;
            }
            this.graph.getModel().beginUpdate();
            try {
                this.layout.setAverageNodeArea(1000000.0);
                this.layout.execute(vertex);
            }
            finally {
                this.graph.getModel().endUpdate();
            }
            this.graph.getModel().beginUpdate();
            try {
                this.resizeVertex(vertex, children);
            }
            finally {
                this.graph.getModel().endUpdate();
            }
            stack.removeFirst();
        }
    }

    public void executeRec(Object parentVertex) {
        Object[] children;
        GroupedLayout.plot(this.graph);
        Object[] objectArray = children = this.graph.getChildVertices(parentVertex);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            mxRectangle before = this.graph.getCellBounds(child, false, false, true);
            this.execute(child);
            mxRectangle mxRectangle2 = this.graph.getCellBounds(child, false, false, true);
            ++n2;
        }
        this.graph.getModel().beginUpdate();
        try {
            this.layout.execute(parentVertex);
        }
        finally {
            this.graph.getModel().endUpdate();
        }
        this.graph.getModel().beginUpdate();
        try {
            this.resizeVertex(parentVertex, children);
        }
        finally {
            this.graph.getModel().endUpdate();
        }
    }

    private static void plot(mxGraph g) {
        Object rootElement;
        Document svgDoc = null;
        try {
            DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = f.newDocumentBuilder();
            svgDoc = builder.newDocument();
            rootElement = svgDoc.createElement("svg");
            svgDoc.appendChild((Node)rootElement);
        }
        catch (ParserConfigurationException f) {
            // empty catch block
        }
        mxSvgCanvas canvas = new mxSvgCanvas(svgDoc);
        g.drawGraph((mxICanvas)canvas);
        String svg = mxXmlUtils.getXml((Node)canvas.getDocument());
        try {
            rootElement = null;
            Object var5_8 = null;
            try (BufferedWriter bw = Files.newBufferedWriter(Paths.get("graphical_res_" + counter++ + ".svg", new String[0]), StandardCharsets.UTF_8, new OpenOption[0]);){
                bw.write(svg);
            }
            catch (Throwable throwable) {
                if (rootElement == null) {
                    rootElement = throwable;
                } else if (rootElement != throwable) {
                    ((Throwable)rootElement).addSuppressed(throwable);
                }
                throw rootElement;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private double getAvgVertexArea(Object[] vertices) {
        if (vertices.length == 0) {
            return 160000.0;
        }
        double sumArea = 0.0;
        Object[] objectArray = vertices;
        int n = vertices.length;
        int n2 = 0;
        while (n2 < n) {
            Object v = objectArray[n2];
            mxRectangle bounds = this.graph.getCellBounds(v);
            sumArea += bounds.getHeight() * bounds.getWidth();
            ++n2;
        }
        return sumArea / (double)vertices.length;
    }

    private void resizeVertex(Object vertex, Object[] children) {
        mxRectangle newBounds = null;
        if (children.length > 0) {
            double shiftY;
            double shiftX;
            mxRectangle bounds;
            double minX = Double.POSITIVE_INFINITY;
            double maxX = Double.NEGATIVE_INFINITY;
            double minY = Double.POSITIVE_INFINITY;
            double maxY = Double.NEGATIVE_INFINITY;
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                bounds = this.graph.getCellBounds(child);
                minX = Math.min(minX, bounds.getX());
                maxX = Math.max(maxX, bounds.getX() + bounds.getWidth());
                minY = Math.min(minY, bounds.getY());
                maxY = Math.max(maxY, bounds.getY() + bounds.getHeight());
                ++n2;
            }
            bounds = this.graph.getCellBounds(vertex);
            if (bounds == null) {
                shiftX = minX - 20.0;
                shiftY = minY - 20.0;
            } else {
                shiftX = minX - bounds.getX() - 20.0;
                shiftY = minY - bounds.getY() - 20.0;
            }
            Object[] objectArray2 = children;
            int n3 = children.length;
            int n4 = 0;
            while (n4 < n3) {
                Object child = objectArray2[n4];
                bounds = this.graph.getCellBounds(child);
                bounds.setX(bounds.getX() - shiftX);
                bounds.setY(bounds.getY() - shiftY);
                this.graph.resizeCell(child, bounds);
                ++n4;
            }
            newBounds = new mxRectangle(minX, minY, maxX - minX + 40.0, maxY - minY + 40.0);
        } else {
            newBounds = this.graph.getBoundingBox(vertex);
        }
        this.graph.resizeCell(vertex, newBounds);
    }

    public void moveCell(Object cell, double x, double y) {
        this.layout.moveCell(cell, x, y);
    }

    public Object getConstraint(Object key, Object cell) {
        return this.layout.getConstraint(key, cell);
    }

    public Object getConstraint(Object key, Object cell, Object edge, boolean source) {
        return this.layout.getConstraint(key, cell, edge, source);
    }

    public boolean isUseBoundingBox() {
        return this.layout.isUseBoundingBox();
    }

    public void setUseBoundingBox(boolean useBoundingBox) {
        this.layout.setUseBoundingBox(useBoundingBox);
    }

    public boolean isVertexMovable(Object vertex) {
        return this.layout.isVertexMovable(vertex);
    }

    public boolean isVertexIgnored(Object vertex) {
        return this.layout.isVertexIgnored(vertex);
    }

    public boolean isEdgeIgnored(Object edge) {
        return this.layout.isEdgeIgnored(edge);
    }

    public void setEdgeStyleEnabled(Object edge, boolean value) {
        this.layout.setEdgeStyleEnabled(edge, value);
    }

    public void setOrthogonalEdge(Object edge, boolean value) {
        this.layout.setOrthogonalEdge(edge, value);
    }

    public mxPoint getParentOffset(Object parentVertex) {
        return this.layout.getParentOffset(parentVertex);
    }

    public void setEdgePoints(Object edge, List<mxPoint> points) {
        this.layout.setEdgePoints(edge, points);
    }

    public mxRectangle getVertexBounds(Object vertex) {
        return this.layout.getVertexBounds(vertex);
    }

    public mxRectangle setVertexLocation(Object vertex, double x, double y) {
        return this.layout.setVertexLocation(vertex, x, y);
    }

    public void arrangeGroups(Object[] groups, int border) {
        this.layout.arrangeGroups(groups, border);
    }
}

