/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.extension.lvl2a;

import de.upb.pga3.panda2.core.datastructures.AnalysisGraph;
import de.upb.pga3.panda2.core.datastructures.Input;
import de.upb.pga3.panda2.core.datastructures.Transition;
import de.upb.pga3.panda2.extension.lvl2a.ParameterNode;
import de.upb.pga3.panda2.extension.lvl2a.TransitionLvl2a;
import gnu.trove.strategy.HashingStrategy;
import gnu.trove.strategy.IdentityHashingStrategy;
import java.util.Set;
import soot.SootMethod;
import soot.Unit;
import soot.util.HashMultiMap;
import soot.util.MultiMap;

public class AnalysisGraphLvl2a
extends AnalysisGraph {
    private final transient MultiMap<Unit, ParameterNode> mUnitToParamNodes = new HashMultiMap<Unit, ParameterNode>();
    private final transient MultiMap<SootMethod, ParameterNode> mMethodToParamNodes = new HashMultiMap<SootMethod, ParameterNode>();

    public AnalysisGraphLvl2a(Input inInput) {
        super(inInput, (HashingStrategy<Object>)new IdentityHashingStrategy(), new EquivToHashingStrategy());
    }

    public void addParameterNode(ParameterNode inParamNode) {
        if (inParamNode.belongsToMethod()) {
            this.mMethodToParamNodes.put(inParamNode.getCorrespondingMethod(), inParamNode);
        } else {
            this.mUnitToParamNodes.put(inParamNode.getCorrespondingUnit(), inParamNode);
        }
    }

    public Set<Unit> getParameterizedInvokeStmnts() {
        return this.mUnitToParamNodes.keySet();
    }

    public Set<SootMethod> getParameterizedMethods() {
        return this.mMethodToParamNodes.keySet();
    }

    public boolean hasParameterNodes(Unit inStmnt) {
        return this.mUnitToParamNodes.containsKey(inStmnt);
    }

    public boolean hasParameterNodes(SootMethod inMethod) {
        return this.mMethodToParamNodes.containsKey(inMethod);
    }

    public Set<ParameterNode> getParameterNodes(Unit inInvokeStmnt) {
        if (this.mUnitToParamNodes.containsKey(inInvokeStmnt)) {
            return this.mUnitToParamNodes.get(inInvokeStmnt);
        }
        throw new IllegalArgumentException("No parameter nodes correspond to the given statement!");
    }

    public Set<ParameterNode> getParameterNodes(SootMethod inMethod) {
        if (this.mMethodToParamNodes.containsKey(inMethod)) {
            return this.mMethodToParamNodes.get(inMethod);
        }
        throw new IllegalArgumentException("No parameter nodes correspond to the given statement!");
    }

    private static class EquivToHashingStrategy
    implements HashingStrategy<Transition> {
        public int computeHashCode(Transition arg0) {
            return ((TransitionLvl2a)arg0).equivHashCode();
        }

        public boolean equals(Transition arg0, Transition arg1) {
            return ((TransitionLvl2a)arg0).equivTo(arg1);
        }
    }
}

