/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.core.services;

import de.upb.pga3.panda2.client.core.datastructures.ManifestInfo;
import de.upb.pga3.panda2.core.datastructures.IntentFilter;
import de.upb.pga3.panda2.core.services.BinaryParser;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ManifestXMLParser
extends BinaryParser {
    private static final Logger LOGGER = LogManager.getLogger(ManifestXMLParser.class);
    private String mStrXMLContent;
    private ManifestInfo mManifestInfo;
    private String mStrAppName;
    private List<String> mLstActivities;
    private List<String> mLstServices;
    private List<String> mLstReceivers;
    private List<String> mLstProviders;
    private List<String> mLstUsesPermission;
    private Map<String, String> mMapRequiredPermissions;
    private Map<String, String> mMapProviderURIs;
    private List<IntentFilter> mLstIntentFilter;

    public ManifestXMLParser(String inAPKPath) {
        super(inAPKPath);
    }

    @Override
    protected boolean parseData(String inAPKFile) {
        File apkFile = new File(inAPKFile);
        if (!apkFile.exists()) {
            LOGGER.info("Can not find the apk file: " + inAPKFile);
            return false;
        }
        this.mLstActivities = new ArrayList<String>();
        this.mLstServices = new ArrayList<String>();
        this.mLstProviders = new ArrayList<String>();
        this.mLstReceivers = new ArrayList<String>();
        this.mLstUsesPermission = new ArrayList<String>();
        this.mMapRequiredPermissions = new HashMap<String, String>();
        this.mLstIntentFilter = new ArrayList<IntentFilter>();
        this.mMapProviderURIs = new HashMap<String, String>();
        this.mStrXMLContent = this.getStrXMLFromAPK(apkFile, "AndroidManifest.xml");
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new ByteArrayInputStream(this.mStrXMLContent.getBytes("utf-8"))));
            NodeList manifests = doc.getElementsByTagName("manifest");
            if (manifests.getLength() < 1) {
                throw new RuntimeException("Invalid manifest file. Manifest file contains no <manifest> element");
            }
            if (manifests.getLength() > 1) {
                throw new RuntimeException("Invalid manifest file.\tManifest file contains more than one <manifest> element");
            }
            this.extractManifestInfo(manifests.item(0));
            NodeList applications = doc.getElementsByTagName("application");
            if (applications.getLength() < 1) {
                throw new RuntimeException("Invalid manifest file. Manifest file contains no <application> element");
            }
            if (applications.getLength() > 1) {
                throw new RuntimeException("Invalid manifest file. Manifest file contains more than one <application> element");
            }
            this.extractAppName();
            NodeList usesPermission = doc.getElementsByTagName("uses-permission");
            this.extractUsesPermission(usesPermission);
            NodeList lstActivities = doc.getElementsByTagName("activity");
            this.extractActivityInfo(lstActivities);
            NodeList lstServices = doc.getElementsByTagName("service");
            this.extractServiceInfo(lstServices);
            NodeList lstProvider = doc.getElementsByTagName("provider");
            this.extractProviderInfo(lstProvider);
            NodeList lstReceiver = doc.getElementsByTagName("receiver");
            this.extractReceiverInfo(lstReceiver);
        }
        catch (RuntimeException e) {
            LOGGER.info("Exception: " + e.getMessage());
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            LOGGER.info("Exception: " + e.getMessage());
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.info("Exception: " + e.getMessage());
            e.printStackTrace();
        }
        catch (SAXException e) {
            LOGGER.info("Exception: " + e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            LOGGER.info("Exception: " + e.getMessage());
            e.printStackTrace();
        }
        return true;
    }

    private void extractActivityInfo(NodeList inLstActivities) {
        try {
            if (inLstActivities != null) {
                int iSize = inLstActivities.getLength();
                int i = 0;
                while (i < iSize) {
                    Node activity = inLstActivities.item(i);
                    String strActivity = activity.getAttributes().getNamedItem("android:name").getNodeValue();
                    this.mLstActivities.add(strActivity);
                    Node reqPermission = activity.getAttributes().getNamedItem("android:permission");
                    if (reqPermission != null) {
                        String requiredPermission = reqPermission.getNodeValue();
                        this.mMapRequiredPermissions.put(strActivity, requiredPermission);
                    }
                    NodeList childLst = activity.getChildNodes();
                    int iSizeChildLst = 0;
                    if (childLst != null && (iSizeChildLst = childLst.getLength()) > 0) {
                        int j = 0;
                        while (j < iSizeChildLst) {
                            Node childNode = childLst.item(j);
                            if (childNode.getNodeName().equals("intent-filter")) {
                                this.extractIntentFilter(strActivity, childNode);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            LOGGER.info("Exception: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    private void extractAppName() {
        String pkgName = this.mManifestInfo.getPackage();
        int pos = pkgName.lastIndexOf(".");
        this.mStrAppName = pkgName.substring(pos + 1, pkgName.length());
    }

    private void extractIntentFilter(String inEleName, Node inNodeIntentFilter) {
        try {
            IntentFilter intent = new IntentFilter(inEleName);
            NodeList childLst = inNodeIntentFilter.getChildNodes();
            int iSize = 0;
            if (childLst != null && (iSize = childLst.getLength()) > 0) {
                int i = 0;
                while (i < iSize) {
                    int iLength;
                    Node node = childLst.item(i);
                    if (node.getNodeName().equals("action")) {
                        String actionName = node.getAttributes().getNamedItem("android:name").getNodeValue();
                        intent.setActionName(actionName);
                    } else if (node.getNodeName().equals("category")) {
                        String categoryName = node.getAttributes().getNamedItem("android:name").getNodeValue();
                        intent.setCategoryName(categoryName);
                    } else if (node.getNodeName().equals("data") && (iLength = node.getAttributes().getLength()) > 0) {
                        int j = 0;
                        while (j < iLength) {
                            Node attData = node.getAttributes().item(j);
                            String attrName = attData.getNodeName();
                            String attrValue = attData.getNodeValue();
                            intent.addData(attrName, attrValue);
                            ++j;
                        }
                    }
                    ++i;
                }
                this.mLstIntentFilter.add(intent);
            }
        }
        catch (Exception ex) {
            LOGGER.info("Exception: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    private void extractManifestInfo(Node inManifestNode) {
        if (inManifestNode != null) {
            try {
                String packName = inManifestNode.getAttributes().getNamedItem("package").getNodeValue();
                String versionCode = inManifestNode.getAttributes().getNamedItem("android:versionCode").getNodeValue();
                String versionName = inManifestNode.getAttributes().getNamedItem("android:versionName").getNodeValue();
                this.mManifestInfo = new ManifestInfo(versionCode, versionName, packName);
            }
            catch (Exception ex) {
                LOGGER.info("Exception: " + ex.getMessage());
                ex.printStackTrace();
            }
        }
    }

    private void extractProviderInfo(NodeList inLstProviders) {
        try {
            if (inLstProviders != null) {
                int iSize = inLstProviders.getLength();
                int i = 0;
                while (i < iSize) {
                    Node provider = inLstProviders.item(i);
                    String strProvider = provider.getAttributes().getNamedItem("android:name").getNodeValue();
                    this.mLstProviders.add(strProvider);
                    Node reqPermission = provider.getAttributes().getNamedItem("android:permission");
                    if (reqPermission != null) {
                        String requiredPermission = reqPermission.getNodeValue();
                        this.mMapRequiredPermissions.put(strProvider, requiredPermission);
                    }
                    NodeList childLst = provider.getChildNodes();
                    int iSizeChildLst = 0;
                    if (childLst != null && (iSizeChildLst = childLst.getLength()) > 0) {
                        int j = 0;
                        while (j < iSizeChildLst) {
                            Node attrPath;
                            Node child = childLst.item(j);
                            if (child.getNodeName().equals("grant-uri-permission") && (attrPath = child.getAttributes().getNamedItem("android:path")) != null) {
                                this.mMapProviderURIs.put(strProvider, attrPath.getNodeValue());
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            LOGGER.info("Exception: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    private void extractReceiverInfo(NodeList inLstReceivers) {
        try {
            if (inLstReceivers != null) {
                int iSize = inLstReceivers.getLength();
                int i = 0;
                while (i < iSize) {
                    Node activity = inLstReceivers.item(i);
                    String strReceiver = activity.getAttributes().getNamedItem("android:name").getNodeValue();
                    this.mLstReceivers.add(strReceiver);
                    Node reqPermission = activity.getAttributes().getNamedItem("android:permission");
                    if (reqPermission != null) {
                        String requiredPermission = reqPermission.getNodeValue();
                        this.mMapRequiredPermissions.put(strReceiver, requiredPermission);
                    }
                    NodeList childLst = activity.getChildNodes();
                    int iSizeChildLst = 0;
                    if (childLst != null && (iSizeChildLst = childLst.getLength()) > 0) {
                        int j = 0;
                        while (j < iSizeChildLst) {
                            Node childNode = childLst.item(j);
                            if (childNode.getNodeName().equals("intent-filter")) {
                                this.extractIntentFilter(strReceiver, childNode);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            LOGGER.info("Exception: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    private void extractServiceInfo(NodeList inLstServices) {
        try {
            if (inLstServices != null) {
                int iSize = inLstServices.getLength();
                int i = 0;
                while (i < iSize) {
                    Node activity = inLstServices.item(i);
                    String strService = activity.getAttributes().getNamedItem("android:name").getNodeValue();
                    this.mLstServices.add(strService);
                    Node reqPermission = activity.getAttributes().getNamedItem("android:permission");
                    if (reqPermission != null) {
                        String requiredPermission = reqPermission.getNodeValue();
                        this.mMapRequiredPermissions.put(strService, requiredPermission);
                    }
                    NodeList childLst = activity.getChildNodes();
                    int iSizeChildLst = 0;
                    if (childLst != null && (iSizeChildLst = childLst.getLength()) > 0) {
                        int j = 0;
                        while (j < iSizeChildLst) {
                            Node childNode = childLst.item(j);
                            if (childNode.getNodeName().equals("intent-filter")) {
                                this.extractIntentFilter(strService, childNode);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            LOGGER.info("Exception: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    private void extractUsesPermission(NodeList inNodeListPermission) {
        try {
            if (inNodeListPermission != null) {
                int iSize = inNodeListPermission.getLength();
                int i = 0;
                while (i < iSize) {
                    Node nPerm = inNodeListPermission.item(i);
                    String strPerm = nPerm.getAttributes().getNamedItem("android:name").getNodeValue();
                    this.mLstUsesPermission.add(strPerm);
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            LOGGER.info("Exception: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public List<String> getLstProviders() {
        if (this.mLstProviders != null && this.mLstProviders.size() > 0) {
            ArrayList<String> fullNameProviders = new ArrayList<String>();
            String packageName = this.mManifestInfo.getPackage();
            int iCount = 0;
            for (String proName : this.mLstProviders) {
                if (proName.contains(packageName)) break;
                fullNameProviders.add(String.valueOf(packageName) + proName);
                ++iCount;
            }
            if (iCount == 0) {
                return this.mLstProviders;
            }
            return fullNameProviders;
        }
        return null;
    }

    public List<String> getLstReceivers() {
        if (this.mLstReceivers != null && this.mLstReceivers.size() > 0) {
            ArrayList<String> fullNameReceivers = new ArrayList<String>();
            String packageName = this.mManifestInfo.getPackage();
            int iCount = 0;
            for (String recName : this.mLstReceivers) {
                if (recName.contains(packageName)) break;
                fullNameReceivers.add(String.valueOf(packageName) + recName);
                ++iCount;
            }
            if (iCount == 0) {
                return this.mLstReceivers;
            }
            return fullNameReceivers;
        }
        return null;
    }

    public List<String> getLstServices() {
        if (this.mLstServices != null && this.mLstServices.size() > 0) {
            ArrayList<String> fullNameServices = new ArrayList<String>();
            String packageName = this.mManifestInfo.getPackage();
            int iCount = 0;
            for (String serName : this.mLstServices) {
                if (serName.contains(packageName)) break;
                fullNameServices.add(String.valueOf(packageName) + serName);
                ++iCount;
            }
            if (iCount == 0) {
                return this.mLstServices;
            }
            return fullNameServices;
        }
        return null;
    }

    public List<String> getLstActivities() {
        if (this.mLstActivities != null && this.mLstActivities.size() > 0) {
            ArrayList<String> fullNameActivities = new ArrayList<String>();
            String packageName = this.mManifestInfo.getPackage();
            int iCount = 0;
            for (String actName : this.mLstActivities) {
                if (actName.contains(packageName)) break;
                fullNameActivities.add(String.valueOf(packageName) + actName);
                ++iCount;
            }
            if (iCount == 0) {
                return this.mLstActivities;
            }
            return fullNameActivities;
        }
        return null;
    }

    public ManifestInfo getManifestInfo() {
        return this.mManifestInfo;
    }

    public String getAppName() {
        return this.mStrAppName;
    }

    public List<String> getUsesPermission() {
        return this.mLstUsesPermission;
    }

    public Map<String, String> getRequiredPermissions() {
        return this.mMapRequiredPermissions;
    }

    public List<IntentFilter> getIntentFilters() {
        return this.mLstIntentFilter;
    }

    public Map<String, String> getContentProviderURIs() {
        return this.mMapProviderURIs;
    }
}

