/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.core.services;

import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.core.datastructures.IntentFilter;
import de.upb.pga3.panda2.core.services.GlobalVariable;
import de.upb.pga3.panda2.core.services.IntentInformation;
import de.upb.pga3.panda2.core.services.StatementAnalyzer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.PatchingChain;
import soot.SootClass;
import soot.Unit;
import soot.ValueBox;
import soot.jimple.internal.JAssignStmt;
import soot.jimple.internal.JIdentityStmt;
import soot.toolkits.graph.ExceptionalUnitGraph;

public final class A3StatementAnalyzer
implements StatementAnalyzer {
    private static A3StatementAnalyzer INSTANCE;

    public static A3StatementAnalyzer getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new A3StatementAnalyzer();
        }
        return INSTANCE;
    }

    @Override
    public Collection<IntentInformation> getAllIntents(Body inBody, EnhancedInput inInput, Map<String, GlobalVariable> ininMapGlobalVars) {
        ArrayList<IntentInformation> collIntentInfoObjs = new ArrayList<IntentInformation>();
        Collection<IntentInformation> launchedIntents = this.analyzeIntents(inBody, inInput, ininMapGlobalVars);
        if (launchedIntents != null && !launchedIntents.isEmpty()) {
            for (IntentInformation intInfo : launchedIntents) {
                if (!intInfo.isValid() || intInfo.getTypeIntent() != 0 && intInfo.getTypeIntent() != 1) continue;
                collIntentInfoObjs.add(intInfo);
            }
        }
        return collIntentInfoObjs;
    }

    @Override
    public Collection<IntentInformation> getExplicitIntents(Body inBody, EnhancedInput inInput, Map<String, GlobalVariable> ininMapGlobalVars) {
        ArrayList<IntentInformation> returnValues = new ArrayList<IntentInformation>();
        Collection<IntentInformation> launchedIntents = this.analyzeIntents(inBody, inInput, ininMapGlobalVars);
        if (launchedIntents != null && !launchedIntents.isEmpty()) {
            for (IntentInformation intInfo : launchedIntents) {
                if (intInfo.getTypeIntent() != 0 || !intInfo.isValid()) continue;
                returnValues.add(intInfo);
            }
        }
        return returnValues;
    }

    @Override
    public Collection<IntentInformation> getImplicitIntents(Body inBody, EnhancedInput inInput, Map<String, GlobalVariable> ininMapGlobalVars) {
        ArrayList<IntentInformation> returnValues = new ArrayList<IntentInformation>();
        Collection<IntentInformation> launchedIntents = this.analyzeIntents(inBody, inInput, ininMapGlobalVars);
        if (launchedIntents != null && !launchedIntents.isEmpty()) {
            for (IntentInformation intInfo : launchedIntents) {
                if (intInfo.getTypeIntent() != 1 || !intInfo.isValid()) continue;
                returnValues.add(intInfo);
            }
        }
        return returnValues;
    }

    @Override
    public Collection<SootClass> getTargetsByActionString(String actionStr, EnhancedInput enhancedInput) {
        ArrayList<SootClass> tempResult = new ArrayList<SootClass>();
        if (enhancedInput.getIntentFilters() != null) {
            block0: for (IntentFilter intentFilter : enhancedInput.getIntentFilters()) {
                if (!intentFilter.getActionName().equals(actionStr)) continue;
                SootClass[] sootClassArray = enhancedInput.getAppClasses();
                int n = sootClassArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SootClass classOrComponent = sootClassArray[n2];
                    if (classOrComponent.toString().contains(intentFilter.getTargetName())) {
                        tempResult.add(classOrComponent);
                        continue block0;
                    }
                    ++n2;
                }
            }
        }
        return tempResult;
    }

    private A3StatementAnalyzer() {
    }

    private Collection<IntentInformation> analyzeIntents(Body inBody, EnhancedInput inInput, Map<String, GlobalVariable> ininMapGlobalVars) {
        ArrayList<IntentInformation> returnValues = new ArrayList<IntentInformation>();
        if (inBody != null) {
            ExceptionalUnitGraph graph = new ExceptionalUnitGraph(inBody);
            PatchingChain<Unit> chainUnt = inBody.getUnits();
            if (chainUnt != null && !chainUnt.isEmpty()) {
                HashMap<String, List<Unit>> mapDefinedLocalVar = new HashMap<String, List<Unit>>();
                HashMap<String, Unit> mapDefVarIntent = new HashMap<String, Unit>();
                HashMap<Unit, List<Object>> mapIntentInfo = new HashMap<Unit, List<Object>>();
                HashSet<Unit> setCheckedUnts = new HashSet<Unit>();
                Object firstUnt = chainUnt.getFirst();
                List<Unit> lstUnits = graph.getSuccsOf((Unit)firstUnt);
                if (lstUnits == null || lstUnits.isEmpty()) {
                    return returnValues;
                }
                ArrayList<List<Unit>> lstProcessedBranches = new ArrayList<List<Unit>>();
                lstProcessedBranches.add(lstUnits);
                while (!lstProcessedBranches.isEmpty()) {
                    lstUnits = (List<Unit>)lstProcessedBranches.get(0);
                    block1: while (!lstUnits.isEmpty()) {
                        Unit unit;
                        List lstInformation;
                        List<ValueBox> lstBoxes;
                        Unit processedUnt = (Unit)lstUnits.get(0);
                        String strProcessedUnt = processedUnt.toString();
                        if (setCheckedUnts.contains(processedUnt)) {
                            lstUnits = this.removeElementAt(0, lstUnits);
                            continue;
                        }
                        if ((processedUnt instanceof JIdentityStmt || processedUnt instanceof JAssignStmt) && (lstBoxes = processedUnt.getDefBoxes()) != null && !lstBoxes.isEmpty()) {
                            ValueBox fiVar = lstBoxes.get(0);
                            String strFiVar = fiVar.getValue().toString();
                            ArrayList<Unit> lstDefUnts = (ArrayList<Unit>)mapDefinedLocalVar.get(strFiVar);
                            if (lstDefUnts == null) {
                                lstDefUnts = new ArrayList<Unit>();
                                lstDefUnts.add(processedUnt);
                                mapDefinedLocalVar.put(strFiVar, lstDefUnts);
                            } else {
                                lstDefUnts.add(processedUnt);
                            }
                        }
                        setCheckedUnts.add(processedUnt);
                        lstUnits = this.removeElementAt(0, lstUnits);
                        List<Unit> nextSucs = graph.getSuccsOf(processedUnt);
                        if (nextSucs == null || nextSucs.isEmpty()) continue;
                        if (nextSucs.size() == 1) {
                            lstUnits.addAll(nextSucs);
                        } else {
                            lstUnits.add(nextSucs.get(0));
                            int i = 1;
                            while (i < nextSucs.size()) {
                                ArrayList<Unit> newBranch = new ArrayList<Unit>();
                                newBranch.add(nextSucs.get(i));
                                lstProcessedBranches.add(newBranch);
                                ++i;
                            }
                        }
                        if (this.isDefinedIntent(processedUnt)) {
                            List<ValueBox> defBoxes = processedUnt.getDefBoxes();
                            if (defBoxes == null || defBoxes.isEmpty()) continue;
                            ValueBox defVar = defBoxes.get(0);
                            mapDefVarIntent.put(defVar.getValue().toString(), processedUnt);
                            ArrayList lstTemp = new ArrayList();
                            mapIntentInfo.put(processedUnt, lstTemp);
                            continue;
                        }
                        if (strProcessedUnt.contains("android.content.Intent: void <init>")) {
                            List<IntentInformation> lstIntInfo = this.processIntentConstructor(processedUnt, inInput, mapDefinedLocalVar, ininMapGlobalVars);
                            Set setVars = mapDefVarIntent.keySet();
                            for (Object var : setVars) {
                                String keyword = String.valueOf(var) + ".<" + "android.content.Intent: void <init>";
                                if (!strProcessedUnt.contains(keyword)) continue;
                                Unit tmpUnt = (Unit)mapDefVarIntent.get(var);
                                if (tmpUnt == null) continue block1;
                                List lstTmpIntInfo = (List)mapIntentInfo.get(tmpUnt);
                                if (lstTmpIntInfo == null) {
                                    mapIntentInfo.put(tmpUnt, lstIntInfo);
                                    continue block1;
                                }
                                lstTmpIntInfo.addAll(lstIntInfo);
                                continue block1;
                            }
                            continue;
                        }
                        if (strProcessedUnt.contains("android.content.Intent: android.content.Intent setAction") || strProcessedUnt.contains("android.content.Intent: android.content.Intent setClass") || strProcessedUnt.contains("android.content.Intent: android.content.Intent setClassName") || strProcessedUnt.contains("android.content.Intent: android.content.Intent setComponent")) {
                            Object var;
                            Set setVars = mapDefVarIntent.keySet();
                            var = setVars.iterator();
                            while (var.hasNext()) {
                                List lstTmpIntInfo;
                                String var2 = (String)var.next();
                                String keyword = String.valueOf(var2) + ".<" + "android.content.Intent: android.content.Intent set";
                                if (!strProcessedUnt.contains(keyword)) continue;
                                Unit tmpUnt = (Unit)mapDefVarIntent.get(var2);
                                if (tmpUnt == null || (lstTmpIntInfo = (List)mapIntentInfo.get(tmpUnt)) == null || lstTmpIntInfo.isEmpty()) continue block1;
                                this.processIntentSetMethod(processedUnt, inInput, lstTmpIntInfo, mapDefinedLocalVar, ininMapGlobalVars);
                                continue block1;
                            }
                            continue;
                        }
                        String var = this.getIntentVariableInLaunchingMethod(strProcessedUnt);
                        if (var.isEmpty() || (lstInformation = (List)mapIntentInfo.get(unit = (Unit)mapDefVarIntent.get(var = var.trim()))) == null || lstInformation.isEmpty()) continue;
                        for (IntentInformation intInfo : lstInformation) {
                            intInfo.addStartingUnit(processedUnt);
                            intInfo.setValid(true);
                            if (returnValues.contains(intInfo)) continue;
                            returnValues.add(intInfo);
                        }
                    }
                    lstProcessedBranches.remove(0);
                }
            }
        }
        return returnValues;
    }

    private static Collection<SootClass> getTargetsByClassName(String targetClassName, EnhancedInput enhancedInput) {
        ArrayList<SootClass> tempResult = new ArrayList<SootClass>();
        SootClass[] sootClassArray = enhancedInput.getAppClasses();
        int n = sootClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            SootClass component = sootClassArray[n2];
            if (enhancedInput.isAndroidComponent(component) && component.toString().equals(targetClassName)) {
                tempResult.add(component);
                return tempResult;
            }
            ++n2;
        }
        return tempResult;
    }

    private static String getTargetClassName(Unit unit, Map<String, List<Unit>> inMapDefLocalVars, Map<String, GlobalVariable> ininMapGlobalVars) {
        String targetClassName = null;
        String packageName = null;
        String strUnit = unit.toString();
        if (!strUnit.contains("android.content.Intent: android.content.Intent setClassName(android.content.Context,java.lang.String)") && !strUnit.contains("android.content.Intent: android.content.Intent setClassName(java.lang.String,java.lang.String)")) {
            int pos1 = strUnit.indexOf(60);
            int pos2 = strUnit.lastIndexOf(62);
            String strLstPrams = strUnit.substring(pos2 + 2, strUnit.length() - 1);
            String subStrUnt = strUnit.substring(pos1 + 1, pos2);
            pos1 = subStrUnt.indexOf(40);
            pos2 = subStrUnt.indexOf(41);
            subStrUnt = subStrUnt.substring(pos1 + 1, pos2);
            String[] lstParamTypes = subStrUnt.split(",");
            int i = 0;
            if (lstParamTypes != null && lstParamTypes.length > 0) {
                i = 0;
                while (i < lstParamTypes.length) {
                    String param = lstParamTypes[i];
                    if (param.equals("java.lang.Class")) break;
                    ++i;
                }
            }
            String[] arrPrams = strLstPrams.split(",");
            if (i >= 0 && i < arrPrams.length) {
                targetClassName = arrPrams[i];
            }
        } else {
            String[] arrParams;
            String strLstPrams;
            int pos2 = strUnit.lastIndexOf(62);
            if (pos2 != -1 && (strLstPrams = strUnit.substring(pos2 + 2, strUnit.length() - 1)) != null && !strLstPrams.isEmpty() && (arrParams = strLstPrams.split(",")).length == 2) {
                packageName = arrParams[0].trim();
                targetClassName = arrParams[1].trim();
            }
        }
        targetClassName = A3StatementAnalyzer.processTargetClassName(targetClassName, packageName, inMapDefLocalVars, ininMapGlobalVars);
        return targetClassName;
    }

    private static String processTargetClassName(String inTargetClassName, String inPackagename, Map<String, List<Unit>> inMapDefLocalVars, Map<String, GlobalVariable> ininMapGlobalVars) {
        String targetClassName = inTargetClassName;
        String packagename = inPackagename;
        if (targetClassName != null && !targetClassName.isEmpty()) {
            if (targetClassName.indexOf(34) != -1 || targetClassName.indexOf(36) == -1) {
                targetClassName = targetClassName.substring(targetClassName.indexOf(34) + 1, targetClassName.length() - 1);
                targetClassName = targetClassName.replaceAll("/", ".");
            } else {
                int i;
                List<Unit> lstDefUnt;
                if (targetClassName.indexOf(36) != -1 && inMapDefLocalVars != null && !inMapDefLocalVars.isEmpty() && (lstDefUnt = inMapDefLocalVars.get(targetClassName)) != null && !lstDefUnt.isEmpty()) {
                    i = lstDefUnt.size() - 1;
                    while (i >= 0) {
                        boolean isUpdatedAlready = false;
                        String strTmpUnit = lstDefUnt.get(i).toString();
                        if (strTmpUnit.contains("= \"")) {
                            targetClassName = strTmpUnit.substring(strTmpUnit.indexOf(34) + 1, strTmpUnit.length() - 1);
                            targetClassName = targetClassName.replaceAll("/", ".");
                            break;
                        }
                        if (!strTmpUnit.contains("(") && !strTmpUnit.contains(")")) {
                            Collection<GlobalVariable> colGlobeVars = ininMapGlobalVars.values();
                            block1: for (GlobalVariable globeVar : colGlobeVars) {
                                String strGlobeVar = globeVar.toString();
                                if (!strTmpUnit.contains(strGlobeVar)) continue;
                                List<String> lstValue = globeVar.getValues();
                                if (lstValue == null || lstValue.isEmpty()) break;
                                int j = lstValue.size() - 1;
                                while (j >= 0) {
                                    String val = lstValue.get(j);
                                    if (val.contains("\"")) {
                                        int iPos1 = val.indexOf(34);
                                        int iPos2 = val.lastIndexOf(34);
                                        targetClassName = val.substring(iPos1 + 1, iPos2);
                                        targetClassName = targetClassName.replace("/", ".");
                                        isUpdatedAlready = true;
                                        break block1;
                                    }
                                    --j;
                                }
                                break block1;
                            }
                        }
                        if (isUpdatedAlready) break;
                        --i;
                    }
                }
                if (packagename != null && !packagename.isEmpty()) {
                    if (packagename.indexOf(36) != -1 && inMapDefLocalVars != null && !inMapDefLocalVars.isEmpty() && (lstDefUnt = inMapDefLocalVars.get(packagename)) != null && !lstDefUnt.isEmpty()) {
                        i = lstDefUnt.size() - 1;
                        while (i >= 0) {
                            String strTmpUnit = lstDefUnt.get(i).toString();
                            if (strTmpUnit.contains("= \"")) {
                                packagename = strTmpUnit.substring(strTmpUnit.indexOf(34) + 1, strTmpUnit.length() - 1);
                                packagename = packagename.replaceAll("/", ".");
                            }
                            --i;
                        }
                    }
                    packagename = packagename.replaceAll("/", ".");
                    if (!targetClassName.contains(packagename = packagename.replaceAll("\"", ""))) {
                        targetClassName = String.valueOf(packagename) + "." + targetClassName;
                    }
                }
            }
        }
        return targetClassName;
    }

    private static String getActionName(Unit inUnit, Map<String, List<Unit>> inMapDefLocalVars, Map<String, GlobalVariable> ininMapGlobalVars) {
        String actionStr = null;
        String strUnit = inUnit.toString();
        if (strUnit != null && !strUnit.isEmpty()) {
            List<Unit> lstDefUnts;
            String[] lstPrams;
            int pos1 = strUnit.indexOf(60);
            int pos2 = strUnit.lastIndexOf(62);
            String strLstPrams = strUnit.substring(pos2 + 2, strUnit.length() - 1);
            if (strLstPrams != null && !strLstPrams.isEmpty() && (lstPrams = strLstPrams.split(",")) != null && lstPrams.length >= 1) {
                actionStr = lstPrams[0];
            }
            if (actionStr != null && actionStr.contains("$") && inMapDefLocalVars != null && !inMapDefLocalVars.isEmpty() && (lstDefUnts = inMapDefLocalVars.get(actionStr)) != null && !lstDefUnts.isEmpty()) {
                int iSize = lstDefUnts.size();
                boolean isUpdatedAlready = false;
                int i = iSize - 1;
                while (i >= 0) {
                    String strUnEle = lstDefUnts.get(i).toString();
                    if (!strUnEle.contains("(") && !strUnEle.contains(")")) {
                        Collection<GlobalVariable> colGlobeVars = ininMapGlobalVars.values();
                        block1: for (GlobalVariable globeVar : colGlobeVars) {
                            String strGlobeVar = globeVar.toString();
                            if (!strUnEle.contains(strGlobeVar)) continue;
                            List<String> lstValue = globeVar.getValues();
                            if (lstValue == null || lstValue.isEmpty()) break;
                            for (String val : lstValue) {
                                if (!val.contains("\"")) continue;
                                int iPos1 = val.indexOf(34);
                                int iPos2 = val.lastIndexOf(34);
                                actionStr = val.substring(iPos1 + 1, iPos2 - 1);
                                actionStr = actionStr.replace("/", ".");
                                isUpdatedAlready = true;
                                break block1;
                            }
                        }
                    }
                    if (isUpdatedAlready) break;
                    int index1 = strUnEle.indexOf(34);
                    int index2 = strUnEle.indexOf(60);
                    if ((index2 == -1 || index1 == -1) && index2 == -1 && index1 != -1) {
                        int index3 = strUnEle.lastIndexOf(34);
                        actionStr = strUnEle.substring(index1 + 1, index3 - 1);
                        actionStr = actionStr.replace("/", ".");
                        break;
                    }
                    --i;
                }
            }
            if (actionStr.contains("\"")) {
                actionStr = actionStr.replaceAll("\"", "");
            }
        }
        return actionStr;
    }

    private List<Unit> removeElementAt(int inPos, List<Unit> inLstUnits) {
        ArrayList<Unit> lstUnits = new ArrayList<Unit>();
        if (inLstUnits != null && !inLstUnits.isEmpty() && inPos >= 0 && inPos < inLstUnits.size()) {
            int i = 0;
            while (i < inLstUnits.size()) {
                if (i != inPos) {
                    lstUnits.add(inLstUnits.get(i));
                }
                ++i;
            }
        }
        return lstUnits;
    }

    private String getIntentVariableInLaunchingMethod(String inStrUnit) {
        String var = "";
        if (!inStrUnit.contains("goto ") && !inStrUnit.contains("if ") && (inStrUnit.contains("void startActivity(android.content.Intent)") || inStrUnit.contains("void startActivity(android.content.Intent,android.os.Bundle)") || inStrUnit.contains("void startActivities(android.content.Intent[])") || inStrUnit.contains("void startActivities(android.content.Intent[],android.os.Bundle)") || inStrUnit.contains("void startActivityForResult(android.content.Intent,int)") || inStrUnit.contains("void startActivityForResult(android.content.Intent,int,android.os.Bundle)") || inStrUnit.contains("void startActivityFromChild(android.app.Activity,android.content.Intent,int)") || inStrUnit.contains("void startActivityFromChild(android.app.Activity,android.content.Intent,int,android.os.Bundle)") || inStrUnit.contains("void startActivityFromFragment(android.app.Fragment,android.content.Intent,int)") || inStrUnit.contains("void startActivityFromFragment(android.app.Fragment,android.content.Intent,int,android.os.Bundle)") || inStrUnit.contains("boolean startActivityIfNeeded(android.content.Intent,int)") || inStrUnit.contains("boolean startActivityIfNeeded(android.content.Intent,int,android.os.Bundle)") || inStrUnit.contains("boolean startNextMatchingActivity(android.content.Intent)") || inStrUnit.contains("boolean startNextMatchingActivity(android.content.Intent,android.os.Bundle)") || inStrUnit.contains("android.content.ComponentName startService(android.content.Intent)") || inStrUnit.contains("boolean bindService(android.content.Intent,android.content.ServiceConnection,int)") || inStrUnit.contains("void sendBroadcast(android.content.Intent,java.lang.String)") || inStrUnit.contains("void sendBroadcast(android.content.Intent)") || inStrUnit.contains("void sendOrderedBroadcast(android.content.Intent,java.lang.String)") || inStrUnit.contains("void sendOrderedBroadcast(android.content.Intent,java.lang.String,android.content.BroadcastReceiver,android.os.Handler,int,java.lang.String,android.os.Bundle)") || inStrUnit.contains("void sendStickyBroadcast(android.content.Intent)") || inStrUnit.contains("void sendStickyOrderedBroadcast(android.content.Intent,android.content.BroadcastReceiver,android.os.Handler,int,java.lang.String,android.os.Bundle)"))) {
            int pos1 = inStrUnit.indexOf(60);
            int pos2 = inStrUnit.indexOf(62);
            String strLstParams = inStrUnit.substring(pos2 + 2, inStrUnit.length() - 1);
            String strParamTypes = inStrUnit.substring(pos1 + 1, pos2);
            pos1 = strParamTypes.indexOf(40);
            pos2 = strParamTypes.indexOf(41);
            strParamTypes = strParamTypes.substring(pos1 + 1, pos2);
            String[] lstParamTypes = strParamTypes.split(",");
            int i = 0;
            if (lstParamTypes != null && lstParamTypes.length > 0) {
                i = 0;
                while (i < lstParamTypes.length) {
                    String param = lstParamTypes[i];
                    if (param.equals("android.content.Intent")) break;
                    ++i;
                }
            }
            String[] lstPrams = strLstParams.split(",");
            if (i >= 0 && i < lstPrams.length) {
                var = lstPrams[i];
            }
            return var;
        }
        return var;
    }

    private void processIntentSetMethod(Unit inUnit, EnhancedInput inInput, List<IntentInformation> inLstIntInfo, Map<String, List<Unit>> inMapLocalVars, Map<String, GlobalVariable> ininMapGlobalVars) {
        block3: {
            Collection<SootClass> collScs;
            String className;
            String strUnt;
            block4: {
                strUnt = inUnit.toString();
                if (strUnt.contains("goto ") || strUnt.contains("if ")) break block3;
                if (!strUnt.contains("android.content.Intent: android.content.Intent setAction(java.lang.String)")) break block4;
                String actionStr = A3StatementAnalyzer.getActionName(inUnit, inMapLocalVars, ininMapGlobalVars);
                if (actionStr == null) break block3;
                for (IntentInformation intInfo : inLstIntInfo) {
                    if (intInfo.getTypeIntent() != -1) continue;
                    intInfo.setTypeIntent(1);
                    intInfo.setClassNameOrActionString(actionStr);
                    Collection<SootClass> collScs2 = this.getTargetsByActionString(actionStr, inInput);
                    if (collScs2 == null || collScs2.isEmpty()) continue;
                    intInfo.addTargetClasses(collScs2);
                }
                break block3;
            }
            if ((strUnt.contains("android.content.Intent: android.content.Intent setClass(android.content.Context,java.lang.Class)") || strUnt.contains("android.content.Intent: android.content.Intent setClassName(android.content.Context,java.lang.String)") || strUnt.contains("android.content.Intent: android.content.Intent setClassName(java.lang.String,java.lang.String)")) && (className = A3StatementAnalyzer.getTargetClassName(inUnit, inMapLocalVars, ininMapGlobalVars)) != null && !className.isEmpty() && (collScs = A3StatementAnalyzer.getTargetsByClassName(className, inInput)) != null && !collScs.isEmpty()) {
                for (IntentInformation intInfo : inLstIntInfo) {
                    intInfo.setClassNameOrActionString(className);
                    intInfo.setTypeIntent(0);
                    intInfo.addTargetClasses(collScs);
                }
            }
        }
    }

    private List<IntentInformation> processIntentConstructor(Unit inUnit, EnhancedInput inInput, Map<String, List<Unit>> inMapDefGeneralVars, Map<String, GlobalVariable> ininMapGlobalVars) {
        String strUnt = inUnit.toString();
        ArrayList<IntentInformation> lstIntents = new ArrayList<IntentInformation>();
        if (!strUnt.contains("goto ") && !strUnt.contains("if ")) {
            if (strUnt.contains("android.content.Intent: void <init>(java.lang.String)") || strUnt.contains("android.content.Intent: void <init>(java.lang.String,android.net.Uri)")) {
                Collection<SootClass> lstSC;
                IntentInformation intInfo = new IntentInformation(1);
                String actionStr = A3StatementAnalyzer.getActionName(inUnit, inMapDefGeneralVars, ininMapGlobalVars);
                intInfo.setClassNameOrActionString(actionStr);
                if (actionStr != null && (lstSC = this.getTargetsByActionString(actionStr, inInput)) != null) {
                    intInfo.addTargetClasses(lstSC);
                }
                lstIntents.add(intInfo);
            } else if (strUnt.contains("android.content.Intent: void <init>(android.content.Context,java.lang.Class)") || strUnt.contains("android.content.Intent: void <init>(java.lang.String,android.net.Uri,android.content.Context,java.lang.Class)")) {
                Collection<SootClass> lstSC;
                IntentInformation intInfo = new IntentInformation(0);
                String className = A3StatementAnalyzer.getTargetClassName(inUnit, inMapDefGeneralVars, ininMapGlobalVars);
                intInfo.setClassNameOrActionString(className);
                if (className != null && (lstSC = A3StatementAnalyzer.getTargetsByClassName(className, inInput)) != null) {
                    intInfo.addTargetClasses(lstSC);
                }
                lstIntents.add(intInfo);
            } else if (strUnt.contains("android.content.Intent: void <init>(android.content.Intent)")) {
                IntentInformation intInfo = new IntentInformation(-1);
                lstIntents.add(intInfo);
            } else {
                IntentInformation intInfo = new IntentInformation(-1);
                lstIntents.add(intInfo);
            }
        }
        return lstIntents;
    }

    private boolean isDefinedIntent(Unit inUnit) {
        if (inUnit != null && (inUnit instanceof JIdentityStmt || inUnit instanceof JAssignStmt)) {
            String inStrUnit = inUnit.toString();
            if (inStrUnit.contains("new android.content.Intent")) {
                return true;
            }
            if (inStrUnit.contains("@parameter") && inStrUnit.contains("android.content.Intent")) {
                return true;
            }
            String keyword = ": android.content.Intent";
            if (inStrUnit.contains(": android.content.Intent")) {
                return true;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void extractGlobalVars(Body inBody, EnhancedInput inInput, Map<String, GlobalVariable> mapGlobalVar) {
        block11: {
            returnValues = new ArrayList<GlobalVariable>();
            unThis = null;
            varThis = "";
            if (inBody == null) break block11;
            graph = new ExceptionalUnitGraph(inBody);
            chainUnt = inBody.getUnits();
            if (chainUnt == null || chainUnt.isEmpty()) break block11;
            setCheckedUnt = new HashSet<Unit>();
            unThis = chainUnt.getFirst();
            if (unThis == null) {
                return;
            }
            if (!(unThis instanceof JIdentityStmt) && !(unThis instanceof JAssignStmt)) {
                return;
            }
            lstBoxes = unThis.getDefBoxes();
            if (lstBoxes != null && !lstBoxes.isEmpty()) {
                fiVar = lstBoxes.get(0);
                varThis = fiVar.getValue().toString();
            }
            if (varThis.isEmpty()) {
                return;
            }
            lastUn = chainUnt.getLast();
            lstUnits = graph.getPredsOf((Unit)lastUn);
            if (lstUnits != null && !lstUnits.isEmpty()) ** GOTO lbl50
            return;
lbl-1000:
            // 1 sources

            {
                processedUnt = lstUnits.get(0);
                strProcessedUnt = processedUnt.toString();
                if (setCheckedUnt.contains(processedUnt)) {
                    lstUnits = this.removeElementAt(0, lstUnits);
                    continue;
                }
                if (processedUnt instanceof JIdentityStmt || processedUnt instanceof JAssignStmt) {
                    lstBoxes = processedUnt.getDefBoxes();
                    lstVB = processedUnt.getUseBoxes();
                    if (lstBoxes != null && !lstBoxes.isEmpty() && (strFiVar = (fiVar = lstBoxes.get(0)).getValue().toString()).contains(String.valueOf(varThis) + ".<") && (subPartsDefVar = (subDefVar = strFiVar.substring((index1 = strFiVar.indexOf(60)) + 1, index2 = strFiVar.indexOf(62))).split(" ")) != null && subPartsDefVar.length == 3 && (sClass = inBody.getMethod().getDeclaringClass()) != null) {
                        inMapGlobVar = mapGlobalVar.get(subPartsDefVar[2]);
                        if (inMapGlobVar == null) {
                            globVar = new GlobalVariable(sClass);
                            globVar.setType(subPartsDefVar[1]);
                            globVar.setVarName(subPartsDefVar[2]);
                            globVar.addUnit(processedUnt);
                            mapGlobalVar.put(subPartsDefVar[2], globVar);
                        } else {
                            inMapGlobVar.addUnit(processedUnt);
                        }
                    }
                }
                setCheckedUnt.add(processedUnt);
                lstUnits = this.removeElementAt(0, lstUnits);
                nextSucs = graph.getPredsOf(processedUnt);
                if (nextSucs == null || nextSucs.isEmpty()) continue;
                lstUnits.addAll(nextSucs);
lbl50:
                // 4 sources

                ** while (!lstUnits.isEmpty())
            }
        }
        for (GlobalVariable globVar : mapGlobalVar.values()) {
            returnValues.add(globVar);
        }
    }
}

