/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.core.datastructures;

public class JavaAPIMethod {
    private String mMethodName;
    private String mClassName;
    private String mReturnType;
    private String mSignature;
    private String mSubSignature;
    private int mHashCode = 0;

    public JavaAPIMethod(String inSignature) {
        this.mSignature = inSignature;
        this.parseSignature(inSignature);
    }

    private void parseSignature(String inSignature) {
        if (inSignature != null && !inSignature.isEmpty()) {
            String optimizedSignature = inSignature.replace("<", "");
            String[] lstSubStr = (optimizedSignature = optimizedSignature.replace(">", "")).split(" ");
            if (lstSubStr.length == 3) {
                this.mClassName = lstSubStr[0].replace(":", "");
                this.mReturnType = lstSubStr[1];
                this.mMethodName = lstSubStr[2];
                this.mSubSignature = String.valueOf(this.mReturnType) + " " + this.mMethodName;
            }
        }
    }

    public String getMethodName() {
        return this.mMethodName;
    }

    public String getClassName() {
        return this.mClassName;
    }

    public String getReturnType() {
        return this.mReturnType;
    }

    public String getSubSignature() {
        return this.mSubSignature;
    }

    public String getSignature() {
        return this.mSignature;
    }

    public boolean equals(Object another) {
        if (super.equals(another)) {
            return true;
        }
        if (!(another instanceof JavaAPIMethod)) {
            return false;
        }
        JavaAPIMethod otherMethod = (JavaAPIMethod)another;
        if (!this.mSignature.equals(otherMethod.mSignature)) {
            return false;
        }
        if (!this.mMethodName.equals(otherMethod.mMethodName)) {
            return false;
        }
        if (!this.mClassName.equals(otherMethod.mClassName)) {
            return false;
        }
        return this.mReturnType.equals(otherMethod.mReturnType);
    }

    public int hashCode() {
        if (this.mHashCode == 0) {
            this.mHashCode = this.mMethodName.hashCode() + this.mClassName.hashCode() * 5;
        }
        return this.mHashCode;
    }

    public String toString() {
        return this.mSignature;
    }
}

