/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.core.datastructures;

import de.upb.pga3.panda2.client.core.datastructures.ManifestInfo;
import de.upb.pga3.panda2.core.datastructures.DetailLevel;
import de.upb.pga3.panda2.core.datastructures.Message;
import de.upb.pga3.panda2.core.services.XMLParser;
import java.util.ArrayList;
import java.util.List;

public abstract class AnalysisResult {
    protected List<Message> mLstMessages = new ArrayList<Message>();
    private ManifestInfo appManifestInfo;
    private String appFingerprint;
    private String appName;
    boolean resultIsFile = false;

    public void initialize(XMLParser xmlParser) {
        this.appManifestInfo = xmlParser.getManifestInformation();
        this.appFingerprint = xmlParser.getFingerprint();
        this.appName = xmlParser.getAppName();
    }

    public abstract String getGraphicalResult(DetailLevel var1, List<String> var2, boolean var3);

    public abstract String getTextualResult(DetailLevel var1, List<String> var2, boolean var3);

    public abstract List<DetailLevel> getDetailLevels();

    public abstract List<String> getFilters();

    public List<Message> getMessages() {
        return this.mLstMessages;
    }

    public void addMessage(Message inMsg) {
        this.mLstMessages.add(inMsg);
    }

    public ManifestInfo getAppManifestInfo() {
        return this.appManifestInfo;
    }

    public void setAppManifestInfo(ManifestInfo appManifestInfo) {
        this.appManifestInfo = appManifestInfo;
    }

    public String getAppFingerprint() {
        return this.appFingerprint;
    }

    public void setAppFingerprint(String appFingerprint) {
        this.appFingerprint = appFingerprint;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public boolean getResultIsFile() {
        return this.resultIsFile;
    }

    public void setResultIsFile(boolean resultIsFile) {
        this.resultIsFile = resultIsFile;
    }
}

