/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.core.datastructures;

import de.upb.pga3.panda2.core.datastructures.Input;
import de.upb.pga3.panda2.core.datastructures.Message;
import de.upb.pga3.panda2.core.datastructures.Transition;
import gnu.trove.strategy.HashingStrategy;
import gnu.trove.strategy.IdentityHashingStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import soot.toolkits.graph.DirectedGraph;
import soot.util.HashMultiMap;

public class AnalysisGraph
implements DirectedGraph<Object> {
    private static final Logger LOGGER = LogManager.getLogger(AnalysisGraph.class);
    private final List<Message> mLstMessage;
    protected final transient HashMultiMap<Object, Transition> mMapTransitionOut;
    protected final transient HashMultiMap<Object, Transition> mMapTransitionIn;
    private final Input mInput;

    public AnalysisGraph(Input inInput) {
        this(inInput, (HashingStrategy<Object>)new IdentityHashingStrategy(), (HashingStrategy<Transition>)new IdentityHashingStrategy());
    }

    protected AnalysisGraph(Input inInput, HashingStrategy<Object> keyStrategy, HashingStrategy<Transition> valueStrategy) {
        this.mInput = inInput;
        this.mMapTransitionOut = new HashMultiMap();
        this.mMapTransitionIn = new HashMultiMap();
        this.mLstMessage = new ArrayList<Message>();
    }

    public boolean addTransition(Transition inTransition) {
        boolean added = true;
        added = added && this.mMapTransitionOut.put(inTransition.getSource(), inTransition);
        boolean bl = added = added && this.mMapTransitionIn.put(inTransition.getTarget(), inTransition);
        if (!added) {
            LOGGER.trace("Transition from '{}' to '{}' could not be added", inTransition.mEleFrom.toString(), inTransition.mEleTo.toString());
        }
        return added;
    }

    public boolean removeTransition(Transition inTransition) {
        boolean removed = true;
        removed = removed && this.mMapTransitionOut.remove(inTransition.getSource(), inTransition);
        boolean bl = removed = removed && this.mMapTransitionIn.remove(inTransition.getTarget(), inTransition);
        if (!removed) {
            LOGGER.trace("Transition from '{}' to '{}' could not be removed", inTransition.mEleFrom.toString(), inTransition.mEleTo.toString());
        }
        return removed;
    }

    public Set<Transition> getOutgoingTransitions(Object inElement) {
        if (this.mMapTransitionOut.containsKey(inElement)) {
            return this.mMapTransitionOut.get(inElement);
        }
        return Collections.emptySet();
    }

    @Deprecated
    public List<Transition> getTransitionList() {
        return new ArrayList<Transition>(this.mMapTransitionIn.values());
    }

    public Set<Transition> getIncomingTransitions(Object inElement) {
        if (this.mMapTransitionIn.containsKey(inElement)) {
            return this.mMapTransitionIn.get(inElement);
        }
        return Collections.emptySet();
    }

    public Set<Object> getNodes() {
        HashSet<Object> nodes = new HashSet<Object>(this.mMapTransitionIn.keySet());
        nodes.addAll(this.mMapTransitionOut.keySet());
        return nodes;
    }

    public void addMessage(Message inMsg) {
        this.mLstMessage.add(inMsg);
    }

    public List<Message> getMessages() {
        return this.mLstMessage;
    }

    public Input getInput() {
        return this.mInput;
    }

    @Override
    public List<Object> getHeads() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Object> getTails() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Object> getPredsOf(Object s) {
        Set<Transition> ingoing = this.mMapTransitionIn.get(s);
        if (ingoing != null) {
            return ingoing.stream().map(t -> t.getSource()).collect(Collectors.toList());
        }
        return new ArrayList<Object>(0);
    }

    @Override
    public List<Object> getSuccsOf(Object s) {
        Set<Transition> outgoing = this.mMapTransitionOut.get(s);
        if (outgoing != null) {
            return outgoing.stream().map(t -> t.getTarget()).collect(Collectors.toList());
        }
        return new ArrayList<Object>(0);
    }

    @Override
    public int size() {
        return this.getNodes().size();
    }

    @Override
    public Iterator<Object> iterator() {
        return this.getNodes().iterator();
    }
}

