/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.client.gui;

import de.upb.pga3.panda2.client.core.AnalysisRegistry;
import de.upb.pga3.panda2.client.gui.ChooserEventHandler;
import de.upb.pga3.panda2.client.gui.Controller;
import de.upb.pga3.panda2.client.gui.GUIHelper;
import de.upb.pga3.panda2.client.gui.GuiConfig;
import de.upb.pga3.panda2.client.gui.InfoWindow;
import de.upb.pga3.panda2.client.gui.Model;
import de.upb.pga3.panda2.core.AsyncAnalysisResult;
import de.upb.pga3.panda2.core.datastructures.AnalysisResult;
import de.upb.pga3.panda2.core.datastructures.DetailLevel;
import de.upb.pga3.panda2.core.datastructures.Message;
import de.upb.pga3.panda2.core.datastructures.MessageType;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.ToolBar;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;

public class GUIView
extends Application
implements AsyncAnalysisResult {
    static final Logger LOGGER = LogManager.getLogger(GUIView.class);
    static final String JS_SCRIPT_ENABLE_FIREBUG = "if (!document.getElementById('FirebugLite')){E = document['createElement' + 'NS'] && document.documentElement.namespaceURI;E = E ? document['createElement' + 'NS'](E, 'script') : document['createElement']('script');E['setAttribute']('id', 'FirebugLite');E['setAttribute']('src', 'https://getfirebug.com/' + 'firebug-lite.js' + '#startOpened');E['setAttribute']('FirebugLite', '4');(document['getElementsByTagName']('head')[0] || document['getElementsByTagName']('body')[0]).appendChild(E);E = new Image;E['setAttribute']('src', 'https://getfirebug.com/' + '#startOpened');}";
    private static AnalysisResult initialResult = null;
    private static File initialApk;
    boolean wait1 = false;
    boolean wait2 = false;
    private Model model = new Model(this);
    private Controller controller = new Controller(this, this.model);
    DetailLevel selectedDetailLevel;
    List<String> selectedFilters;
    boolean selectedShowStats;
    private ImageView statusImage;
    private static final int suggestions = 0;
    private static final int errors = 1;
    private static final int warnings = 2;
    private static final int infos = 3;
    List<List<Node>> messageItems;
    int[] messages;
    Button[] loadAllMessages;
    List<VBox> msgPartBox;
    Stage stage;
    TabPane tabPane;
    Tab tabTextual;
    Tab tabGraphical;
    Tab tabMessages;
    static TextArea infoArea;
    WebView htmlTextual;
    WebView htmlGraphical;
    WebEngine htmlEngineTextual;
    WebEngine htmlEngineGraphical;
    DebugChangeListener dbgChngLstnrTextual;
    DebugChangeListener dbgChngLstnrGraphical;
    VBox filterBox;
    VBox messageBox;
    FlowPane flowPaneActiveFilters;
    Button btnPrev;
    Button btnNext;
    Button btnSave;
    Button btnNew;
    Button btnOpen;
    Button btnViewInBrowser;
    ComboBox<String> analysisJumper;
    Button btnClearJumper;
    MenuItem menuItemNew;
    MenuItem menuItemOpen;
    MenuItem menuItemSave;
    MenuItem menuItemSaveAs;
    String htmlTextualStr;
    String htmlGraphicalStr;
    boolean isFile;

    static {
        infoArea = null;
    }

    Model getModel() {
        return this.model;
    }

    public Controller getController() {
        return this.controller;
    }

    public static void setInitialResult(AnalysisResult result, File apk) {
        initialResult = result;
        initialApk = apk;
    }

    public void start(Stage inStage) {
        GuiConfig.getInstance().load();
        this.stage = inStage;
        this.stage.setTitle("PAndA\u00b2");
        GUIHelper.setPandaIcon(this.stage);
        this.stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent we) {
                we.consume();
                GUIView.this.getController().exitClicked();
            }
        });
        VBox menuBox = new VBox();
        MenuBar menuBar = new MenuBar();
        Menu menuFile = new Menu("File");
        this.menuItemNew = new MenuItem("New Analysis...");
        this.menuItemNew.setGraphic((Node)new ImageView(new Image("file:data/images/document_16.png")));
        this.menuItemNew.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.N, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        this.menuItemNew.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                GUIView.this.getController().newClicked();
            }
        });
        SeparatorMenuItem seperator1 = new SeparatorMenuItem();
        this.menuItemOpen = new MenuItem("Open previous result");
        this.menuItemOpen.setGraphic((Node)new ImageView(new Image("file:data/images/folder_16.png")));
        this.menuItemOpen.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.O, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        this.menuItemOpen.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                GUIView.this.getController().openClicked();
            }
        });
        SeparatorMenuItem seperator2 = new SeparatorMenuItem();
        this.menuItemSave = new MenuItem("Save");
        this.menuItemSave.setGraphic((Node)new ImageView(new Image("file:data/images/save_16.png")));
        this.menuItemSave.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.S, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        this.menuItemSave.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                GUIView.this.getController().saveClicked();
            }
        });
        this.menuItemSaveAs = new MenuItem("Save As...");
        this.menuItemSaveAs.setGraphic((Node)new ImageView(new Image("file:data/images/save_16.png")));
        this.menuItemSaveAs.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                GUIView.this.getController().saveAsClicked();
            }
        });
        SeparatorMenuItem seperator3 = new SeparatorMenuItem();
        MenuItem menuItemExit = new MenuItem("Exit");
        menuItemExit.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                GUIView.this.getController().exitClicked();
            }
        });
        menuFile.getItems().addAll((Object[])new MenuItem[]{this.menuItemNew, seperator1, this.menuItemOpen, seperator2, this.menuItemSave, this.menuItemSaveAs, seperator3, menuItemExit});
        Menu menuHelp = new Menu("Help");
        final CheckMenuItem debugHTMLCheckBox = new CheckMenuItem();
        debugHTMLCheckBox.setGraphic((Node)new ImageView(new Image("file:data/images/firebug.png")));
        debugHTMLCheckBox.setSelected(false);
        debugHTMLCheckBox.setText("Debug HTML");
        debugHTMLCheckBox.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (debugHTMLCheckBox.isSelected()) {
                    GUIView.this.htmlEngineTextual.documentProperty().addListener((ChangeListener)GUIView.this.dbgChngLstnrTextual);
                    GUIView.this.htmlEngineGraphical.documentProperty().addListener((ChangeListener)GUIView.this.dbgChngLstnrGraphical);
                    GUIView.log("Debug HTML enabled");
                } else {
                    GUIView.this.htmlEngineTextual.documentProperty().removeListener((ChangeListener)GUIView.this.dbgChngLstnrTextual);
                    GUIView.this.htmlEngineGraphical.documentProperty().removeListener((ChangeListener)GUIView.this.dbgChngLstnrGraphical);
                    GUIView.log("Debug HTML disabled");
                }
            }
        });
        MenuItem menuItemManual = new MenuItem("Manual");
        menuItemManual.setGraphic((Node)new ImageView(new Image("file:data/images/help_16.png")));
        menuItemManual.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (Desktop.isDesktopSupported()) {
                    try {
                        File myFile = new File("data/help/manual.pdf");
                        Desktop.getDesktop().open(myFile);
                    }
                    catch (IOException ex) {
                        LOGGER.error("Could not access manual.pdf or PDF Viewer.");
                    }
                }
            }
        });
        MenuItem menuItemInfo = new MenuItem("Info");
        menuItemInfo.setGraphic((Node)new ImageView(new Image("file:data/images/logo_panda_16.png")));
        menuItemInfo.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                new InfoWindow().start(new Stage());
            }
        });
        menuHelp.getItems().addAll((Object[])new MenuItem[]{debugHTMLCheckBox, menuItemManual, menuItemInfo});
        menuBar.getMenus().addAll((Object[])new Menu[]{menuFile, menuHelp});
        ToolBar toolBar = new ToolBar();
        this.btnNew = new Button();
        this.btnNew.setGraphic((Node)new ImageView(new Image("file:data/images/document_16.png")));
        this.btnNew.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                GUIView.this.getController().newClicked();
            }
        });
        this.btnOpen = new Button();
        this.btnOpen.setGraphic((Node)new ImageView(new Image("file:data/images/folder_16.png")));
        this.btnOpen.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                GUIView.this.getController().openClicked();
            }
        });
        this.btnSave = new Button();
        this.btnSave.setGraphic((Node)new ImageView(new Image("file:data/images/save_16.png")));
        this.btnSave.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                GUIView.this.getController().saveClicked();
            }
        });
        Separator separator = new Separator();
        this.btnPrev = new Button();
        this.btnPrev.setGraphic((Node)new ImageView(new Image("file:data/images/left_16.png")));
        this.btnPrev.setDisable(true);
        this.btnPrev.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                AnalysisResult tempResult = GUIView.this.getModel().currentAnalysisResult;
                for (AnalysisResult item : GUIView.this.getModel().analysisResults) {
                    if (item == GUIView.this.getModel().currentAnalysisResult) break;
                    tempResult = item;
                }
                GUIView.this.analysisLoad(tempResult);
            }
        });
        this.btnNext = new Button();
        this.btnNext.setGraphic((Node)new ImageView(new Image("file:data/images/right_16.png")));
        this.btnNext.setDisable(true);
        this.btnNext.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                AnalysisResult tempResult = GUIView.this.getModel().currentAnalysisResult;
                int i = GUIView.this.getModel().analysisResults.size() - 1;
                while (i >= 0) {
                    AnalysisResult item = GUIView.this.getModel().analysisResults.get(i);
                    if (item == GUIView.this.getModel().currentAnalysisResult) break;
                    tempResult = item;
                    --i;
                }
                GUIView.this.analysisLoad(tempResult);
            }
        });
        this.analysisJumper = new ComboBox();
        this.analysisJumper.setDisable(true);
        this.analysisJumper.setMaxWidth(250.0);
        this.analysisJumper.setPrefWidth(250.0);
        this.analysisJumper.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (!GUIView.this.getModel().dontJumpFlag) {
                    String tempStr = ((String)GUIView.this.analysisJumper.getValue()).toString();
                    int i = 0;
                    while (i < GUIView.this.getModel().analysisResults.size()) {
                        AnalysisResult result = GUIView.this.getModel().analysisResults.get(i);
                        String equalStr = String.valueOf(i + 1) + ". " + GUIView.this.getModel().mapAnalysisResults.get(result).get(0) + ", " + GUIView.this.getModel().mapAnalysisResults.get(result).get(1);
                        if (tempStr.equals(equalStr)) {
                            GUIView.this.analysisLoad(result);
                            break;
                        }
                        ++i;
                    }
                }
            }
        });
        this.btnClearJumper = new Button("Clear");
        this.btnClearJumper.setGraphic((Node)new ImageView(new Image("file:data/images/trash_16.png")));
        this.btnClearJumper.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                GUIView.this.getModel().analysisResults.clear();
                GUIView.this.getModel().mapAnalysisResults.clear();
                GUIView.this.setStatus(0);
            }
        });
        HBox zoomSpaceingBox = new HBox();
        HBox.setHgrow((Node)zoomSpaceingBox, (Priority)Priority.ALWAYS);
        this.btnViewInBrowser = new Button();
        this.btnViewInBrowser.setGraphic((Node)new ImageView(new Image("file:data/images/globe_16.png")));
        this.btnViewInBrowser.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                GUIView.this.getController().viewInBrowser(!GUIView.this.isFile);
            }
        });
        this.btnViewInBrowser.setDisable(true);
        Separator separator2 = new Separator();
        final Button btnZoomIn = new Button();
        btnZoomIn.setGraphic((Node)new ImageView(new Image("file:data/images/zoomIn_16.png")));
        btnZoomIn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                GUIView.this.getController().zoomIn();
            }
        });
        final Button btnZoomOut = new Button();
        btnZoomOut.setGraphic((Node)new ImageView(new Image("file:data/images/zoomOut_16.png")));
        btnZoomOut.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                GUIView.this.getController().zoomOut();
            }
        });
        final Button btnZoomReset = new Button();
        btnZoomReset.setGraphic((Node)new ImageView(new Image("file:data/images/zoomReset_16.png")));
        btnZoomReset.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                GUIView.this.getController().zoomReset();
            }
        });
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                btnZoomIn.getScene().getAccelerators().put((Object)new KeyCodeCombination(KeyCode.PLUS, new KeyCombination.Modifier[]{KeyCombination.CONTROL_ANY}), (Object)new Runnable(){

                    @Override
                    public void run() {
                        btnZoomIn.fire();
                    }
                });
                btnZoomOut.getScene().getAccelerators().put((Object)new KeyCodeCombination(KeyCode.MINUS, new KeyCombination.Modifier[]{KeyCombination.CONTROL_ANY}), (Object)new Runnable(){

                    @Override
                    public void run() {
                        btnZoomOut.fire();
                    }
                });
                btnZoomReset.getScene().getAccelerators().put((Object)new KeyCodeCombination(KeyCode.DIGIT0, new KeyCombination.Modifier[]{KeyCombination.CONTROL_ANY}), (Object)new Runnable(){

                    @Override
                    public void run() {
                        btnZoomReset.fire();
                    }
                });
            }
        });
        toolBar.getItems().addAll((Object[])new Node[]{this.btnNew, this.btnOpen, this.btnSave, separator, this.btnPrev, this.btnNext, this.analysisJumper, this.btnClearJumper, zoomSpaceingBox, this.btnViewInBrowser, separator2, btnZoomIn, btnZoomOut, btnZoomReset});
        menuBox.getChildren().addAll((Object[])new Node[]{menuBar, toolBar});
        this.tabPane = new TabPane();
        this.tabTextual = new Tab();
        this.tabTextual.setGraphic((Node)new ImageView(new Image("file:data/images/address_16.png")));
        this.tabTextual.setText("Textual");
        this.tabTextual.setClosable(false);
        this.htmlTextual = new WebView();
        this.htmlEngineTextual = this.htmlTextual.getEngine();
        this.dbgChngLstnrTextual = new DebugChangeListener(this.htmlEngineTextual);
        this.htmlEngineTextual.loadContent(GUIHelper.generateHTMLDocument(""));
        this.getModel().initDevPxRatioTextual = Controller.getDevPxRatio(this.htmlEngineTextual);
        this.tabTextual.setContent((Node)this.htmlTextual);
        this.tabGraphical = new Tab();
        this.tabGraphical.setGraphic((Node)new ImageView(new Image("file:data/images/diagram_16.png")));
        this.tabGraphical.setText("Graphical");
        this.tabGraphical.setClosable(false);
        this.htmlGraphical = new WebView();
        this.htmlEngineGraphical = this.htmlGraphical.getEngine();
        this.dbgChngLstnrGraphical = new DebugChangeListener(this.htmlEngineGraphical);
        this.htmlEngineGraphical.loadContent(GUIHelper.generateHTMLDocument(""));
        this.getModel().initDevPxRatioGraphical = Controller.getDevPxRatio(this.htmlEngineGraphical);
        this.tabGraphical.setContent((Node)this.htmlGraphical);
        LOGGER.debug("WebView User Agent: {}", this.htmlEngineGraphical.getUserAgent());
        this.tabMessages = new Tab();
        this.tabMessages.setGraphic((Node)new ImageView(new Image("file:data/images/bubble_16.png")));
        this.tabMessages.setText("Messages");
        this.tabMessages.setClosable(false);
        ScrollPane scrollPaneMessages = new ScrollPane();
        scrollPaneMessages.setFitToWidth(true);
        this.messageBox = new VBox();
        this.messageBox.setPadding(new Insets(15.0, 15.0, 15.0, 15.0));
        scrollPaneMessages.setContent((Node)this.messageBox);
        this.tabMessages.setContent((Node)scrollPaneMessages);
        this.messageItems = new ArrayList<List<Node>>(4);
        this.loadAllMessages = new Button[4];
        this.messages = new int[4];
        int i = 0;
        while (i <= 3) {
            this.messageItems.add(new ArrayList());
            final int current = i++;
            this.loadAllMessages[current] = new Button("Show more");
            this.loadAllMessages[current].setPrefWidth(Double.MAX_VALUE);
            this.loadAllMessages[current].setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    GUIView.this.getController().loadMessages(current);
                }
            });
        }
        this.tabPane.getTabs().addAll((Object[])new Tab[]{this.tabTextual, this.tabGraphical, this.tabMessages});
        BorderPane bottomPane = new BorderPane();
        this.filterBox = new VBox(10.0);
        TitledPane filterPane = new TitledPane("Filter", (Node)this.filterBox);
        filterPane.setExpanded(false);
        HBox infoBox = new HBox();
        infoBox.setMaxWidth(Double.MAX_VALUE);
        VBox statusBox = new VBox(15.0);
        Label statusLabel = new Label("Status:");
        statusLabel.setMinWidth(50.0);
        this.statusImage = new ImageView();
        this.setStatus(0);
        statusBox.getChildren().addAll((Object[])new Node[]{statusLabel, this.statusImage});
        infoArea = new TextArea();
        infoArea.textProperty().addListener((ChangeListener)new ChangeListener<Object>(){

            public void changed(ObservableValue<?> observable, Object oldValue, Object newValue) {
                infoArea.setScrollTop(Double.MAX_VALUE);
            }
        });
        infoArea.setEditable(false);
        infoArea.setPrefWidth(2.147483647E9);
        infoBox.getChildren().addAll((Object[])new Node[]{statusBox, infoArea});
        TitledPane infoPane = new TitledPane("Details", (Node)infoBox);
        bottomPane.setTop((Node)filterPane);
        bottomPane.setCenter((Node)infoPane);
        BorderPane pane = new BorderPane();
        pane.setTop((Node)menuBox);
        pane.setCenter((Node)this.tabPane);
        pane.setBottom((Node)bottomPane);
        Scene scene = new Scene((Parent)pane, 800.0, 600.0);
        this.stage.setScene(scene);
        if (initialResult != null) {
            this.getModel().setLastSetup(AnalysisRegistry.getInstance().getName(initialResult), initialApk.toString());
            SingleSelectionModel selectionModel = this.tabPane.getSelectionModel();
            selectionModel.select((Object)this.tabGraphical);
            this.analysisFinished(initialResult);
            initialResult = null;
        }
        this.stage.show();
    }

    void setStatus(int status) {
        if (status == 0) {
            this.menuItemNew.setDisable(false);
            this.btnNew.setDisable(false);
            this.menuItemOpen.setDisable(false);
            this.btnOpen.setDisable(false);
            if (!this.getModel().analysisResults.isEmpty()) {
                this.menuItemSave.setDisable(false);
                this.btnSave.setDisable(false);
                this.menuItemSaveAs.setDisable(false);
            } else {
                this.menuItemSave.setDisable(true);
                this.btnSave.setDisable(true);
                this.menuItemSaveAs.setDisable(true);
            }
            this.statusImage.setImage(new Image("file:data/images/tick_32.png"));
        } else if (status == 1) {
            this.menuItemNew.setDisable(true);
            this.btnNew.setDisable(true);
            this.menuItemOpen.setDisable(true);
            this.btnOpen.setDisable(true);
            this.menuItemSave.setDisable(true);
            this.btnSave.setDisable(true);
            this.menuItemSaveAs.setDisable(true);
            this.statusImage.setImage(new Image("file:data/images/loading.gif"));
        }
        int current = this.getModel().analysisResults.indexOf(this.getModel().currentAnalysisResult);
        if (this.getModel().analysisResults.size() >= 1) {
            this.analysisJumper.setDisable(false);
            this.btnClearJumper.setDisable(false);
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    int i = 0;
                    while (i < GUIView.this.getModel().analysisResults.size()) {
                        AnalysisResult result = GUIView.this.getModel().analysisResults.get(i);
                        String tempStr = String.valueOf(i + 1) + ". " + GUIView.this.getModel().mapAnalysisResults.get(result).get(0) + ", " + GUIView.this.getModel().mapAnalysisResults.get(result).get(1);
                        if (!GUIView.this.analysisJumper.getItems().contains((Object)tempStr)) {
                            GUIView.this.analysisJumper.getItems().add((Object)tempStr);
                        }
                        if (result == GUIView.this.getModel().currentAnalysisResult) {
                            GUIView.this.getModel().dontJumpFlag = true;
                            GUIView.this.analysisJumper.setValue((Object)tempStr);
                            GUIView.this.getModel().dontJumpFlag = false;
                        }
                        ++i;
                    }
                }
            });
        } else {
            this.analysisJumper.setDisable(true);
            this.btnClearJumper.setDisable(true);
        }
        if (this.getModel().analysisResults.size() > 1) {
            if (current != 0) {
                this.btnPrev.setDisable(false);
            } else {
                this.btnPrev.setDisable(true);
            }
            if (current != this.getModel().analysisResults.size() - 1) {
                this.btnNext.setDisable(false);
            } else {
                this.btnNext.setDisable(true);
            }
        } else {
            this.btnPrev.setDisable(true);
            this.btnNext.setDisable(true);
        }
    }

    static void log(final String msg) {
        if (infoArea != null) {
            final SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
            final Date date = new Date();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    infoArea.appendText(String.valueOf(dateFormat.format(date)) + ": " + msg + "\n");
                }
            });
        }
    }

    void analysisLoad(AnalysisResult result) {
        List<String> loadedSetup = this.getModel().mapAnalysisResults.get(result);
        GUIView.log("Analysis result loaded: " + loadedSetup.get(0) + ", " + loadedSetup.get(1));
        this.loadAnalysisResult(result);
    }

    @Override
    public void analysisFinished(AnalysisResult result) {
        this.getModel().mapAnalysisResults.put(result, this.getModel().lastSetup);
        this.getModel().time = new Date().getTime() / 1000L - this.getModel().time;
        if (initialResult == null) {
            GUIView.log("Analysis finished (" + this.getModel().time + "s)");
        }
        this.loadAnalysisResult(result);
    }

    void loadAnalysisResult(final AnalysisResult result) {
        this.wait1 = true;
        this.wait2 = true;
        if (!this.getModel().analysisResults.contains(result)) {
            this.getModel().analysisResults.add(result);
        }
        this.getModel().currentAnalysisResult = result;
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                GUIView.this.filterBox.getChildren().removeAll((Collection)GUIView.this.filterBox.getChildren());
                final CheckBox showStatsCheckBox = new CheckBox();
                showStatsCheckBox.setSelected(true);
                GUIView.this.selectedShowStats = showStatsCheckBox.isSelected();
                showStatsCheckBox.setText("Auto hide statistics & legend");
                showStatsCheckBox.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent event) {
                        (this).GUIView.this.selectedShowStats = showStatsCheckBox.isSelected();
                        if ((this).GUIView.this.selectedShowStats) {
                            GUIView.log("Statistics enabled");
                        } else {
                            GUIView.log("Statistics disabled");
                        }
                        GUIView.this.showResult(result);
                    }
                });
                Separator separatorCheckBox = new Separator();
                separatorCheckBox.setOrientation(Orientation.VERTICAL);
                GUIView.this.selectedDetailLevel = result.getDetailLevels().get(0);
                HBox detailLevelBox = new HBox(25.0);
                ToggleGroup detailLevelRadioGroup = new ToggleGroup();
                boolean first = true;
                for (final DetailLevel level : result.getDetailLevels()) {
                    RadioButton radioBtn = new RadioButton(level.toString().replaceAll("_", " "));
                    if (first) {
                        radioBtn.setSelected(true);
                        first = false;
                    }
                    radioBtn.setToggleGroup(detailLevelRadioGroup);
                    radioBtn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                        public void handle(ActionEvent event) {
                            (this).GUIView.this.selectedDetailLevel = level;
                            GUIView.log("Detaillevel selected: " + level.toString());
                            GUIView.this.showResult(result);
                        }
                    });
                    detailLevelBox.getChildren().add((Object)radioBtn);
                }
                detailLevelBox.getChildren().addAll((Object[])new Node[]{separatorCheckBox, showStatsCheckBox});
                Separator separator1 = new Separator();
                GUIView.this.filterBox.getChildren().addAll((Object[])new Node[]{detailLevelBox, separator1});
                VBox outerFilterBox = new VBox(10.0);
                HBox innerFilterBox = new HBox(5.0);
                String[] prefixes = new String[]{"Permission:", "Source:", "Sink:"};
                GUIView.this.selectedFilters = new ArrayList<String>();
                for (String filter : result.getFilters()) {
                    if (filter.contains(prefixes[0]) || filter.contains(prefixes[1]) || filter.contains(prefixes[2])) continue;
                    GUIView.this.selectedFilters.add(filter);
                }
                int i = 0;
                while (i <= prefixes.length) {
                    List<String> tempList;
                    if (i == prefixes.length) {
                        tempList = GUIView.this.selectedFilters;
                    } else {
                        tempList = new ArrayList<String>();
                        for (String filter : result.getFilters()) {
                            if (!filter.contains(prefixes[i])) continue;
                            tempList.add(filter);
                        }
                    }
                    if (!tempList.isEmpty()) {
                        ObservableList filterOptions = FXCollections.observableArrayList(tempList);
                        final ComboBox filterChooser = new ComboBox(filterOptions);
                        filterChooser.setMaxWidth(250.0);
                        filterChooser.setValue((Object)tempList.get(0));
                        final ChooserEventHandler filterChooserHandler = new ChooserEventHandler((ComboBox<String>)filterChooser, (ObservableList<String>)filterOptions);
                        filterChooser.setOnKeyPressed((EventHandler)filterChooserHandler);
                        filterChooser.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                            public void changed(ObservableValue<? extends Boolean> arg0, Boolean oldPropertyValue, Boolean newPropertyValue) {
                                if (!newPropertyValue.booleanValue()) {
                                    filterChooserHandler.reset(false);
                                }
                            }
                        });
                        Button btnFilterAdd = new Button("Add");
                        btnFilterAdd.setGraphic((Node)new ImageView(new Image("file:data/images/plus_16.png")));
                        btnFilterAdd.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                            public void handle(ActionEvent event) {
                                if (!(this).GUIView.this.selectedFilters.contains(filterChooser.getValue())) {
                                    GUIView.this.addActiveFilter((String)filterChooser.getValue());
                                    (this).GUIView.this.selectedFilters.add((String)filterChooser.getValue());
                                    GUIView.log("Filter activated: " + (String)filterChooser.getValue());
                                } else if (GUIView.this.getController().removeFilter((String)filterChooser.getValue())) {
                                    (this).GUIView.this.selectedFilters.remove(filterChooser.getValue());
                                    for (Node box : (this).GUIView.this.flowPaneActiveFilters.getChildren()) {
                                        if (!((Label)((HBox)box).getChildren().get(1)).getText().equals(filterChooser.getValue())) continue;
                                        (this).GUIView.this.flowPaneActiveFilters.getChildren().remove((Object)box);
                                        break;
                                    }
                                }
                                GUIView.this.showResult(result);
                            }
                        });
                        Separator separator = new Separator();
                        separator.setOrientation(Orientation.VERTICAL);
                        innerFilterBox.getChildren().addAll((Object[])new Node[]{filterChooser, btnFilterAdd, separator});
                    }
                    ++i;
                }
                if (GUIView.this.selectedFilters.contains("Expandable tree")) {
                    GUIView.this.selectedFilters.remove("Expandable tree");
                }
                if (GUIView.this.selectedFilters.contains("Expandable tree")) {
                    GUIView.this.selectedFilters.remove("Expandable tree");
                }
                if (GUIView.this.selectedFilters.isEmpty()) {
                    GUIView.this.selectedFilters = result.getFilters();
                }
                Button btnFilterAddAll = new Button("Add All filters");
                btnFilterAddAll.setGraphic((Node)new ImageView(new Image("file:data/images/plusplus_16.png")));
                btnFilterAddAll.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent event) {
                        for (String tempFilter : result.getFilters()) {
                            if ((this).GUIView.this.selectedFilters.contains(tempFilter)) continue;
                            GUIView.this.addActiveFilter(tempFilter);
                            (this).GUIView.this.selectedFilters.add(tempFilter);
                        }
                        GUIView.log("All available filters activated");
                        GUIView.this.showResult(result);
                    }
                });
                Button btnFilterClear = new Button("Clear");
                btnFilterClear.setGraphic((Node)new ImageView(new Image("file:data/images/trash_16.png")));
                btnFilterClear.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent event) {
                        (this).GUIView.this.selectedFilters.clear();
                        (this).GUIView.this.flowPaneActiveFilters.getChildren().removeAll((Collection)(this).GUIView.this.flowPaneActiveFilters.getChildren());
                        GUIView.log("All active filters removed");
                        GUIView.this.showResult(result);
                    }
                });
                BorderPane activeFilterBox = new BorderPane();
                Text activeFilterText = new Text("Active filters:");
                activeFilterText.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.BOLD, (double)12.0));
                GUIView.this.flowPaneActiveFilters = new FlowPane();
                GUIView.this.flowPaneActiveFilters.setStyle("-fx-background-color: white");
                GUIView.this.flowPaneActiveFilters.setHgap(10.0);
                GUIView.this.flowPaneActiveFilters.setVgap(5.0);
                ScrollPane filterFlowPaneScrollPane = new ScrollPane((Node)GUIView.this.flowPaneActiveFilters);
                filterFlowPaneScrollPane.setFitToWidth(true);
                filterFlowPaneScrollPane.setFitToHeight(true);
                filterFlowPaneScrollPane.setMaxHeight(155.0);
                filterFlowPaneScrollPane.setMinHeight(19.0);
                activeFilterBox.setLeft((Node)activeFilterText);
                activeFilterBox.setCenter((Node)filterFlowPaneScrollPane);
                innerFilterBox.getChildren().addAll((Object[])new Node[]{btnFilterAddAll, btnFilterClear});
                outerFilterBox.getChildren().addAll((Object[])new Node[]{innerFilterBox, activeFilterBox});
                GUIView.this.filterBox.getChildren().add((Object)outerFilterBox);
                for (String filter : GUIView.this.selectedFilters) {
                    GUIView.this.addActiveFilter(filter);
                }
                GUIView.this.wait1 = false;
                GUIView.this.wait2 = false;
            }
        });
        this.showResult(result);
        this.showMessages(result);
    }

    void showResult(final AnalysisResult result) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (GUIView.this.wait1) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                GUIView.this.wait1 = true;
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        GUIView.this.setStatus(1);
                        (this).GUIView.this.wait1 = false;
                    }
                });
                while (GUIView.this.wait1) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    GUIView.this.htmlTextualStr = result.getTextualResult(GUIView.this.selectedDetailLevel, GUIView.this.selectedFilters, GUIView.this.selectedShowStats);
                }
                catch (Exception e) {
                    GUIView.log("An error accured while filtering the textual result.");
                    LOGGER.error("An error accured while filtering the textual result: " + e.getMessage());
                    e.printStackTrace();
                }
                try {
                    GUIView.this.htmlGraphicalStr = result.getGraphicalResult(GUIView.this.selectedDetailLevel, GUIView.this.selectedFilters, GUIView.this.selectedShowStats);
                }
                catch (Exception e) {
                    GUIView.log("An error accured while filtering the graphical result.");
                    LOGGER.error("An error accured while filtering the graphical result: " + e.getMessage());
                    e.printStackTrace();
                }
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!result.getResultIsFile()) {
                            (this).GUIView.this.isFile = false;
                            (this).GUIView.this.htmlEngineTextual.loadContent((this).GUIView.this.htmlTextualStr);
                            (this).GUIView.this.htmlEngineGraphical.loadContent((this).GUIView.this.htmlGraphicalStr);
                        } else {
                            (this).GUIView.this.isFile = true;
                            (this).GUIView.this.htmlEngineTextual.load("file:///" + new File((this).GUIView.this.htmlTextualStr).getAbsolutePath());
                            (this).GUIView.this.htmlEngineGraphical.load("file:///" + new File((this).GUIView.this.htmlGraphicalStr).getAbsolutePath());
                        }
                        (this).GUIView.this.btnViewInBrowser.setDisable(false);
                        GUIView.this.setStatus(0);
                        GUIView.log("Result filtered.");
                    }
                });
            }
        }).start();
    }

    void showMessages(final AnalysisResult result) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (GUIView.this.wait2) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                int i = 0;
                while (i <= 3) {
                    GUIView.this.messageItems.get(i).clear();
                    GUIView.this.messages[i] = 0;
                    GUIView.this.loadAllMessages[i].setVisible(true);
                    ++i;
                }
                for (Message msg : result.getMessages()) {
                    if (msg.getType() == MessageType.SUGGESTION) {
                        GUIView.this.messages[0] = GUIView.this.messages[0] + 1;
                        GUIView.this.messageItems.get(0).add((Node)GUIView.addMessage(msg, GUIView.this.messages[0]));
                        continue;
                    }
                    if (msg.getType() == MessageType.ERROR) {
                        GUIView.this.messages[1] = GUIView.this.messages[1] + 1;
                        GUIView.this.messageItems.get(1).add((Node)GUIView.addMessage(msg, GUIView.this.messages[1]));
                        continue;
                    }
                    if (msg.getType() == MessageType.WARNING) {
                        GUIView.this.messages[2] = GUIView.this.messages[2] + 1;
                        GUIView.this.messageItems.get(2).add((Node)GUIView.addMessage(msg, GUIView.this.messages[2]));
                        continue;
                    }
                    GUIView.this.messages[3] = GUIView.this.messages[3] + 1;
                    GUIView.this.messageItems.get(3).add((Node)GUIView.addMessage(msg, GUIView.this.messages[3]));
                }
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        (this).GUIView.this.messageBox.getChildren().clear();
                        (this).GUIView.this.msgPartBox = new ArrayList<VBox>();
                        int i = 0;
                        while (i <= 3) {
                            (this).GUIView.this.msgPartBox.add(new VBox(5.0));
                            (this).GUIView.this.msgPartBox.get(i).getChildren().addAll((this).GUIView.this.messageItems.get(i).subList(0, (this).GUIView.this.messageItems.get(i).size() < 100 ? (this).GUIView.this.messageItems.get(i).size() : 100));
                            if ((this).GUIView.this.messageItems.get(i).size() >= 100) {
                                (this).GUIView.this.msgPartBox.get(i).getChildren().add((Object)(this).GUIView.this.loadAllMessages[i]);
                            }
                            ++i;
                        }
                        TitledPane suggestionPane = new TitledPane("Suggestions (" + (this).GUIView.this.messages[0] + ")", (Node)(this).GUIView.this.msgPartBox.get(0));
                        suggestionPane.setStyle("-fx-background-color: white");
                        if ((this).GUIView.this.msgPartBox.get(0).getChildren().size() == 0) {
                            suggestionPane.setExpanded(false);
                        }
                        TitledPane errorPane = new TitledPane("Errors (" + (this).GUIView.this.messages[1] + ")", (Node)(this).GUIView.this.msgPartBox.get(1));
                        errorPane.setStyle("-fx-background-color: white");
                        if ((this).GUIView.this.msgPartBox.get(1).getChildren().size() == 0) {
                            errorPane.setExpanded(false);
                        }
                        TitledPane warningPane = new TitledPane("Warnings (" + (this).GUIView.this.messages[2] + ")", (Node)(this).GUIView.this.msgPartBox.get(2));
                        warningPane.setStyle("-fx-background-color: white");
                        if ((this).GUIView.this.msgPartBox.get(2).getChildren().size() == 0) {
                            warningPane.setExpanded(false);
                        }
                        TitledPane infoPane = new TitledPane("Information (" + (this).GUIView.this.messages[3] + ")", (Node)(this).GUIView.this.msgPartBox.get(3));
                        infoPane.setStyle("-fx-background-color: white");
                        if ((this).GUIView.this.msgPartBox.get(3).getChildren().size() == 0) {
                            infoPane.setExpanded(false);
                        }
                        (this).GUIView.this.messageBox.getChildren().addAll((Object[])new Node[]{suggestionPane, errorPane, warningPane, infoPane});
                    }
                });
            }
        }).start();
    }

    public void showNextMessages(int current) {
        this.setStatus(1);
        this.msgPartBox.get(current).getChildren().remove((Object)this.loadAllMessages[current]);
        int startIndex = this.msgPartBox.get(current).getChildren().size();
        this.msgPartBox.get(current).getChildren().addAll(this.messageItems.get(current).subList(startIndex, startIndex + 500));
        if (startIndex + 500 < this.messageItems.get(current).size()) {
            this.msgPartBox.get(current).getChildren().add((Object)this.loadAllMessages[current]);
        }
        this.setStatus(0);
    }

    static VBox addMessage(Message msg, int number) {
        VBox wholeBox = new VBox(5.0);
        String msgBodyStr = msg.getBody().contains("\n") ? msg.getBody().substring(0, msg.getBody().indexOf("\n")) : msg.getBody();
        Label msgBody = new Label(msgBodyStr);
        msgBody.setWrapText(true);
        Separator separator = new Separator();
        HBox msgBox = new HBox(10.0);
        ImageView msgImage = msg.getType() == MessageType.WARNING ? new ImageView(new Image("file:data/images/warning_16.png")) : (msg.getType() == MessageType.ERROR ? new ImageView(new Image("file:data/images/delete_16.png")) : (msg.getType() == MessageType.SUGGESTION ? new ImageView(new Image("file:data/images/flag_16.png")) : new ImageView(new Image("file:data/images/info_16.png"))));
        Text msgTitle = new Text(String.valueOf(number) + ". " + msg.getTitle());
        msgTitle.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.BOLD, (double)12.0));
        msgBox.getChildren().addAll((Object[])new Node[]{msgImage, msgTitle});
        wholeBox.getChildren().addAll((Object[])new Node[]{msgBox, msgBody, separator});
        wholeBox.setCache(true);
        wholeBox.setCacheHint(CacheHint.SPEED);
        return wholeBox;
    }

    void addActiveFilter(final String filterStr) {
        final HBox singleFilterBox = new HBox(1.0);
        singleFilterBox.setAlignment(Pos.CENTER_LEFT);
        Label filterLabel = new Label(filterStr);
        ImageView filterRemoveBtn = new ImageView(new Image("file:data/images/delete_16.png"));
        filterRemoveBtn.setScaleX(0.75);
        filterRemoveBtn.setScaleY(0.75);
        filterRemoveBtn.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                event.consume();
                GUIView.this.selectedFilters.remove(filterStr);
                GUIView.this.flowPaneActiveFilters.getChildren().remove((Object)singleFilterBox);
                GUIView.this.showResult(GUIView.this.getModel().currentAnalysisResult);
            }
        });
        singleFilterBox.getChildren().addAll((Object[])new Node[]{filterRemoveBtn, filterLabel});
        this.flowPaneActiveFilters.getChildren().add((Object)singleFilterBox);
    }

    private class DebugChangeListener
    implements ChangeListener<Document> {
        private final WebEngine engine;

        public DebugChangeListener(WebEngine engine) {
            this.engine = engine;
        }

        public void changed(ObservableValue<? extends Document> prop, Document oldDoc, Document newDoc) {
            this.engine.executeScript(GUIView.JS_SCRIPT_ENABLE_FIREBUG);
        }
    }
}

