/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.client.gui;

import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.control.ComboBox;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChooserEventHandler
implements EventHandler<KeyEvent> {
    static final Logger LOGGER = LogManager.getLogger(ChooserEventHandler.class);
    ComboBox<String> parent;
    private ObservableList<String> defaultFilters;
    ObservableList<String> currentFilters;
    private StringBuilder sb;

    ChooserEventHandler(ComboBox<String> parent, ObservableList<String> defaultFilters) {
        this.parent = parent;
        this.defaultFilters = defaultFilters;
        this.currentFilters = FXCollections.observableArrayList();
        this.sb = new StringBuilder();
    }

    public void handle(KeyEvent event) {
        if (event.getCode() == KeyCode.DOWN || event.getCode() == KeyCode.UP || event.getCode() == KeyCode.TAB) {
            return;
        }
        if (event.getCode() == KeyCode.BACK_SPACE && this.sb.length() > 0) {
            this.sb.deleteCharAt(this.sb.length() - 1);
        } else {
            this.sb.append(event.getText());
        }
        this.currentFilters.clear();
        for (String filter : this.defaultFilters) {
            if (!filter.toLowerCase().contains(this.sb.toString().toLowerCase())) continue;
            this.currentFilters.add((Object)filter);
        }
        this.setNow(this.currentFilters, true);
    }

    public void reset(boolean refresh) {
        this.sb = new StringBuilder();
        this.setNow(this.defaultFilters, refresh);
    }

    private void setNow(final ObservableList<String> list, final boolean refresh) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ChooserEventHandler.this.parent.setItems(list);
                if (list.size() > 0 && refresh) {
                    ChooserEventHandler.this.parent.setValue((Object)((String)list.get(0)));
                }
            }
        });
    }
}

