/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.client.core;

import com.beust.jcommander.Parameter;
import de.upb.pga3.panda2.client.core.datastructures.LevelSpecificMode;
import de.upb.pga3.panda2.client.core.datastructures.Mode;
import de.upb.pga3.panda2.client.core.datastructures.ResultRepresentation;
import de.upb.pga3.panda2.client.core.datastructures.ResultView;
import de.upb.pga3.panda2.client.core.datastructures.ToolSpecificOption;
import de.upb.pga3.panda2.client.core.datastructures.validation.LevelSpecificModeConverter;
import de.upb.pga3.panda2.client.core.datastructures.validation.ResultRepresentationConverter;
import de.upb.pga3.panda2.client.core.datastructures.validation.ResultViewConverter;
import de.upb.pga3.panda2.client.core.datastructures.validation.ToolSpecificOptionConverter;
import de.upb.pga3.panda2.core.datastructures.AnalysisResult;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class UserInput {
    @Parameter(names={"-toolopt", "-opt", "-option"}, description="Tool options: Please choose any one of these options,Analysis ==>(ANALYZE/ANA/ANALYSIS/A),LOAD ==> (LOAD/L),HELP ==> (HELP, H, -HELP, -H, MAN, -MAN).", converter=ToolSpecificOptionConverter.class)
    private ToolSpecificOption tsOption = ToolSpecificOption.ANALYSIS;
    @Parameter(names={"-l", "-level"}, description="Analysis Level: COMPULSORY for all the levels. Please choose any one of these options,Level1 ==>(1/LEVEL 1/LEVEL1/INTRA-APP-PERMISSION/INTRA-PERM/INTRA-APP-PERM),Level2a ==> (2A/LEVEL 2A/LEVEL2A/INTRA-APP-INFO-FLOW/INTRA-INFO-FLOW/INTRA-IF),Level2b ==> (2B/LEVEL 2B/LEVEL2B/INTER-APP-PERMISSION/INTER-APP-PERM/INTER-PERM)", required=false)
    private String level;
    @Parameter(names={"-lm", "-levelmode"}, description="Analysis Level Specific Mode: COMPULSORY for LEVEL2B Scenario: Please choose any one of these options,(APP/ALL).", required=false, converter=LevelSpecificModeConverter.class)
    private LevelSpecificMode levelSpecificMode;
    private Mode mode = Mode.SUMMARY;
    @Parameter(names={"-i", "-input"}, description="Initial APK file path. COMPULSORY for all the levels.", required=false, variableArity=true)
    private List<String> selectedInitialInput;
    @Parameter(names={"-nn", "-nonnative"}, description="Non Native APK file path. Optional field to give for LEVEL2B scenario.", required=false, variableArity=true)
    private List<String> selectedNonNativeapps;
    @Parameter(names={"-ci", "-compareinput"}, description="Previous analysis file path for 'Comparison Mode'. COMPULSORY if you want to use this mode.")
    private String selectedComparisonInput;
    @Parameter(names={"-r", "-result"}, description="Result Representation Option. Available options,Save ==>(S/SAVE/SA),View ==> (V/VIEW/VI)", required=false, converter=ResultRepresentationConverter.class)
    private ResultRepresentation resultRepresentation = ResultRepresentation.VIEW;
    @Parameter(names={"-v", "-view"}, description="Result View Option. Available options,Textual ==>(T/TEXT/TEXTUAL),Graphical ==> (G, GRAPH, GRAPHICAL),Message ==> (M, MSG, MESSAGE)", required=false, converter=ResultViewConverter.class)
    private ResultView resultView = ResultView.TEXTUAL;
    @Parameter(names={"-fp", "-filepath"}, description="File path for Viewing previous result/Saving current analysis result. COMPULSORY for both these scenarios", required=false)
    private String filePath;
    @Parameter(names={"-x", "-exit", "-t", "-terminate"}, description="Terminate the program after the analysis execution.", required=false, arity=1)
    private boolean terminate = true;
    @Parameter(names={"-f", "-filter"}, description="Provide the 'Result Filters'. Can give more than one value by giving space between them. Some filter options are:Please choose any one of these options,Filters ==>(REQUIRED/MAYBE_REQUIRED/UNUSED/MISSING/MAYBE_MISSING)", required=false, variableArity=true)
    private List<String> userSelectedFilters;
    @Parameter(names={"-dl", "-detaillevel"}, description="Provide the 'Detail Level'. Available options,DetailLevelLvl1 ==>(APP/COMPONENT/CLASS/METHOD),DetailLevelLvl2a ==> (RES_TO_RES/COMPONENT/STATEMENT),DetailLevelLvl2b ==> (APP/COMPONENT)", required=false)
    private String userSelectedDetailLevel;
    @Parameter(names={"-ts", "-testscenario"}, description="Whether you want the testing scenario to be enabled?If so use this option so that result won't be printed in the console.", required=false, arity=1)
    private boolean testingScenario = false;
    @Parameter(names={"-tstat", "-teststats"}, description="Showing test statistics in the result.", required=false, arity=1)
    private boolean showTestStatistics = true;
    private AnalysisResult previousAnalysisResult;
    private List<File> initialInputAPKFiles;
    private List<File> nonNativeAPKFiles;
    private File previousAnalysisResultFile;

    public UserInput() {
    }

    public UserInput(String level, LevelSpecificMode levelSpecificMode, Mode mode) {
        this.level = level;
        this.levelSpecificMode = levelSpecificMode;
        this.mode = mode;
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public LevelSpecificMode getLevelSpecificMode() {
        return this.levelSpecificMode;
    }

    public void setLevelSpecificMode(LevelSpecificMode levelSpecificMode) {
        this.levelSpecificMode = levelSpecificMode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public List<String> getSelectedInitialInput() {
        return this.selectedInitialInput;
    }

    public void setSelectedInitialInput(List<String> selectedInitialInput) {
        this.selectedInitialInput = selectedInitialInput;
    }

    public List<String> getSelectedNonNativeapps() {
        return this.selectedNonNativeapps;
    }

    public void setSelectedNonNativeapps(List<String> selectedNonNativeapps) {
        this.selectedNonNativeapps = selectedNonNativeapps;
    }

    public String getSelectedComparisonInput() {
        return this.selectedComparisonInput;
    }

    public void setSelectedComparisonInput(String selectedComparisonInput) {
        this.selectedComparisonInput = selectedComparisonInput;
    }

    public AnalysisResult getPreviousAnalysisResult() {
        return this.previousAnalysisResult;
    }

    public void setPreviousAnalysisResult(AnalysisResult previousAnalysisResult) {
        this.previousAnalysisResult = previousAnalysisResult;
    }

    public ResultRepresentation getResultRepresentation() {
        return this.resultRepresentation;
    }

    public ResultView getResultView() {
        return this.resultView;
    }

    public List<String> getUserSelectedFilters() {
        return this.userSelectedFilters;
    }

    public String getUserSelectedDetailLevel() {
        return this.userSelectedDetailLevel;
    }

    public void createAPKFilesForInitialInput() {
        this.initialInputAPKFiles = new ArrayList<File>();
        for (String inputFile : this.selectedInitialInput) {
            File file = new File(inputFile);
            this.initialInputAPKFiles.add(file);
        }
    }

    public void createAPKFilesForNonNativeApps() {
        this.nonNativeAPKFiles = new ArrayList<File>();
        if (this.selectedNonNativeapps != null) {
            for (String inputFile : this.selectedNonNativeapps) {
                File file = new File(inputFile);
                this.nonNativeAPKFiles.add(file);
            }
        }
    }

    public void createPreviousAnalysisResultFile() {
        this.previousAnalysisResultFile = new File(this.selectedComparisonInput);
    }

    public List<File> getInitialInputAPKFiles() {
        return this.initialInputAPKFiles;
    }

    public List<File> getNonNativeAPKFiles() {
        return this.nonNativeAPKFiles;
    }

    public File getPreviousAnalysisResultFile() {
        return this.previousAnalysisResultFile;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public boolean isTerminate() {
        return this.terminate;
    }

    public void setTerminate(boolean terminate) {
        this.terminate = terminate;
    }

    public boolean isTestingScenario() {
        return this.testingScenario;
    }

    public boolean isShowTestStatistics() {
        return this.showTestStatistics;
    }

    public ToolSpecificOption getTsOption() {
        return this.tsOption;
    }
}

