/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.client.cmdline;

import de.upb.pga3.panda2.client.cmdline.HtmlParser;
import de.upb.pga3.panda2.client.core.Client;
import de.upb.pga3.panda2.client.core.ClientCommandLine;
import de.upb.pga3.panda2.client.core.datastructures.UIMessage;
import de.upb.pga3.panda2.client.core.datastructures.UIMessageType;
import de.upb.pga3.panda2.client.gui.GUIView;
import de.upb.pga3.panda2.core.datastructures.DetailLevel;
import de.upb.pga3.panda2.core.datastructures.Message;
import de.upb.pga3.panda2.core.datastructures.MessageType;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import javafx.application.Application;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommandLine {
    static final Logger LOGGER = LogManager.getLogger(CommandLine.class);
    final Scanner scan = new Scanner(System.in);
    private ClientCommandLine clientCommandLine;

    public boolean validateInitialInput(String ... args) {
        this.clientCommandLine = new ClientCommandLine();
        return this.clientCommandLine.validateCommandLineInputArguments(args);
    }

    public void validateAndCompareInput() {
        block6: {
            try {
                UIMessage uiMessage = this.clientCommandLine.compareApp();
                boolean isTestingScenario = this.clientCommandLine.isTestingScenario();
                if (!uiMessage.getType().equals((Object)UIMessageType.ERROR)) {
                    Client.print(uiMessage.getType().name());
                    Client.print(uiMessage.getBody());
                    if (!isTestingScenario) {
                        Client.print("Would you like to continue to proceed the analysis? Please type Y/N");
                        String userSelection = null;
                        if (this.scan.hasNextLine()) {
                            userSelection = this.scan.nextLine();
                        }
                        if (!this.clientCommandLine.continueAnalysis(userSelection)) {
                            LOGGER.info("Program is Terminated");
                            this.scan.close();
                            System.exit(0);
                        }
                    }
                    break block6;
                }
                throw new Exception(uiMessage.getBody());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                LOGGER.error("ERROR OCCURED in validateAndCompareInput()");
                if (this.getClientCommandLine().getUserInput().isTestingScenario()) break block6;
                this.scan.close();
                System.exit(1);
            }
        }
    }

    public void saveOrShowResult() {
        block9: {
            try {
                UIMessage uiMessage;
                if (this.clientCommandLine.isHelpOptionSelected()) {
                    this.scan.close();
                    System.exit(1);
                    break block9;
                }
                if (this.clientCommandLine.isLoadOptionSelected()) {
                    this.clientCommandLine.viewPreviousAnalysisResult();
                    if (this.clientCommandLine.getAnalysisResult() == null) {
                        throw new Exception("Unable to load the Analysis Result.");
                    }
                    this.showResult();
                    break block9;
                }
                if (this.clientCommandLine.isComparisonMode()) {
                    this.validateAndCompareInput();
                }
                if (!(uiMessage = this.clientCommandLine.performAnalysis()).getType().equals((Object)UIMessageType.ERROR)) {
                    if (this.clientCommandLine.isSaveResult()) {
                        this.clientCommandLine.saveResult();
                    } else {
                        this.showResult();
                    }
                    break block9;
                }
                throw new Exception(uiMessage.getBody());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                LOGGER.error("ERROR OCCURED in saveOrShowResult()");
                if (this.getClientCommandLine().getUserInput().isTestingScenario()) break block9;
                this.scan.close();
                System.exit(1);
            }
        }
    }

    public void showResult() {
        if (this.clientCommandLine.isGraphicalViewResult()) {
            this.showGUIGraphicalResult();
        } else if (this.clientCommandLine.isMessageViewResult()) {
            this.displayMessagesTextualResult(this.clientCommandLine.getMessages());
        } else {
            this.parseHtmlTextualResult();
            if (!this.clientCommandLine.isProgramTerminate() && !this.getClientCommandLine().getUserInput().isTestingScenario()) {
                this.filterResult();
            }
        }
    }

    private void parseHtmlTextualResult() {
        DetailLevel defaultDetailLevel;
        List<String> resultFilter = null;
        try {
            List<String> initialResultFilter = this.clientCommandLine.getUserInput().getUserSelectedFilters();
            String initialDetailLevel = this.clientCommandLine.getUserInput().getUserSelectedDetailLevel();
            if (initialResultFilter != null && !initialResultFilter.isEmpty()) {
                resultFilter = initialResultFilter;
            } else {
                String[] prefixes = new String[]{"Permission:", "Source:", "Sink:"};
                resultFilter = new ArrayList<String>();
                if (this.clientCommandLine.getResultFilters() != null && !this.clientCommandLine.getResultFilters().isEmpty()) {
                    for (String filter : this.clientCommandLine.getResultFilters()) {
                        if (filter.contains(prefixes[0]) || filter.contains(prefixes[1]) || filter.contains(prefixes[2])) continue;
                        resultFilter.add(filter);
                    }
                }
                if (!resultFilter.isEmpty()) {
                    if (resultFilter.contains("Expandable tree")) {
                        resultFilter.remove("Expandable tree");
                    }
                    if (resultFilter.contains("Expandable tree")) {
                        resultFilter.remove("Expandable tree");
                    }
                } else {
                    resultFilter = this.clientCommandLine.getResultFilters();
                }
            }
            defaultDetailLevel = initialDetailLevel != null ? this.clientCommandLine.getDetailLevelFromString(initialDetailLevel) : this.clientCommandLine.getDefaultDetailLevel();
        }
        catch (Exception e) {
            LOGGER.error("Selected Detail level is wrong. Default detail level was selected by the application for filtering.");
            defaultDetailLevel = this.clientCommandLine.getDefaultDetailLevel();
        }
        String textualResult = this.clientCommandLine.filterTextViewResult(defaultDetailLevel, resultFilter);
        HtmlParser.parse(textualResult, this.clientCommandLine.getUserInput().isTestingScenario());
    }

    private void showGUIGraphicalResult() {
        if (this.clientCommandLine.isLoadOptionSelected()) {
            GUIView.setInitialResult(this.getClientCommandLine().getAnalysisResult(), new File(this.getClientCommandLine().getUserInput().getFilePath()));
        } else {
            GUIView.setInitialResult(this.getClientCommandLine().getAnalysisResult(), this.getClientCommandLine().getUserInput().getInitialInputAPKFiles().get(0));
        }
        Application.launch(GUIView.class, (String[])new String[0]);
    }

    private void displayMessagesTextualResult(List<Message> messages) {
        boolean isTestingScenario = this.clientCommandLine.isTestingScenario();
        ArrayList<Message> errorMessagesList = new ArrayList<Message>();
        ArrayList<Message> warningMessagesList = new ArrayList<Message>();
        ArrayList<Message> infoMessagesList = new ArrayList<Message>();
        ArrayList<Message> suggestionsMessagesList = new ArrayList<Message>();
        for (Message message : messages) {
            if (message.getType() == MessageType.SUGGESTION) {
                suggestionsMessagesList.add(message);
                continue;
            }
            if (message.getType() == MessageType.ERROR) {
                errorMessagesList.add(message);
                continue;
            }
            if (message.getType() == MessageType.WARNING) {
                warningMessagesList.add(message);
                continue;
            }
            infoMessagesList.add(message);
        }
        this.printTextualMessageResult(errorMessagesList, isTestingScenario);
        this.printTextualMessageResult(warningMessagesList, isTestingScenario);
        this.printTextualMessageResult(infoMessagesList, isTestingScenario);
        this.printTextualMessageResult(suggestionsMessagesList, isTestingScenario);
    }

    private void printTextualMessageResult(List<Message> messages, boolean isTestingScenario) {
        int messageCount = 0;
        for (Message message : messages) {
            ++messageCount;
            if (isTestingScenario) continue;
            Client.print("\n Message:" + messageCount);
            Client.print("\n ---Message Type--- " + message.getType().toString());
            Client.print("\n ---Message Body--- " + message.getBody());
            Client.print("\n ---Message Title--- " + message.getTitle());
        }
    }

    public ClientCommandLine getClientCommandLine() {
        return this.clientCommandLine;
    }

    public void filterResult() {
        try {
            boolean isTestingScenario = this.clientCommandLine.getUserInput().isTestingScenario();
            if (!isTestingScenario) {
                Client.print("Would you like to filter the result? Please type Y/N");
                String userSelection = null;
                if (this.scan.hasNextLine()) {
                    userSelection = this.scan.nextLine();
                }
                if (this.clientCommandLine.continueAnalysis(userSelection)) {
                    this.showDetailLevelAndFilterResult();
                    DetailLevel selectedDetailLevel = this.selectedDetailLevel(this.scan);
                    List<String> userSelectedResultList = this.getUserSelectedResultList(this.scan);
                    String textualResult = this.clientCommandLine.filterTextViewResult(selectedDetailLevel, userSelectedResultList);
                    HtmlParser.parse(textualResult, isTestingScenario);
                    this.filterResult();
                } else if (userSelection.equalsIgnoreCase("NO") || userSelection.equalsIgnoreCase("N")) {
                    this.scan.close();
                } else {
                    Client.print("Invalid Input. So please select the valid input again");
                    this.filterResult();
                }
            } else {
                String textualResult = this.clientCommandLine.filterTextViewResult(this.clientCommandLine.getDefaultDetailLevel(), this.clientCommandLine.getResultFilters());
                HtmlParser.parse(textualResult, isTestingScenario);
            }
        }
        catch (Exception ex) {
            LOGGER.error("Program was terminated. Internal error while filtering the result.");
        }
    }

    private void showDetailLevelAndFilterResult() {
        String availableDetailLevel = "\n ---AVAILABLE DETAIL LEVELS--- \n";
        for (String detailLevel : this.clientCommandLine.getDetailLevels()) {
            availableDetailLevel = String.valueOf(availableDetailLevel) + detailLevel + "\n";
        }
        Client.print(availableDetailLevel);
        String availableResultFilter = "\n ---AVAILABLE RESULT FILTERS--- \n";
        for (String resultFilter : this.clientCommandLine.getResultFilters()) {
            availableResultFilter = String.valueOf(availableResultFilter) + resultFilter + "\n";
        }
        Client.print(availableResultFilter);
    }

    private DetailLevel selectedDetailLevel(Scanner scan) {
        DetailLevel selectedDetailLevel = null;
        try {
            Client.print("Select your desired level:");
            String selectedString = null;
            if (scan.hasNextLine()) {
                selectedString = scan.nextLine();
            }
            selectedDetailLevel = this.clientCommandLine.getDetailLevelFromString(selectedString);
        }
        catch (Exception e) {
            LOGGER.error("Selected Detail level is wrong. Please give the correct detail level.");
            selectedDetailLevel = this.selectedDetailLevel(scan);
        }
        return selectedDetailLevel;
    }

    private List<String> getUserSelectedResultList(Scanner scan) {
        ArrayList<String> userSelectedResultList = new ArrayList<String>();
        Client.print("Select your desired filter:");
        while (true) {
            String line = null;
            if (scan.hasNextLine()) {
                line = scan.nextLine();
            }
            if (line == null || line.equalsIgnoreCase("")) break;
            userSelectedResultList.add(line);
        }
        return userSelectedResultList;
    }
}

