/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup;

import android.app.IWallpaperManager;
import android.app.backup.BackupAgentHelper;
import android.app.backup.BackupDataInput;
import android.app.backup.BackupDataOutput;
import android.app.backup.FullBackup;
import android.app.backup.FullBackupDataOutput;
import android.app.backup.WallpaperBackupHelper;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Slog;
import java.io.File;
import java.io.IOException;

public class SystemBackupAgent
extends BackupAgentHelper {
    private static final String TAG = "SystemBackupAgent";
    private static final String WALLPAPER_IMAGE;
    private static final String WALLPAPER_IMAGE_DIR;
    private static final String WALLPAPER_IMAGE_FILENAME = "wallpaper";
    private static final String WALLPAPER_IMAGE_KEY = "/data/data/com.android.settings/files/wallpaper";
    private static final String WALLPAPER_INFO;
    private static final String WALLPAPER_INFO_DIR;
    private static final String WALLPAPER_INFO_FILENAME = "wallpaper_info.xml";
    private static final String WALLPAPER_INFO_KEY = "/data/system/wallpaper_info.xml";

    static {
        WALLPAPER_IMAGE_DIR = Environment.getUserSystemDirectory(0).getAbsolutePath();
        WALLPAPER_IMAGE = WallpaperBackupHelper.WALLPAPER_IMAGE;
        WALLPAPER_INFO_DIR = Environment.getUserSystemDirectory(0).getAbsolutePath();
        WALLPAPER_INFO = WallpaperBackupHelper.WALLPAPER_INFO;
    }

    private void fullWallpaperBackup(FullBackupDataOutput fullBackupDataOutput) {
        FullBackup.backupToTar(this.getPackageName(), "r", null, WALLPAPER_INFO_DIR, WALLPAPER_INFO, fullBackupDataOutput.getData());
        FullBackup.backupToTar(this.getPackageName(), "r", null, WALLPAPER_IMAGE_DIR, WALLPAPER_IMAGE, fullBackupDataOutput.getData());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onBackup(ParcelFileDescriptor parcelFileDescriptor, BackupDataOutput backupDataOutput, ParcelFileDescriptor parcelFileDescriptor2) throws IOException {
        String[] stringArray;
        String[] stringArray2;
        block4: {
            String[] stringArray3;
            IWallpaperManager iWallpaperManager = (IWallpaperManager)((Object)ServiceManager.getService(WALLPAPER_IMAGE_FILENAME));
            stringArray2 = new String[]{WALLPAPER_IMAGE, WALLPAPER_INFO};
            stringArray = new String[]{WALLPAPER_IMAGE_KEY, WALLPAPER_INFO_KEY};
            if (iWallpaperManager == null) break block4;
            try {
                String string2 = iWallpaperManager.getName();
                if (string2 == null || string2.length() <= 0) break block4;
                stringArray3 = new String[]{WALLPAPER_INFO};
            }
            catch (RemoteException remoteException) {}
            try {
                String[] stringArray4 = new String[]{WALLPAPER_INFO_KEY};
                stringArray = stringArray4;
                stringArray2 = stringArray3;
                break block4;
            }
            catch (RemoteException remoteException) {
                stringArray2 = stringArray3;
            }
            {
                void var7_11;
                Slog.e(TAG, "Couldn't get wallpaper name\n" + var7_11);
            }
        }
        this.addHelper(WALLPAPER_IMAGE_FILENAME, new WallpaperBackupHelper(this, stringArray2, stringArray));
        super.onBackup(parcelFileDescriptor, backupDataOutput, parcelFileDescriptor2);
    }

    @Override
    public void onFullBackup(FullBackupDataOutput fullBackupDataOutput) throws IOException {
        this.fullWallpaperBackup(fullBackupDataOutput);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    @Override
    public void onRestore(BackupDataInput backupDataInput, int n, ParcelFileDescriptor parcelFileDescriptor) throws IOException {
        String[] stringArray = new String[]{WALLPAPER_IMAGE, WALLPAPER_INFO};
        this.addHelper(WALLPAPER_IMAGE_FILENAME, new WallpaperBackupHelper(this, stringArray, new String[]{WALLPAPER_IMAGE_KEY, WALLPAPER_INFO_KEY}));
        String[] stringArray2 = new String[]{WALLPAPER_IMAGE};
        this.addHelper("system_files", new WallpaperBackupHelper(this, stringArray2, new String[]{WALLPAPER_IMAGE_KEY}));
        try {
            super.onRestore(backupDataInput, n, parcelFileDescriptor);
            IWallpaperManager iWallpaperManager = (IWallpaperManager)((Object)ServiceManager.getService(WALLPAPER_IMAGE_FILENAME));
            if (iWallpaperManager == null) return;
            try {
                iWallpaperManager.settingsRestored();
                return;
            }
            catch (RemoteException remoteException) {
                Slog.e(TAG, "Couldn't restore settings\n" + remoteException);
                return;
            }
        }
        catch (IOException iOException) {
            Slog.d(TAG, "restore failed", iOException);
            new File(WALLPAPER_IMAGE).delete();
            new File(WALLPAPER_INFO).delete();
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void onRestoreFile(ParcelFileDescriptor var1_1, long var2_2, int var4_3, String var5_4, String var6_5, long var7_6, long var9_7) throws IOException {
        block9: {
            block8: {
                Slog.i("SystemBackupAgent", "Restoring file domain=" + var5_4 + " path=" + var6_5);
                var12_8 = var5_4.equals("r");
                var13_9 = null;
                var14_10 = false;
                if (!var12_8) break block8;
                if (!var6_5.equals("wallpaper_info.xml")) break block9;
                var13_9 = new File(SystemBackupAgent.WALLPAPER_INFO);
                var14_10 = true;
            }
lbl11:
            // 3 sources

            while (true) {
                if (var13_9 != null) ** GOTO lbl16
                Slog.w("SystemBackupAgent", "Skipping unrecognized system file: [ " + var5_4 + " : " + var6_5 + " ]");
lbl16:
                // 2 sources

                FullBackup.restoreFile(var1_1, var2_2, var4_3, var7_6, var9_7, var13_9);
                if (!var14_10) ** GOTO lbl23
                var18_11 = (IWallpaperManager)ServiceManager.getService("wallpaper");
                if (var18_11 == null) ** GOTO lbl23
                var18_11.settingsRestored();
lbl23:
                // 4 sources

                return;
                break;
            }
        }
        var22_12 = var6_5.equals("wallpaper");
        var13_9 = null;
        var14_10 = false;
        if (!var22_12) ** GOTO lbl11
        var13_9 = new File(SystemBackupAgent.WALLPAPER_IMAGE);
        var14_10 = true;
        ** while (true)
        catch (RemoteException var19_13) {
            try {
                Slog.e("SystemBackupAgent", "Couldn't restore settings\n" + var19_13);
                return;
            }
            catch (IOException var15_14) {
                if (!var14_10) ** continue;
                new File(SystemBackupAgent.WALLPAPER_IMAGE).delete();
                new File(SystemBackupAgent.WALLPAPER_INFO).delete();
                return;
            }
        }
    }
}

