/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.media.AudioAttributes;
import android.os.Vibrator;
import android.provider.Settings;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.accessibility.AccessibilityManager;
import com.android.internal.widget.DrawableHolder;
import java.util.ArrayList;

public class WaveView
extends View
implements ValueAnimator.AnimatorUpdateListener {
    private static final boolean DBG = false;
    private static final long DELAY_INCREMENT = 15L;
    private static final long DELAY_INCREMENT2 = 12L;
    private static final long DURATION = 300L;
    private static final long FINAL_DELAY = 200L;
    private static final long FINAL_DURATION = 200L;
    private static final float GRAB_HANDLE_RADIUS_SCALE_ACCESSIBILITY_DISABLED = 0.5f;
    private static final float GRAB_HANDLE_RADIUS_SCALE_ACCESSIBILITY_ENABLED = 1.0f;
    private static final long RESET_TIMEOUT = 3000L;
    private static final long RING_DELAY = 1300L;
    private static final long SHORT_DELAY = 100L;
    private static final int STATE_ATTEMPTING = 3;
    private static final int STATE_READY = 1;
    private static final int STATE_RESET_LOCK = 0;
    private static final int STATE_START_ATTEMPT = 2;
    private static final int STATE_UNLOCK_ATTEMPT = 4;
    private static final int STATE_UNLOCK_SUCCESS = 5;
    private static final String TAG = "WaveView";
    private static final long VIBRATE_LONG = 20L;
    private static final long VIBRATE_SHORT = 20L;
    private static final AudioAttributes VIBRATION_ATTRIBUTES = new AudioAttributes.Builder().setContentType(4).setUsage(13).build();
    private static final int WAVE_COUNT = 20;
    private static final long WAVE_DELAY = 100L;
    private static final long WAVE_DURATION = 2000L;
    private final Runnable mAddWaveAction;
    private int mCurrentWave = 0;
    private ArrayList<DrawableHolder> mDrawables = new ArrayList(3);
    private boolean mFingerDown = false;
    private boolean mFinishWaves;
    private int mGrabbedState = 0;
    private ArrayList<DrawableHolder> mLightWaves = new ArrayList(20);
    private float mLockCenterX;
    private float mLockCenterY;
    private int mLockState = 0;
    private final Runnable mLockTimerActions = new Runnable(){

        @Override
        public void run() {
            if (WaveView.this.mLockState == 3) {
                WaveView.access$002(WaveView.this, 0);
            }
            if (WaveView.this.mLockState == 5) {
                WaveView.access$002(WaveView.this, 0);
            }
            WaveView.this.invalidate();
        }
    };
    private float mMouseX;
    private float mMouseY;
    private OnTriggerListener mOnTriggerListener;
    private float mRingRadius = 182.0f;
    private int mSnapRadius = 136;
    private DrawableHolder mUnlockDefault;
    private DrawableHolder mUnlockHalo;
    private DrawableHolder mUnlockRing;
    private Vibrator mVibrator;
    private int mWaveCount = 20;
    private long mWaveTimerDelay = 100L;
    private boolean mWavesRunning;

    public WaveView(Context context) {
        this(context, null);
    }

    public WaveView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mAddWaveAction = new Runnable(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void run() {
                int n = (int)Math.ceil(Math.hypot(WaveView.this.mMouseX - WaveView.this.mLockCenterX, WaveView.this.mMouseY - WaveView.this.mLockCenterY));
                if (WaveView.this.mLockState == 3 && n < WaveView.this.mSnapRadius && WaveView.this.mWaveTimerDelay >= 100L) {
                    WaveView.access$602(WaveView.this, Math.min(2000L, 15L + WaveView.this.mWaveTimerDelay));
                    DrawableHolder drawableHolder = (DrawableHolder)WaveView.this.mLightWaves.get(WaveView.this.mCurrentWave);
                    drawableHolder.setAlpha(0.0f);
                    drawableHolder.setScaleX(0.2f);
                    drawableHolder.setScaleY(0.2f);
                    drawableHolder.setX(WaveView.this.mMouseX);
                    drawableHolder.setY(WaveView.this.mMouseY);
                    drawableHolder.addAnimTo(2000L, 0L, "x", WaveView.this.mLockCenterX, true);
                    drawableHolder.addAnimTo(2000L, 0L, "y", WaveView.this.mLockCenterY, true);
                    drawableHolder.addAnimTo(1333L, 0L, "alpha", 1.0f, true);
                    drawableHolder.addAnimTo(2000L, 0L, "scaleX", 1.0f, true);
                    drawableHolder.addAnimTo(2000L, 0L, "scaleY", 1.0f, true);
                    drawableHolder.addAnimTo(1000L, 1300L, "alpha", 0.0f, false);
                    drawableHolder.startAnimations(WaveView.this);
                    WaveView.access$702(WaveView.this, (1 + WaveView.this.mCurrentWave) % WaveView.this.mWaveCount);
                } else {
                    WaveView.access$614(WaveView.this, 12L);
                }
                if (WaveView.this.mFinishWaves) {
                    WaveView.access$1102(WaveView.this, false);
                    return;
                }
                WaveView.this.postDelayed(WaveView.this.mAddWaveAction, WaveView.this.mWaveTimerDelay);
            }
        };
        this.initDrawables();
    }

    static /* synthetic */ int access$002(WaveView waveView, int n) {
        waveView.mLockState = n;
        return n;
    }

    static /* synthetic */ boolean access$1102(WaveView waveView, boolean bl) {
        waveView.mWavesRunning = bl;
        return bl;
    }

    static /* synthetic */ long access$602(WaveView waveView, long l) {
        waveView.mWaveTimerDelay = l;
        return l;
    }

    static /* synthetic */ long access$614(WaveView waveView, long l) {
        long l2;
        waveView.mWaveTimerDelay = l2 = l + waveView.mWaveTimerDelay;
        return l2;
    }

    static /* synthetic */ int access$702(WaveView waveView, int n) {
        waveView.mCurrentWave = n;
        return n;
    }

    private void announceUnlockHandle() {
        this.setContentDescription(this.mContext.getString(17040778));
        this.sendAccessibilityEvent(8);
        this.setContentDescription(null);
    }

    private void dispatchTriggerEvent(int n) {
        this.vibrate(20L);
        if (this.mOnTriggerListener != null) {
            this.mOnTriggerListener.onTrigger(this, n);
        }
    }

    private float getScaledGrabHandleRadius() {
        if (AccessibilityManager.getInstance(this.mContext).isEnabled()) {
            return 1.0f * (float)this.mUnlockHalo.getWidth();
        }
        return 0.5f * (float)this.mUnlockHalo.getWidth();
    }

    private void initDrawables() {
        this.mUnlockRing = new DrawableHolder(this.createDrawable(17303601));
        this.mUnlockRing.setX(this.mLockCenterX);
        this.mUnlockRing.setY(this.mLockCenterY);
        this.mUnlockRing.setScaleX(0.1f);
        this.mUnlockRing.setScaleY(0.1f);
        this.mUnlockRing.setAlpha(0.0f);
        this.mDrawables.add(this.mUnlockRing);
        this.mUnlockDefault = new DrawableHolder(this.createDrawable(17303599));
        this.mUnlockDefault.setX(this.mLockCenterX);
        this.mUnlockDefault.setY(this.mLockCenterY);
        this.mUnlockDefault.setScaleX(0.1f);
        this.mUnlockDefault.setScaleY(0.1f);
        this.mUnlockDefault.setAlpha(0.0f);
        this.mDrawables.add(this.mUnlockDefault);
        this.mUnlockHalo = new DrawableHolder(this.createDrawable(17303600));
        this.mUnlockHalo.setX(this.mLockCenterX);
        this.mUnlockHalo.setY(this.mLockCenterY);
        this.mUnlockHalo.setScaleX(0.1f);
        this.mUnlockHalo.setScaleY(0.1f);
        this.mUnlockHalo.setAlpha(0.0f);
        this.mDrawables.add(this.mUnlockHalo);
        BitmapDrawable bitmapDrawable = this.createDrawable(17303602);
        for (int i = 0; i < this.mWaveCount; ++i) {
            DrawableHolder drawableHolder = new DrawableHolder(bitmapDrawable);
            this.mLightWaves.add(drawableHolder);
            drawableHolder.setAlpha(0.0f);
        }
    }

    private void setGrabbedState(int n) {
        if (n != this.mGrabbedState) {
            this.mGrabbedState = n;
            if (this.mOnTriggerListener != null) {
                this.mOnTriggerListener.onGrabbedStateChange(this, this.mGrabbedState);
            }
        }
    }

    private void tryTransitionToStartAttemptState(MotionEvent motionEvent) {
        float f;
        float f2 = motionEvent.getX() - this.mUnlockHalo.getX();
        if ((float)Math.hypot(f2, f = motionEvent.getY() - this.mUnlockHalo.getY()) <= this.getScaledGrabHandleRadius()) {
            this.setGrabbedState(10);
            if (this.mLockState == 1) {
                this.mLockState = 2;
                if (AccessibilityManager.getInstance(this.mContext).isEnabled()) {
                    this.announceUnlockHandle();
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void vibrate(long l) {
        boolean bl = true;
        synchronized (this) {
            if (Settings.System.getIntForUser(this.mContext.getContentResolver(), "haptic_feedback_enabled", 1, -2) == 0) return;
            if (!bl) return;
            if (this.mVibrator == null) {
                this.mVibrator = (Vibrator)this.getContext().getSystemService("vibrator");
            }
            this.mVibrator.vibrate(l, VIBRATION_ATTRIBUTES);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void waveUpdateFrame(float f, float f2, boolean bl) {
        double d = f - this.mLockCenterX;
        double d2 = f2 - this.mLockCenterY;
        int n = (int)Math.ceil(Math.hypot(d, d2));
        double d3 = Math.atan2(d, d2);
        float f3 = (float)((double)this.mLockCenterX + (double)this.mRingRadius * Math.sin(d3));
        float f4 = (float)((double)this.mLockCenterY + (double)this.mRingRadius * Math.cos(d3));
        switch (this.mLockState) {
            case 0: {
                int n2;
                int n3;
                this.mWaveTimerDelay = 100L;
                for (int i = 0; i < (n3 = this.mLightWaves.size()); ++i) {
                    this.mLightWaves.get(i).addAnimTo(300L, 0L, "alpha", 0.0f, false);
                }
                for (int i = 0; i < (n2 = this.mLightWaves.size()); ++i) {
                    this.mLightWaves.get(i).startAnimations(this);
                }
                this.mUnlockRing.addAnimTo(300L, 0L, "x", this.mLockCenterX, true);
                this.mUnlockRing.addAnimTo(300L, 0L, "y", this.mLockCenterY, true);
                this.mUnlockRing.addAnimTo(300L, 0L, "scaleX", 0.1f, true);
                this.mUnlockRing.addAnimTo(300L, 0L, "scaleY", 0.1f, true);
                this.mUnlockRing.addAnimTo(300L, 0L, "alpha", 0.0f, true);
                this.mUnlockDefault.removeAnimationFor("x");
                this.mUnlockDefault.removeAnimationFor("y");
                this.mUnlockDefault.removeAnimationFor("scaleX");
                this.mUnlockDefault.removeAnimationFor("scaleY");
                this.mUnlockDefault.removeAnimationFor("alpha");
                this.mUnlockDefault.setX(this.mLockCenterX);
                this.mUnlockDefault.setY(this.mLockCenterY);
                this.mUnlockDefault.setScaleX(0.1f);
                this.mUnlockDefault.setScaleY(0.1f);
                this.mUnlockDefault.setAlpha(0.0f);
                this.mUnlockDefault.addAnimTo(300L, 100L, "scaleX", 1.0f, true);
                this.mUnlockDefault.addAnimTo(300L, 100L, "scaleY", 1.0f, true);
                this.mUnlockDefault.addAnimTo(300L, 100L, "alpha", 1.0f, true);
                this.mUnlockHalo.removeAnimationFor("x");
                this.mUnlockHalo.removeAnimationFor("y");
                this.mUnlockHalo.removeAnimationFor("scaleX");
                this.mUnlockHalo.removeAnimationFor("scaleY");
                this.mUnlockHalo.removeAnimationFor("alpha");
                this.mUnlockHalo.setX(this.mLockCenterX);
                this.mUnlockHalo.setY(this.mLockCenterY);
                this.mUnlockHalo.setScaleX(0.1f);
                this.mUnlockHalo.setScaleY(0.1f);
                this.mUnlockHalo.setAlpha(0.0f);
                this.mUnlockHalo.addAnimTo(300L, 100L, "x", this.mLockCenterX, true);
                this.mUnlockHalo.addAnimTo(300L, 100L, "y", this.mLockCenterY, true);
                this.mUnlockHalo.addAnimTo(300L, 100L, "scaleX", 1.0f, true);
                this.mUnlockHalo.addAnimTo(300L, 100L, "scaleY", 1.0f, true);
                this.mUnlockHalo.addAnimTo(300L, 100L, "alpha", 1.0f, true);
                this.removeCallbacks(this.mLockTimerActions);
                this.mLockState = 1;
                break;
            }
            case 1: {
                this.mWaveTimerDelay = 100L;
                break;
            }
            case 2: {
                this.mUnlockDefault.removeAnimationFor("x");
                this.mUnlockDefault.removeAnimationFor("y");
                this.mUnlockDefault.removeAnimationFor("scaleX");
                this.mUnlockDefault.removeAnimationFor("scaleY");
                this.mUnlockDefault.removeAnimationFor("alpha");
                this.mUnlockDefault.setX(182.0f + this.mLockCenterX);
                this.mUnlockDefault.setY(this.mLockCenterY);
                this.mUnlockDefault.setScaleX(0.1f);
                this.mUnlockDefault.setScaleY(0.1f);
                this.mUnlockDefault.setAlpha(0.0f);
                this.mUnlockDefault.addAnimTo(300L, 100L, "scaleX", 1.0f, false);
                this.mUnlockDefault.addAnimTo(300L, 100L, "scaleY", 1.0f, false);
                this.mUnlockDefault.addAnimTo(300L, 100L, "alpha", 1.0f, false);
                this.mUnlockRing.addAnimTo(300L, 0L, "scaleX", 1.0f, true);
                this.mUnlockRing.addAnimTo(300L, 0L, "scaleY", 1.0f, true);
                this.mUnlockRing.addAnimTo(300L, 0L, "alpha", 1.0f, true);
                this.mLockState = 3;
                break;
            }
            case 3: {
                if (n > this.mSnapRadius) {
                    this.mFinishWaves = true;
                    if (bl) {
                        this.mUnlockHalo.addAnimTo(0L, 0L, "x", f3, true);
                        this.mUnlockHalo.addAnimTo(0L, 0L, "y", f4, true);
                        this.mUnlockHalo.addAnimTo(0L, 0L, "scaleX", 1.0f, true);
                        this.mUnlockHalo.addAnimTo(0L, 0L, "scaleY", 1.0f, true);
                        this.mUnlockHalo.addAnimTo(0L, 0L, "alpha", 1.0f, true);
                        break;
                    }
                    this.mLockState = 4;
                    break;
                }
                if (!this.mWavesRunning) {
                    this.mWavesRunning = true;
                    this.mFinishWaves = false;
                    this.postDelayed(this.mAddWaveAction, this.mWaveTimerDelay);
                }
                this.mUnlockHalo.addAnimTo(0L, 0L, "x", f, true);
                this.mUnlockHalo.addAnimTo(0L, 0L, "y", f2, true);
                this.mUnlockHalo.addAnimTo(0L, 0L, "scaleX", 1.0f, true);
                this.mUnlockHalo.addAnimTo(0L, 0L, "scaleY", 1.0f, true);
                this.mUnlockHalo.addAnimTo(0L, 0L, "alpha", 1.0f, true);
                break;
            }
            case 4: {
                if (n > this.mSnapRadius) {
                    int n4;
                    int n5;
                    for (int i = 0; i < (n5 = this.mLightWaves.size()); ++i) {
                        DrawableHolder drawableHolder = this.mLightWaves.get(i);
                        long l = 1000L * (long)(i + 6 - this.mCurrentWave) / 10L;
                        drawableHolder.addAnimTo(200L, l, "x", f3, true);
                        drawableHolder.addAnimTo(200L, l, "y", f4, true);
                        drawableHolder.addAnimTo(200L, l, "scaleX", 0.1f, true);
                        drawableHolder.addAnimTo(200L, l, "scaleY", 0.1f, true);
                        drawableHolder.addAnimTo(200L, l, "alpha", 0.0f, true);
                    }
                    for (int i = 0; i < (n4 = this.mLightWaves.size()); ++i) {
                        this.mLightWaves.get(i).startAnimations(this);
                    }
                    this.mUnlockRing.addAnimTo(200L, 0L, "x", f3, false);
                    this.mUnlockRing.addAnimTo(200L, 0L, "y", f4, false);
                    this.mUnlockRing.addAnimTo(200L, 0L, "scaleX", 0.1f, false);
                    this.mUnlockRing.addAnimTo(200L, 0L, "scaleY", 0.1f, false);
                    this.mUnlockRing.addAnimTo(200L, 0L, "alpha", 0.0f, false);
                    this.mUnlockRing.addAnimTo(200L, 200L, "alpha", 0.0f, false);
                    this.mUnlockDefault.removeAnimationFor("x");
                    this.mUnlockDefault.removeAnimationFor("y");
                    this.mUnlockDefault.removeAnimationFor("scaleX");
                    this.mUnlockDefault.removeAnimationFor("scaleY");
                    this.mUnlockDefault.removeAnimationFor("alpha");
                    this.mUnlockDefault.setX(f3);
                    this.mUnlockDefault.setY(f4);
                    this.mUnlockDefault.setScaleX(0.1f);
                    this.mUnlockDefault.setScaleY(0.1f);
                    this.mUnlockDefault.setAlpha(0.0f);
                    this.mUnlockDefault.addAnimTo(200L, 0L, "x", f3, true);
                    this.mUnlockDefault.addAnimTo(200L, 0L, "y", f4, true);
                    this.mUnlockDefault.addAnimTo(200L, 0L, "scaleX", 1.0f, true);
                    this.mUnlockDefault.addAnimTo(200L, 0L, "scaleY", 1.0f, true);
                    this.mUnlockDefault.addAnimTo(200L, 0L, "alpha", 1.0f, true);
                    this.mUnlockDefault.addAnimTo(200L, 200L, "scaleX", 3.0f, false);
                    this.mUnlockDefault.addAnimTo(200L, 200L, "scaleY", 3.0f, false);
                    this.mUnlockDefault.addAnimTo(200L, 200L, "alpha", 0.0f, false);
                    this.mUnlockHalo.addAnimTo(200L, 0L, "x", f3, false);
                    this.mUnlockHalo.addAnimTo(200L, 0L, "y", f4, false);
                    this.mUnlockHalo.addAnimTo(200L, 200L, "scaleX", 3.0f, false);
                    this.mUnlockHalo.addAnimTo(200L, 200L, "scaleY", 3.0f, false);
                    this.mUnlockHalo.addAnimTo(200L, 200L, "alpha", 0.0f, false);
                    this.removeCallbacks(this.mLockTimerActions);
                    this.postDelayed(this.mLockTimerActions, 3000L);
                    this.dispatchTriggerEvent(10);
                    this.mLockState = 5;
                    break;
                }
                this.mLockState = 0;
                break;
            }
            case 5: {
                this.removeCallbacks(this.mAddWaveAction);
                break;
            }
        }
        this.mUnlockDefault.startAnimations(this);
        this.mUnlockHalo.startAnimations(this);
        this.mUnlockRing.startAnimations(this);
    }

    BitmapDrawable createDrawable(int n) {
        Resources resources = this.getResources();
        return new BitmapDrawable(resources, BitmapFactory.decodeResource(resources, n));
    }

    @Override
    protected int getSuggestedMinimumHeight() {
        return this.mUnlockRing.getHeight() + this.mUnlockHalo.getHeight();
    }

    @Override
    protected int getSuggestedMinimumWidth() {
        return this.mUnlockRing.getWidth() + this.mUnlockHalo.getWidth();
    }

    @Override
    public void onAnimationUpdate(ValueAnimator valueAnimator) {
        this.invalidate();
    }

    @Override
    protected void onDraw(Canvas canvas) {
        this.waveUpdateFrame(this.mMouseX, this.mMouseY, this.mFingerDown);
        for (int i = 0; i < this.mDrawables.size(); ++i) {
            this.mDrawables.get(i).draw(canvas);
        }
        for (int i = 0; i < this.mLightWaves.size(); ++i) {
            this.mLightWaves.get(i).draw(canvas);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onHoverEvent(MotionEvent motionEvent) {
        if (AccessibilityManager.getInstance(this.mContext).isTouchExplorationEnabled()) {
            int n = motionEvent.getAction();
            switch (n) {
                case 9: {
                    motionEvent.setAction(0);
                    break;
                }
                case 7: {
                    motionEvent.setAction(2);
                    break;
                }
                case 10: {
                    motionEvent.setAction(1);
                    break;
                }
            }
            this.onTouchEvent(motionEvent);
            motionEvent.setAction(n);
        }
        return super.onHoverEvent(motionEvent);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onMeasure(int n, int n2) {
        int n3 = View.MeasureSpec.getMode(n);
        int n4 = View.MeasureSpec.getMode(n2);
        int n5 = View.MeasureSpec.getSize(n);
        int n6 = View.MeasureSpec.getSize(n2);
        int n7 = n3 == Integer.MIN_VALUE ? Math.min(n5, this.getSuggestedMinimumWidth()) : (n3 == 0x40000000 ? n5 : this.getSuggestedMinimumWidth());
        int n8 = n4 == Integer.MIN_VALUE ? Math.min(n6, this.getSuggestedMinimumWidth()) : (n4 == 0x40000000 ? n6 : this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(n7, n8);
    }

    @Override
    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        this.mLockCenterX = 0.5f * (float)n;
        this.mLockCenterY = 0.5f * (float)n2;
        super.onSizeChanged(n, n2, n3, n4);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        int n = motionEvent.getAction();
        this.mMouseX = motionEvent.getX();
        this.mMouseY = motionEvent.getY();
        boolean bl = false;
        switch (n) {
            case 0: {
                this.removeCallbacks(this.mLockTimerActions);
                this.mFingerDown = true;
                this.tryTransitionToStartAttemptState(motionEvent);
                bl = true;
                break;
            }
            case 2: {
                this.tryTransitionToStartAttemptState(motionEvent);
                bl = true;
                break;
            }
            case 1: {
                this.mFingerDown = false;
                this.postDelayed(this.mLockTimerActions, 3000L);
                this.setGrabbedState(0);
                this.waveUpdateFrame(this.mMouseX, this.mMouseY, this.mFingerDown);
                bl = true;
                break;
            }
            case 3: {
                this.mFingerDown = false;
                bl = true;
            }
        }
        this.invalidate();
        if (bl) {
            return true;
        }
        return super.onTouchEvent(motionEvent);
    }

    public void reset() {
        this.mLockState = 0;
        this.invalidate();
    }

    public void setOnTriggerListener(OnTriggerListener onTriggerListener) {
        this.mOnTriggerListener = onTriggerListener;
    }

    public static interface OnTriggerListener {
        public static final int CENTER_HANDLE = 10;
        public static final int NO_HANDLE;

        public void onGrabbedStateChange(View var1, int var2);

        public void onTrigger(View var1, int var2);
    }
}

