/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.ActionMenuPresenter;
import android.widget.AdapterView;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.Toolbar;
import com.android.internal.R;
import com.android.internal.view.menu.ActionMenuItem;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuPresenter;
import com.android.internal.widget.DecorToolbar;
import com.android.internal.widget.ScrollingTabContainerView;

public class ToolbarWidgetWrapper
implements DecorToolbar {
    private static final int AFFECTS_LOGO_MASK = 3;
    private static final String TAG = "ToolbarWidgetWrapper";
    private ActionMenuPresenter mActionMenuPresenter;
    private View mCustomView;
    private int mDefaultNavigationContentDescription = 0;
    private Drawable mDefaultNavigationIcon;
    private int mDisplayOpts;
    private CharSequence mHomeDescription;
    private Drawable mIcon;
    private Drawable mLogo;
    private boolean mMenuPrepared;
    private Drawable mNavIcon;
    private int mNavigationMode = 0;
    private Spinner mSpinner;
    private CharSequence mSubtitle;
    private View mTabView;
    private CharSequence mTitle;
    private boolean mTitleSet;
    private Toolbar mToolbar;
    private Window.Callback mWindowCallback;

    public ToolbarWidgetWrapper(Toolbar toolbar, boolean bl) {
        this(toolbar, bl, 17040782);
    }

    /*
     * Enabled aggressive block sorting
     */
    public ToolbarWidgetWrapper(Toolbar toolbar, boolean bl, int n) {
        this.mToolbar = toolbar;
        this.mTitle = toolbar.getTitle();
        this.mSubtitle = toolbar.getSubtitle();
        boolean bl2 = this.mTitle != null;
        this.mTitleSet = bl2;
        TypedArray typedArray = toolbar.getContext().obtainStyledAttributes(null, R.styleable.ActionBar, 16843470, 0);
        this.mDefaultNavigationIcon = typedArray.getDrawable(13);
        if (bl) {
            int n2;
            int n3;
            int n4;
            int n5;
            Drawable drawable2;
            Drawable drawable3;
            CharSequence charSequence;
            CharSequence charSequence2 = typedArray.getText(5);
            if (!TextUtils.isEmpty(charSequence2)) {
                this.setTitle(charSequence2);
            }
            if (!TextUtils.isEmpty(charSequence = typedArray.getText(9))) {
                this.setSubtitle(charSequence);
            }
            if ((drawable3 = typedArray.getDrawable(6)) != null) {
                this.setLogo(drawable3);
            }
            if ((drawable2 = typedArray.getDrawable(0)) != null) {
                this.setIcon(drawable2);
            }
            if (this.mDefaultNavigationIcon != null) {
                this.setNavigationIcon(this.mDefaultNavigationIcon);
            }
            this.setDisplayOptions(typedArray.getInt(8, 0));
            int n6 = typedArray.getResourceId(10, 0);
            if (n6 != 0) {
                this.setCustomView(LayoutInflater.from(this.mToolbar.getContext()).inflate(n6, (ViewGroup)this.mToolbar, false));
                this.setDisplayOptions(0x10 | this.mDisplayOpts);
            }
            if ((n5 = typedArray.getLayoutDimension(4, 0)) > 0) {
                ViewGroup.LayoutParams layoutParams = this.mToolbar.getLayoutParams();
                layoutParams.height = n5;
                this.mToolbar.setLayoutParams(layoutParams);
            }
            int n7 = typedArray.getDimensionPixelOffset(22, -1);
            int n8 = typedArray.getDimensionPixelOffset(23, -1);
            if (n7 >= 0 || n8 >= 0) {
                this.mToolbar.setContentInsetsRelative(Math.max(n7, 0), Math.max(n8, 0));
            }
            if ((n4 = typedArray.getResourceId(11, 0)) != 0) {
                this.mToolbar.setTitleTextAppearance(this.mToolbar.getContext(), n4);
            }
            if ((n3 = typedArray.getResourceId(12, 0)) != 0) {
                this.mToolbar.setSubtitleTextAppearance(this.mToolbar.getContext(), n3);
            }
            if ((n2 = typedArray.getResourceId(26, 0)) != 0) {
                this.mToolbar.setPopupTheme(n2);
            }
        } else {
            this.mDisplayOpts = this.detectDisplayOptions();
        }
        typedArray.recycle();
        this.setDefaultNavigationContentDescription(n);
        this.mHomeDescription = this.mToolbar.getNavigationContentDescription();
        Toolbar toolbar2 = this.mToolbar;
        View.OnClickListener onClickListener = new View.OnClickListener(){
            final ActionMenuItem mNavItem;
            {
                this.mNavItem = new ActionMenuItem(ToolbarWidgetWrapper.this.mToolbar.getContext(), 0, 16908332, 0, 0, ToolbarWidgetWrapper.this.mTitle);
            }

            @Override
            public void onClick(View view) {
                if (ToolbarWidgetWrapper.this.mWindowCallback != null && ToolbarWidgetWrapper.this.mMenuPrepared) {
                    ToolbarWidgetWrapper.this.mWindowCallback.onMenuItemSelected(0, this.mNavItem);
                }
            }
        };
        toolbar2.setNavigationOnClickListener(onClickListener);
    }

    private int detectDisplayOptions() {
        int n = 11;
        if (this.mToolbar.getNavigationIcon() != null) {
            n |= 4;
            this.mDefaultNavigationIcon = this.mToolbar.getNavigationIcon();
        }
        return n;
    }

    private void ensureSpinner() {
        if (this.mSpinner == null) {
            this.mSpinner = new Spinner(this.getContext(), null, 16843479);
            Toolbar.LayoutParams layoutParams = new Toolbar.LayoutParams(-2, -2, 8388627);
            this.mSpinner.setLayoutParams(layoutParams);
        }
    }

    private void setTitleInt(CharSequence charSequence) {
        this.mTitle = charSequence;
        if ((8 & this.mDisplayOpts) != 0) {
            this.mToolbar.setTitle(charSequence);
        }
    }

    private void updateHomeAccessibility() {
        block3: {
            block2: {
                if ((4 & this.mDisplayOpts) == 0) break block2;
                if (!TextUtils.isEmpty(this.mHomeDescription)) break block3;
                this.mToolbar.setNavigationContentDescription(this.mDefaultNavigationContentDescription);
            }
            return;
        }
        this.mToolbar.setNavigationContentDescription(this.mHomeDescription);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateNavigationIcon() {
        if ((4 & this.mDisplayOpts) == 0) {
            this.mToolbar.setNavigationIcon(null);
            return;
        }
        Toolbar toolbar = this.mToolbar;
        Drawable drawable2 = this.mNavIcon != null ? this.mNavIcon : this.mDefaultNavigationIcon;
        toolbar.setNavigationIcon(drawable2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateToolbarLogo() {
        int n = 2 & this.mDisplayOpts;
        Drawable drawable2 = null;
        if (n != 0) {
            drawable2 = (1 & this.mDisplayOpts) != 0 ? (this.mLogo != null ? this.mLogo : this.mIcon) : this.mIcon;
        }
        this.mToolbar.setLogo(drawable2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void animateToVisibility(int n) {
        if (n == 8) {
            this.mToolbar.animate().alpha(0.0f).setListener(new AnimatorListenerAdapter(){
                private boolean mCanceled = false;

                @Override
                public void onAnimationCancel(Animator animator2) {
                    this.mCanceled = true;
                }

                @Override
                public void onAnimationEnd(Animator animator2) {
                    if (!this.mCanceled) {
                        ToolbarWidgetWrapper.this.mToolbar.setVisibility(8);
                    }
                }
            });
            return;
        } else {
            if (n != 0) return;
            this.mToolbar.animate().alpha(1.0f).setListener(new AnimatorListenerAdapter(){

                @Override
                public void onAnimationStart(Animator animator2) {
                    ToolbarWidgetWrapper.this.mToolbar.setVisibility(0);
                }
            });
            return;
        }
    }

    @Override
    public boolean canShowOverflowMenu() {
        return this.mToolbar.canShowOverflowMenu();
    }

    @Override
    public boolean canSplit() {
        return false;
    }

    @Override
    public void collapseActionView() {
        this.mToolbar.collapseActionView();
    }

    @Override
    public void dismissPopupMenus() {
        this.mToolbar.dismissPopupMenus();
    }

    @Override
    public Context getContext() {
        return this.mToolbar.getContext();
    }

    @Override
    public View getCustomView() {
        return this.mCustomView;
    }

    @Override
    public int getDisplayOptions() {
        return this.mDisplayOpts;
    }

    @Override
    public int getDropdownItemCount() {
        if (this.mSpinner != null) {
            return this.mSpinner.getCount();
        }
        return 0;
    }

    @Override
    public int getDropdownSelectedPosition() {
        if (this.mSpinner != null) {
            return this.mSpinner.getSelectedItemPosition();
        }
        return 0;
    }

    @Override
    public int getNavigationMode() {
        return this.mNavigationMode;
    }

    @Override
    public CharSequence getSubtitle() {
        return this.mToolbar.getSubtitle();
    }

    @Override
    public CharSequence getTitle() {
        return this.mToolbar.getTitle();
    }

    @Override
    public ViewGroup getViewGroup() {
        return this.mToolbar;
    }

    @Override
    public boolean hasEmbeddedTabs() {
        return this.mTabView != null;
    }

    @Override
    public boolean hasExpandedActionView() {
        return this.mToolbar.hasExpandedActionView();
    }

    @Override
    public boolean hasIcon() {
        return this.mIcon != null;
    }

    @Override
    public boolean hasLogo() {
        return this.mLogo != null;
    }

    @Override
    public boolean hideOverflowMenu() {
        return this.mToolbar.hideOverflowMenu();
    }

    @Override
    public void initIndeterminateProgress() {
        Log.i(TAG, "Progress display unsupported");
    }

    @Override
    public void initProgress() {
        Log.i(TAG, "Progress display unsupported");
    }

    @Override
    public boolean isOverflowMenuShowPending() {
        return this.mToolbar.isOverflowMenuShowPending();
    }

    @Override
    public boolean isOverflowMenuShowing() {
        return this.mToolbar.isOverflowMenuShowing();
    }

    @Override
    public boolean isSplit() {
        return false;
    }

    @Override
    public boolean isTitleTruncated() {
        return this.mToolbar.isTitleTruncated();
    }

    @Override
    public void restoreHierarchyState(SparseArray<Parcelable> sparseArray) {
        this.mToolbar.restoreHierarchyState(sparseArray);
    }

    @Override
    public void saveHierarchyState(SparseArray<Parcelable> sparseArray) {
        this.mToolbar.saveHierarchyState(sparseArray);
    }

    @Override
    public void setCollapsible(boolean bl) {
        this.mToolbar.setCollapsible(bl);
    }

    @Override
    public void setCustomView(View view) {
        if (this.mCustomView != null && (0x10 & this.mDisplayOpts) != 0) {
            this.mToolbar.removeView(this.mCustomView);
        }
        this.mCustomView = view;
        if (view != null && (0x10 & this.mDisplayOpts) != 0) {
            this.mToolbar.addView(this.mCustomView);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setDefaultNavigationContentDescription(int n) {
        block3: {
            block2: {
                if (n == this.mDefaultNavigationContentDescription) break block2;
                this.mDefaultNavigationContentDescription = n;
                if (TextUtils.isEmpty(this.mToolbar.getNavigationContentDescription())) break block3;
            }
            return;
        }
        this.setNavigationContentDescription(this.mDefaultNavigationContentDescription);
    }

    @Override
    public void setDefaultNavigationIcon(Drawable drawable2) {
        if (this.mDefaultNavigationIcon != drawable2) {
            this.mDefaultNavigationIcon = drawable2;
            this.updateNavigationIcon();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setDisplayOptions(int n) {
        int n2 = n ^ this.mDisplayOpts;
        this.mDisplayOpts = n;
        if (n2 != 0) {
            if ((n2 & 4) != 0) {
                if ((n & 4) != 0) {
                    this.updateHomeAccessibility();
                }
                this.updateNavigationIcon();
            }
            if ((n2 & 3) != 0) {
                this.updateToolbarLogo();
            }
            if ((n2 & 8) != 0) {
                if ((n & 8) != 0) {
                    this.mToolbar.setTitle(this.mTitle);
                    this.mToolbar.setSubtitle(this.mSubtitle);
                } else {
                    this.mToolbar.setTitle(null);
                    this.mToolbar.setSubtitle(null);
                }
            }
            if ((n2 & 0x10) != 0 && this.mCustomView != null) {
                if ((n & 0x10) == 0) {
                    this.mToolbar.removeView(this.mCustomView);
                    return;
                }
                this.mToolbar.addView(this.mCustomView);
            }
        }
    }

    @Override
    public void setDropdownParams(SpinnerAdapter spinnerAdapter, AdapterView.OnItemSelectedListener onItemSelectedListener) {
        this.ensureSpinner();
        this.mSpinner.setAdapter(spinnerAdapter);
        this.mSpinner.setOnItemSelectedListener(onItemSelectedListener);
    }

    @Override
    public void setDropdownSelectedPosition(int n) {
        if (this.mSpinner == null) {
            throw new IllegalStateException("Can't set dropdown selected position without an adapter");
        }
        this.mSpinner.setSelection(n);
    }

    @Override
    public void setEmbeddedTabView(ScrollingTabContainerView scrollingTabContainerView) {
        if (this.mTabView != null && this.mTabView.getParent() == this.mToolbar) {
            this.mToolbar.removeView(this.mTabView);
        }
        this.mTabView = scrollingTabContainerView;
        if (scrollingTabContainerView != null && this.mNavigationMode == 2) {
            this.mToolbar.addView(this.mTabView, 0);
            Toolbar.LayoutParams layoutParams = (Toolbar.LayoutParams)this.mTabView.getLayoutParams();
            layoutParams.width = -2;
            layoutParams.height = -2;
            layoutParams.gravity = 8388691;
            scrollingTabContainerView.setAllowCollapse(true);
        }
    }

    @Override
    public void setHomeButtonEnabled(boolean bl) {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setIcon(int n) {
        Drawable drawable2 = n != 0 ? this.getContext().getDrawable(n) : null;
        this.setIcon(drawable2);
    }

    @Override
    public void setIcon(Drawable drawable2) {
        this.mIcon = drawable2;
        this.updateToolbarLogo();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setLogo(int n) {
        Drawable drawable2 = n != 0 ? this.getContext().getDrawable(n) : null;
        this.setLogo(drawable2);
    }

    @Override
    public void setLogo(Drawable drawable2) {
        this.mLogo = drawable2;
        this.updateToolbarLogo();
    }

    @Override
    public void setMenu(Menu menu2, MenuPresenter.Callback callback) {
        if (this.mActionMenuPresenter == null) {
            this.mActionMenuPresenter = new ActionMenuPresenter(this.mToolbar.getContext());
            this.mActionMenuPresenter.setId(16908351);
        }
        this.mActionMenuPresenter.setCallback(callback);
        this.mToolbar.setMenu((MenuBuilder)menu2, this.mActionMenuPresenter);
    }

    @Override
    public void setMenuPrepared() {
        this.mMenuPrepared = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setNavigationContentDescription(int n) {
        String string2 = n == 0 ? null : this.getContext().getString(n);
        this.setNavigationContentDescription(string2);
    }

    @Override
    public void setNavigationContentDescription(CharSequence charSequence) {
        this.mHomeDescription = charSequence;
        this.updateHomeAccessibility();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setNavigationIcon(int n) {
        Drawable drawable2 = n != 0 ? this.mToolbar.getContext().getDrawable(n) : null;
        this.setNavigationIcon(drawable2);
    }

    @Override
    public void setNavigationIcon(Drawable drawable2) {
        this.mNavIcon = drawable2;
        this.updateNavigationIcon();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setNavigationMode(int n) {
        int n2 = this.mNavigationMode;
        if (n == n2) return;
        switch (n2) {
            case 1: {
                if (this.mSpinner != null && this.mSpinner.getParent() == this.mToolbar) {
                    this.mToolbar.removeView(this.mSpinner);
                }
            }
            default: {
                break;
            }
            case 2: {
                if (this.mTabView == null || this.mTabView.getParent() != this.mToolbar) break;
                this.mToolbar.removeView(this.mTabView);
            }
        }
        this.mNavigationMode = n;
        switch (n) {
            default: {
                throw new IllegalArgumentException("Invalid navigation mode " + n);
            }
            case 1: {
                this.ensureSpinner();
                this.mToolbar.addView((View)this.mSpinner, 0);
            }
            case 0: {
                return;
            }
            case 2: {
                if (this.mTabView == null) return;
                this.mToolbar.addView(this.mTabView, 0);
                Toolbar.LayoutParams layoutParams = (Toolbar.LayoutParams)this.mTabView.getLayoutParams();
                layoutParams.width = -2;
                layoutParams.height = -2;
                layoutParams.gravity = 8388691;
                return;
            }
        }
    }

    @Override
    public void setSplitToolbar(boolean bl) {
        if (bl) {
            throw new UnsupportedOperationException("Cannot split an android.widget.Toolbar");
        }
    }

    @Override
    public void setSplitView(ViewGroup viewGroup) {
    }

    @Override
    public void setSplitWhenNarrow(boolean bl) {
    }

    @Override
    public void setSubtitle(CharSequence charSequence) {
        this.mSubtitle = charSequence;
        if ((8 & this.mDisplayOpts) != 0) {
            this.mToolbar.setSubtitle(charSequence);
        }
    }

    @Override
    public void setTitle(CharSequence charSequence) {
        this.mTitleSet = true;
        this.setTitleInt(charSequence);
    }

    @Override
    public void setWindowCallback(Window.Callback callback) {
        this.mWindowCallback = callback;
    }

    @Override
    public void setWindowTitle(CharSequence charSequence) {
        if (!this.mTitleSet) {
            this.setTitleInt(charSequence);
        }
    }

    @Override
    public boolean showOverflowMenu() {
        return this.mToolbar.showOverflowMenu();
    }
}

