/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.R;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import android.view.accessibility.CaptioningManager;

public class SubtitleView
extends View {
    private static final int COLOR_BEVEL_DARK = Integer.MIN_VALUE;
    private static final int COLOR_BEVEL_LIGHT = -2130706433;
    private static final float INNER_PADDING_RATIO = 0.125f;
    private Layout.Alignment mAlignment;
    private int mBackgroundColor;
    private final float mCornerRadius;
    private int mEdgeColor;
    private int mEdgeType;
    private int mForegroundColor;
    private boolean mHasMeasurements;
    private int mInnerPaddingX = 0;
    private int mLastMeasuredWidth;
    private StaticLayout mLayout;
    private final RectF mLineBounds = new RectF();
    private final float mOutlineWidth;
    private Paint mPaint;
    private final float mShadowOffsetX;
    private final float mShadowOffsetY;
    private final float mShadowRadius;
    private float mSpacingAdd = 0.0f;
    private float mSpacingMult = 1.0f;
    private final StringBuilder mText = new StringBuilder();
    private TextPaint mTextPaint;

    public SubtitleView(Context context) {
        this(context, null);
    }

    public SubtitleView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public SubtitleView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public SubtitleView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.TextView, n, n2);
        String string2 = "";
        int n3 = 15;
        int n4 = typedArray.getIndexCount();
        int n5 = 0;
        while (true) {
            if (n5 >= n4) {
                void var6_7;
                Resources resources = this.getContext().getResources();
                this.mCornerRadius = resources.getDimensionPixelSize(17105018);
                this.mOutlineWidth = resources.getDimensionPixelSize(17105021);
                this.mShadowRadius = resources.getDimensionPixelSize(17105019);
                this.mShadowOffsetY = this.mShadowOffsetX = (float)resources.getDimensionPixelSize(17105020);
                this.mTextPaint = new TextPaint();
                this.mTextPaint.setAntiAlias(true);
                this.mTextPaint.setSubpixelText(true);
                this.mPaint = new Paint();
                this.mPaint.setAntiAlias(true);
                this.setText((CharSequence)var6_7);
                this.setTextSize(n3);
                return;
            }
            int n6 = typedArray.getIndex(n5);
            switch (n6) {
                case 18: {
                    CharSequence charSequence = typedArray.getText(n6);
                    break;
                }
                case 53: {
                    this.mSpacingAdd = typedArray.getDimensionPixelSize(n6, (int)this.mSpacingAdd);
                    break;
                }
                case 54: {
                    this.mSpacingMult = typedArray.getFloat(n6, this.mSpacingMult);
                    break;
                }
                case 0: {
                    n3 = typedArray.getDimensionPixelSize(n6, n3);
                    break;
                }
            }
            ++n5;
        }
    }

    private boolean computeMeasurements(int n) {
        if (this.mHasMeasurements && n == this.mLastMeasuredWidth) {
            return true;
        }
        int n2 = n - (this.mPaddingLeft + this.mPaddingRight + 2 * this.mInnerPaddingX);
        if (n2 <= 0) {
            return false;
        }
        this.mHasMeasurements = true;
        this.mLastMeasuredWidth = n2;
        this.mLayout = new StaticLayout((CharSequence)this.mText, this.mTextPaint, n2, this.mAlignment, this.mSpacingMult, this.mSpacingAdd, true);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onDraw(Canvas canvas) {
        int n;
        StaticLayout staticLayout = this.mLayout;
        if (staticLayout == null) {
            return;
        }
        int n2 = canvas.save();
        int n3 = this.mInnerPaddingX;
        canvas.translate(n3 + this.mPaddingLeft, this.mPaddingTop);
        int n4 = staticLayout.getLineCount();
        TextPaint textPaint = this.mTextPaint;
        Paint paint = this.mPaint;
        RectF rectF = this.mLineBounds;
        if (Color.alpha(this.mBackgroundColor) > 0) {
            float f = this.mCornerRadius;
            float f2 = staticLayout.getLineTop(0);
            paint.setColor(this.mBackgroundColor);
            paint.setStyle(Paint.Style.FILL);
            for (int i = 0; i < n4; ++i) {
                rectF.left = staticLayout.getLineLeft(i) - (float)n3;
                rectF.right = staticLayout.getLineRight(i) + (float)n3;
                rectF.top = f2;
                f2 = rectF.bottom = (float)staticLayout.getLineBottom(i);
                canvas.drawRoundRect(rectF, f, f, paint);
            }
        }
        if ((n = this.mEdgeType) == 1) {
            textPaint.setStrokeJoin(Paint.Join.ROUND);
            textPaint.setStrokeWidth(this.mOutlineWidth);
            textPaint.setColor(this.mEdgeColor);
            textPaint.setStyle(Paint.Style.FILL_AND_STROKE);
            for (int i = 0; i < n4; ++i) {
                staticLayout.drawText(canvas, i, i);
            }
        } else if (n == 2) {
            textPaint.setShadowLayer(this.mShadowRadius, this.mShadowOffsetX, this.mShadowOffsetY, this.mEdgeColor);
        } else if (n == 3 || n == 4) {
            boolean bl = n == 3;
            int n5 = bl ? -1 : this.mEdgeColor;
            int n6 = bl ? this.mEdgeColor : -1;
            float f = this.mShadowRadius / 2.0f;
            textPaint.setColor(this.mForegroundColor);
            textPaint.setStyle(Paint.Style.FILL);
            textPaint.setShadowLayer(this.mShadowRadius, -f, -f, n5);
            for (int i = 0; i < n4; ++i) {
                staticLayout.drawText(canvas, i, i);
            }
            textPaint.setShadowLayer(this.mShadowRadius, f, f, n6);
        }
        textPaint.setColor(this.mForegroundColor);
        textPaint.setStyle(Paint.Style.FILL);
        int n7 = 0;
        while (true) {
            if (n7 >= n4) {
                textPaint.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
                canvas.restoreToCount(n2);
                return;
            }
            staticLayout.drawText(canvas, n7, n7);
            ++n7;
        }
    }

    @Override
    public void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        this.computeMeasurements(n3 - n);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        if (this.computeMeasurements(View.MeasureSpec.getSize(n))) {
            StaticLayout staticLayout = this.mLayout;
            this.setMeasuredDimension(this.mPaddingLeft + this.mPaddingRight + 2 * this.mInnerPaddingX + staticLayout.getWidth(), staticLayout.getHeight() + this.mPaddingTop + this.mPaddingBottom);
            return;
        }
        this.setMeasuredDimension(0x1000000, 0x1000000);
    }

    public void setAlignment(Layout.Alignment alignment) {
        if (this.mAlignment != alignment) {
            this.mAlignment = alignment;
            this.mHasMeasurements = false;
            this.requestLayout();
            this.invalidate();
        }
    }

    @Override
    public void setBackgroundColor(int n) {
        this.mBackgroundColor = n;
        this.invalidate();
    }

    public void setEdgeColor(int n) {
        this.mEdgeColor = n;
        this.invalidate();
    }

    public void setEdgeType(int n) {
        this.mEdgeType = n;
        this.invalidate();
    }

    public void setForegroundColor(int n) {
        this.mForegroundColor = n;
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setStyle(int n) {
        ContentResolver contentResolver = this.mContext.getContentResolver();
        CaptioningManager.CaptionStyle captionStyle = n == -1 ? CaptioningManager.CaptionStyle.getCustomStyle(contentResolver) : CaptioningManager.CaptionStyle.PRESETS[n];
        CaptioningManager.CaptionStyle captionStyle2 = CaptioningManager.CaptionStyle.DEFAULT;
        int n2 = captionStyle.hasForegroundColor() ? captionStyle.foregroundColor : captionStyle2.foregroundColor;
        this.mForegroundColor = n2;
        int n3 = captionStyle.hasBackgroundColor() ? captionStyle.backgroundColor : captionStyle2.backgroundColor;
        this.mBackgroundColor = n3;
        int n4 = captionStyle.hasEdgeType() ? captionStyle.edgeType : captionStyle2.edgeType;
        this.mEdgeType = n4;
        int n5 = captionStyle.hasEdgeColor() ? captionStyle.edgeColor : captionStyle2.edgeColor;
        this.mEdgeColor = n5;
        this.mHasMeasurements = false;
        this.setTypeface(captionStyle.getTypeface());
        this.requestLayout();
    }

    public void setText(int n) {
        this.setText(this.getContext().getText(n));
    }

    public void setText(CharSequence charSequence) {
        this.mText.setLength(0);
        this.mText.append(charSequence);
        this.mHasMeasurements = false;
        this.requestLayout();
    }

    public void setTextSize(float f) {
        if (this.mTextPaint.getTextSize() != f) {
            this.mTextPaint.setTextSize(f);
            this.mInnerPaddingX = (int)(0.5f + 0.125f * f);
            this.mHasMeasurements = false;
            this.requestLayout();
            this.invalidate();
        }
    }

    public void setTypeface(Typeface typeface) {
        if (this.mTextPaint.getTypeface() != typeface) {
            this.mTextPaint.setTypeface(typeface);
            this.mHasMeasurements = false;
            this.requestLayout();
            this.invalidate();
        }
    }
}

