/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.content.res.Resources;
import android.inputmethodservice.Keyboard;
import android.inputmethodservice.KeyboardView;
import android.os.SystemClock;
import android.provider.Settings;
import android.util.Log;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewRootImpl;
import com.android.internal.widget.PasswordEntryKeyboard;

public class PasswordEntryKeyboardHelper
implements KeyboardView.OnKeyboardActionListener {
    public static final int KEYBOARD_MODE_ALPHA = 0;
    public static final int KEYBOARD_MODE_NUMERIC = 1;
    private static final int KEYBOARD_STATE_CAPSLOCK = 2;
    private static final int KEYBOARD_STATE_NORMAL = 0;
    private static final int KEYBOARD_STATE_SHIFTED = 1;
    private static final int NUMERIC = 0;
    private static final int QWERTY = 1;
    private static final int QWERTY_SHIFTED = 2;
    private static final int SYMBOLS = 3;
    private static final int SYMBOLS_SHIFTED = 4;
    private static final String TAG = "PasswordEntryKeyboardHelper";
    private final Context mContext;
    private boolean mEnableHaptics = false;
    private int mKeyboardMode = 0;
    private int mKeyboardState = 0;
    private final KeyboardView mKeyboardView;
    int[] mLayouts = new int[]{0x1110009, 0x111000B, 0x111000C, 0x111000D, 0x111000E};
    private PasswordEntryKeyboard mNumericKeyboard;
    private PasswordEntryKeyboard mQwertyKeyboard;
    private PasswordEntryKeyboard mQwertyKeyboardShifted;
    private PasswordEntryKeyboard mSymbolsKeyboard;
    private PasswordEntryKeyboard mSymbolsKeyboardShifted;
    private final View mTargetView;
    private boolean mUsingScreenWidth;
    private long[] mVibratePattern;

    public PasswordEntryKeyboardHelper(Context context, KeyboardView keyboardView, View view) {
        this(context, keyboardView, view, true, null);
    }

    public PasswordEntryKeyboardHelper(Context context, KeyboardView keyboardView, View view, boolean bl) {
        this(context, keyboardView, view, bl, null);
    }

    public PasswordEntryKeyboardHelper(Context context, KeyboardView keyboardView, View view, boolean bl, int[] nArray) {
        this.mContext = context;
        this.mTargetView = view;
        this.mKeyboardView = keyboardView;
        this.mKeyboardView.setOnKeyboardActionListener(this);
        this.mUsingScreenWidth = bl;
        if (nArray != null) {
            if (nArray.length != this.mLayouts.length) {
                throw new RuntimeException("Wrong number of layouts");
            }
            for (int i = 0; i < this.mLayouts.length; ++i) {
                this.mLayouts[i] = nArray[i];
            }
        }
        this.createKeyboards();
    }

    private void createKeyboardsWithDefaultWidth() {
        this.mNumericKeyboard = new PasswordEntryKeyboard(this.mContext, this.mLayouts[0]);
        this.mQwertyKeyboard = new PasswordEntryKeyboard(this.mContext, this.mLayouts[1], 16909318);
        this.mQwertyKeyboard.enableShiftLock();
        this.mQwertyKeyboardShifted = new PasswordEntryKeyboard(this.mContext, this.mLayouts[2], 16909318);
        this.mQwertyKeyboardShifted.enableShiftLock();
        this.mQwertyKeyboardShifted.setShifted(true);
        this.mSymbolsKeyboard = new PasswordEntryKeyboard(this.mContext, this.mLayouts[3]);
        this.mSymbolsKeyboard.enableShiftLock();
        this.mSymbolsKeyboardShifted = new PasswordEntryKeyboard(this.mContext, this.mLayouts[4]);
        this.mSymbolsKeyboardShifted.enableShiftLock();
        this.mSymbolsKeyboardShifted.setShifted(true);
    }

    private void createKeyboardsWithSpecificSize(int n, int n2) {
        this.mNumericKeyboard = new PasswordEntryKeyboard(this.mContext, this.mLayouts[0], n, n2);
        this.mQwertyKeyboard = new PasswordEntryKeyboard(this.mContext, this.mLayouts[1], 16909318, n, n2);
        this.mQwertyKeyboard.enableShiftLock();
        this.mQwertyKeyboardShifted = new PasswordEntryKeyboard(this.mContext, this.mLayouts[2], 16909318, n, n2);
        this.mQwertyKeyboardShifted.enableShiftLock();
        this.mQwertyKeyboardShifted.setShifted(true);
        this.mSymbolsKeyboard = new PasswordEntryKeyboard(this.mContext, this.mLayouts[3], n, n2);
        this.mSymbolsKeyboard.enableShiftLock();
        this.mSymbolsKeyboardShifted = new PasswordEntryKeyboard(this.mContext, this.mLayouts[4], n, n2);
        this.mSymbolsKeyboardShifted.enableShiftLock();
        this.mSymbolsKeyboardShifted.setShifted(true);
    }

    private void handleCharacter(int n, int[] nArray) {
        if (this.mKeyboardView.isShifted() && n != 32 && n != 10) {
            n = Character.toUpperCase(n);
        }
        this.sendKeyEventsToTarget(n);
    }

    private void handleClose() {
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleModeChange() {
        PasswordEntryKeyboard passwordEntryKeyboard;
        block5: {
            block6: {
                Keyboard keyboard;
                block4: {
                    keyboard = this.mKeyboardView.getKeyboard();
                    if (keyboard != this.mQwertyKeyboard && keyboard != this.mQwertyKeyboardShifted) break block4;
                    passwordEntryKeyboard = this.mSymbolsKeyboard;
                    break block5;
                }
                if (keyboard == this.mSymbolsKeyboard) break block6;
                PasswordEntryKeyboard passwordEntryKeyboard2 = this.mSymbolsKeyboardShifted;
                passwordEntryKeyboard = null;
                if (keyboard != passwordEntryKeyboard2) break block5;
            }
            passwordEntryKeyboard = this.mQwertyKeyboard;
        }
        if (passwordEntryKeyboard != null) {
            this.mKeyboardView.setKeyboard(passwordEntryKeyboard);
            this.mKeyboardState = 0;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void handleShift() {
        PasswordEntryKeyboard passwordEntryKeyboard;
        Keyboard keyboard;
        int n;
        block13: {
            block12: {
                n = 1;
                if (this.mKeyboardView == null) break block12;
                keyboard = this.mKeyboardView.getKeyboard();
                int n2 = keyboard == this.mQwertyKeyboard || keyboard == this.mQwertyKeyboardShifted ? n : 0;
                if (this.mKeyboardState == 0) {
                    void var9_5;
                    if (n2) {
                        int n3 = n;
                    } else {
                        int n4 = 2;
                    }
                    this.mKeyboardState = var9_5;
                    passwordEntryKeyboard = n2 ? this.mQwertyKeyboardShifted : this.mSymbolsKeyboardShifted;
                } else if (this.mKeyboardState == n) {
                    this.mKeyboardState = 2;
                    passwordEntryKeyboard = n2 ? this.mQwertyKeyboardShifted : this.mSymbolsKeyboardShifted;
                } else {
                    int n5 = this.mKeyboardState;
                    passwordEntryKeyboard = null;
                    if (n5 == 2) {
                        this.mKeyboardState = 0;
                        passwordEntryKeyboard = n2 != 0 ? this.mQwertyKeyboard : this.mSymbolsKeyboard;
                    }
                }
                if (passwordEntryKeyboard != null) break block13;
            }
            return;
        }
        if (passwordEntryKeyboard != keyboard) {
            this.mKeyboardView.setKeyboard(passwordEntryKeyboard);
        }
        int n6 = this.mKeyboardState == 2 ? n : 0;
        passwordEntryKeyboard.setShiftLocked(n6 != 0);
        KeyboardView keyboardView = this.mKeyboardView;
        if (this.mKeyboardState == 0) {
            n = 0;
        }
        keyboardView.setShifted(n != 0);
    }

    private void performHapticFeedback() {
        if (this.mEnableHaptics) {
            this.mKeyboardView.performHapticFeedback(1, 3);
        }
    }

    private void sendKeyEventsToTarget(int n) {
        ViewRootImpl viewRootImpl = this.mTargetView.getViewRootImpl();
        KeyCharacterMap keyCharacterMap = KeyCharacterMap.load(-1);
        char[] cArray = new char[]{(char)n};
        KeyEvent[] keyEventArray = keyCharacterMap.getEvents(cArray);
        if (keyEventArray != null) {
            for (KeyEvent keyEvent : keyEventArray) {
                viewRootImpl.dispatchInputEvent(KeyEvent.changeFlags(keyEvent, 4 | (2 | keyEvent.getFlags())));
            }
        }
    }

    public void createKeyboards() {
        ViewGroup.LayoutParams layoutParams = this.mKeyboardView.getLayoutParams();
        if (this.mUsingScreenWidth || layoutParams.width == -1) {
            this.createKeyboardsWithDefaultWidth();
            return;
        }
        this.createKeyboardsWithSpecificSize(layoutParams.width, layoutParams.height);
    }

    public void handleBackspace() {
        this.sendDownUpKeyEvents(67);
        this.performHapticFeedback();
    }

    public boolean isAlpha() {
        return this.mKeyboardMode == 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onKey(int n, int[] nArray) {
        if (n == -5) {
            this.handleBackspace();
            return;
        } else {
            if (n == -1) {
                this.handleShift();
                return;
            }
            if (n == -3) {
                this.handleClose();
                return;
            }
            if (n == -2 && this.mKeyboardView != null) {
                this.handleModeChange();
                return;
            }
            this.handleCharacter(n, nArray);
            if (this.mKeyboardState != 1) return;
            this.mKeyboardState = 2;
            this.handleShift();
            return;
        }
    }

    @Override
    public void onPress(int n) {
        this.performHapticFeedback();
    }

    @Override
    public void onRelease(int n) {
    }

    @Override
    public void onText(CharSequence charSequence) {
    }

    public void sendDownUpKeyEvents(int n) {
        long l = SystemClock.uptimeMillis();
        ViewRootImpl viewRootImpl = this.mTargetView.getViewRootImpl();
        viewRootImpl.dispatchKeyFromIme(new KeyEvent(l, l, 0, n, 0, 0, -1, 0, 6));
        viewRootImpl.dispatchKeyFromIme(new KeyEvent(l, l, 1, n, 0, 0, -1, 0, 6));
    }

    public void setEnableHaptics(boolean bl) {
        this.mEnableHaptics = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setKeyboardMode(int n) {
        int n2 = 1;
        switch (n) {
            case 0: {
                this.mKeyboardView.setKeyboard(this.mQwertyKeyboard);
                this.mKeyboardState = 0;
                if (Settings.System.getInt(this.mContext.getContentResolver(), "show_password", n2) == 0) {
                    n2 = 0;
                }
                KeyboardView keyboardView = this.mKeyboardView;
                if (n2 != 0) {
                    // empty if block
                }
                keyboardView.setPreviewEnabled(false);
            }
            default: {
                break;
            }
            case 1: {
                this.mKeyboardView.setKeyboard(this.mNumericKeyboard);
                this.mKeyboardState = 0;
                this.mKeyboardView.setPreviewEnabled(false);
            }
        }
        this.mKeyboardMode = n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setVibratePattern(int n) {
        int[] nArray;
        block5: {
            try {
                int[] nArray2;
                nArray = nArray2 = this.mContext.getResources().getIntArray(n);
            }
            catch (Resources.NotFoundException notFoundException) {
                nArray = null;
                if (n == 0) break block5;
                Log.e(TAG, "Vibrate pattern missing", notFoundException);
                nArray = null;
            }
        }
        if (nArray == null) {
            this.mVibratePattern = null;
            return;
        } else {
            this.mVibratePattern = new long[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                this.mVibratePattern[i] = nArray[i];
            }
        }
    }

    @Override
    public void swipeDown() {
    }

    @Override
    public void swipeLeft() {
    }

    @Override
    public void swipeRight() {
    }

    @Override
    public void swipeUp() {
    }
}

