/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.os.IBinder;
import android.os.RemoteException;
import android.util.ArrayMap;
import com.android.internal.widget.ILockSettings;
import com.android.internal.widget.ILockSettingsObserver;

public class LockPatternUtilsCache
implements ILockSettings {
    private static final String HAS_LOCK_PASSWORD_CACHE_KEY = "LockPatternUtils.Cache.HasLockPasswordCacheKey";
    private static final String HAS_LOCK_PATTERN_CACHE_KEY = "LockPatternUtils.Cache.HasLockPatternCacheKey";
    private static LockPatternUtilsCache sInstance;
    private final ArrayMap<CacheKey, Object> mCache = new ArrayMap();
    private final CacheKey mCacheKey = new CacheKey();
    private final ILockSettingsObserver mObserver = new ILockSettingsObserver.Stub(){

        @Override
        public void onLockSettingChanged(String string2, int n) throws RemoteException {
            LockPatternUtilsCache.this.invalidateCache(string2, n);
        }
    };
    private final ILockSettings mService;

    private LockPatternUtilsCache(ILockSettings iLockSettings) {
        this.mService = iLockSettings;
        try {
            iLockSettings.registerObserver(this.mObserver);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public static LockPatternUtilsCache getInstance(ILockSettings iLockSettings) {
        synchronized (LockPatternUtilsCache.class) {
            if (sInstance == null) {
                sInstance = new LockPatternUtilsCache(iLockSettings);
            }
            LockPatternUtilsCache lockPatternUtilsCache = sInstance;
            return lockPatternUtilsCache;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void invalidateCache(String string2, int n) {
        ArrayMap<CacheKey, Object> arrayMap = this.mCache;
        synchronized (arrayMap) {
            this.mCache.remove(this.mCacheKey.set(string2, n));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object peekCache(String string2, int n) {
        ArrayMap<CacheKey, Object> arrayMap = this.mCache;
        synchronized (arrayMap) {
            return this.mCache.get(this.mCacheKey.set(string2, n));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void putCache(String string2, int n, Object object) {
        ArrayMap<CacheKey, Object> arrayMap = this.mCache;
        synchronized (arrayMap) {
            this.mCache.put(new CacheKey().set(string2, n), object);
            return;
        }
    }

    @Override
    public IBinder asBinder() {
        return this.mService.asBinder();
    }

    @Override
    public boolean checkPassword(String string2, int n) throws RemoteException {
        return this.mService.checkPassword(string2, n);
    }

    @Override
    public boolean checkPasswordByUserId(String string2, int n) throws RemoteException {
        return this.mService.checkPasswordByUserId(string2, n);
    }

    @Override
    public boolean checkPattern(String string2, int n) throws RemoteException {
        return this.mService.checkPattern(string2, n);
    }

    @Override
    public boolean checkPatternByUserId(String string2, int n) throws RemoteException {
        return this.mService.checkPatternByUserId(string2, n);
    }

    @Override
    public boolean checkVoldPassword(int n) throws RemoteException {
        return this.mService.checkVoldPassword(n);
    }

    @Override
    public void clearCache() {
        this.mCache.clear();
    }

    @Override
    public boolean getBoolean(String string2, boolean bl, int n) throws RemoteException {
        Object object = this.peekCache(string2, n);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        boolean bl2 = this.mService.getBoolean(string2, bl, n);
        this.putCache(string2, n, bl2);
        return bl2;
    }

    @Override
    public long getLong(String string2, long l, int n) throws RemoteException {
        Object object = this.peekCache(string2, n);
        if (object instanceof Long) {
            return (Long)object;
        }
        long l2 = this.mService.getLong(string2, l, n);
        this.putCache(string2, n, l2);
        return l2;
    }

    @Override
    public String getString(String string2, String string3, int n) throws RemoteException {
        Object object = this.peekCache(string2, n);
        if (object instanceof String) {
            return (String)object;
        }
        String string4 = this.mService.getString(string2, string3, n);
        this.putCache(string2, n, string4);
        return string4;
    }

    @Override
    public boolean havePassword(int n) throws RemoteException {
        Object object = this.peekCache(HAS_LOCK_PASSWORD_CACHE_KEY, n);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        boolean bl = this.mService.havePassword(n);
        this.putCache(HAS_LOCK_PASSWORD_CACHE_KEY, n, bl);
        return bl;
    }

    @Override
    public boolean havePattern(int n) throws RemoteException {
        Object object = this.peekCache(HAS_LOCK_PATTERN_CACHE_KEY, n);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        boolean bl = this.mService.havePattern(n);
        this.putCache(HAS_LOCK_PATTERN_CACHE_KEY, n, bl);
        return bl;
    }

    @Override
    public void registerObserver(ILockSettingsObserver iLockSettingsObserver) throws RemoteException {
        this.mService.registerObserver(iLockSettingsObserver);
    }

    @Override
    public void removeUser(int n) throws RemoteException {
        this.mService.removeUser(n);
        this.clearCache();
    }

    @Override
    public void setBoolean(String string2, boolean bl, int n) throws RemoteException {
        this.invalidateCache(string2, n);
        this.mService.setBoolean(string2, bl, n);
        this.putCache(string2, n, bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setLockPassword(String string2, int n) throws RemoteException {
        this.invalidateCache(HAS_LOCK_PASSWORD_CACHE_KEY, n);
        this.mService.setLockPassword(string2, n);
        boolean bl = string2 != null;
        this.putCache(HAS_LOCK_PASSWORD_CACHE_KEY, n, bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setLockPattern(String string2, int n) throws RemoteException {
        this.invalidateCache(HAS_LOCK_PATTERN_CACHE_KEY, n);
        this.mService.setLockPattern(string2, n);
        boolean bl = string2 != null;
        this.putCache(HAS_LOCK_PATTERN_CACHE_KEY, n, bl);
    }

    @Override
    public void setLong(String string2, long l, int n) throws RemoteException {
        this.invalidateCache(string2, n);
        this.mService.setLong(string2, l, n);
        this.putCache(string2, n, l);
    }

    @Override
    public void setString(String string2, String string3, int n) throws RemoteException {
        this.invalidateCache(string2, n);
        this.mService.setString(string2, string3, n);
        this.putCache(string2, n, string3);
    }

    @Override
    public void unregisterObserver(ILockSettingsObserver iLockSettingsObserver) throws RemoteException {
        this.mService.unregisterObserver(iLockSettingsObserver);
    }

    private static final class CacheKey {
        String key;
        int userId;

        private CacheKey() {
        }

        public CacheKey copy() {
            return new CacheKey().set(this.key, this.userId);
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (!(object instanceof CacheKey)) break block2;
                    CacheKey cacheKey = (CacheKey)object;
                    if (this.userId == cacheKey.userId && this.key.equals(cacheKey.key)) break block3;
                }
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.key.hashCode() ^ this.userId;
        }

        public CacheKey set(String string2, int n) {
            this.key = string2;
            this.userId = n;
            return this;
        }
    }
}

