/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.animation.LayoutTransition;
import android.app.ActionBar;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.Layout;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.CollapsibleActionView;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.view.accessibility.AccessibilityEvent;
import android.widget.ActionMenuPresenter;
import android.widget.ActionMenuView;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import com.android.internal.R;
import com.android.internal.transition.ActionBarTransition;
import com.android.internal.view.menu.ActionMenuItem;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuPresenter;
import com.android.internal.view.menu.MenuView;
import com.android.internal.view.menu.SubMenuBuilder;
import com.android.internal.widget.AbsActionBarView;
import com.android.internal.widget.ActionBarContextView;
import com.android.internal.widget.DecorToolbar;
import com.android.internal.widget.ScrollingTabContainerView;

public class ActionBarView
extends AbsActionBarView
implements DecorToolbar {
    private static final int DEFAULT_CUSTOM_GRAVITY = 8388627;
    public static final int DISPLAY_DEFAULT = 0;
    private static final int DISPLAY_RELAYOUT_MASK = 63;
    private static final String TAG = "ActionBarView";
    private ActionBarContextView mContextView;
    private View mCustomNavView;
    private int mDefaultUpDescription = 17040782;
    private int mDisplayOptions = -1;
    View mExpandedActionView;
    private final View.OnClickListener mExpandedActionViewUpListener = new View.OnClickListener(){

        @Override
        public void onClick(View view) {
            MenuItemImpl menuItemImpl = ((ActionBarView)ActionBarView.this).mExpandedMenuPresenter.mCurrentExpandedItem;
            if (menuItemImpl != null) {
                menuItemImpl.collapseActionView();
            }
        }
    };
    private HomeView mExpandedHomeLayout;
    private ExpandedActionViewMenuPresenter mExpandedMenuPresenter;
    private CharSequence mHomeDescription;
    private int mHomeDescriptionRes;
    private HomeView mHomeLayout;
    private Drawable mIcon;
    private boolean mIncludeTabs;
    private int mIndeterminateProgressStyle;
    private ProgressBar mIndeterminateProgressView;
    private boolean mIsCollapsible;
    private int mItemPadding;
    private LinearLayout mListNavLayout;
    private Drawable mLogo;
    private ActionMenuItem mLogoNavItem;
    private boolean mMenuPrepared;
    private AdapterView.OnItemSelectedListener mNavItemSelectedListener;
    private int mNavigationMode;
    private MenuBuilder mOptionsMenu;
    private int mProgressBarPadding;
    private int mProgressStyle;
    private ProgressBar mProgressView;
    private Spinner mSpinner;
    private SpinnerAdapter mSpinnerAdapter;
    private CharSequence mSubtitle;
    private int mSubtitleStyleRes;
    private TextView mSubtitleView;
    private ScrollingTabContainerView mTabScrollView;
    private Runnable mTabSelector;
    private CharSequence mTitle;
    private LinearLayout mTitleLayout;
    private int mTitleStyleRes;
    private TextView mTitleView;
    private final View.OnClickListener mUpClickListener = new View.OnClickListener(){

        @Override
        public void onClick(View view) {
            if (ActionBarView.this.mMenuPrepared) {
                ActionBarView.this.mWindowCallback.onMenuItemSelected(0, ActionBarView.this.mLogoNavItem);
            }
        }
    };
    private ViewGroup mUpGoerFive;
    private boolean mUserTitle;
    private boolean mWasHomeEnabled;
    Window.Callback mWindowCallback;

    public ActionBarView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setBackgroundResource(0);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.ActionBar, 16843470, 0);
        this.mNavigationMode = typedArray.getInt(7, 0);
        this.mTitle = typedArray.getText(5);
        this.mSubtitle = typedArray.getText(9);
        this.mLogo = typedArray.getDrawable(6);
        this.mIcon = typedArray.getDrawable(0);
        LayoutInflater layoutInflater = LayoutInflater.from(context);
        int n = typedArray.getResourceId(16, 17367064);
        this.mUpGoerFive = (ViewGroup)layoutInflater.inflate(17367067, (ViewGroup)this, false);
        this.mHomeLayout = (HomeView)layoutInflater.inflate(n, this.mUpGoerFive, false);
        this.mExpandedHomeLayout = (HomeView)layoutInflater.inflate(n, this.mUpGoerFive, false);
        this.mExpandedHomeLayout.setShowUp(true);
        this.mExpandedHomeLayout.setOnClickListener(this.mExpandedActionViewUpListener);
        this.mExpandedHomeLayout.setContentDescription(this.getResources().getText(this.mDefaultUpDescription));
        Drawable drawable2 = this.mUpGoerFive.getBackground();
        if (drawable2 != null) {
            this.mExpandedHomeLayout.setBackground(drawable2.getConstantState().newDrawable());
        }
        this.mExpandedHomeLayout.setEnabled(true);
        this.mExpandedHomeLayout.setFocusable(true);
        this.mTitleStyleRes = typedArray.getResourceId(11, 0);
        this.mSubtitleStyleRes = typedArray.getResourceId(12, 0);
        this.mProgressStyle = typedArray.getResourceId(1, 0);
        this.mIndeterminateProgressStyle = typedArray.getResourceId(14, 0);
        this.mProgressBarPadding = typedArray.getDimensionPixelOffset(15, 0);
        this.mItemPadding = typedArray.getDimensionPixelOffset(17, 0);
        this.setDisplayOptions(typedArray.getInt(8, 0));
        int n2 = typedArray.getResourceId(10, 0);
        if (n2 != 0) {
            this.mCustomNavView = layoutInflater.inflate(n2, (ViewGroup)this, false);
            this.mNavigationMode = 0;
            this.setDisplayOptions(0x10 | this.mDisplayOptions);
        }
        this.mContentHeight = typedArray.getLayoutDimension(4, 0);
        typedArray.recycle();
        this.mLogoNavItem = new ActionMenuItem(context, 0, 16908332, 0, 0, this.mTitle);
        this.mUpGoerFive.setOnClickListener(this.mUpClickListener);
        this.mUpGoerFive.setClickable(true);
        this.mUpGoerFive.setFocusable(true);
        if (this.getImportantForAccessibility() == 0) {
            this.setImportantForAccessibility(1);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private CharSequence buildHomeContentDescription() {
        CharSequence charSequence = this.mHomeDescription != null ? this.mHomeDescription : ((4 & this.mDisplayOptions) != 0 ? this.mContext.getResources().getText(this.mDefaultUpDescription) : this.mContext.getResources().getText(17040781));
        CharSequence charSequence2 = this.getTitle();
        CharSequence charSequence3 = this.getSubtitle();
        if (TextUtils.isEmpty(charSequence2)) {
            return charSequence;
        }
        if (!TextUtils.isEmpty(charSequence3)) {
            return this.getResources().getString(17040785, charSequence2, charSequence3, charSequence);
        }
        return this.getResources().getString(17040784, charSequence2, charSequence);
    }

    private void configPresenters(MenuBuilder menuBuilder) {
        if (menuBuilder != null) {
            menuBuilder.addMenuPresenter(this.mActionMenuPresenter, this.mPopupContext);
            menuBuilder.addMenuPresenter(this.mExpandedMenuPresenter, this.mPopupContext);
            return;
        }
        this.mActionMenuPresenter.initForMenu(this.mPopupContext, null);
        this.mExpandedMenuPresenter.initForMenu(this.mPopupContext, null);
        this.mActionMenuPresenter.updateMenuView(true);
        this.mExpandedMenuPresenter.updateMenuView(true);
    }

    private void initTitle() {
        if (this.mTitleLayout == null) {
            this.mTitleLayout = (LinearLayout)LayoutInflater.from(this.getContext()).inflate(17367066, (ViewGroup)this, false);
            this.mTitleView = (TextView)this.mTitleLayout.findViewById(16909001);
            this.mSubtitleView = (TextView)this.mTitleLayout.findViewById(16909002);
            if (this.mTitleStyleRes != 0) {
                this.mTitleView.setTextAppearance(this.mContext, this.mTitleStyleRes);
            }
            if (this.mTitle != null) {
                this.mTitleView.setText(this.mTitle);
            }
            if (this.mSubtitleStyleRes != 0) {
                this.mSubtitleView.setTextAppearance(this.mContext, this.mSubtitleStyleRes);
            }
            if (this.mSubtitle != null) {
                this.mSubtitleView.setText(this.mSubtitle);
                this.mSubtitleView.setVisibility(0);
            }
        }
        ActionBarTransition.beginDelayedTransition(this);
        this.mUpGoerFive.addView(this.mTitleLayout);
        if (this.mExpandedActionView != null || TextUtils.isEmpty(this.mTitle) && TextUtils.isEmpty(this.mSubtitle)) {
            this.mTitleLayout.setVisibility(8);
            return;
        }
        this.mTitleLayout.setVisibility(0);
    }

    private void setHomeButtonEnabled(boolean bl, boolean bl2) {
        if (bl2) {
            this.mWasHomeEnabled = bl;
        }
        if (this.mExpandedActionView != null) {
            return;
        }
        this.mUpGoerFive.setEnabled(bl);
        this.mUpGoerFive.setFocusable(bl);
        this.updateHomeAccessibility(bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setTitleImpl(CharSequence charSequence) {
        ActionBarTransition.beginDelayedTransition(this);
        this.mTitle = charSequence;
        if (this.mTitleView != null) {
            this.mTitleView.setText(charSequence);
            boolean bl = this.mExpandedActionView == null && (8 & this.mDisplayOptions) != 0 && (!TextUtils.isEmpty(this.mTitle) || !TextUtils.isEmpty(this.mSubtitle));
            LinearLayout linearLayout = this.mTitleLayout;
            int n = 0;
            if (!bl) {
                n = 8;
            }
            linearLayout.setVisibility(n);
        }
        if (this.mLogoNavItem != null) {
            this.mLogoNavItem.setTitle(charSequence);
        }
        this.updateHomeAccessibility(this.mUpGoerFive.isEnabled());
    }

    private void updateHomeAccessibility(boolean bl) {
        if (!bl) {
            this.mUpGoerFive.setContentDescription(null);
            this.mUpGoerFive.setImportantForAccessibility(2);
            return;
        }
        this.mUpGoerFive.setImportantForAccessibility(0);
        this.mUpGoerFive.setContentDescription(this.buildHomeContentDescription());
    }

    @Override
    public boolean canSplit() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void collapseActionView() {
        if (this.mExpandedMenuPresenter == null) {
            return;
        }
        MenuItemImpl menuItemImpl = this.mExpandedMenuPresenter.mCurrentExpandedItem;
        if (menuItemImpl == null) return;
        menuItemImpl.collapseActionView();
    }

    @Override
    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ActionBar.LayoutParams(8388627);
    }

    @Override
    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new ActionBar.LayoutParams(this.getContext(), attributeSet);
    }

    @Override
    public ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        if (layoutParams == null) {
            layoutParams = this.generateDefaultLayoutParams();
        }
        return layoutParams;
    }

    @Override
    public View getCustomView() {
        return this.mCustomNavView;
    }

    @Override
    public int getDisplayOptions() {
        return this.mDisplayOptions;
    }

    @Override
    public int getDropdownItemCount() {
        if (this.mSpinnerAdapter != null) {
            return this.mSpinnerAdapter.getCount();
        }
        return 0;
    }

    @Override
    public int getDropdownSelectedPosition() {
        return this.mSpinner.getSelectedItemPosition();
    }

    @Override
    public int getNavigationMode() {
        return this.mNavigationMode;
    }

    @Override
    public CharSequence getSubtitle() {
        return this.mSubtitle;
    }

    @Override
    public CharSequence getTitle() {
        return this.mTitle;
    }

    @Override
    public ViewGroup getViewGroup() {
        return this;
    }

    @Override
    public boolean hasEmbeddedTabs() {
        return this.mIncludeTabs;
    }

    @Override
    public boolean hasExpandedActionView() {
        return this.mExpandedMenuPresenter != null && this.mExpandedMenuPresenter.mCurrentExpandedItem != null;
    }

    @Override
    public boolean hasIcon() {
        return this.mIcon != null;
    }

    @Override
    public boolean hasLogo() {
        return this.mLogo != null;
    }

    @Override
    public void initIndeterminateProgress() {
        this.mIndeterminateProgressView = new ProgressBar(this.mContext, null, 0, this.mIndeterminateProgressStyle);
        this.mIndeterminateProgressView.setId(16909231);
        this.mIndeterminateProgressView.setVisibility(8);
        this.addView(this.mIndeterminateProgressView);
    }

    @Override
    public void initProgress() {
        this.mProgressView = new ProgressBar(this.mContext, null, 0, this.mProgressStyle);
        this.mProgressView.setId(16909232);
        this.mProgressView.setMax(10000);
        this.mProgressView.setVisibility(8);
        this.addView(this.mProgressView);
    }

    @Override
    public boolean isSplit() {
        return this.mSplitActionBar;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean isTitleTruncated() {
        Layout layout2;
        if (this.mTitleView != null && (layout2 = this.mTitleView.getLayout()) != null) {
            int n = layout2.getLineCount();
            for (int i = 0; i < n; ++i) {
                if (layout2.getEllipsisCount(i) <= 0) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        this.mTitleView = null;
        this.mSubtitleView = null;
        if (this.mTitleLayout != null && this.mTitleLayout.getParent() == this.mUpGoerFive) {
            this.mUpGoerFive.removeView(this.mTitleLayout);
        }
        this.mTitleLayout = null;
        if ((8 & this.mDisplayOptions) != 0) {
            this.initTitle();
        }
        if (this.mHomeDescriptionRes != 0) {
            this.setNavigationContentDescription(this.mHomeDescriptionRes);
        }
        if (this.mTabScrollView != null && this.mIncludeTabs) {
            ViewGroup.LayoutParams layoutParams = this.mTabScrollView.getLayoutParams();
            if (layoutParams != null) {
                layoutParams.width = -2;
                layoutParams.height = -1;
            }
            this.mTabScrollView.setAllowCollapse(true);
        }
    }

    @Override
    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeCallbacks(this.mTabSelector);
        if (this.mActionMenuPresenter != null) {
            this.mActionMenuPresenter.hideOverflowMenu();
            this.mActionMenuPresenter.hideSubMenus();
        }
    }

    @Override
    protected void onFinishInflate() {
        ViewParent viewParent;
        super.onFinishInflate();
        this.mUpGoerFive.addView((View)this.mHomeLayout, 0);
        this.addView(this.mUpGoerFive);
        if (this.mCustomNavView != null && (0x10 & this.mDisplayOptions) != 0 && (viewParent = this.mCustomNavView.getParent()) != this) {
            if (viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView(this.mCustomNavView);
            }
            this.addView(this.mCustomNavView);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        block48: {
            block43: {
                block44: {
                    int n5;
                    int n6;
                    int n7;
                    int n8;
                    int n9;
                    int n10;
                    View view;
                    int n11;
                    int n12;
                    boolean bl2;
                    block47: {
                        block45: {
                            int n13;
                            block46: {
                                int n14 = n4 - n2 - this.getPaddingTop() - this.getPaddingBottom();
                                if (n14 <= 0) break block43;
                                bl2 = this.isLayoutRtl();
                                int n15 = bl2 ? 1 : -1;
                                n12 = bl2 ? this.getPaddingLeft() : n3 - n - this.getPaddingRight();
                                int n16 = bl2 ? n3 - n - this.getPaddingRight() : this.getPaddingLeft();
                                int n17 = this.getPaddingTop();
                                HomeView homeView = this.mExpandedActionView != null ? this.mExpandedHomeLayout : this.mHomeLayout;
                                boolean bl3 = this.mTitleLayout != null && this.mTitleLayout.getVisibility() != 8 && (8 & this.mDisplayOptions) != 0;
                                ViewParent viewParent = homeView.getParent();
                                ViewGroup viewGroup = this.mUpGoerFive;
                                int n18 = 0;
                                if (viewParent == viewGroup) {
                                    if (homeView.getVisibility() != 8) {
                                        n18 = homeView.getStartOffset();
                                    } else {
                                        n18 = 0;
                                        if (bl3) {
                                            n18 = homeView.getUpWidth();
                                        }
                                    }
                                }
                                n11 = ActionBarView.next(n16 + this.positionChild(this.mUpGoerFive, ActionBarView.next(n16, n18, bl2), n17, n14, bl2), n18, bl2);
                                if (this.mExpandedActionView == null) {
                                    switch (this.mNavigationMode) {
                                        case 1: {
                                            if (this.mListNavLayout == null) break;
                                            if (bl3) {
                                                n11 = ActionBarView.next(n11, this.mItemPadding, bl2);
                                            }
                                            n11 = ActionBarView.next(n11 + this.positionChild(this.mListNavLayout, n11, n17, n14, bl2), this.mItemPadding, bl2);
                                            break;
                                        }
                                        case 2: {
                                            if (this.mTabScrollView == null) break;
                                            if (bl3) {
                                                n11 = ActionBarView.next(n11, this.mItemPadding, bl2);
                                            }
                                            n11 = ActionBarView.next(n11 + this.positionChild(this.mTabScrollView, n11, n17, n14, bl2), this.mItemPadding, bl2);
                                            break;
                                        }
                                    }
                                }
                                if (this.mMenuView != null && this.mMenuView.getParent() == this) {
                                    ActionMenuView actionMenuView = this.mMenuView;
                                    boolean bl4 = !bl2;
                                    this.positionChild(actionMenuView, n12, n17, n14, bl4);
                                    n12 += n15 * this.mMenuView.getMeasuredWidth();
                                }
                                if (this.mIndeterminateProgressView != null && this.mIndeterminateProgressView.getVisibility() != 8) {
                                    ProgressBar progressBar = this.mIndeterminateProgressView;
                                    boolean bl5 = !bl2;
                                    this.positionChild(progressBar, n12, n17, n14, bl5);
                                    n12 += n15 * this.mIndeterminateProgressView.getMeasuredWidth();
                                }
                                if (this.mExpandedActionView != null) {
                                    view = this.mExpandedActionView;
                                } else {
                                    int n19 = 0x10 & this.mDisplayOptions;
                                    view = null;
                                    if (n19 != 0) {
                                        View view2 = this.mCustomNavView;
                                        view = null;
                                        if (view2 != null) {
                                            view = this.mCustomNavView;
                                        }
                                    }
                                }
                                if (view == null) break block44;
                                n10 = this.getLayoutDirection();
                                ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
                                ActionBar.LayoutParams layoutParams2 = layoutParams instanceof ActionBar.LayoutParams ? (ActionBar.LayoutParams)layoutParams : null;
                                n9 = layoutParams2 != null ? layoutParams2.gravity : 8388627;
                                n8 = view.getMeasuredWidth();
                                n7 = 0;
                                n6 = 0;
                                if (layoutParams2 != null) {
                                    n11 = ActionBarView.next(n11, layoutParams2.getMarginStart(), bl2);
                                    n12 += n15 * layoutParams2.getMarginEnd();
                                    n6 = layoutParams2.topMargin;
                                    n7 = layoutParams2.bottomMargin;
                                }
                                if ((n5 = n9 & 0x800007) != 1) break block45;
                                n13 = (this.mRight - this.mLeft - n8) / 2;
                                if (!bl2) break block46;
                                if (n13 + n8 > n11) {
                                    n5 = 5;
                                    break block47;
                                } else if (n13 < n12) {
                                    n5 = 3;
                                }
                                break block47;
                            }
                            int n20 = n13 + n8;
                            if (n13 < n11) {
                                n5 = 3;
                                break block47;
                            } else if (n20 > n12) {
                                n5 = 5;
                            }
                            break block47;
                        }
                        if (n9 == 0) {
                            n5 = 0x800003;
                        }
                    }
                    int n21 = Gravity.getAbsoluteGravity(n5, n10);
                    int n22 = 0;
                    switch (n21) {
                        case 1: {
                            n22 = (this.mRight - this.mLeft - n8) / 2;
                            break;
                        }
                        case 3: {
                            if (bl2) {
                                n22 = n12;
                                break;
                            }
                            n22 = n11;
                            break;
                        }
                        case 5: {
                            if (bl2) {
                                n22 = n11 - n8;
                                break;
                            }
                            n22 = n12 - n8;
                            break;
                        }
                    }
                    int n23 = n9 & 0x70;
                    if (n9 == 0) {
                        n23 = 16;
                    }
                    int n24 = 0;
                    switch (n23) {
                        case 16: {
                            int n25 = this.getPaddingTop();
                            n24 = (this.mBottom - this.mTop - this.getPaddingBottom() - n25 - view.getMeasuredHeight()) / 2;
                            break;
                        }
                        case 48: {
                            n24 = n6 + this.getPaddingTop();
                            break;
                        }
                        case 80: {
                            n24 = this.getHeight() - this.getPaddingBottom() - view.getMeasuredHeight() - n7;
                            break;
                        }
                    }
                    int n26 = view.getMeasuredWidth();
                    int n27 = n22 + n26;
                    int n28 = n24 + view.getMeasuredHeight();
                    view.layout(n22, n24, n27, n28);
                    ActionBarView.next(n11, n26, bl2);
                }
                if (this.mProgressView != null) break block48;
            }
            return;
        }
        this.mProgressView.bringToFront();
        int n29 = this.mProgressView.getMeasuredHeight() / 2;
        this.mProgressView.layout(this.mProgressBarPadding, -n29, this.mProgressBarPadding + this.mProgressView.getMeasuredWidth(), n29);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onMeasure(int n, int n2) {
        View view;
        int n3;
        boolean bl;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        block32: {
            HomeView homeView;
            block31: {
                n13 = this.getChildCount();
                if (this.mIsCollapsible) {
                    int n14 = 0;
                    for (int i = 0; i < n13; ++i) {
                        View view2 = this.getChildAt(i);
                        if (view2.getVisibility() == 8 || view2 == this.mMenuView && this.mMenuView.getChildCount() == 0 || view2 == this.mUpGoerFive) continue;
                        ++n14;
                    }
                    int n15 = this.mUpGoerFive.getChildCount();
                    for (int i = 0; i < n15; ++i) {
                        if (this.mUpGoerFive.getChildAt(i).getVisibility() == 8) continue;
                        ++n14;
                    }
                    if (n14 == 0) {
                        this.setMeasuredDimension(0, 0);
                        return;
                    }
                }
                if (View.MeasureSpec.getMode(n) != 0x40000000) {
                    throw new IllegalStateException(this.getClass().getSimpleName() + " can only be used " + "with android:layout_width=\"match_parent\" (or fill_parent)");
                }
                if (View.MeasureSpec.getMode(n2) != Integer.MIN_VALUE) {
                    throw new IllegalStateException(this.getClass().getSimpleName() + " can only be used " + "with android:layout_height=\"wrap_content\"");
                }
                n12 = View.MeasureSpec.getSize(n);
                n11 = this.mContentHeight >= 0 ? this.mContentHeight : View.MeasureSpec.getSize(n2);
                n10 = this.getPaddingTop() + this.getPaddingBottom();
                int n16 = this.getPaddingLeft();
                int n17 = this.getPaddingRight();
                n9 = n11 - n10;
                n8 = View.MeasureSpec.makeMeasureSpec(n9, Integer.MIN_VALUE);
                n7 = View.MeasureSpec.makeMeasureSpec(n9, 0x40000000);
                n6 = n12 - n16 - n17;
                n4 = n5 = n6 / 2;
                bl = this.mTitleLayout != null && this.mTitleLayout.getVisibility() != 8 && (8 & this.mDisplayOptions) != 0;
                homeView = this.mExpandedActionView != null ? this.mExpandedHomeLayout : this.mHomeLayout;
                ViewGroup.LayoutParams layoutParams = homeView.getLayoutParams();
                int n18 = layoutParams.width < 0 ? View.MeasureSpec.makeMeasureSpec(n6, Integer.MIN_VALUE) : View.MeasureSpec.makeMeasureSpec(layoutParams.width, 0x40000000);
                homeView.measure(n18, n7);
                if (homeView.getVisibility() != 8 && homeView.getParent() == this.mUpGoerFive) break block31;
                n3 = 0;
                if (!bl) break block32;
            }
            n3 = homeView.getMeasuredWidth();
            int n19 = n3 + homeView.getStartOffset();
            n6 = Math.max(0, n6 - n19);
            n5 = Math.max(0, n6 - n19);
        }
        if (this.mMenuView != null && this.mMenuView.getParent() == this) {
            n6 = this.measureChildView(this.mMenuView, n6, n7, 0);
            n4 = Math.max(0, n4 - this.mMenuView.getMeasuredWidth());
        }
        if (this.mIndeterminateProgressView != null && this.mIndeterminateProgressView.getVisibility() != 8) {
            n6 = this.measureChildView(this.mIndeterminateProgressView, n6, n8, 0);
            n4 = Math.max(0, n4 - this.mIndeterminateProgressView.getMeasuredWidth());
        }
        if (this.mExpandedActionView == null) {
            switch (this.mNavigationMode) {
                case 1: {
                    if (this.mListNavLayout == null) break;
                    int n20 = bl ? 2 * this.mItemPadding : this.mItemPadding;
                    int n21 = Math.max(0, n6 - n20);
                    int n22 = Math.max(0, n5 - n20);
                    this.mListNavLayout.measure(View.MeasureSpec.makeMeasureSpec(n21, Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec(n9, 0x40000000));
                    int n23 = this.mListNavLayout.getMeasuredWidth();
                    n6 = Math.max(0, n21 - n23);
                    n5 = Math.max(0, n22 - n23);
                    break;
                }
                case 2: {
                    if (this.mTabScrollView == null) break;
                    int n24 = bl ? 2 * this.mItemPadding : this.mItemPadding;
                    int n25 = Math.max(0, n6 - n24);
                    int n26 = Math.max(0, n5 - n24);
                    this.mTabScrollView.measure(View.MeasureSpec.makeMeasureSpec(n25, Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec(n9, 0x40000000));
                    int n27 = this.mTabScrollView.getMeasuredWidth();
                    n6 = Math.max(0, n25 - n27);
                    n5 = Math.max(0, n26 - n27);
                }
            }
        }
        if (this.mExpandedActionView != null) {
            view = this.mExpandedActionView;
        } else {
            int n28 = 0x10 & this.mDisplayOptions;
            view = null;
            if (n28 != 0) {
                View view3 = this.mCustomNavView;
                view = null;
                if (view3 != null) {
                    view = this.mCustomNavView;
                }
            }
        }
        if (view != null) {
            ViewGroup.LayoutParams layoutParams = this.generateLayoutParams(view.getLayoutParams());
            ActionBar.LayoutParams layoutParams2 = layoutParams instanceof ActionBar.LayoutParams ? (ActionBar.LayoutParams)layoutParams : null;
            int n29 = 0;
            int n30 = 0;
            if (layoutParams2 != null) {
                n29 = layoutParams2.leftMargin + layoutParams2.rightMargin;
                n30 = layoutParams2.topMargin + layoutParams2.bottomMargin;
            }
            int n31 = this.mContentHeight <= 0 ? Integer.MIN_VALUE : (layoutParams.height != -2 ? 0x40000000 : Integer.MIN_VALUE);
            if (layoutParams.height >= 0) {
                n9 = Math.min(layoutParams.height, n9);
            }
            int n32 = Math.max(0, n9 - n30);
            int n33 = layoutParams.width != -2 ? 0x40000000 : Integer.MIN_VALUE;
            int n34 = layoutParams.width >= 0 ? Math.min(layoutParams.width, n6) : n6;
            int n35 = Math.max(0, n34 - n29);
            int n36 = layoutParams2 != null ? layoutParams2.gravity : 8388627;
            if ((n36 & 7) == 1 && layoutParams.width == -1) {
                n35 = 2 * Math.min(n5, n4);
            }
            view.measure(View.MeasureSpec.makeMeasureSpec(n35, n33), View.MeasureSpec.makeMeasureSpec(n32, n31));
            n6 -= n29 + view.getMeasuredWidth();
        }
        this.measureChildView(this.mUpGoerFive, n6 + n3, View.MeasureSpec.makeMeasureSpec(this.mContentHeight, 0x40000000), 0);
        if (this.mTitleLayout != null) {
            Math.max(0, n5 - this.mTitleLayout.getMeasuredWidth());
        }
        if (this.mContentHeight <= 0) {
            int n37 = 0;
            for (int i = 0; i < n13; ++i) {
                int n38 = n10 + this.getChildAt(i).getMeasuredHeight();
                if (n38 <= n37) continue;
                n37 = n38;
            }
            this.setMeasuredDimension(n12, n37);
        } else {
            this.setMeasuredDimension(n12, n11);
        }
        if (this.mContextView != null) {
            this.mContextView.setContentHeight(this.getMeasuredHeight());
        }
        if (this.mProgressView == null || this.mProgressView.getVisibility() == 8) return;
        this.mProgressView.measure(View.MeasureSpec.makeMeasureSpec(n12 - 2 * this.mProgressBarPadding, 0x40000000), View.MeasureSpec.makeMeasureSpec(this.getMeasuredHeight(), Integer.MIN_VALUE));
    }

    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        MenuItem menuItem;
        SavedState savedState = (SavedState)parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        if (savedState.expandedMenuItemId != 0 && this.mExpandedMenuPresenter != null && this.mOptionsMenu != null && (menuItem = this.mOptionsMenu.findItem(savedState.expandedMenuItemId)) != null) {
            menuItem.expandActionView();
        }
        if (savedState.isOverflowOpen) {
            this.postShowOverflowMenu();
        }
    }

    @Override
    public Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        if (this.mExpandedMenuPresenter != null && this.mExpandedMenuPresenter.mCurrentExpandedItem != null) {
            savedState.expandedMenuItemId = this.mExpandedMenuPresenter.mCurrentExpandedItem.getItemId();
        }
        savedState.isOverflowOpen = this.isOverflowMenuShowing();
        return savedState;
    }

    @Override
    public void setCollapsible(boolean bl) {
        this.mIsCollapsible = bl;
    }

    public void setContextView(ActionBarContextView actionBarContextView) {
        this.mContextView = actionBarContextView;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setCustomView(View view) {
        boolean bl = (0x10 & this.mDisplayOptions) != 0;
        if (bl) {
            ActionBarTransition.beginDelayedTransition(this);
        }
        if (this.mCustomNavView != null && bl) {
            this.removeView(this.mCustomNavView);
        }
        this.mCustomNavView = view;
        if (this.mCustomNavView != null && bl) {
            this.addView(this.mCustomNavView);
        }
    }

    @Override
    public void setDefaultNavigationContentDescription(int n) {
        if (this.mDefaultUpDescription == n) {
            return;
        }
        this.mDefaultUpDescription = n;
        this.updateHomeAccessibility(this.mUpGoerFive.isEnabled());
    }

    @Override
    public void setDefaultNavigationIcon(Drawable drawable2) {
        this.mHomeLayout.setDefaultUpIndicator(drawable2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setDisplayOptions(int n) {
        int n2 = -1;
        if (this.mDisplayOptions != n2) {
            n2 = n ^ this.mDisplayOptions;
        }
        this.mDisplayOptions = n;
        if ((n2 & 0x3F) != 0) {
            ActionBarTransition.beginDelayedTransition(this);
            if ((n2 & 4) != 0) {
                boolean bl = (n & 4) != 0;
                this.mHomeLayout.setShowUp(bl);
                if (bl) {
                    this.setHomeButtonEnabled(true);
                }
            }
            if ((n2 & 1) != 0) {
                boolean bl = this.mLogo != null && (n & 1) != 0;
                HomeView homeView = this.mHomeLayout;
                Drawable drawable2 = bl ? this.mLogo : this.mIcon;
                homeView.setIcon(drawable2);
            }
            if ((n2 & 8) != 0) {
                if ((n & 8) != 0) {
                    this.initTitle();
                } else {
                    this.mUpGoerFive.removeView(this.mTitleLayout);
                }
            }
            boolean bl = (n & 2) != 0;
            boolean bl2 = (4 & this.mDisplayOptions) != 0;
            boolean bl3 = !bl && bl2;
            this.mHomeLayout.setShowIcon(bl);
            int n3 = (bl || bl3) && this.mExpandedActionView == null ? 0 : 8;
            this.mHomeLayout.setVisibility(n3);
            if ((n2 & 0x10) != 0 && this.mCustomNavView != null) {
                if ((n & 0x10) != 0) {
                    this.addView(this.mCustomNavView);
                } else {
                    this.removeView(this.mCustomNavView);
                }
            }
            if (this.mTitleLayout != null && (n2 & 0x20) != 0) {
                if ((n & 0x20) != 0) {
                    this.mTitleView.setSingleLine(false);
                    this.mTitleView.setMaxLines(2);
                } else {
                    this.mTitleView.setMaxLines(1);
                    this.mTitleView.setSingleLine(true);
                }
            }
            this.requestLayout();
        } else {
            this.invalidate();
        }
        this.updateHomeAccessibility(this.mUpGoerFive.isEnabled());
    }

    @Override
    public void setDropdownParams(SpinnerAdapter spinnerAdapter, AdapterView.OnItemSelectedListener onItemSelectedListener) {
        this.mSpinnerAdapter = spinnerAdapter;
        this.mNavItemSelectedListener = onItemSelectedListener;
        if (this.mSpinner != null) {
            this.mSpinner.setAdapter(spinnerAdapter);
            this.mSpinner.setOnItemSelectedListener(onItemSelectedListener);
        }
    }

    @Override
    public void setDropdownSelectedPosition(int n) {
        this.mSpinner.setSelection(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setEmbeddedTabView(ScrollingTabContainerView scrollingTabContainerView) {
        if (this.mTabScrollView != null) {
            this.removeView(this.mTabScrollView);
        }
        this.mTabScrollView = scrollingTabContainerView;
        boolean bl = scrollingTabContainerView != null;
        this.mIncludeTabs = bl;
        if (this.mIncludeTabs && this.mNavigationMode == 2) {
            this.addView(this.mTabScrollView);
            ViewGroup.LayoutParams layoutParams = this.mTabScrollView.getLayoutParams();
            layoutParams.width = -2;
            layoutParams.height = -1;
            scrollingTabContainerView.setAllowCollapse(true);
        }
    }

    @Override
    public void setHomeButtonEnabled(boolean bl) {
        this.setHomeButtonEnabled(bl, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setIcon(int n) {
        Drawable drawable2 = n != 0 ? this.mContext.getDrawable(n) : null;
        this.setIcon(drawable2);
    }

    @Override
    public void setIcon(Drawable drawable2) {
        this.mIcon = drawable2;
        if (drawable2 != null && ((1 & this.mDisplayOptions) == 0 || this.mLogo == null)) {
            this.mHomeLayout.setIcon(drawable2);
        }
        if (this.mExpandedActionView != null) {
            this.mExpandedHomeLayout.setIcon(this.mIcon.getConstantState().newDrawable(this.getResources()));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setLogo(int n) {
        Drawable drawable2 = n != 0 ? this.mContext.getDrawable(n) : null;
        this.setLogo(drawable2);
    }

    @Override
    public void setLogo(Drawable drawable2) {
        this.mLogo = drawable2;
        if (drawable2 != null && (1 & this.mDisplayOptions) != 0) {
            this.mHomeLayout.setIcon(drawable2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setMenu(Menu menu2, MenuPresenter.Callback callback) {
        ActionMenuView actionMenuView;
        ViewGroup viewGroup;
        MenuBuilder menuBuilder;
        if (menu2 == this.mOptionsMenu) {
            return;
        }
        if (this.mOptionsMenu != null) {
            this.mOptionsMenu.removeMenuPresenter(this.mActionMenuPresenter);
            this.mOptionsMenu.removeMenuPresenter(this.mExpandedMenuPresenter);
        }
        this.mOptionsMenu = menuBuilder = (MenuBuilder)menu2;
        if (this.mMenuView != null && (viewGroup = (ViewGroup)this.mMenuView.getParent()) != null) {
            viewGroup.removeView(this.mMenuView);
        }
        if (this.mActionMenuPresenter == null) {
            this.mActionMenuPresenter = new ActionMenuPresenter(this.mContext);
            this.mActionMenuPresenter.setCallback(callback);
            this.mActionMenuPresenter.setId(16908351);
            this.mExpandedMenuPresenter = new ExpandedActionViewMenuPresenter();
        }
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-2, -1);
        if (!this.mSplitActionBar) {
            this.mActionMenuPresenter.setExpandedActionViewsExclusive(this.getResources().getBoolean(17956873));
            this.configPresenters(menuBuilder);
            actionMenuView = (ActionMenuView)this.mActionMenuPresenter.getMenuView(this);
            ViewGroup viewGroup2 = (ViewGroup)actionMenuView.getParent();
            if (viewGroup2 != null && viewGroup2 != this) {
                viewGroup2.removeView(actionMenuView);
            }
            this.addView((View)actionMenuView, layoutParams);
        } else {
            this.mActionMenuPresenter.setExpandedActionViewsExclusive(false);
            this.mActionMenuPresenter.setWidthLimit(this.getContext().getResources().getDisplayMetrics().widthPixels, true);
            this.mActionMenuPresenter.setItemLimit(Integer.MAX_VALUE);
            layoutParams.width = -1;
            layoutParams.height = -2;
            this.configPresenters(menuBuilder);
            actionMenuView = (ActionMenuView)this.mActionMenuPresenter.getMenuView(this);
            if (this.mSplitView != null) {
                ViewGroup viewGroup3 = (ViewGroup)actionMenuView.getParent();
                if (viewGroup3 != null && viewGroup3 != this.mSplitView) {
                    viewGroup3.removeView(actionMenuView);
                }
                actionMenuView.setVisibility(this.getAnimatedVisibility());
                this.mSplitView.addView((View)actionMenuView, layoutParams);
            } else {
                actionMenuView.setLayoutParams(layoutParams);
            }
        }
        this.mMenuView = actionMenuView;
    }

    @Override
    public void setMenuPrepared() {
        this.mMenuPrepared = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setNavigationContentDescription(int n) {
        this.mHomeDescriptionRes = n;
        CharSequence charSequence = n != 0 ? this.getResources().getText(n) : null;
        this.mHomeDescription = charSequence;
        this.updateHomeAccessibility(this.mUpGoerFive.isEnabled());
    }

    @Override
    public void setNavigationContentDescription(CharSequence charSequence) {
        this.mHomeDescription = charSequence;
        this.updateHomeAccessibility(this.mUpGoerFive.isEnabled());
    }

    @Override
    public void setNavigationIcon(int n) {
        this.mHomeLayout.setUpIndicator(n);
    }

    @Override
    public void setNavigationIcon(Drawable drawable2) {
        this.mHomeLayout.setUpIndicator(drawable2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setNavigationMode(int n) {
        int n2 = this.mNavigationMode;
        if (n != n2) {
            ActionBarTransition.beginDelayedTransition(this);
            switch (n2) {
                case 1: {
                    if (this.mListNavLayout != null) {
                        this.removeView(this.mListNavLayout);
                    }
                }
                default: {
                    break;
                }
                case 2: {
                    if (this.mTabScrollView == null || !this.mIncludeTabs) break;
                    this.removeView(this.mTabScrollView);
                }
            }
            switch (n) {
                case 1: {
                    if (this.mSpinner == null) {
                        this.mSpinner = new Spinner(this.mContext, null, 16843479);
                        this.mSpinner.setId(16908354);
                        this.mListNavLayout = new LinearLayout(this.mContext, null, 16843508);
                        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -1);
                        layoutParams.gravity = 17;
                        this.mListNavLayout.addView((View)this.mSpinner, layoutParams);
                    }
                    if (this.mSpinner.getAdapter() != this.mSpinnerAdapter) {
                        this.mSpinner.setAdapter(this.mSpinnerAdapter);
                    }
                    this.mSpinner.setOnItemSelectedListener(this.mNavItemSelectedListener);
                    this.addView(this.mListNavLayout);
                }
                default: {
                    break;
                }
                case 2: {
                    if (this.mTabScrollView == null || !this.mIncludeTabs) break;
                    this.addView(this.mTabScrollView);
                }
            }
            this.mNavigationMode = n;
            this.requestLayout();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setSplitToolbar(boolean bl) {
        if (this.mSplitActionBar != bl) {
            if (this.mMenuView != null) {
                ViewGroup viewGroup = (ViewGroup)this.mMenuView.getParent();
                if (viewGroup != null) {
                    viewGroup.removeView(this.mMenuView);
                }
                if (bl) {
                    if (this.mSplitView != null) {
                        this.mSplitView.addView(this.mMenuView);
                    }
                    this.mMenuView.getLayoutParams().width = -1;
                } else {
                    this.addView(this.mMenuView);
                    this.mMenuView.getLayoutParams().width = -2;
                }
                this.mMenuView.requestLayout();
            }
            if (this.mSplitView != null) {
                ViewGroup viewGroup = this.mSplitView;
                int n = bl ? 0 : 8;
                viewGroup.setVisibility(n);
            }
            if (this.mActionMenuPresenter != null) {
                if (!bl) {
                    this.mActionMenuPresenter.setExpandedActionViewsExclusive(this.getResources().getBoolean(17956873));
                } else {
                    this.mActionMenuPresenter.setExpandedActionViewsExclusive(false);
                    this.mActionMenuPresenter.setWidthLimit(this.getContext().getResources().getDisplayMetrics().widthPixels, true);
                    this.mActionMenuPresenter.setItemLimit(Integer.MAX_VALUE);
                }
            }
            super.setSplitToolbar(bl);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setSubtitle(CharSequence charSequence) {
        ActionBarTransition.beginDelayedTransition(this);
        this.mSubtitle = charSequence;
        if (this.mSubtitleView != null) {
            this.mSubtitleView.setText(charSequence);
            TextView textView = this.mSubtitleView;
            int n = charSequence != null ? 0 : 8;
            textView.setVisibility(n);
            boolean bl = this.mExpandedActionView == null && (8 & this.mDisplayOptions) != 0 && (!TextUtils.isEmpty(this.mTitle) || !TextUtils.isEmpty(this.mSubtitle));
            LinearLayout linearLayout = this.mTitleLayout;
            int n2 = 0;
            if (!bl) {
                n2 = 8;
            }
            linearLayout.setVisibility(n2);
        }
        this.updateHomeAccessibility(this.mUpGoerFive.isEnabled());
    }

    @Override
    public void setTitle(CharSequence charSequence) {
        this.mUserTitle = true;
        this.setTitleImpl(charSequence);
    }

    @Override
    public void setWindowCallback(Window.Callback callback) {
        this.mWindowCallback = callback;
    }

    @Override
    public void setWindowTitle(CharSequence charSequence) {
        if (!this.mUserTitle) {
            this.setTitleImpl(charSequence);
        }
    }

    @Override
    public boolean shouldDelayChildPressedState() {
        return false;
    }

    private class ExpandedActionViewMenuPresenter
    implements MenuPresenter {
        MenuItemImpl mCurrentExpandedItem;
        MenuBuilder mMenu;

        private ExpandedActionViewMenuPresenter() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean collapseItemActionView(MenuBuilder menuBuilder, MenuItemImpl menuItemImpl) {
            ActionBarTransition.beginDelayedTransition(ActionBarView.this);
            if (ActionBarView.this.mExpandedActionView instanceof CollapsibleActionView) {
                ((CollapsibleActionView)((Object)ActionBarView.this.mExpandedActionView)).onActionViewCollapsed();
            }
            ActionBarView.this.removeView(ActionBarView.this.mExpandedActionView);
            ActionBarView.this.mUpGoerFive.removeView(ActionBarView.this.mExpandedHomeLayout);
            ActionBarView.this.mExpandedActionView = null;
            if ((2 & ActionBarView.this.mDisplayOptions) != 0) {
                ActionBarView.this.mHomeLayout.setVisibility(0);
            }
            if ((8 & ActionBarView.this.mDisplayOptions) != 0) {
                if (ActionBarView.this.mTitleLayout == null) {
                    ActionBarView.this.initTitle();
                } else {
                    ActionBarView.this.mTitleLayout.setVisibility(0);
                }
            }
            if (ActionBarView.this.mTabScrollView != null) {
                ActionBarView.this.mTabScrollView.setVisibility(0);
            }
            if (ActionBarView.this.mSpinner != null) {
                ActionBarView.this.mSpinner.setVisibility(0);
            }
            if (ActionBarView.this.mCustomNavView != null) {
                ActionBarView.this.mCustomNavView.setVisibility(0);
            }
            ActionBarView.this.mExpandedHomeLayout.setIcon(null);
            this.mCurrentExpandedItem = null;
            ActionBarView.this.setHomeButtonEnabled(ActionBarView.this.mWasHomeEnabled);
            ActionBarView.this.requestLayout();
            menuItemImpl.setActionViewExpanded(false);
            return true;
        }

        @Override
        public boolean expandItemActionView(MenuBuilder menuBuilder, MenuItemImpl menuItemImpl) {
            ActionBarTransition.beginDelayedTransition(ActionBarView.this);
            ActionBarView.this.mExpandedActionView = menuItemImpl.getActionView();
            ActionBarView.this.mExpandedHomeLayout.setIcon(ActionBarView.this.mIcon.getConstantState().newDrawable(ActionBarView.this.getResources()));
            this.mCurrentExpandedItem = menuItemImpl;
            if (ActionBarView.this.mExpandedActionView.getParent() != ActionBarView.this) {
                ActionBarView.this.addView(ActionBarView.this.mExpandedActionView);
            }
            if (ActionBarView.this.mExpandedHomeLayout.getParent() != ActionBarView.this.mUpGoerFive) {
                ActionBarView.this.mUpGoerFive.addView(ActionBarView.this.mExpandedHomeLayout);
            }
            ActionBarView.this.mHomeLayout.setVisibility(8);
            if (ActionBarView.this.mTitleLayout != null) {
                ActionBarView.this.mTitleLayout.setVisibility(8);
            }
            if (ActionBarView.this.mTabScrollView != null) {
                ActionBarView.this.mTabScrollView.setVisibility(8);
            }
            if (ActionBarView.this.mSpinner != null) {
                ActionBarView.this.mSpinner.setVisibility(8);
            }
            if (ActionBarView.this.mCustomNavView != null) {
                ActionBarView.this.mCustomNavView.setVisibility(8);
            }
            ActionBarView.this.setHomeButtonEnabled(false, false);
            ActionBarView.this.requestLayout();
            menuItemImpl.setActionViewExpanded(true);
            if (ActionBarView.this.mExpandedActionView instanceof CollapsibleActionView) {
                ((CollapsibleActionView)((Object)ActionBarView.this.mExpandedActionView)).onActionViewExpanded();
            }
            return true;
        }

        @Override
        public boolean flagActionItems() {
            return false;
        }

        @Override
        public int getId() {
            return 0;
        }

        @Override
        public MenuView getMenuView(ViewGroup viewGroup) {
            return null;
        }

        @Override
        public void initForMenu(Context context, MenuBuilder menuBuilder) {
            if (this.mMenu != null && this.mCurrentExpandedItem != null) {
                this.mMenu.collapseItemActionView(this.mCurrentExpandedItem);
            }
            this.mMenu = menuBuilder;
        }

        @Override
        public void onCloseMenu(MenuBuilder menuBuilder, boolean bl) {
        }

        @Override
        public void onRestoreInstanceState(Parcelable parcelable) {
        }

        @Override
        public Parcelable onSaveInstanceState() {
            return null;
        }

        @Override
        public boolean onSubMenuSelected(SubMenuBuilder subMenuBuilder) {
            return false;
        }

        @Override
        public void setCallback(MenuPresenter.Callback callback) {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void updateMenuView(boolean bl) {
            if (this.mCurrentExpandedItem == null) return;
            MenuBuilder menuBuilder = this.mMenu;
            boolean bl2 = false;
            if (menuBuilder != null) {
                int n = this.mMenu.size();
                int n2 = 0;
                while (true) {
                    bl2 = false;
                    if (n2 >= n) break;
                    if (this.mMenu.getItem(n2) == this.mCurrentExpandedItem) {
                        return;
                    }
                    ++n2;
                }
            }
            if (bl2) return;
            this.collapseItemActionView(this.mMenu, this.mCurrentExpandedItem);
        }
    }

    private static class HomeView
    extends FrameLayout {
        private static final long DEFAULT_TRANSITION_DURATION = 150L;
        private Drawable mDefaultUpIndicator;
        private ImageView mIconView;
        private int mStartOffset;
        private Drawable mUpIndicator;
        private int mUpIndicatorRes;
        private ImageView mUpView;
        private int mUpWidth;

        public HomeView(Context context) {
            this(context, null);
        }

        public HomeView(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            LayoutTransition layoutTransition = this.getLayoutTransition();
            if (layoutTransition != null) {
                layoutTransition.setDuration(150L);
            }
        }

        private void updateUpIndicator() {
            if (this.mUpIndicator != null) {
                this.mUpView.setImageDrawable(this.mUpIndicator);
                return;
            }
            if (this.mUpIndicatorRes != 0) {
                this.mUpView.setImageDrawable(this.getContext().getDrawable(this.mUpIndicatorRes));
                return;
            }
            this.mUpView.setImageDrawable(this.mDefaultUpIndicator);
        }

        @Override
        public boolean dispatchHoverEvent(MotionEvent motionEvent) {
            return this.onHoverEvent(motionEvent);
        }

        @Override
        public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
            this.onPopulateAccessibilityEvent(accessibilityEvent);
            return true;
        }

        public int getStartOffset() {
            if (this.mUpView.getVisibility() == 8) {
                return this.mStartOffset;
            }
            return 0;
        }

        public int getUpWidth() {
            return this.mUpWidth;
        }

        @Override
        protected void onConfigurationChanged(Configuration configuration) {
            super.onConfigurationChanged(configuration);
            if (this.mUpIndicatorRes != 0) {
                this.updateUpIndicator();
            }
        }

        @Override
        protected void onFinishInflate() {
            this.mUpView = (ImageView)this.findViewById(16908347);
            this.mIconView = (ImageView)this.findViewById(16908332);
            this.mDefaultUpIndicator = this.mUpView.getDrawable();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
            int n5;
            int n6;
            int n7 = (n4 - n2) / 2;
            boolean bl2 = this.isLayoutRtl();
            int n8 = this.getWidth();
            int n9 = this.mUpView.getVisibility();
            int n10 = 0;
            if (n9 != 8) {
                int n11;
                int n12;
                FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.mUpView.getLayoutParams();
                int n13 = this.mUpView.getMeasuredHeight();
                int n14 = this.mUpView.getMeasuredWidth();
                n10 = n14 + layoutParams.leftMargin + layoutParams.rightMargin;
                int n15 = n7 - n13 / 2;
                int n16 = n15 + n13;
                if (bl2) {
                    n12 = n8;
                    n11 = n12 - n14;
                    n3 -= n10;
                } else {
                    n12 = n14;
                    n += n10;
                    n11 = 0;
                }
                this.mUpView.layout(n11, n15, n12, n16);
            }
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.mIconView.getLayoutParams();
            int n17 = this.mIconView.getMeasuredHeight();
            int n18 = this.mIconView.getMeasuredWidth();
            int n19 = (n3 - n) / 2;
            int n20 = Math.max(layoutParams.topMargin, n7 - n17 / 2);
            int n21 = n20 + n17;
            int n22 = Math.max(layoutParams.getMarginStart(), n19 - n18 / 2);
            if (bl2) {
                n6 = n8 - n10 - n22;
                n5 = n6 - n18;
            } else {
                n5 = n10 + n22;
                n6 = n5 + n18;
            }
            this.mIconView.layout(n5, n20, n6, n21);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected void onMeasure(int n, int n2) {
            this.measureChildWithMargins(this.mUpView, n, 0, n2, 0);
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.mUpView.getLayoutParams();
            int n3 = layoutParams.leftMargin + layoutParams.rightMargin;
            this.mUpWidth = this.mUpView.getMeasuredWidth();
            this.mStartOffset = n3 + this.mUpWidth;
            int n4 = this.mUpView.getVisibility() == 8 ? 0 : this.mStartOffset;
            int n5 = layoutParams.topMargin + this.mUpView.getMeasuredHeight() + layoutParams.bottomMargin;
            if (this.mIconView.getVisibility() != 8) {
                this.measureChildWithMargins(this.mIconView, n, n4, n2, 0);
                FrameLayout.LayoutParams layoutParams2 = (FrameLayout.LayoutParams)this.mIconView.getLayoutParams();
                n4 += layoutParams2.leftMargin + this.mIconView.getMeasuredWidth() + layoutParams2.rightMargin;
                n5 = Math.max(n5, layoutParams2.topMargin + this.mIconView.getMeasuredHeight() + layoutParams2.bottomMargin);
            } else if (n3 < 0) {
                n4 -= n3;
            }
            int n6 = View.MeasureSpec.getMode(n);
            int n7 = View.MeasureSpec.getMode(n2);
            int n8 = View.MeasureSpec.getSize(n);
            int n9 = View.MeasureSpec.getSize(n2);
            switch (n6) {
                case -2147483648: {
                    n4 = Math.min(n4, n8);
                }
                default: {
                    break;
                }
                case 0x40000000: {
                    n4 = n8;
                }
            }
            switch (n7) {
                case -2147483648: {
                    n5 = Math.min(n5, n9);
                }
                default: {
                    break;
                }
                case 0x40000000: {
                    n5 = n9;
                }
            }
            this.setMeasuredDimension(n4, n5);
        }

        @Override
        public void onPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
            super.onPopulateAccessibilityEvent(accessibilityEvent);
            CharSequence charSequence = this.getContentDescription();
            if (!TextUtils.isEmpty(charSequence)) {
                accessibilityEvent.getText().add(charSequence);
            }
        }

        public void setDefaultUpIndicator(Drawable drawable2) {
            this.mDefaultUpIndicator = drawable2;
            this.updateUpIndicator();
        }

        public void setIcon(Drawable drawable2) {
            this.mIconView.setImageDrawable(drawable2);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void setShowIcon(boolean bl) {
            ImageView imageView = this.mIconView;
            int n = bl ? 0 : 8;
            imageView.setVisibility(n);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void setShowUp(boolean bl) {
            ImageView imageView = this.mUpView;
            int n = bl ? 0 : 8;
            imageView.setVisibility(n);
        }

        public void setUpIndicator(int n) {
            this.mUpIndicatorRes = n;
            this.mUpIndicator = null;
            this.updateUpIndicator();
        }

        public void setUpIndicator(Drawable drawable2) {
            this.mUpIndicator = drawable2;
            this.mUpIndicatorRes = 0;
            this.updateUpIndicator();
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        int expandedMenuItemId;
        boolean isOverflowOpen;

        /*
         * Enabled aggressive block sorting
         */
        private SavedState(Parcel parcel) {
            super(parcel);
            this.expandedMenuItemId = parcel.readInt();
            boolean bl = parcel.readInt() != 0;
            this.isOverflowOpen = bl;
        }

        SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            parcel.writeInt(this.expandedMenuItemId);
            int n2 = this.isOverflowOpen ? 1 : 0;
            parcel.writeInt(n2);
        }
    }
}

