/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.SparseArray;
import android.view.ContextThemeWrapper;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import com.android.internal.view.menu.BaseMenuPresenter;
import com.android.internal.view.menu.IconMenuItemView;
import com.android.internal.view.menu.IconMenuView;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuDialogHelper;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuPresenter;
import com.android.internal.view.menu.MenuView;
import com.android.internal.view.menu.SubMenuBuilder;
import java.util.ArrayList;

public class IconMenuPresenter
extends BaseMenuPresenter {
    private static final String OPEN_SUBMENU_KEY = "android:menu:icon:submenu";
    private static final String VIEWS_TAG = "android:menu:icon";
    private int mMaxItems = -1;
    private IconMenuItemView mMoreView;
    MenuDialogHelper mOpenSubMenu;
    int mOpenSubMenuId;
    SubMenuPresenterCallback mSubMenuPresenterCallback = new SubMenuPresenterCallback();

    public IconMenuPresenter(Context context) {
        super(new ContextThemeWrapper(context, 16974970), 17367156, 17367155);
    }

    @Override
    protected void addItemView(View view, int n) {
        IconMenuItemView iconMenuItemView = (IconMenuItemView)view;
        IconMenuView iconMenuView = (IconMenuView)this.mMenuView;
        iconMenuItemView.setIconMenuView(iconMenuView);
        iconMenuItemView.setItemInvoker(iconMenuView);
        iconMenuItemView.setBackgroundDrawable(iconMenuView.getItemBackgroundDrawable());
        super.addItemView(view, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void bindItemView(MenuItemImpl menuItemImpl, MenuView.ItemView itemView) {
        IconMenuItemView iconMenuItemView = (IconMenuItemView)itemView;
        iconMenuItemView.setItemData(menuItemImpl);
        iconMenuItemView.initialize(menuItemImpl.getTitleForItemView(iconMenuItemView), menuItemImpl.getIcon());
        int n = menuItemImpl.isVisible() ? 0 : 8;
        iconMenuItemView.setVisibility(n);
        iconMenuItemView.setEnabled(iconMenuItemView.isEnabled());
        iconMenuItemView.setLayoutParams(iconMenuItemView.getTextAppropriateLayoutParams());
    }

    @Override
    protected boolean filterLeftoverView(ViewGroup viewGroup, int n) {
        if (viewGroup.getChildAt(n) != this.mMoreView) {
            return super.filterLeftoverView(viewGroup, n);
        }
        return false;
    }

    public int getNumActualItemsShown() {
        return ((IconMenuView)this.mMenuView).getNumActualItemsShown();
    }

    @Override
    public void initForMenu(Context context, MenuBuilder menuBuilder) {
        super.initForMenu(context, menuBuilder);
        this.mMaxItems = -1;
    }

    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        this.restoreHierarchyState((Bundle)parcelable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Parcelable onSaveInstanceState() {
        if (this.mMenuView == null) {
            return null;
        }
        Bundle bundle = new Bundle();
        this.saveHierarchyState(bundle);
        if (this.mOpenSubMenuId <= 0) return bundle;
        bundle.putInt(OPEN_SUBMENU_KEY, this.mOpenSubMenuId);
        return bundle;
    }

    @Override
    public boolean onSubMenuSelected(SubMenuBuilder subMenuBuilder) {
        if (!subMenuBuilder.hasVisibleItems()) {
            return false;
        }
        MenuDialogHelper menuDialogHelper = new MenuDialogHelper(subMenuBuilder);
        menuDialogHelper.setPresenterCallback(this.mSubMenuPresenterCallback);
        menuDialogHelper.show(null);
        this.mOpenSubMenu = menuDialogHelper;
        this.mOpenSubMenuId = subMenuBuilder.getItem().getItemId();
        super.onSubMenuSelected(subMenuBuilder);
        return true;
    }

    public void restoreHierarchyState(Bundle bundle) {
        MenuItem menuItem;
        int n;
        SparseArray<Parcelable> sparseArray = bundle.getSparseParcelableArray(VIEWS_TAG);
        if (sparseArray != null) {
            ((View)((Object)this.mMenuView)).restoreHierarchyState(sparseArray);
        }
        if ((n = bundle.getInt(OPEN_SUBMENU_KEY, 0)) > 0 && this.mMenu != null && (menuItem = this.mMenu.findItem(n)) != null) {
            this.onSubMenuSelected((SubMenuBuilder)menuItem.getSubMenu());
        }
    }

    public void saveHierarchyState(Bundle bundle) {
        SparseArray<Parcelable> sparseArray = new SparseArray<Parcelable>();
        if (this.mMenuView != null) {
            ((View)((Object)this.mMenuView)).saveHierarchyState(sparseArray);
        }
        bundle.putSparseParcelableArray(VIEWS_TAG, sparseArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean shouldIncludeItem(int n, MenuItemImpl menuItemImpl) {
        if (this.mMenu.getNonActionItems().size() != this.mMaxItems || n >= this.mMaxItems) {
            if (n >= -1 + this.mMaxItems) return false;
        }
        boolean bl = true;
        if (!bl) return false;
        if (menuItemImpl.isActionButton()) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void updateMenuView(boolean bl) {
        ArrayList<MenuItemImpl> arrayList;
        IconMenuView iconMenuView = (IconMenuView)this.mMenuView;
        if (this.mMaxItems < 0) {
            this.mMaxItems = iconMenuView.getMaxItems();
        }
        boolean bl2 = (arrayList = this.mMenu.getNonActionItems()).size() > this.mMaxItems;
        super.updateMenuView(bl);
        if (bl2 && (this.mMoreView == null || this.mMoreView.getParent() != iconMenuView)) {
            if (this.mMoreView == null) {
                this.mMoreView = iconMenuView.createMoreItemView();
                this.mMoreView.setBackgroundDrawable(iconMenuView.getItemBackgroundDrawable());
            }
            iconMenuView.addView(this.mMoreView);
        } else if (!bl2 && this.mMoreView != null) {
            iconMenuView.removeView(this.mMoreView);
        }
        int n = bl2 ? -1 + this.mMaxItems : arrayList.size();
        iconMenuView.setNumActualItemsShown(n);
    }

    class SubMenuPresenterCallback
    implements MenuPresenter.Callback {
        SubMenuPresenterCallback() {
        }

        @Override
        public void onCloseMenu(MenuBuilder menuBuilder, boolean bl) {
            IconMenuPresenter.this.mOpenSubMenuId = 0;
            if (IconMenuPresenter.this.mOpenSubMenu != null) {
                IconMenuPresenter.this.mOpenSubMenu.dismiss();
                IconMenuPresenter.this.mOpenSubMenu = null;
            }
        }

        @Override
        public boolean onOpenSubMenu(MenuBuilder menuBuilder) {
            if (menuBuilder != null) {
                IconMenuPresenter.this.mOpenSubMenuId = ((SubMenuBuilder)menuBuilder).getItem().getItemId();
            }
            return false;
        }
    }
}

